/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.openscience.jmol.viewer.Util;
import org.openscience.jmol.viewer.datamodel.Atom;
import org.openscience.jmol.viewer.datamodel.AtomIterator;
import org.openscience.jmol.viewer.datamodel.DotsRenderer;
import org.openscience.jmol.viewer.datamodel.Shape;

public class Dots
extends Shape {
    DotsRenderer dotsRenderer;
    short mad;
    int dotsConvexMax;
    int[][] dotsConvexMaps;
    short[] colixesConvex;
    Vector3f[] geodesicVertices;
    int geodesicCount;
    int[] geodesicMap;
    static final int[] mapNull = new int[0];
    int cavityCount;
    Cavity[] cavities;
    int torusCount;
    Torus[] tori;
    Hashtable htTori;
    int indexI;
    int indexJ;
    int indexK;
    Atom atomI;
    Atom atomJ;
    Atom atomK;
    Point3f centerI;
    Point3f centerJ;
    Point3f centerK;
    float radiusI;
    float radiusJ;
    float radiusK;
    float radiusP;
    float diameterP;
    float radiiIP2;
    float radiiJP2;
    float radiiKP2;
    float distanceIJ2;
    Torus torusIJ;
    Torus torusIK;
    final Point3f baseIJK = new Point3f();
    final Point3f probeIJK = new Point3f();
    float heightIJK;
    final Point3f pointT = new Point3f();
    final Point3f pointT1 = new Point3f();
    int neighborCount;
    Atom[] neighbors = new Atom[16];
    int[] neighborIndices = new int[16];
    Point3f[] neighborCenters = new Point3f[16];
    float[] neighborPlusProbeRadii2 = new float[16];
    final Matrix3f matrixT = new Matrix3f();
    final Matrix3f matrixT1 = new Matrix3f();
    final AxisAngle4f aaT = new AxisAngle4f();
    final Vector3f vectorT = new Vector3f();
    final Vector3f vectorT1 = new Vector3f();
    final Vector3f vectorZ = new Vector3f(0.0f, 0.0f, 1.0f);
    final Vector3f vectorX = new Vector3f(1.0f, 0.0f, 0.0f);
    final Point3f pointTorusP = new Point3f();
    final Vector3f vectorPI = new Vector3f();
    final Vector3f vectorPJ = new Vector3f();
    final Vector3f uIJK = new Vector3f();
    final Vector3f v2v3 = new Vector3f();
    final Vector3f v3v1 = new Vector3f();
    final Vector3f v1v2 = new Vector3f();
    final Vector3f p1 = new Vector3f();
    final Vector3f p2 = new Vector3f();
    final Vector3f p3 = new Vector3f();
    final Vector3f vectorPK = new Vector3f();
    static final byte[] gcSplits = new byte[]{1, 2, 4, 2, 3, 5, 3, 1, 6, 1, 4, 7, 2, 4, 8, 2, 5, 9, 3, 5, 10, 3, 6, 11, 1, 6, 12};

    void initShape() {
        this.dotsRenderer = (DotsRenderer)this.frame.getRenderer(7);
        this.geodesicVertices = this.dotsRenderer.geodesic.vertices;
        this.geodesicCount = this.geodesicVertices.length;
        this.geodesicMap = Dots.allocateBitmap(this.geodesicCount);
    }

    void setSize(int size, BitSet bsSelected) {
        int i;
        short mad;
        this.mad = mad = (short)size;
        if (this.radiusP != this.viewer.getCurrentSolventProbeRadius()) {
            this.dotsConvexMax = 0;
            this.dotsConvexMaps = null;
            this.torusCount = 0;
            this.htTori = null;
            this.tori = null;
            this.cavityCount = 0;
            this.cavities = null;
            this.radiusP = this.viewer.getCurrentSolventProbeRadius();
            this.diameterP = 2.0f * this.radiusP;
        }
        int atomCount = this.frame.atomCount;
        if (this.dotsConvexMaps != null) {
            i = atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.dotsConvexMaps[i] = null;
            }
            this.deleteUnnecessaryTori();
            this.deleteUnnecessaryCavities();
        }
        if (mad != 0) {
            if (this.dotsConvexMaps == null) {
                this.dotsConvexMaps = new int[atomCount][];
                this.colixesConvex = new short[atomCount];
            }
            i = atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setAtomI(i);
                this.getNeighbors(bsSelected);
                this.calcConvexMap();
                this.calcTori();
                this.calcCavities();
            }
        }
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMax = 0;
        } else {
            i = atomCount;
            while (--i >= 0 && this.dotsConvexMaps[i] == null) {
            }
            this.dotsConvexMax = i + 1;
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        int atomCount = this.frame.atomCount;
        Atom[] atoms = this.frame.atoms;
        if ("color" == propertyName) {
            System.out.println("Dots.setProperty('color')");
            this.setProperty("colorConvex", value, bs);
            this.setProperty("colorConcave", value, bs);
            this.setProperty("colorSaddle", value, bs);
        }
        if ("colorConvex" == propertyName) {
            System.out.println("Dots.setProperty('colorConvex')");
            short colix = this.g3d.getColix(value);
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.colixesConvex[i] = colix;
            }
            return;
        }
        if ("colorSaddle" == propertyName) {
            short colix = this.g3d.getColix(value);
            int i = this.torusCount;
            while (--i >= 0) {
                Torus torus = this.tori[i];
                if (bs.get(torus.indexI)) {
                    torus.colixI = colix;
                }
                if (!bs.get(torus.indexJ)) continue;
                torus.colixJ = colix;
            }
            return;
        }
        if ("colorConcave" == propertyName) {
            short colix = this.g3d.getColix(value);
            int i = this.cavityCount;
            while (--i >= 0) {
                Cavity cavity = this.cavities[i];
                if (bs.get(cavity.ixI)) {
                    cavity.colixI = colix;
                }
                if (bs.get(cavity.ixJ)) {
                    cavity.colixJ = colix;
                }
                if (!bs.get(cavity.ixK)) continue;
                cavity.colixK = colix;
            }
            return;
        }
        if ("colorScheme" == propertyName) {
            if (value != null) {
                byte palette = this.viewer.getPalette((String)value);
                int i = atomCount;
                while (--i >= 0) {
                    if (!bs.get(i)) continue;
                    Atom atom = atoms[i];
                    this.colixesConvex[i] = this.viewer.getColixAtomPalette(atom, palette);
                }
                i = this.torusCount;
                while (--i >= 0) {
                    Torus torus = this.tori[i];
                    if (bs.get(torus.indexI)) {
                        torus.colixI = this.viewer.getColixAtomPalette(atoms[torus.indexI], palette);
                    }
                    if (!bs.get(torus.indexJ)) continue;
                    torus.colixJ = this.viewer.getColixAtomPalette(atoms[torus.indexJ], palette);
                }
                i = this.cavityCount;
                while (--i >= 0) {
                    Cavity cavity = this.cavities[i];
                    if (bs.get(cavity.ixI)) {
                        cavity.colixI = this.viewer.getColixAtomPalette(atoms[cavity.ixI], palette);
                    }
                    if (bs.get(cavity.ixJ)) {
                        cavity.colixJ = this.viewer.getColixAtomPalette(atoms[cavity.ixJ], palette);
                    }
                    if (!bs.get(cavity.ixK)) continue;
                    cavity.colixK = this.viewer.getColixAtomPalette(atoms[cavity.ixK], palette);
                }
                return;
            }
            return;
        }
    }

    void setAtomI(int indexI) {
        this.indexI = indexI;
        this.atomI = this.frame.atoms[indexI];
        this.centerI = this.atomI.point3f;
        this.radiusI = this.atomI.getVanderwaalsRadiusFloat();
        this.radiiIP2 = this.radiusI + this.radiusP;
        this.radiiIP2 *= this.radiiIP2;
    }

    void setNeighborJ(int indexNeighbor) {
        this.indexJ = this.neighborIndices[indexNeighbor];
        this.atomJ = this.neighbors[indexNeighbor];
        this.radiusJ = this.atomJ.getVanderwaalsRadiusFloat();
        this.radiiJP2 = this.neighborPlusProbeRadii2[indexNeighbor];
        this.centerJ = this.neighborCenters[indexNeighbor];
        this.distanceIJ2 = this.centerI.distanceSquared(this.centerJ);
    }

    void setNeighborK(int indexNeighbor) {
        this.indexK = this.neighborIndices[indexNeighbor];
        this.centerK = this.neighborCenters[indexNeighbor];
        this.atomK = this.neighbors[indexNeighbor];
        this.radiusK = this.atomK.getVanderwaalsRadiusFloat();
        this.radiiKP2 = this.neighborPlusProbeRadii2[indexNeighbor];
    }

    void calcConvexMap() {
        this.calcConvexBits();
        int indexLast = this.geodesicMap.length;
        while (--indexLast >= 0 && this.geodesicMap[indexLast] == 0) {
        }
        int[] map = mapNull;
        if (indexLast >= 0) {
            int count = indexLast + 1;
            map = new int[indexLast + 1];
            System.arraycopy(this.geodesicMap, 0, map, 0, count);
        }
        this.dotsConvexMaps[this.indexI] = map;
    }

    void calcConvexBits() {
        Dots.setAllBits(this.geodesicMap, this.geodesicCount);
        if (this.neighborCount == 0) {
            return;
        }
        float combinedRadii = this.radiusI + this.radiusP;
        int iLastUsed = 0;
        int iDot = this.geodesicCount;
        block0: while (--iDot >= 0) {
            this.pointT.set(this.geodesicVertices[iDot]);
            this.pointT.scaleAdd(combinedRadii, this.centerI);
            int iStart = iLastUsed;
            do {
                if (!(this.pointT.distanceSquared(this.neighborCenters[iLastUsed]) < this.neighborPlusProbeRadii2[iLastUsed])) continue;
                Dots.clearBit(this.geodesicMap, iDot);
                continue block0;
            } while ((iLastUsed = (iLastUsed + 1) % this.neighborCount) != iStart);
        }
    }

    void getNeighbors(BitSet bsSelected) {
        AtomIterator iter = this.frame.getWithinIterator(this.atomI, this.radiusI + this.diameterP + this.frame.getMaxVanderwaalsRadius());
        this.neighborCount = 0;
        while (iter.hasNext()) {
            Atom neighbor = iter.next();
            if (neighbor == this.atomI || !bsSelected.get(neighbor.atomIndex)) continue;
            float neighborRadius = neighbor.getVanderwaalsRadiusFloat();
            if (this.centerI.distance(neighbor.point3f) > this.radiusI + this.radiusP + this.radiusP + neighborRadius) continue;
            if (this.neighborCount == this.neighbors.length) {
                this.neighbors = (Atom[])Util.doubleLength(this.neighbors);
                this.neighborIndices = Util.doubleLength(this.neighborIndices);
                this.neighborCenters = (Point3f[])Util.doubleLength(this.neighborCenters);
                this.neighborPlusProbeRadii2 = Util.doubleLength(this.neighborPlusProbeRadii2);
            }
            this.neighbors[this.neighborCount] = neighbor;
            this.neighborCenters[this.neighborCount] = neighbor.point3f;
            this.neighborIndices[this.neighborCount] = neighbor.atomIndex;
            float neighborPlusProbeRadii = neighborRadius + this.radiusP;
            this.neighborPlusProbeRadii2[this.neighborCount] = neighborPlusProbeRadii * neighborPlusProbeRadii;
            ++this.neighborCount;
        }
    }

    void calcTori() {
        if (this.radiusP == 0.0f) {
            return;
        }
        if (this.htTori == null) {
            this.torusCount = 0;
            this.tori = new Torus[32];
            this.htTori = new Hashtable();
        }
        int iJ = this.neighborCount;
        while (--iJ >= 0) {
            if (this.indexI >= this.neighborIndices[iJ]) continue;
            this.setNeighborJ(iJ);
            this.torusIJ = this.getTorus(this.atomI, this.atomJ);
            if (this.torusIJ == null) continue;
            this.calcTorusProbeMap(this.torusIJ);
            if (this.torusIJ.probeMap == 0L) continue;
            if (this.torusCount == this.tori.length) {
                this.tori = (Torus[])Util.doubleLength(this.tori);
            }
            this.tori[this.torusCount++] = this.torusIJ;
        }
    }

    void deleteUnnecessaryTori() {
        boolean torusDeleted = false;
        int i = this.torusCount;
        while (--i >= 0) {
            Torus torus = this.tori[i];
            if (this.dotsConvexMaps[torus.indexI] != null || this.dotsConvexMaps[torus.indexJ] != null) continue;
            torusDeleted = true;
            this.tori[i] = null;
        }
        if (torusDeleted) {
            int iDestination = 0;
            for (int iSource = 0; iSource < this.torusCount; ++iSource) {
                if (this.tori[iSource] == null) continue;
                this.tori[iDestination++] = this.tori[iSource];
            }
            int i2 = this.torusCount;
            while (--i2 >= iDestination) {
                this.tori[i2] = null;
            }
            this.torusCount = iDestination;
        }
    }

    void calcTorusProbeMap(Torus torus) {
        long probeMap = -1L;
        float stepAngle = 0.09817477f;
        this.aaT.set(torus.axisVector, 0.0f);
        int iLastNeighbor = 0;
        int a = 64;
        block0: while (--a >= 0) {
            this.aaT.angle = (float)a * stepAngle;
            this.matrixT.set(this.aaT);
            this.matrixT.transform(torus.radialVector, this.pointT);
            this.pointT.add(torus.center);
            int iStart = iLastNeighbor;
            do {
                if (this.neighbors[iLastNeighbor].atomIndex == torus.indexJ || !(this.pointT.distanceSquared(this.neighborCenters[iLastNeighbor]) < this.neighborPlusProbeRadii2[iLastNeighbor])) continue;
                probeMap &= 1L << 63 - a ^ 0xFFFFFFFFFFFFFFFFL;
                continue block0;
            } while ((iLastNeighbor = (iLastNeighbor + 1) % this.neighborCount) != iStart);
        }
        torus.probeMap = probeMap;
    }

    Torus getTorus(Atom atomI, Atom atomJ) {
        int indexI = atomI.atomIndex;
        int indexJ = atomJ.atomIndex;
        if (indexI >= indexJ) {
            throw new NullPointerException();
        }
        Long key = new Long(((long)indexI << 32) + (long)indexJ);
        Object value = this.htTori.get(key);
        if (value != null) {
            if (value instanceof Torus) {
                Torus torus = (Torus)value;
                return torus;
            }
            return null;
        }
        float radius = this.calcTorusRadius();
        if (radius == 0.0f) {
            this.htTori.put(key, Boolean.FALSE);
            return null;
        }
        Point3f center = this.calcTorusCenter();
        Torus torus = new Torus(this.centerI, indexI, this.centerJ, indexJ, center, radius);
        this.htTori.put(key, torus);
        return torus;
    }

    Point3f calcTorusCenter() {
        Point3f torusCenter = new Point3f();
        torusCenter.sub(this.centerJ, this.centerI);
        torusCenter.scale((this.radiiIP2 - this.radiiJP2) / this.distanceIJ2);
        torusCenter.add(this.centerI);
        torusCenter.add(this.centerJ);
        torusCenter.scale(0.5f);
        return torusCenter;
    }

    float calcTorusRadius() {
        float t1 = this.radiusI + this.radiusJ + this.diameterP;
        float t2 = t1 * t1 - this.distanceIJ2;
        float diff = this.radiusI - this.radiusJ;
        float t3 = this.distanceIJ2 - diff * diff;
        if (t2 <= 0.0f || t3 <= 0.0f || this.distanceIJ2 == 0.0f) {
            return 0.0f;
        }
        return (float)(0.5 * Math.sqrt(t2) * Math.sqrt(t3) / Math.sqrt(this.distanceIJ2));
    }

    void calcCavities() {
        if (this.radiusP == 0.0f) {
            return;
        }
        if (this.cavities == null) {
            this.cavities = new Cavity[16];
            this.cavityCount = 0;
        }
        int iJ = this.neighborCount;
        while (--iJ >= 0) {
            if (this.indexI >= this.neighborIndices[iJ]) continue;
            this.setNeighborJ(iJ);
            int iK = this.neighborCount;
            while (--iK >= 0) {
                if (this.indexJ >= this.neighborIndices[iK]) continue;
                this.setNeighborK(iK);
                float distanceJK2 = this.centerJ.distanceSquared(this.centerK);
                if (distanceJK2 >= this.radiiJP2 + this.radiiKP2) continue;
                this.getCavitiesIJK();
            }
        }
    }

    void deleteUnnecessaryCavities() {
        boolean cavityDeleted = false;
        int i = this.cavityCount;
        while (--i >= 0) {
            Cavity cavity = this.cavities[i];
            if (this.dotsConvexMaps[cavity.ixI] != null || this.dotsConvexMaps[cavity.ixJ] != null || this.dotsConvexMaps[cavity.ixK] != null) continue;
            cavityDeleted = true;
            this.cavities[i] = null;
        }
        if (cavityDeleted) {
            int iDestination = 0;
            for (int iSource = 0; iSource < this.cavityCount; ++iSource) {
                if (this.cavities[iSource] == null) continue;
                this.cavities[iDestination++] = this.cavities[iSource];
            }
            int i2 = this.cavityCount;
            while (--i2 >= iDestination) {
                this.cavities[i2] = null;
            }
            this.cavityCount = iDestination;
        }
    }

    void getCavitiesIJK() {
        this.torusIJ = this.getTorus(this.atomI, this.atomJ);
        this.torusIK = this.getTorus(this.atomI, this.atomK);
        if (this.torusIJ == null || this.torusIK == null) {
            System.out.println("null torus found?");
            return;
        }
        this.uIJK.cross(this.torusIJ.axisVector, this.torusIK.axisVector);
        this.uIJK.normalize();
        if (!this.calcBaseIJK() || !this.calcHeightIJK()) {
            return;
        }
        this.probeIJK.scaleAdd(this.heightIJK, this.uIJK, this.baseIJK);
        if (this.checkProbeIJK()) {
            this.addCavity(new Cavity());
        }
        this.probeIJK.scaleAdd(-this.heightIJK, this.uIJK, this.baseIJK);
        if (this.checkProbeIJK()) {
            this.addCavity(new Cavity());
        }
    }

    boolean checkProbeIJK() {
        int i = this.neighborCount;
        while (--i >= 0) {
            int neighborIndex = this.neighborIndices[i];
            if (neighborIndex == this.indexI || neighborIndex == this.indexJ || neighborIndex == this.indexK || !(this.probeIJK.distanceSquared(this.neighborCenters[i]) < this.neighborPlusProbeRadii2[i])) continue;
            return false;
        }
        return true;
    }

    void addCavity(Cavity cavity) {
        if (this.cavityCount == this.cavities.length) {
            this.cavities = (Cavity[])Util.doubleLength(this.cavities);
        }
        this.cavities[this.cavityCount++] = cavity;
    }

    boolean calcBaseIJK() {
        Vector3f v1 = this.torusIJ.axisVector;
        this.p1.set(this.torusIJ.center);
        Vector3f v2 = this.torusIK.axisVector;
        this.p2.set(this.torusIK.center);
        Vector3f v3 = this.uIJK;
        this.p3.set(this.centerI);
        this.v2v3.cross(v2, v3);
        this.v3v1.cross(v3, v1);
        this.v1v2.cross(v1, v2);
        float denominator = v1.dot(this.v2v3);
        if (denominator == 0.0f) {
            return false;
        }
        this.baseIJK.scale(v1.dot(this.p1), this.v2v3);
        this.baseIJK.scaleAdd(v2.dot(this.p2), this.v3v1, this.baseIJK);
        this.baseIJK.scaleAdd(v3.dot(this.p3), this.v1v2, this.baseIJK);
        this.baseIJK.scale(1.0f / denominator);
        return true;
    }

    boolean calcHeightIJK() {
        float hypotenuse2 = this.radiiIP2;
        this.vectorT.sub(this.baseIJK, this.centerI);
        float baseLength2 = this.vectorT.lengthSquared();
        float height2 = hypotenuse2 - baseLength2;
        if (height2 <= 0.0f) {
            return false;
        }
        this.heightIJK = (float)Math.sqrt(height2);
        return true;
    }

    static final int[] allocateBitmap(int count) {
        return new int[count + 31 >> 5];
    }

    static final void setBit(int[] bitmap, int i) {
        int n = i >> 5;
        bitmap[n] = bitmap[n] | 1 << (~i & 0x1F);
    }

    static final void clearBit(int[] bitmap, int i) {
        int n = i >> 5;
        bitmap[n] = bitmap[n] & ~(1 << (~i & 0x1F));
    }

    static final boolean getBit(int[] bitmap, int i) {
        return bitmap[i >> 5] << (i & 0x1F) < 0;
    }

    static final void setAllBits(int[] bitmap, int count) {
        int i = count >> 5;
        if ((count & 0x1F) != 0) {
            bitmap[i] = Integer.MIN_VALUE >> count - 1;
        }
        while (--i >= 0) {
            bitmap[i] = -1;
        }
    }

    static final void clearBitmap(int[] bitmap) {
        int i = bitmap.length;
        while (--i >= 0) {
            bitmap[i] = 0;
        }
    }

    class Cavity {
        final int ixI;
        final int ixJ;
        final int ixK;
        final Point3f[] points;
        short colixI;
        short colixJ;
        short colixK;

        Cavity() {
            this.ixI = Dots.this.indexI;
            this.ixJ = Dots.this.indexJ;
            this.ixK = Dots.this.indexK;
            this.points = new Point3f[25];
            int i = 25;
            while (--i >= 0) {
                this.points[i] = new Point3f();
            }
            Dots.this.vectorPI.sub(Dots.this.centerI, Dots.this.probeIJK);
            Dots.this.vectorPI.normalize();
            this.points[1].scaleAdd(Dots.this.radiusP, Dots.this.vectorPI, Dots.this.probeIJK);
            Dots.this.vectorPJ.sub(Dots.this.centerJ, Dots.this.probeIJK);
            Dots.this.vectorPJ.normalize();
            this.points[2].scaleAdd(Dots.this.radiusP, Dots.this.vectorPJ, Dots.this.probeIJK);
            Dots.this.vectorPK.sub(Dots.this.centerK, Dots.this.probeIJK);
            Dots.this.vectorPK.normalize();
            this.points[3].scaleAdd(Dots.this.radiusP, Dots.this.vectorPK, Dots.this.probeIJK);
            Dots.this.vectorT.add(Dots.this.vectorPI, Dots.this.vectorPJ);
            Dots.this.vectorT.add(Dots.this.vectorPK);
            Dots.this.vectorT.normalize();
            this.points[0].scaleAdd(Dots.this.radiusP, Dots.this.vectorT, Dots.this.probeIJK);
            for (i = 0; i < gcSplits.length; i += 3) {
                this.splitGreatCircle(gcSplits[i], gcSplits[i + 1], gcSplits[i + 2]);
            }
            for (i = 13; i < 25; ++i) {
                this.splitGreatCircle(0, i - 12, i);
            }
        }

        void splitGreatCircle(int indexA, int indexB, int indexMiddle) {
            Dots.this.vectorT.sub(this.points[indexA], Dots.this.probeIJK);
            Dots.this.vectorT1.sub(this.points[indexB], Dots.this.probeIJK);
            Dots.this.vectorT.add(Dots.this.vectorT1);
            Dots.this.vectorT.normalize();
            this.points[indexMiddle].scaleAdd(Dots.this.radiusP, Dots.this.vectorT, Dots.this.probeIJK);
        }
    }

    class Torus {
        int indexI;
        int indexJ;
        Point3f center;
        float radius;
        Vector3f axisVector;
        Vector3f radialVector;
        Vector3f unitRadialVector;
        Vector3f tangentVector;
        Vector3f outerRadial;
        float outerAngle;
        long probeMap;
        AxisAngle4f aaRotate;
        short colixI;
        short colixJ;

        Torus(Point3f centerI, int indexI, Point3f centerJ, int indexJ, Point3f center, float radius) {
            this.indexI = indexI;
            this.indexJ = indexJ;
            this.center = center;
            this.radius = radius;
            this.axisVector = new Vector3f();
            this.axisVector.sub(centerJ, centerI);
            if (this.axisVector.x == 0.0f) {
                this.unitRadialVector = new Vector3f(1.0f, 0.0f, 0.0f);
            } else if (this.axisVector.y == 0.0f) {
                this.unitRadialVector = new Vector3f(0.0f, 1.0f, 0.0f);
            } else if (this.axisVector.z == 0.0f) {
                this.unitRadialVector = new Vector3f(0.0f, 0.0f, 1.0f);
            } else {
                this.unitRadialVector = new Vector3f(-this.axisVector.y, this.axisVector.x, 0.0f);
                this.unitRadialVector.normalize();
            }
            this.radialVector = new Vector3f(this.unitRadialVector);
            this.radialVector.scale(radius);
            this.tangentVector = new Vector3f();
            this.tangentVector.cross(this.radialVector, this.axisVector);
            this.tangentVector.normalize();
            Dots.this.pointTorusP.add(center, this.radialVector);
            Dots.this.vectorPI.sub(centerI, Dots.this.pointTorusP);
            Dots.this.vectorPI.normalize();
            Dots.this.vectorPI.scale(Dots.this.radiusP);
            Dots.this.vectorPJ.sub(centerJ, Dots.this.pointTorusP);
            Dots.this.vectorPJ.normalize();
            Dots.this.vectorPJ.scale(Dots.this.radiusP);
            this.outerRadial = new Vector3f();
            this.outerRadial.add(Dots.this.vectorPI, Dots.this.vectorPJ);
            this.outerRadial.normalize();
            this.outerRadial.scale(Dots.this.radiusP);
            this.outerAngle = Dots.this.vectorPJ.angle(Dots.this.vectorPI) / 2.0f;
            float angle = Dots.this.vectorZ.angle(this.axisVector);
            if (angle == 0.0f) {
                Dots.this.matrixT.setIdentity();
            } else {
                Dots.this.vectorT.cross(Dots.this.vectorZ, this.axisVector);
                Dots.this.aaT.set(Dots.this.vectorT, angle);
                Dots.this.matrixT.set(Dots.this.aaT);
            }
            Dots.this.matrixT.transform(this.unitRadialVector, Dots.this.vectorT);
            angle = Dots.this.vectorX.angle(Dots.this.vectorT);
            if (angle != 0.0f) {
                Dots.this.vectorT.cross(Dots.this.vectorX, Dots.this.vectorT);
                Dots.this.aaT.set(Dots.this.vectorT, angle);
                Dots.this.matrixT1.set(Dots.this.aaT);
                Dots.this.matrixT.mul(Dots.this.matrixT1);
            }
            this.aaRotate = new AxisAngle4f();
            this.aaRotate.set(Dots.this.matrixT);
        }
    }
}

