/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import java.awt.Rectangle;
import java.util.BitSet;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.ModelAdapter;
import org.jmol.g3d.Graphics3D;
import org.openscience.jmol.viewer.JmolConstants;
import org.openscience.jmol.viewer.JmolViewer;
import org.openscience.jmol.viewer.Util;
import org.openscience.jmol.viewer.datamodel.Atom;
import org.openscience.jmol.viewer.datamodel.AtomIterator;
import org.openscience.jmol.viewer.datamodel.Bond;
import org.openscience.jmol.viewer.datamodel.BondIterator;
import org.openscience.jmol.viewer.datamodel.Bspf;
import org.openscience.jmol.viewer.datamodel.Bspt;
import org.openscience.jmol.viewer.datamodel.Closest;
import org.openscience.jmol.viewer.datamodel.FrameExportModelAdapter;
import org.openscience.jmol.viewer.datamodel.FrameRenderer;
import org.openscience.jmol.viewer.datamodel.Group;
import org.openscience.jmol.viewer.datamodel.Measurement;
import org.openscience.jmol.viewer.datamodel.Mmset;
import org.openscience.jmol.viewer.datamodel.Shape;
import org.openscience.jmol.viewer.datamodel.ShapeRenderer;

public final class Frame {
    JmolViewer viewer;
    FrameRenderer frameRenderer;
    String modelTypeName;
    Mmset mmset;
    Graphics3D g3d;
    float maxBondingRadius = -2.1474836E9f;
    float maxVanderwaalsRadius = -2.1474836E9f;
    int atomCount;
    Atom[] atoms;
    Object[] clientAtomReferences;
    int bondCount;
    Bond[] bonds;
    private static final int growthIncrement = 250;
    boolean fileCoordinatesAreFractional;
    float[] notionalUnitcell;
    Matrix3f matrixNotional;
    Matrix3f pdbScaleMatrix;
    Matrix3f pdbScaleMatrixTranspose;
    Vector3f pdbTranslateVector;
    Matrix3f matrixEuclideanToFractional;
    Matrix3f matrixFractionalToEuclidean;
    boolean hasVibrationVectors;
    boolean fileHasHbonds;
    boolean structuresDefined;
    BitSet elementsPresent;
    int groupCount;
    Group[] groups;
    BitSet groupsPresent;
    boolean hasBfactorRange;
    int bfactor100Lo;
    int bfactor100Hi;
    FrameExportModelAdapter exportModelAdapter;
    final Shape[] shapes = new Shape[22];
    Point3f averageAtomPoint;
    Point3f centerBoundingBox;
    Vector3f boundingBoxCornerVector;
    Point3f minBoundingBox;
    Point3f maxBoundingBox;
    Point3f centerUnitcell;
    Point3f rotationCenter;
    float rotationRadius;
    Point3f rotationCenterDefault;
    float rotationRadiusDefault;
    static final Point3f[] unitBboxPoints = new Point3f[]{new Point3f(1.0f, 1.0f, 1.0f), new Point3f(1.0f, 1.0f, -1.0f), new Point3f(1.0f, -1.0f, 1.0f), new Point3f(1.0f, -1.0f, -1.0f), new Point3f(-1.0f, 1.0f, 1.0f), new Point3f(-1.0f, 1.0f, -1.0f), new Point3f(-1.0f, -1.0f, 1.0f), new Point3f(-1.0f, -1.0f, -1.0f)};
    final Point3f[] bboxVertices = new Point3f[8];
    static final Point3f[] unitCubePoints = new Point3f[]{new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 1.0f, 1.0f), new Point3f(1.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 1.0f), new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, 1.0f, 1.0f)};
    Point3f[] unitcellVertices;
    static final int measurementGrowthIncrement = 16;
    int measurementCount = 0;
    Measurement[] measurements = null;
    static final int minimumPixelSelectionRadius = 4;
    final Closest closest = new Closest();
    final BitSet bsEmpty = new BitSet();
    final BitSet bsFoundRectangle = new BitSet();
    private Bspf bspf;
    private final WithinIterator withinAtomIterator = new WithinIterator();
    static final boolean showRebondTimes = false;
    private float bondTolerance;
    private float minBondDistance;
    private float minBondDistance2;
    float hbondMax = 3.25f;
    float hbondMin = 2.5f;
    float hbondMin2 = this.hbondMin * this.hbondMin;
    boolean hbondsCalculated;
    boolean useRasMolHbondsCalculation = true;
    static final float toRadians = (float)Math.PI / 180;

    public Frame(JmolViewer viewer, String modelTypeName) {
        this.viewer = viewer;
        this.modelTypeName = modelTypeName.toLowerCase().intern();
        this.mmset = new Mmset(this);
        this.frameRenderer = viewer.getFrameRenderer();
        this.g3d = viewer.g3d;
    }

    public ModelAdapter getExportModelAdapter() {
        if (this.exportModelAdapter == null) {
            this.exportModelAdapter = new FrameExportModelAdapter(this.viewer, this);
        }
        return this.exportModelAdapter;
    }

    void freeze() {
        if (this.atomCount < this.atoms.length) {
            this.atoms = (Atom[])Util.setLength(this.atoms, this.atomCount);
        }
        if (this.clientAtomReferences != null && this.atomCount < this.clientAtomReferences.length) {
            this.clientAtomReferences = (Object[])Util.setLength(this.clientAtomReferences, this.atomCount);
        }
        if (this.bondCount < this.bonds.length) {
            this.bonds = (Bond[])Util.setLength(this.bonds, this.bondCount);
        }
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].vibrationVector == null) continue;
            this.hasVibrationVectors = true;
            break;
        }
        this.hackAtomSerialNumbersForAnimations();
        if (!this.structuresDefined) {
            this.mmset.calculateStructures();
        }
        this.findElementsPresent();
        this.findGroupsPresent();
        this.mmset.freeze();
        this.loadShape(0);
        this.loadShape(1);
        if (this.fileHasHbonds) {
            this.loadShape(2);
        }
    }

    /*
     * WARNING - void declaration
     */
    void hackAtomSerialNumbersForAnimations() {
        void var1_2;
        int n = this.atomCount;
        while (--var1_2 >= 0) {
            if (this.atoms[var1_2].atomSerial == Integer.MIN_VALUE) continue;
            return;
        }
        int n2 = Integer.MAX_VALUE;
        int modelAtomIndex = 0;
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            short s;
            Atom atom = this.atoms[i2];
            if (atom.modelIndex != s) {
                s = atom.modelIndex;
                modelAtomIndex = 1;
            }
            atom.atomSerial = modelAtomIndex++;
        }
    }

    public void defineStructure(String structureType, char startChainID, int startSequenceNumber, char startInsertionCode, char endChainID, int endSequenceNumber, char endInsertionCode) {
        this.structuresDefined = true;
        this.mmset.defineStructure(structureType, startChainID, startSequenceNumber, startInsertionCode, endChainID, endSequenceNumber, endInsertionCode);
    }

    public int getAtomIndexFromAtomNumber(int atomNumber) {
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].getAtomNumber() != atomNumber) continue;
            return i;
        }
        return -1;
    }

    public int getModelCount() {
        return this.mmset.getModelCount();
    }

    public int getModelIndex(String modelTag) {
        return this.mmset.getModelIndex(modelTag);
    }

    public int getChainCount() {
        return this.mmset.getChainCount();
    }

    public int getGroupCount() {
        return this.mmset.getGroupCount();
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom getAtomAt(int atomIndex) {
        return this.atoms[atomIndex];
    }

    public Point3f getAtomPoint3f(int atomIndex) {
        return this.atoms[atomIndex].point3f;
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public Bond getBondAt(int bondIndex) {
        return this.bonds[bondIndex];
    }

    private void addBond(Bond bond) {
        if (bond == null) {
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])Util.setLength(this.bonds, this.bondCount + 250);
        }
        this.bonds[this.bondCount++] = bond;
    }

    void bondAtoms(Atom atom1, Atom atom2, int order) {
        this.addBond(atom1.bondMutually(atom2, order, this.viewer));
    }

    public boolean hasVibrationVectors() {
        return this.hasVibrationVectors;
    }

    Shape allocateShape(int shapeID) {
        String classBase = JmolConstants.shapeClassBases[shapeID];
        String className = "org.openscience.jmol.viewer.datamodel." + classBase;
        try {
            Class<?> shapeClass = Class.forName(className);
            Shape shape = (Shape)shapeClass.newInstance();
            shape.setViewerG3dFrame(this.viewer, this.g3d, this);
            return shape;
        }
        catch (Exception e) {
            System.out.println("Could not instantiate shape:" + classBase + "\n" + e);
            e.printStackTrace();
            return null;
        }
    }

    void loadShape(int shapeID) {
        if (this.shapes[shapeID] == null) {
            this.shapes[shapeID] = this.allocateShape(shapeID);
        }
    }

    public void setShapeSize(int shapeID, int size, BitSet bsSelected) {
        if (size != 0) {
            this.loadShape(shapeID);
        }
        if (this.shapes[shapeID] != null) {
            this.shapes[shapeID].setSize(size, bsSelected);
        }
    }

    public void setShapeProperty(int shapeID, String propertyName, Object value, BitSet bsSelected) {
        this.loadShape(shapeID);
        if (this.shapes[shapeID] != null) {
            this.shapes[shapeID].setProperty(propertyName, value, bsSelected);
        }
    }

    public Object getShapeProperty(int shapeID, String propertyName, int index) {
        return this.shapes[shapeID] == null ? null : this.shapes[shapeID].getProperty(propertyName, index);
    }

    public Point3f getBoundingBoxCenter() {
        this.findBounds();
        return this.centerBoundingBox;
    }

    public Vector3f getBoundingBoxCornerVector() {
        this.findBounds();
        return this.boundingBoxCornerVector;
    }

    public Point3f getRotationCenter() {
        this.findBounds();
        return this.rotationCenter;
    }

    public void increaseRotationRadius(float increaseInAngstroms) {
        this.rotationRadius += increaseInAngstroms;
    }

    public float getRotationRadius() {
        this.findBounds();
        return this.rotationRadius;
    }

    public void setRotationCenter(Point3f newCenterOfRotation) {
        if (newCenterOfRotation != null) {
            this.rotationCenter = newCenterOfRotation;
            this.rotationRadius = this.calcRotationRadius(this.rotationCenter);
        } else {
            this.rotationCenter = this.rotationCenterDefault;
            this.rotationRadius = this.rotationRadiusDefault;
        }
    }

    void clearBounds() {
        this.rotationCenter = null;
        this.rotationRadius = 0.0f;
    }

    private void findBounds() {
        if (this.rotationCenter != null || this.atomCount <= 0) {
            return;
        }
        this.calcRotationSphere();
    }

    private void calcRotationSphere() {
        this.calcAverageAtomPoint();
        this.calcBoundingBoxDimensions();
        if (this.notionalUnitcell != null) {
            this.calcUnitcellDimensions();
        }
        this.rotationCenter = this.rotationCenterDefault = this.averageAtomPoint;
        this.rotationRadius = this.rotationRadiusDefault = this.calcRotationRadius(this.rotationCenterDefault);
    }

    private void calcAverageAtomPoint() {
        Point3f average = this.averageAtomPoint = new Point3f();
        int i = this.atomCount;
        while (--i >= 0) {
            average.add(this.atoms[i].point3f);
        }
        average.scale(1.0f / (float)this.atomCount);
    }

    private void calcBoundingBoxDimensions() {
        this.minBoundingBox = new Point3f();
        this.maxBoundingBox = new Point3f();
        this.calcAtomsMinMax(this.minBoundingBox, this.maxBoundingBox);
        this.centerBoundingBox = new Point3f(this.minBoundingBox);
        this.centerBoundingBox.add(this.maxBoundingBox);
        this.centerBoundingBox.scale(0.5f);
        this.boundingBoxCornerVector = new Vector3f(this.maxBoundingBox);
        this.boundingBoxCornerVector.sub(this.centerBoundingBox);
        int i = 8;
        while (--i >= 0) {
            Point3f bbcagePoint = this.bboxVertices[i] = new Point3f(unitBboxPoints[i]);
            bbcagePoint.x *= this.boundingBoxCornerVector.x;
            bbcagePoint.y *= this.boundingBoxCornerVector.y;
            bbcagePoint.z *= this.boundingBoxCornerVector.z;
            bbcagePoint.add(this.centerBoundingBox);
        }
    }

    private void calcUnitcellDimensions() {
        this.unitcellVertices = new Point3f[8];
        int i = 8;
        while (--i >= 0) {
            Point3f vertex = this.unitcellVertices[i] = new Point3f();
            this.matrixFractionalToEuclidean.transform(unitCubePoints[i], vertex);
        }
        this.centerUnitcell = new Point3f(this.unitcellVertices[7]);
        this.centerUnitcell.scale(0.5f);
    }

    private float calcRotationRadius(Point3f center) {
        float maxRadius = 0.0f;
        int i = this.atomCount;
        while (--i >= 0) {
            float radiusVdw;
            Atom atom = this.atoms[i];
            float distAtom = center.distance(atom.point3f);
            float outerVdw = distAtom + (radiusVdw = atom.getVanderwaalsRadiusFloat());
            if (!(outerVdw > maxRadius)) continue;
            maxRadius = outerVdw;
        }
        return maxRadius;
    }

    public boolean frankClicked(int x, int y) {
        Shape frankShape = this.shapes[18];
        if (frankShape == null) {
            return false;
        }
        return frankShape.wasClicked(x, y);
    }

    public int findNearestAtomIndex(int x, int y) {
        this.closest.atom = null;
        for (int i = 0; i < this.shapes.length; ++i) {
            Shape shape = this.shapes[i];
            if (shape == null) continue;
            this.shapes[i].findNearestAtomIndex(x, y, this.closest);
            if (this.closest.atom != null) break;
        }
        int closestIndex = this.closest.atom == null ? -1 : this.closest.atom.atomIndex;
        this.closest.atom = null;
        return closestIndex;
    }

    public BitSet findAtomsInRectangle(Rectangle rect) {
        this.bsFoundRectangle.and(this.bsEmpty);
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            if (!rect.contains(atom.getScreenX(), atom.getScreenY())) continue;
            this.bsFoundRectangle.set(i);
        }
        return this.bsFoundRectangle;
    }

    public BondIterator getBondIterator(short bondType, BitSet bsSelected) {
        return new SelectedBondIterator(bondType, bsSelected);
    }

    void initializeBspf() {
        if (this.bspf == null) {
            this.bspf = new Bspf(3);
            int i = this.atomCount;
            while (--i >= 0) {
                Atom atom = this.atoms[i];
                if (atom.isDeleted()) continue;
                this.bspf.addTuple(atom.modelIndex, atom);
            }
        }
    }

    private void clearBspf() {
        this.bspf = null;
    }

    int getBsptCount() {
        if (this.bspf == null) {
            this.initializeBspf();
        }
        return this.bspf.getBsptCount();
    }

    public AtomIterator getWithinIterator(Atom atomCenter, float radius) {
        this.withinAtomIterator.initialize(atomCenter.modelIndex, atomCenter, radius);
        return this.withinAtomIterator;
    }

    void doAutobond() {
        if (this.viewer.getAutoBond() && (this.bondCount == 0 || this.modelTypeName == "pdb" && this.bondCount < this.atomCount / 2)) {
            this.rebond(false);
        }
    }

    public void rebond() {
        this.rebond(true);
    }

    void rebond(boolean deleteFirst) {
        if (deleteFirst) {
            this.deleteAllBonds();
        }
        if (this.maxBondingRadius == -2.1474836E9f) {
            this.findMaxRadii();
        }
        this.bondTolerance = this.viewer.getBondTolerance();
        this.minBondDistance = this.viewer.getMinBondDistance();
        this.minBondDistance2 = this.minBondDistance * this.minBondDistance;
        int chainLast = 63;
        int indexLastCA = -1;
        Object atomLastCA = null;
        this.initializeBspf();
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            float myBondingRadius = atom.getBondingRadiusFloat();
            if (myBondingRadius == 0.0f) continue;
            float searchRadius = myBondingRadius + this.maxBondingRadius + this.bondTolerance;
            Bspt.SphereIterator iter = this.bspf.getSphereIterator(atom.modelIndex);
            iter.initializeHemisphere(atom, searchRadius);
            while (iter.hasMoreElements()) {
                int order;
                Atom atomNear = (Atom)iter.nextElement();
                if (atomNear == atom || (order = this.getBondOrder(atom, myBondingRadius, atomNear, atomNear.getBondingRadiusFloat(), iter.foundDistance2())) <= 0) continue;
                this.addBond(atom.bondMutually(atomNear, order, this.viewer));
            }
            iter.release();
        }
    }

    private int getBondOrder(Atom atomA, float bondingRadiusA, Atom atomB, float bondingRadiusB, float distance2) {
        if (bondingRadiusA == 0.0f || bondingRadiusB == 0.0f) {
            return 0;
        }
        float maxAcceptable = bondingRadiusA + bondingRadiusB + this.bondTolerance;
        float maxAcceptable2 = maxAcceptable * maxAcceptable;
        if (distance2 < this.minBondDistance2) {
            return 0;
        }
        if (distance2 <= maxAcceptable2) {
            return 1;
        }
        return 0;
    }

    void calcHbonds() {
        if (this.hbondsCalculated) {
            return;
        }
        this.hbondsCalculated = true;
        if (this.useRasMolHbondsCalculation) {
            if (this.mmset != null) {
                this.mmset.calcHydrogenBonds();
            }
            return;
        }
        this.initializeBspf();
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            byte elementNumber = atom.elementNumber;
            if (elementNumber != 7 && elementNumber != 8) continue;
            float searchRadius = this.hbondMax;
            Bspt.SphereIterator iter = this.bspf.getSphereIterator(atom.modelIndex);
            iter.initializeHemisphere(atom, this.hbondMax);
            while (iter.hasMoreElements()) {
                Atom atomNear = (Atom)iter.nextElement();
                byte elementNumberNear = atomNear.elementNumber;
                if (elementNumberNear != 7 && elementNumberNear != 8 || atomNear == atom || iter.foundDistance2() < this.hbondMin2 || atom.isBonded(atomNear)) continue;
                this.addBond(atom.bondMutually(atomNear, 64, this.viewer));
                System.out.println("adding an hbond between " + atom.atomIndex + " & " + atomNear.atomIndex);
            }
            iter.release();
        }
    }

    void deleteAllBonds() {
        int i = this.bondCount;
        while (--i >= 0) {
            this.bonds[i].deleteAtomReferences();
            this.bonds[i] = null;
        }
        this.bondCount = 0;
    }

    void deleteBond(Bond bond) {
        int i = this.bondCount;
        while (--i >= 0) {
            if (this.bonds[i] != bond) continue;
            this.bonds[i].deleteAtomReferences();
            System.arraycopy(this.bonds, i + 1, this.bonds, i, this.bondCount - i - 1);
            --this.bondCount;
            this.bonds[this.bondCount] = null;
        }
    }

    void deleteCovalentBonds() {
        int indexNoncovalent = 0;
        for (int i = 0; i < this.bondCount; ++i) {
            Bond bond = this.bonds[i];
            if (!bond.isCovalent()) {
                if (i == indexNoncovalent) continue;
                this.bonds[indexNoncovalent++] = bond;
                this.bonds[i] = null;
                continue;
            }
            bond.deleteAtomReferences();
            this.bonds[i] = null;
        }
        this.bondCount = indexNoncovalent;
    }

    void deleteAtom(int atomIndex) {
        this.clearBspf();
        this.atoms[atomIndex].markDeleted();
    }

    float getMaxVanderwaalsRadius() {
        if (this.maxVanderwaalsRadius == -2.1474836E9f) {
            this.findMaxRadii();
        }
        return this.maxVanderwaalsRadius;
    }

    void setNotionalUnitcell(float[] notionalUnitcell) {
        if (notionalUnitcell != null && notionalUnitcell.length != 6) {
            System.out.println("notionalUnitcell length incorrect:" + notionalUnitcell);
        } else {
            this.notionalUnitcell = notionalUnitcell;
        }
    }

    void setPdbScaleMatrix(float[] pdbScaleMatrixArray) {
        if (pdbScaleMatrixArray == null) {
            return;
        }
        if (pdbScaleMatrixArray.length != 9) {
            System.out.println("pdbScaleMatrix.length != 9 :" + this.pdbScaleMatrix);
            return;
        }
        this.pdbScaleMatrix = new Matrix3f(pdbScaleMatrixArray);
        this.pdbScaleMatrixTranspose = new Matrix3f();
        this.pdbScaleMatrixTranspose.transpose(this.pdbScaleMatrix);
    }

    void setPdbScaleTranslate(float[] pdbScaleTranslate) {
        if (pdbScaleTranslate == null) {
            return;
        }
        if (pdbScaleTranslate.length != 3) {
            System.out.println("pdbScaleTranslate.length != 3 :" + pdbScaleTranslate);
            return;
        }
        this.pdbTranslateVector = new Vector3f(pdbScaleTranslate);
    }

    ShapeRenderer getRenderer(int shapeID) {
        return this.frameRenderer.getRenderer(shapeID, null);
    }

    void doUnitcellStuff() {
        if (this.notionalUnitcell != null) {
            this.constructFractionalMatrices();
            if (this.fileCoordinatesAreFractional) {
                this.convertFractionalToEuclidean();
            }
        }
    }

    void constructFractionalMatrices() {
        this.matrixNotional = new Matrix3f();
        this.calcNotionalMatrix(this.notionalUnitcell, this.matrixNotional);
        if (this.pdbScaleMatrix != null) {
            this.matrixEuclideanToFractional = new Matrix3f();
            this.matrixEuclideanToFractional.transpose(this.pdbScaleMatrix);
            this.matrixFractionalToEuclidean = new Matrix3f();
            this.matrixFractionalToEuclidean.invert(this.matrixEuclideanToFractional);
        } else {
            this.matrixFractionalToEuclidean = this.matrixNotional;
            this.matrixEuclideanToFractional = new Matrix3f();
            this.matrixEuclideanToFractional.invert(this.matrixFractionalToEuclidean);
        }
    }

    void calcNotionalMatrix(float[] notionalUnitcell, Matrix3f matrixNotional) {
        float gamma = notionalUnitcell[5];
        float beta = notionalUnitcell[4];
        float alpha = notionalUnitcell[3];
        float c = notionalUnitcell[2];
        float b = notionalUnitcell[1];
        float a = notionalUnitcell[0];
        float cosAlpha = (float)Math.cos((float)Math.PI / 180 * alpha);
        float sinAlpha = (float)Math.sin((float)Math.PI / 180 * alpha);
        float cosBeta = (float)Math.cos((float)Math.PI / 180 * beta);
        float sinBeta = (float)Math.sin((float)Math.PI / 180 * beta);
        float cosGamma = (float)Math.cos((float)Math.PI / 180 * gamma);
        float sinGamma = (float)Math.sin((float)Math.PI / 180 * gamma);
        matrixNotional.setColumn(0, a, 0.0f, 0.0f);
        matrixNotional.setColumn(1, b * cosGamma, b * sinGamma, 0.0f);
        float V = a * b * c * (float)Math.sqrt(1.0 - (double)(cosAlpha * cosAlpha) - (double)(cosBeta * cosBeta) - (double)(cosGamma * cosGamma) + 2.0 * (double)cosAlpha * (double)cosBeta * (double)cosGamma);
        matrixNotional.setColumn(2, c * cosBeta, c * (cosAlpha - cosBeta * cosGamma) / sinGamma, V / (a * b * sinGamma));
    }

    void putAtomsInsideUnitcell() {
        this.convertEuclideanToFractional();
        Point3f adjustment = this.findFractionalAdjustment();
        if (adjustment.x != 0.0f || adjustment.y != 0.0f || adjustment.z != 0.0f) {
            this.applyFractionalAdjustment(adjustment);
        }
        this.convertFractionalToEuclidean();
    }

    void convertEuclideanToFractional() {
        int i = this.atomCount;
        while (--i >= 0) {
            this.matrixEuclideanToFractional.transform(this.atoms[i].point3f);
        }
    }

    void convertFractionalToEuclidean() {
        int i = this.atomCount;
        while (--i >= 0) {
            this.matrixFractionalToEuclidean.transform(this.atoms[i].point3f);
        }
    }

    Point3f findFractionalAdjustment() {
        Point3f pointMin = new Point3f();
        Point3f pointMax = new Point3f();
        this.calcAtomsMinMax(pointMin, pointMax);
        pointMin.add(pointMax);
        pointMin.scale(0.5f);
        Point3f fractionalCenter = pointMin;
        System.out.println("fractionalCenter=" + fractionalCenter);
        Point3f adjustment = pointMax;
        adjustment.set((float)Math.floor(fractionalCenter.x), (float)Math.floor(fractionalCenter.y), (float)Math.floor(fractionalCenter.z));
        return adjustment;
    }

    void applyFractionalAdjustment(Point3f adjustment) {
        System.out.println("applyFractionalAdjustment(" + adjustment + ")");
        int i = this.atomCount;
        while (--i >= 0) {
            this.atoms[i].point3f.sub(adjustment);
        }
    }

    void calcAtomsMinMax(Point3f pointMin, Point3f pointMax) {
        float maxZ;
        float maxY;
        float maxX;
        Point3f pointT = this.atoms[0].point3f;
        float minX = maxX = pointT.x;
        float minY = maxY = pointT.y;
        float minZ = maxZ = pointT.z;
        int i = this.atomCount;
        while (--i > 0) {
            pointT = this.atoms[i].point3f;
            float t = pointT.x;
            if (t < minX) {
                minX = t;
            } else if (t > maxX) {
                maxX = t;
            }
            t = pointT.y;
            if (t < minY) {
                minY = t;
            } else if (t > maxY) {
                maxY = t;
            }
            t = pointT.z;
            if (t < minZ) {
                minZ = t;
                continue;
            }
            if (!(t > maxZ)) continue;
            maxZ = t;
        }
        pointMin.set(minX, minY, minZ);
        pointMax.set(maxX, maxY, maxZ);
    }

    void setLabel(String label, int atomIndex) {
    }

    void findElementsPresent() {
        this.elementsPresent = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            this.elementsPresent.set(this.atoms[i].elementNumber);
        }
    }

    public BitSet getElementsPresentBitSet() {
        return this.elementsPresent;
    }

    void findGroupsPresent() {
        Group groupLast = null;
        this.groupsPresent = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (groupLast == this.atoms[i].group) continue;
            groupLast = this.atoms[i].group;
            this.groupsPresent.set(groupLast.getGroupID());
        }
    }

    void findMaxRadii() {
        int i = this.atomCount;
        while (--i >= 0) {
            float vdwRadius;
            Atom atom = this.atoms[i];
            float bondingRadius = atom.getBondingRadiusFloat();
            if (bondingRadius > this.maxBondingRadius) {
                this.maxBondingRadius = bondingRadius;
            }
            if (!((vdwRadius = atom.getVanderwaalsRadiusFloat()) > this.maxVanderwaalsRadius)) continue;
            this.maxVanderwaalsRadius = vdwRadius;
        }
    }

    public BitSet getGroupsPresentBitSet() {
        return this.groupsPresent;
    }

    void calcBfactorRange() {
        if (!this.hasBfactorRange) {
            this.bfactor100Lo = this.bfactor100Hi = this.atoms[0].getBfactor100();
            int i = this.atomCount;
            while (--i > 0) {
                int bf = this.atoms[i].getBfactor100();
                if (bf < this.bfactor100Lo) {
                    this.bfactor100Lo = bf;
                    continue;
                }
                if (bf <= this.bfactor100Hi) continue;
                this.bfactor100Hi = bf;
            }
            this.hasBfactorRange = true;
        }
    }

    public int getBfactor100Lo() {
        if (!this.hasBfactorRange) {
            this.calcBfactorRange();
        }
        return this.bfactor100Lo;
    }

    public int getBfactor100Hi() {
        if (!this.hasBfactorRange) {
            this.calcBfactorRange();
        }
        return this.bfactor100Hi;
    }

    class WithinIterator
    implements AtomIterator {
        int bsptIndex;
        Bspt.Tuple center;
        float radius;
        Bspt.SphereIterator bsptIter;

        WithinIterator() {
        }

        void initialize(int bsptIndex, Bspt.Tuple center, float radius) {
            Frame.this.initializeBspf();
            this.bsptIndex = bsptIndex;
            this.bsptIter = Frame.this.bspf.getSphereIterator(bsptIndex);
            this.center = center;
            this.radius = radius;
            this.bsptIter.initialize(center, radius);
        }

        public boolean hasNext() {
            return this.bsptIter.hasMoreElements();
        }

        public Atom next() {
            return (Atom)this.bsptIter.nextElement();
        }

        public void release() {
            this.bsptIter.release();
            this.bsptIter = null;
        }
    }

    class SelectedBondIterator
    implements BondIterator {
        short bondType;
        int iBond;
        BitSet bsSelected;
        boolean bondSelectionModeOr;

        SelectedBondIterator(short bondType, BitSet bsSelected) {
            this.bondType = bondType;
            this.bsSelected = bsSelected;
            this.iBond = 0;
            this.bondSelectionModeOr = Frame.this.viewer.getBondSelectionModeOr();
        }

        public boolean hasNext() {
            while (this.iBond < Frame.this.bondCount) {
                Bond bond = Frame.this.bonds[this.iBond];
                if ((bond.order & this.bondType) != 0) {
                    boolean isSelected2;
                    boolean isSelected1;
                    if (!this.bondSelectionModeOr & (isSelected1 = this.bsSelected.get(bond.atom1.atomIndex)) & (isSelected2 = this.bsSelected.get(bond.atom2.atomIndex)) || this.bondSelectionModeOr & (isSelected1 | isSelected2)) {
                        return true;
                    }
                }
                ++this.iBond;
            }
            return false;
        }

        public Bond next() {
            return Frame.this.bonds[this.iBond++];
        }
    }
}

