/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.openscience.jmol.viewer.datamodel.AlphaPolymer;
import org.openscience.jmol.viewer.datamodel.ProteinStructure;

class Helix
extends ProteinStructure {
    float sumXiLi;
    float sumYiLi;
    float sumZiLi;
    float cosineX;
    float cosineY;
    float cosineZ;

    Helix(AlphaPolymer apolymer, int monomerIndex, int monomerCount) {
        super(apolymer, (byte)3, monomerIndex, monomerCount);
    }

    void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        this.axisA = new Point3f();
        if (this.lowerNeighborIsHelixOrSheet()) {
            this.apolymer.getLeadMidPoint(this.monomerIndex, this.axisA);
        } else {
            this.apolymer.getLeadMidPoint(this.monomerIndex + 1, this.axisA);
        }
        this.axisB = new Point3f();
        if (this.upperNeighborIsHelixOrSheet()) {
            this.apolymer.getLeadMidPoint(this.monomerIndex + this.monomerCount, this.axisB);
        } else {
            this.apolymer.getLeadMidPoint(this.monomerIndex + this.monomerCount - 1, this.axisB);
        }
        this.axisUnitVector = new Vector3f();
        this.axisUnitVector.sub(this.axisB, this.axisA);
        this.axisUnitVector.normalize();
        Point3f tempA = new Point3f();
        this.apolymer.getLeadMidPoint(this.monomerIndex, tempA);
        this.projectOntoAxis(tempA);
        Point3f tempB = new Point3f();
        this.apolymer.getLeadMidPoint(this.monomerIndex + this.monomerCount, tempB);
        this.projectOntoAxis(tempB);
        this.axisA = tempA;
        this.axisB = tempB;
    }

    void calcCenter() {
        if (this.center == null) {
            int i = this.monomerIndex + this.monomerCount - 1;
            this.center = new Point3f(this.apolymer.getLeadPoint(i));
            while (--i >= this.monomerIndex) {
                this.center.add(this.apolymer.getLeadPoint(i));
            }
            this.center.scale(1.0f / (float)this.monomerCount);
        }
    }

    static float length(Point3f point) {
        return (float)Math.sqrt(point.x * point.x + point.y * point.y + point.z * point.z);
    }

    void calcSums(int count, Point3f[] points, float[] lengths) {
        this.sumZiLi = 0.0f;
        this.sumYiLi = 0.0f;
        this.sumXiLi = 0.0f;
        int i = count;
        while (--i >= 0) {
            Point3f point = points[i];
            float length = lengths[i];
            this.sumXiLi += point.x * length;
            this.sumYiLi += point.y * length;
            this.sumZiLi += point.z * length;
        }
    }

    void calcDirectionCosines() {
        float denominator = (float)Math.sqrt(this.sumXiLi * this.sumXiLi + this.sumYiLi * this.sumYiLi + this.sumZiLi * this.sumZiLi);
        this.cosineX = this.sumXiLi / denominator;
        this.cosineY = this.sumYiLi / denominator;
        this.cosineZ = this.sumZiLi / denominator;
    }
}

