/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.openscience.jmol.viewer.datamodel.AlphaPolymer;
import org.openscience.jmol.viewer.datamodel.Monomer;

abstract class ProteinStructure {
    AlphaPolymer apolymer;
    byte type;
    int monomerIndex;
    int monomerCount;
    Point3f center;
    Point3f axisA;
    Point3f axisB;
    Vector3f axisUnitVector;
    Point3f[] segments;
    final Vector3f vectorProjection = new Vector3f();

    ProteinStructure(AlphaPolymer apolymer, byte type, int monomerIndex, int monomerCount) {
        this.apolymer = apolymer;
        this.type = type;
        this.monomerIndex = monomerIndex;
        this.monomerCount = monomerCount;
    }

    void calcAxis() {
    }

    void calcSegments() {
        if (this.segments != null) {
            return;
        }
        this.calcAxis();
        this.segments = new Point3f[this.monomerCount + 1];
        this.segments[this.monomerCount] = this.axisB;
        this.segments[0] = this.axisA;
        int i = this.monomerCount;
        while (--i > 0) {
            Point3f point = this.segments[i] = new Point3f();
            this.apolymer.getLeadMidPoint(this.monomerIndex + i, point);
            this.projectOntoAxis(point);
        }
        for (i = 0; i < this.segments.length; ++i) {
            Point3f point3f = this.segments[i];
        }
    }

    boolean lowerNeighborIsHelixOrSheet() {
        if (this.monomerIndex == 0) {
            return false;
        }
        return this.apolymer.monomers[this.monomerIndex - 1].isHelixOrSheet();
    }

    boolean upperNeighborIsHelixOrSheet() {
        int upperNeighborIndex = this.monomerIndex + this.monomerCount;
        if (upperNeighborIndex == this.apolymer.count) {
            return false;
        }
        return this.apolymer.monomers[upperNeighborIndex].isHelixOrSheet();
    }

    void projectOntoAxis(Point3f point) {
        this.vectorProjection.sub(point, this.axisA);
        float projectedLength = this.vectorProjection.dot(this.axisUnitVector);
        point.set(this.axisUnitVector);
        point.scaleAdd(projectedLength, this.axisA);
    }

    int getMonomerCount() {
        return this.monomerCount;
    }

    int getMonomerIndex() {
        return this.monomerIndex;
    }

    int getIndex(Monomer monomer) {
        Monomer[] monomers = this.apolymer.monomers;
        int i = this.monomerCount;
        while (--i >= 0 && monomers[this.monomerIndex + i] != monomer) {
        }
        return i;
    }

    Point3f[] getSegments() {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments;
    }

    Point3f getAxisStartPoint() {
        this.calcAxis();
        return this.axisA;
    }

    Point3f getAxisEndPoint() {
        this.calcAxis();
        return this.axisB;
    }

    Point3f getStructureMidPoint(int index) {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments[index];
    }
}

