/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.mirror;

import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.SiteModelFactory;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class MirrorSite
extends Site {
    private static final String INDENT = "   ";
    private SiteModelFactory factory;
    private Collection downloadedPluginEntries = new ArrayList();
    private Collection downloadedFeatureReferenceModels = new ArrayList();

    public MirrorSite(SiteModelFactory factory) {
        this.factory = factory;
    }

    public void mirrorAndExpose(ISite remoteSite, ISiteFeatureReference[] sourceFeatureRefs, IFeatureReference[] optionalfeatures, String mirrorSiteUrl) throws CoreException {
        this.mirrorAndExposeFeatures(remoteSite, sourceFeatureRefs, optionalfeatures);
        System.out.println("Installing features finished. Updating categories ...");
        this.updateCategories(remoteSite);
        System.out.println("Updating categories finished. Updating site description ...");
        this.updateDescription(remoteSite);
        System.out.println("Updating site description finished. Saving site.xml ...");
        this.save();
        if (mirrorSiteUrl != null) {
            this.generateUpdatePolicy(mirrorSiteUrl);
        }
    }

    private void mirrorAndExposeFeatures(ISite remoteSite, ISiteFeatureReference[] sourceFeatureRefs, IFeatureReference[] optionalfeatures) throws CoreException {
        int j;
        ICategory[] remoteCategories;
        SiteFeatureReferenceModel featureRef;
        IFeature sourceFeature;
        ArrayList<ISiteFeatureReference> failedFeatures = new ArrayList<ISiteFeatureReference>();
        int i = 0;
        while (i < sourceFeatureRefs.length) {
            try {
                sourceFeature = sourceFeatureRefs[i].getFeature((IProgressMonitor)new NullProgressMonitor());
                featureRef = this.mirrorFeature(remoteSite, sourceFeature, optionalfeatures, 1);
                remoteCategories = sourceFeatureRefs[i].getCategories();
                j = 0;
                while (j < remoteCategories.length) {
                    featureRef.addCategoryName(remoteCategories[j].getName());
                    ++j;
                }
                this.addFeatureReferenceModel(remoteSite, featureRef);
            }
            catch (CoreException coreException) {
                failedFeatures.add(sourceFeatureRefs[i]);
            }
            ++i;
        }
        if (failedFeatures.size() <= 0) {
            return;
        }
        sourceFeatureRefs = failedFeatures.toArray(new ISiteFeatureReference[failedFeatures.size()]);
        i = 0;
        while (i < sourceFeatureRefs.length) {
            sourceFeature = sourceFeatureRefs[i].getFeature((IProgressMonitor)new NullProgressMonitor());
            featureRef = this.mirrorFeature(remoteSite, sourceFeature, optionalfeatures, 1);
            remoteCategories = sourceFeatureRefs[i].getCategories();
            j = 0;
            while (j < remoteCategories.length) {
                featureRef.addCategoryName(remoteCategories[j].getName());
                ++j;
            }
            this.addFeatureReferenceModel(remoteSite, featureRef);
            ++i;
        }
    }

    private SiteFeatureReferenceModel mirrorFeature(ISite remoteSite, IFeature sourceFeature, IFeatureReference[] optionalfeatures, int indent) throws CoreException {
        ContentReference[] references;
        String tab = "";
        int i = 0;
        while (i < indent) {
            tab = String.valueOf(tab) + " ";
            ++i;
        }
        System.out.println(String.valueOf(tab) + "Mirroring feature " + sourceFeature.getVersionedIdentifier() + " ...");
        SiteFeatureReferenceModel[] existingFeatures = this.getDownloadedFeatureReferenceModels();
        int e = 0;
        while (e < existingFeatures.length) {
            if (existingFeatures[e].getVersionedIdentifier().equals(sourceFeature.getVersionedIdentifier())) {
                System.out.println(String.valueOf(tab) + "Feature " + sourceFeature.getVersionedIdentifier() + " already exists.  Skipping downloading.");
                return existingFeatures[e];
            }
            ++e;
        }
        IFeatureContentProvider provider = sourceFeature.getFeatureContentProvider();
        System.out.println(String.valueOf(tab) + "Getting plugin entries for " + sourceFeature.getVersionedIdentifier() + " ...");
        IPluginEntry[] sourceFeaturePluginEntries = sourceFeature.getPluginEntries();
        IPluginEntry[] pluginsToInstall = UpdateManagerUtils.diff(sourceFeaturePluginEntries, this.getDownloadedPluginEntries());
        System.out.println(String.valueOf(tab) + "Getting non plugin entries for " + sourceFeature.getVersionedIdentifier() + " ...");
        INonPluginEntry[] nonPluginsToInstall = sourceFeature.getRawNonPluginEntries();
        System.out.println(String.valueOf(tab) + "Getting included features for " + sourceFeature.getVersionedIdentifier() + " ...");
        IFeatureReference[] children = sourceFeature.getRawIncludedFeatureReferences();
        if (optionalfeatures != null) {
            children = UpdateManagerUtils.optionalChildrenToInstall(children, optionalfeatures);
        }
        System.out.println(String.valueOf(tab) + "Downloading feature archives for " + sourceFeature.getVersionedIdentifier() + " ...");
        provider.getFeatureEntryArchiveReferences(null);
        System.out.println(String.valueOf(tab) + "Downloading plug-in archives for " + sourceFeature.getVersionedIdentifier() + " ...");
        int i2 = 0;
        while (i2 < pluginsToInstall.length) {
            provider.getPluginEntryArchiveReferences(pluginsToInstall[i2], null);
            ++i2;
        }
        System.out.println(String.valueOf(tab) + "Downloading non plug-in archives for " + sourceFeature.getVersionedIdentifier() + " ...");
        i2 = 0;
        while (i2 < nonPluginsToInstall.length) {
            provider.getNonPluginEntryArchiveReferences(nonPluginsToInstall[i2], null);
            ++i2;
        }
        System.out.println(String.valueOf(tab) + "Installing child features for " + sourceFeature.getVersionedIdentifier() + " ...");
        i2 = 0;
        while (i2 < children.length) {
            IFeature childFeature = children[i2].getFeature(null);
            this.mirrorFeature(remoteSite, childFeature, optionalfeatures, indent + 1);
            ++i2;
        }
        System.out.println(String.valueOf(tab) + "Storing plug-in archives for " + sourceFeature.getVersionedIdentifier() + " ...");
        i2 = 0;
        while (i2 < pluginsToInstall.length) {
            references = provider.getPluginEntryArchiveReferences(pluginsToInstall[i2], null);
            this.storePluginArchive(references[0]);
            this.addDownloadedPluginEntry(pluginsToInstall[i2]);
            ++i2;
        }
        System.out.println(String.valueOf(tab) + "Storing non plug-in archives for " + sourceFeature.getVersionedIdentifier() + " ...");
        i2 = 0;
        while (i2 < nonPluginsToInstall.length) {
            references = provider.getNonPluginEntryArchiveReferences(nonPluginsToInstall[i2], null);
            int r = 0;
            while (r < references.length) {
                this.storeNonPluginArchive(sourceFeature.getVersionedIdentifier(), references[r]);
                ++r;
            }
            ++i2;
        }
        System.out.println(String.valueOf(tab) + "Storing feature archives for " + sourceFeature.getVersionedIdentifier() + " ...");
        ContentReference[] references2 = provider.getFeatureEntryArchiveReferences(null);
        this.storeFeatureArchive(references2[0]);
        System.out.println(String.valueOf(tab) + "Adding feature " + sourceFeature.getVersionedIdentifier() + " to model ...");
        SiteFeatureReferenceModel featureRef = this.factory.createFeatureReferenceModel();
        featureRef.setSiteModel(this);
        featureRef.setType("org.eclipse.update.core.packaged");
        featureRef.setFeatureIdentifier(sourceFeature.getVersionedIdentifier().getIdentifier());
        featureRef.setFeatureVersion(sourceFeature.getVersionedIdentifier().getVersion().toString());
        this.addDownloadedFeatureReferenceModel(featureRef);
        System.out.println(String.valueOf(tab) + "Mirroring feature " + sourceFeature.getVersionedIdentifier() + " finished.");
        return featureRef;
    }

    public void addFeatureReferenceModel(ISite remoteSite, SiteFeatureReferenceModel featureReference) {
        ISiteFeatureReference[] remoteFeatures = remoteSite.getRawFeatureReferences();
        int i = 0;
        while (i < remoteFeatures.length) {
            ISiteFeatureReference remoteFeatureRef = remoteFeatures[i];
            try {
                if (remoteFeatureRef.getVersionedIdentifier().equals(featureReference.getVersionedIdentifier())) {
                    this.addFeatureReferenceModel(featureReference);
                }
            }
            catch (CoreException ce) {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(ce);
            }
            ++i;
        }
        this.save();
        System.out.println("Feature " + featureReference.getVersionedIdentifier() + " added to site.xml.");
    }

    public void addFeatureReferenceModel(SiteFeatureReferenceModel featureReference) {
        SiteFeatureReferenceModel[] existingModels = this.getFeatureReferenceModels();
        int j = 0;
        while (j < existingModels.length) {
            if (existingModels[j].getVersionedIdentifier().equals(featureReference.getVersionedIdentifier())) {
                super.removeFeatureReferenceModel(existingModels[j]);
            }
            ++j;
        }
        super.addFeatureReferenceModel(featureReference);
    }

    /*
     * Exception decompiling
     */
    private void storeFeatureArchive(ContentReference contentReference) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 119->123)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void storePluginArchive(ContentReference contentReference) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 97->101)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void storeNonPluginArchive(VersionedIdentifier featureVersionedIdentifier, ContentReference contentReference) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 148->152)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void save() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 113->117)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void save(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writeSite("", writer);
    }

    private void writeSite(String indent, PrintWriter writer) {
        writer.print(String.valueOf(indent) + "<site");
        String indent2 = String.valueOf(indent) + INDENT;
        writer.println(">");
        URLEntryModel description = this.getDescriptionModel();
        if (description != null) {
            writer.println();
            this.writeDescription(indent2, writer, description);
            writer.println();
        }
        this.writeFeatures(indent2, writer);
        this.writeCategories(indent2, writer);
        writer.println(String.valueOf(indent) + "</site>");
    }

    private void writeFeatures(String indent, PrintWriter writer) {
        SiteFeatureReferenceModel[] featureReferenceModels = this.getFeatureReferenceModels();
        int i = 0;
        while (i < featureReferenceModels.length) {
            writer.print(indent);
            writer.print("<feature");
            writer.print(" url=\"features/" + featureReferenceModels[i].getFeatureIdentifier() + "_" + featureReferenceModels[i].getFeatureVersion() + ".jar\"");
            writer.print(" id=\"" + featureReferenceModels[i].getFeatureIdentifier() + "\"");
            writer.print(" version=\"" + featureReferenceModels[i].getFeatureVersion() + "\"");
            writer.println(">");
            String[] categoryNames = featureReferenceModels[i].getCategoryNames();
            int cn = 0;
            while (cn < categoryNames.length) {
                writer.print(String.valueOf(indent) + INDENT);
                writer.println("<category name=\"" + categoryNames[cn] + "\" />");
                ++cn;
            }
            writer.print(indent);
            writer.println("</feature>");
            writer.println();
            ++i;
        }
    }

    private void writeCategories(String indent, PrintWriter writer) {
        CategoryModel[] categoryModels = this.getCategoryModels();
        if (categoryModels.length <= 0) {
            return;
        }
        int i = 0;
        while (i < categoryModels.length) {
            writer.print(indent);
            writer.print("<category-def");
            writer.print(" name=\"" + categoryModels[i].getName() + "\" label=\"" + categoryModels[i].getLabel() + "\"");
            writer.println(">");
            if (categoryModels[i].getDescriptionModel() != null) {
                this.writeDescription(String.valueOf(indent) + INDENT, writer, categoryModels[i].getDescriptionModel());
            }
            writer.print(indent);
            writer.println("</category-def>");
            writer.println();
            ++i;
        }
    }

    private void writeDescription(String indent, PrintWriter writer, URLEntryModel urlEntryModel) {
        String url = urlEntryModel.getURLString();
        String text = urlEntryModel.getAnnotationNonLocalized();
        if (url == null && text == null && text.length() <= 0) {
            return;
        }
        writer.print(indent);
        writer.print("<description");
        if (url != null) {
            writer.print(" url=\"" + url + "\"");
        }
        if (text == null || text.length() <= 0) {
            writer.println(" />");
        } else {
            writer.println(">");
            if (text != null) {
                writer.println(String.valueOf(indent) + INDENT + UpdateManagerUtils.Writer.xmlSafe(text));
            }
            writer.println(String.valueOf(indent) + "</description>");
        }
    }

    public void addDownloadedPluginEntry(IPluginEntry pluginEntry) {
        this.downloadedPluginEntries.add(pluginEntry);
    }

    private IPluginEntry[] getDownloadedPluginEntries() {
        return this.downloadedPluginEntries.toArray(new IPluginEntry[this.downloadedPluginEntries.size()]);
    }

    public void addDownloadedFeatureReferenceModel(SiteFeatureReferenceModel featureModel) {
        this.downloadedFeatureReferenceModels.add(featureModel);
    }

    private SiteFeatureReferenceModel[] getDownloadedFeatureReferenceModels() {
        return this.downloadedFeatureReferenceModels.toArray(new SiteFeatureReferenceModel[this.downloadedFeatureReferenceModels.size()]);
    }

    private void updateDescription(ISite remoteSite) {
        IURLEntry urlEntry = remoteSite.getDescription();
        if (urlEntry != null) {
            URLEntryModel newUrlEntryModel = new URLEntryModel();
            URL url = urlEntry.getURL();
            newUrlEntryModel.setAnnotation(urlEntry.getAnnotation());
            newUrlEntryModel.setURLString(url.toExternalForm());
            this.setDescriptionModel(newUrlEntryModel);
        }
    }

    private void updateCategories(ISite remoteSite) {
        HashSet<String> usedCategoryNames = new HashSet<String>();
        SiteFeatureReferenceModel[] featureRefModels = this.getFeatureReferenceModels();
        int f = 0;
        while (f < featureRefModels.length) {
            String[] featureCategoryNames = featureRefModels[f].getCategoryNames();
            int c = 0;
            while (c < featureCategoryNames.length) {
                usedCategoryNames.add(featureCategoryNames[c]);
                ++c;
            }
            ++f;
        }
        ArrayList<Object> newCategoryModels = new ArrayList<Object>();
        Iterator it = usedCategoryNames.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ICategory remoteCategory = remoteSite.getCategory(name);
            if (remoteCategory == null) {
                CategoryModel oldCategory = null;
                try {
                    oldCategory = (CategoryModel)((Object)this.getCategory(name));
                }
                catch (NullPointerException nullPointerException) {}
                if (oldCategory == null) continue;
                newCategoryModels.add((Object)oldCategory);
                continue;
            }
            newCategoryModels.add(remoteCategory);
        }
        this.setCategoryModels(newCategoryModels.toArray(new CategoryModel[newCategoryModels.size()]));
    }

    /*
     * Exception decompiling
     */
    private void generateUpdatePolicy(String url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 156->160)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeUrlMaps(PrintWriter writer, String url) {
        SiteFeatureReferenceModel[] featureReferenceModels = this.getFeatureReferenceModels();
        int i = 0;
        while (i < featureReferenceModels.length) {
            writer.print("\t");
            writer.print("<url-map");
            writer.print(" pattern=\"" + featureReferenceModels[i].getFeatureIdentifier() + "\"");
            writer.print(" url=\"" + url + "\"");
            writer.println(" />");
            ++i;
        }
    }
}

