/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.emboss.jemboss.editor.Consensus;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.gui.form.LabelTextBox;
import org.emboss.jemboss.gui.form.TextFieldFloat;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class ConsensusOptions
extends JFrame {
    private TextFieldFloat pluralFloat;
    private TextFieldInt idInt;
    private TextFieldFloat caseFloat;
    private GraphicSequenceCollection gsc;
    private Matrix mat;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private JScrollPane jspSequence;

    public ConsensusOptions(JScrollPane jScrollPane) {
        super("Consensus Options");
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(4));
        Box box2 = Box.createHorizontalBox();
        this.pluralFloat = new TextFieldFloat();
        Dimension dimension = new Dimension(65, 30);
        this.pluralFloat.setPreferredSize(dimension);
        this.pluralFloat.setMaximumSize(dimension);
        box2.add(this.pluralFloat);
        LabelTextBox labelTextBox = new LabelTextBox("Minimum positive match score value for there to be a consensus", "Set a cut-off for the number of\npositive matches below which\nthere is no consensus.");
        box2.add(labelTextBox);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        this.idInt = new TextFieldInt();
        this.idInt.setText("0");
        this.idInt.setPreferredSize(dimension);
        this.idInt.setMaximumSize(dimension);
        box2.add(this.idInt);
        LabelTextBox labelTextBox2 = new LabelTextBox("Minimum number of identities for there to be a consensus", "The required number of identities\nat a site for it to give a consensus\nat that position. Therefore, if this\nis set to the number of sequences in\nthe alignment only columns of identities\ncontribute to the consensus.");
        box2.add(labelTextBox2);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        this.caseFloat = new TextFieldFloat();
        this.caseFloat.setPreferredSize(dimension);
        this.caseFloat.setMaximumSize(dimension);
        box2.add(this.caseFloat);
        LabelTextBox labelTextBox3 = new LabelTextBox("Threshold positive match score for setting the consensus to upper-case", "Sets the threshold for the positive\nmatches above which the consensus is\nin upper-case and below which the\nconsensus is in lower-case.");
        box2.add(labelTextBox3);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        JButton jButton = new JButton("Calculate Consensus");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsensusOptions.this.setCursor(ConsensusOptions.this.cbusy);
                ConsensusOptions.this.gsc.deleteSequence("Consensus");
                Consensus consensus = new Consensus(ConsensusOptions.this.mat, ConsensusOptions.this.gsc.getSequenceCollection(), ConsensusOptions.this.getPlurality(), ConsensusOptions.this.getCase(), ConsensusOptions.this.getIdentity());
                int n = ConsensusOptions.this.gsc.getFontSize();
                ConsensusOptions.this.gsc.addSequence(consensus.getConsensusSequence(), true, 5, n);
                Dimension dimension = ConsensusOptions.this.gsc.getPanelSize();
                ConsensusOptions.this.gsc.setPreferredSize(dimension);
                ConsensusOptions.this.gsc.setNamePanelWidth(ConsensusOptions.this.gsc.getNameWidth());
                ConsensusOptions.this.setCursor(ConsensusOptions.this.cdone);
            }
        });
        box2.add(jButton);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenu.add(new JSeparator());
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsensusOptions.this.setVisible(false);
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.getContentPane().add(box);
        this.pack();
    }

    public float getPlurality() {
        return Float.parseFloat(this.pluralFloat.getText());
    }

    public float getCase() {
        return Float.parseFloat(this.caseFloat.getText());
    }

    public int getIdentity() {
        return Integer.parseInt(this.idInt.getText());
    }

    protected void setCase(float f) {
        f = Math.round(f * 100.0f);
        this.caseFloat.setText(Float.toString(f / 100.0f));
    }

    protected void setGraphicSequenceCollection(GraphicSequenceCollection graphicSequenceCollection) {
        this.gsc = graphicSequenceCollection;
    }

    protected void setMatrix(Matrix matrix) {
        this.mat = matrix;
    }

    protected void setPlurality(float f) {
        f = Math.round(f * 100.0f);
        this.pluralFloat.setText(Float.toString(f / 100.0f));
    }
}

