/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumn;
import org.emboss.jemboss.editor.PrintableJTable;
import org.emboss.jemboss.editor.Sequence;

public class IDTableJFrame
extends JFrame {
    private PrintableJTable idTable = new PrintableJTable();

    public IDTableJFrame(Vector vector) {
        super("Percentatge ID");
        int n = vector.size();
        Font font = this.idTable.getFont();
        FontMetrics fontMetrics = this.idTable.getFontMetrics(font);
        int n2 = 0;
        String[] stringArray = new String[n + 1];
        Object[][] objectArray = new Object[n][n + 1];
        stringArray[0] = new String("");
        for (int i = 0; i < n; ++i) {
            Sequence sequence = (Sequence)vector.get(i);
            int n3 = sequence.getLength();
            String string = sequence.getName();
            int n4 = fontMetrics.stringWidth(string + "  ");
            if (n4 > n2) {
                n2 = n4;
            }
            stringArray[i + 1] = string;
            objectArray[i][0] = string;
            if (string.equals("Consensus")) continue;
            for (int j = i; j < n; ++j) {
                Sequence sequence2 = (Sequence)vector.get(j);
                if (sequence2.getName().equals("Consensus")) continue;
                int n5 = 0;
                int n6 = sequence2.getLength();
                if (n6 > n3) {
                    n3 = n6;
                }
                for (int k = 0; k < n3; ++k) {
                    try {
                        if (!sequence.getResidueAt(k).equals(sequence2.getResidueAt(k))) continue;
                        ++n5;
                        continue;
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        System.out.println("Sequences have different length!");
                    }
                }
                float f = Math.round((float)n5 / (float)n3 * 10000.0f);
                objectArray[i][j + 1] = new Float(f / 100.0f);
            }
        }
        this.idTable = new PrintableJTable(objectArray, stringArray);
        TableColumn tableColumn = null;
        tableColumn = this.idTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(n2);
        for (int i = 0; i < n; ++i) {
            tableColumn = this.idTable.getColumnModel().getColumn(i + 1);
            String string = this.idTable.getColumnName(i + 1);
            int n7 = fontMetrics.stringWidth(string + "  ");
            tableColumn.setPreferredWidth(n7);
        }
        this.idTable.setAutoResizeMode(0);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Print");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IDTableJFrame.this.idTable.doPrintActions();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        JMenuItem jMenuItem2 = new JMenuItem("Close");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IDTableJFrame.this.setVisible(false);
            }
        });
        jMenu.add(jMenuItem2);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        JScrollPane jScrollPane = new JScrollPane(this.idTable);
        jScrollPane.setPreferredSize(this.idTable.getPreferredSize());
        this.getContentPane().add(jScrollPane);
        this.pack();
    }

    protected void printTable() {
        int n = this.idTable.getColumnCount();
        int n2 = this.idTable.getRowCount();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Object object = this.idTable.getValueAt(i, j);
                if (object == null) {
                    object = "-";
                }
                System.out.print(object + "\t");
            }
            System.out.print("\n");
        }
    }
}

