/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.gui.form.LabelTextBox;
import org.emboss.jemboss.gui.form.TextFieldFloat;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class PrettyPlotJFrame
extends JFrame
implements ActionListener {
    private TextFieldInt textInt;
    private TextFieldFloat textFloat;
    private JColorChooser idColour;
    private JColorChooser matchColour;
    private JColorChooser idColourBackground;
    private JColorChooser matchColourBackground;
    private GraphicSequenceCollection gsc;
    private JCheckBox prettyBox;

    public PrettyPlotJFrame(int n, float f, Color color, Color color2, Color color3, Color color4, boolean bl) {
        this.textInt = new TextFieldInt();
        this.textInt.setText(Integer.toString(n));
        this.textFloat = new TextFieldFloat();
        this.textFloat.setValue(f);
        this.idColour = new JColorChooser(color);
        this.matchColour = new JColorChooser(color2);
        this.idColourBackground = new JColorChooser(color3);
        this.matchColourBackground = new JColorChooser(color4);
        this.prettyBox = new JCheckBox();
        this.prettyBox.setSelected(bl);
    }

    public PrettyPlotJFrame(GraphicSequenceCollection graphicSequenceCollection) {
        super("Colour Matches");
        this.gsc = graphicSequenceCollection;
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(4));
        Box box2 = Box.createHorizontalBox();
        this.textInt = new TextFieldInt();
        this.textInt.setText(Integer.toString(graphicSequenceCollection.getNumberSequences()));
        Dimension dimension = new Dimension(50, 30);
        this.textInt.setPreferredSize(dimension);
        this.textInt.setMaximumSize(dimension);
        box2.add(this.textInt);
        LabelTextBox labelTextBox = new LabelTextBox("Identity Number", "Minimum number of identities in a column");
        box2.add(labelTextBox);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createVerticalStrut(4));
        box2 = Box.createHorizontalBox();
        this.textFloat = new TextFieldFloat();
        this.textFloat.setValue(AlignJFrame.getTotalWeight(graphicSequenceCollection.getSequenceCollection()) / 2.0f);
        this.textFloat.setPreferredSize(dimension);
        this.textFloat.setMinimumSize(dimension);
        box2.add(this.textFloat);
        LabelTextBox labelTextBox2 = new LabelTextBox("Threshold for positive matches", "Minimum number of positive matches. The default\nis half the total weight of all the sequences.");
        box2.add(labelTextBox2);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createVerticalStrut(4));
        box2 = Box.createHorizontalBox();
        this.idColour = new JColorChooser(Color.red);
        final JButton jButton = new JButton("");
        Dimension dimension2 = new Dimension(25, 20);
        jButton.setPreferredSize(dimension2);
        final JDialog jDialog = JColorChooser.createDialog(jButton, "Pick a Color", true, this.idColour, null, null);
        jButton.setBackground(Color.red);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.show();
                jButton.setBackground(PrettyPlotJFrame.this.idColour.getColor());
            }
        });
        box2.add(jButton);
        labelTextBox = new LabelTextBox("Identity Colour", "");
        box2.add(labelTextBox);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createVerticalStrut(4));
        box2 = Box.createHorizontalBox();
        this.idColourBackground = new JColorChooser(Color.white);
        final JButton jButton2 = new JButton("");
        jButton2.setPreferredSize(dimension2);
        final JDialog jDialog2 = JColorChooser.createDialog(jButton2, "Pick a Color", true, this.idColourBackground, null, null);
        jButton2.setBackground(Color.white);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog2.show();
                jButton2.setBackground(PrettyPlotJFrame.this.idColourBackground.getColor());
            }
        });
        box2.add(jButton2);
        labelTextBox = new LabelTextBox("Identity Background Colour", "");
        box2.add(labelTextBox);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createVerticalStrut(4));
        box2 = Box.createHorizontalBox();
        this.matchColour = new JColorChooser(Color.blue);
        final JButton jButton3 = new JButton("");
        jButton3.setPreferredSize(dimension2);
        final JDialog jDialog3 = JColorChooser.createDialog(jButton3, "Pick a Color", true, this.matchColour, null, null);
        jButton3.setBackground(Color.blue);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog3.show();
                jButton3.setBackground(PrettyPlotJFrame.this.matchColour.getColor());
            }
        });
        box2.add(jButton3);
        labelTextBox = new LabelTextBox("Positive Match Colour", "");
        box2.add(labelTextBox);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        this.matchColourBackground = new JColorChooser(Color.white);
        final JButton jButton4 = new JButton("");
        jButton4.setPreferredSize(dimension2);
        final JDialog jDialog4 = JColorChooser.createDialog(jButton3, "Pick a Color", true, this.matchColourBackground, null, null);
        jButton4.setBackground(Color.white);
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog4.show();
                jButton4.setBackground(PrettyPlotJFrame.this.matchColourBackground.getColor());
            }
        });
        box2.add(jButton4);
        labelTextBox = new LabelTextBox("Positive Match Background Colour", "");
        box2.add(labelTextBox);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        this.prettyBox = new JCheckBox("Box");
        this.prettyBox.setSelected(true);
        box2.add(this.prettyBox);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        JButton jButton5 = new JButton("Set");
        jButton5.addActionListener(this);
        jButton5.setActionCommand("SET");
        box2.add(jButton5);
        box.add(box2);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenu.add(new JSeparator());
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrettyPlotJFrame.this.setVisible(false);
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.getContentPane().add(box);
        this.pack();
    }

    public int getMinimumIdentity(int n) {
        return Integer.parseInt(this.textInt.getText());
    }

    public double getMatchThreshold() {
        return this.textFloat.getValue();
    }

    public Color getIDColour() {
        return this.idColour.getColor();
    }

    public Color getIDBackgroundColour() {
        return this.idColourBackground.getColor();
    }

    public Color getMatchColour() {
        return this.matchColour.getColor();
    }

    public Color getMatchBackgroundColour() {
        return this.matchColourBackground.getColor();
    }

    protected boolean isPrettyBox() {
        return this.prettyBox.isSelected();
    }

    protected void setGraphicSequenceCollection(GraphicSequenceCollection graphicSequenceCollection) {
        this.gsc = graphicSequenceCollection;
        this.textInt.setText(Integer.toString(graphicSequenceCollection.getNumberSequences()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("SET")) {
            this.gsc.setPrettyPlot(true, this);
            this.gsc.setDrawBoxes(false);
            this.gsc.setDrawColor(false);
        }
    }
}

