/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.editor.PrintAlignment;
import org.emboss.jemboss.gui.ScrollPanel;

public class PrintAlignmentImage
extends ScrollPanel {
    private PageFormat format = null;
    private int pageIndex = 0;
    private GraphicSequenceCollection gsc;
    private String filePrefix;
    private JTextField statusField = new JTextField("");
    private int nResPerLine = 0;
    private boolean antiAlias = false;

    public PrintAlignmentImage(GraphicSequenceCollection graphicSequenceCollection, PageFormat pageFormat) {
        this(graphicSequenceCollection);
        this.format = pageFormat;
    }

    public PrintAlignmentImage(GraphicSequenceCollection graphicSequenceCollection) {
        this.gsc = graphicSequenceCollection;
        this.setBackground(Color.white);
    }

    protected void setFormat(PageFormat pageFormat) {
        this.format = pageFormat;
    }

    protected PageFormat getFormat() {
        return this.format;
    }

    public void setPageIndex(int n) {
        this.pageIndex = n;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.nResPerLine == 0) {
            this.gsc.drawSequences(graphics2D, this.format, this.pageIndex);
        } else {
            this.gsc.drawSequences(graphics2D, this.format, this.pageIndex, this.nResPerLine);
        }
    }

    public void print() {
        if (this.format == null) {
            this.getFormatDialog();
        }
        try {
            String string = this.showOptions(true);
            int n = this.gsc.getNumberPages(this.format, this.nResPerLine);
            for (int i = 0; i < n; ++i) {
                RenderedImage renderedImage = this.createAlignmentImage(i);
                this.writeImageToFile(renderedImage, new File(this.filePrefix + i + "." + string), string);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            JOptionPane.showMessageDialog(this, "This option requires Java 1.4 or higher.");
        }
    }

    public void print(int n, String string, String string2, boolean bl, double d, double d2, double d3, double d4) {
        this.nResPerLine = n;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.format = new PageFormat();
        if (bl) {
            this.format.setOrientation(0);
        } else {
            this.format.setOrientation(1);
        }
        if (d > 0.0) {
            Paper paper = this.format.getPaper();
            double d5 = paper.getWidth() - 72.0 * (d + d2);
            double d6 = paper.getHeight() - 72.0 * (d3 + d4);
            paper.setImageableArea(d * 72.0, d3 * 72.0, d5, d6);
            this.format.setPaper(paper);
        }
        if (n <= 0) {
            this.nResPerLine = this.gsc.getResiduesPerLine(this.format);
        }
        try {
            int n2 = this.gsc.getNumberPages(this.format, this.nResPerLine);
            for (int i = 0; i < n2; ++i) {
                RenderedImage renderedImage = this.createAlignmentImage(i);
                this.writeImageToFile(renderedImage, new File(string2 + i + "." + string), string);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            JOptionPane.showMessageDialog(this, "This option requires Java 1.4 or higher.");
        }
    }

    public void print(String string, double d, double d2, double d3, double d4) {
        this.print(this.nResPerLine, string, this.filePrefix, d, d2, d3, d4);
    }

    public void print(int n, String string, String string2, double d, double d2, double d3, double d4) {
        this.nResPerLine = n;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.format = new PageFormat();
        Dimension dimension = this.gsc.getImageableSize(n);
        double d5 = dimension.getWidth();
        double d6 = dimension.getHeight();
        Paper paper = this.format.getPaper();
        if (d > 0.0) {
            paper.setSize(d5 + ((d *= 72.0) + (d2 *= 72.0)), d6 + ((d3 *= 72.0) + (d4 *= 72.0)));
        } else {
            paper.setSize(d5, d6);
            d = 0.0;
            d3 = 0.0;
        }
        paper.setImageableArea(d, d3, d5, d6 + d6);
        this.format.setPaper(paper);
        try {
            RenderedImage renderedImage = this.createAlignmentImage(0);
            this.writeImageToFile(renderedImage, new File(string2 + "." + string), string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            JOptionPane.showMessageDialog(this, "This option requires Java 1.4 or higher.");
        }
    }

    protected String showOptions(boolean bl) {
        Box box;
        Object object;
        Object object2;
        JPanel jPanel = new JPanel();
        Box box2 = Box.createVerticalBox();
        jPanel.add(box2);
        JComboBox<String> jComboBox = null;
        JTextField jTextField = null;
        if (bl) {
            object2 = new JLabel("File prefix: ");
            object = System.getProperty("user.dir") + System.getProperty("file.separator");
            try {
                object = ((String)object).concat(this.gsc.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            jTextField = new JTextField((String)object);
            box = Box.createHorizontalBox();
            box.add((Component)object2);
            box.add(jTextField);
            box.add(Box.createHorizontalGlue());
            box2.add(box);
            jComboBox = new JComboBox<String>(ImageIO.getWriterFormatNames());
            box2.add(jComboBox);
        }
        box = Box.createHorizontalBox();
        if (this.format == null) {
            this.format = new PageFormat();
        }
        object2 = Integer.toString(this.gsc.getResiduesPerLine(this.format));
        object = new JLabel("Residues per line: [max:" + (String)object2 + "]");
        if (this.nResPerLine != 0) {
            object2 = Integer.toString(this.nResPerLine);
        }
        JTextField jTextField2 = new JTextField((String)object2);
        box.add((Component)object);
        box.add(jTextField2);
        box.add(Box.createHorizontalGlue());
        box2.add(box);
        JOptionPane.showMessageDialog(null, jPanel, "Options", -1);
        this.nResPerLine = Integer.parseInt(jTextField2.getText());
        if (bl) {
            this.filePrefix = jTextField.getText().trim();
            return (String)jComboBox.getSelectedItem();
        }
        return null;
    }

    protected PageFormat getFormatDialog() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.format = new PageFormat();
        this.format = printerJob.pageDialog(this.format);
        return this.format;
    }

    protected void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
    }

    private RenderedImage createAlignmentImage(int n) {
        int n2 = (int)this.format.getWidth();
        int n3 = (int)this.format.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (this.antiAlias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n2, n3);
        if (this.nResPerLine == 0) {
            this.gsc.drawSequences(graphics2D, this.format, n);
        } else {
            this.gsc.drawSequences(graphics2D, this.format, n, this.nResPerLine);
        }
        return bufferedImage;
    }

    protected void printSinglePagePreview() {
        Border border = BorderFactory.createLoweredBevelBorder();
        Border border2 = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        this.statusField.setBorder(compoundBorder);
        this.statusField.setEditable(false);
        this.format = new PageFormat();
        Dimension dimension = this.gsc.getImageableSize(this.nResPerLine);
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        Paper paper = this.format.getPaper();
        paper.setSize(d, d2);
        paper.setImageableArea(0.0, 0.0, d, d2 + d2);
        this.format.setPaper(paper);
        this.statusField.setText(this.pageIndex + "1 of 1 page(s)");
        final JFrame jFrame = new JFrame("Print Preview");
        JPanel jPanel = (JPanel)jFrame.getContentPane();
        JScrollPane jScrollPane = new JScrollPane(this);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.statusField, "South");
        Dimension dimension2 = jFrame.getToolkit().getScreenSize();
        dimension = new Dimension((int)this.format.getWidth(), (int)this.format.getHeight());
        this.setPreferredSize(dimension);
        dimension = new Dimension((int)(dimension2.getWidth() / 2.0), (int)(dimension2.getHeight() * 3.0 / 4.0));
        jFrame.setSize(dimension);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Print Image File (png/jpeg)...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintAlignmentImage.this.print();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        JMenuItem jMenuItem2 = new JMenuItem("Close");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.dispose();
            }
        });
        jFrame.setJMenuBar(jMenuBar);
        jFrame.setVisible(true);
    }

    protected void printPreview() {
        Border border = BorderFactory.createLoweredBevelBorder();
        Border border2 = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        this.statusField.setBorder(compoundBorder);
        this.statusField.setEditable(false);
        if (this.format == null) {
            this.format = this.getFormatDialog();
        }
        this.showOptions(false);
        final int n = this.gsc.getNumberPages(this.format, this.nResPerLine);
        this.statusField.setText(this.pageIndex + "1 of " + n + " page(s)");
        final JFrame jFrame = new JFrame("Print Preview");
        JPanel jPanel = (JPanel)jFrame.getContentPane();
        JScrollPane jScrollPane = new JScrollPane(this);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.statusField, "South");
        Dimension dimension = jFrame.getToolkit().getScreenSize();
        Dimension dimension2 = new Dimension((int)this.format.getWidth(), (int)this.format.getHeight());
        this.setPreferredSize(dimension2);
        dimension2 = new Dimension((int)(dimension.getWidth() / 2.0), (int)(dimension.getHeight() * 3.0 / 4.0));
        jFrame.setSize(dimension2);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Print");
        jMenu.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem("Print Postscript...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new PrintAlignment(PrintAlignmentImage.this.gsc);
            }
        });
        jMenu2.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Print Image Files (png/jpeg)...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintAlignmentImage.this.print();
            }
        });
        jMenu2.add(jMenuItem2);
        jMenu.add(new JSeparator());
        JMenuItem jMenuItem3 = new JMenuItem("Close");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenu.add(jMenuItem3);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.dispose();
            }
        });
        final JButton jButton = new JButton(">");
        final JButton jButton2 = new JButton(">>");
        final JButton jButton3 = new JButton("<");
        final JButton jButton4 = new JButton("<<");
        jMenuBar.add(jButton4);
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintAlignmentImage.this.pageIndex = 0;
                PrintAlignmentImage.this.repaint();
                jButton3.setEnabled(false);
                jButton4.setEnabled(false);
                jButton.setEnabled(true);
                jButton2.setEnabled(true);
                PrintAlignmentImage.this.statusField.setText(PrintAlignmentImage.this.pageIndex + 1 + " of " + n + " pages");
            }
        });
        jMenuBar.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintAlignmentImage.this.pageIndex--;
                PrintAlignmentImage.this.repaint();
                if (PrintAlignmentImage.this.pageIndex == 0) {
                    jButton3.setEnabled(false);
                    jButton4.setEnabled(false);
                }
                jButton.setEnabled(true);
                jButton2.setEnabled(true);
                PrintAlignmentImage.this.statusField.setText(PrintAlignmentImage.this.pageIndex + 1 + " of " + n + " pages");
            }
        });
        jButton3.setEnabled(false);
        jButton4.setEnabled(false);
        jMenuBar.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintAlignmentImage.this.pageIndex++;
                PrintAlignmentImage.this.repaint();
                if (PrintAlignmentImage.this.pageIndex == n - 1) {
                    jButton.setEnabled(false);
                    jButton2.setEnabled(false);
                }
                jButton3.setEnabled(true);
                jButton4.setEnabled(true);
                PrintAlignmentImage.this.statusField.setText(PrintAlignmentImage.this.pageIndex + 1 + " of " + n + " pages");
            }
        });
        jMenuBar.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintAlignmentImage.this.pageIndex = n - 1;
                PrintAlignmentImage.this.repaint();
                jButton.setEnabled(false);
                jButton2.setEnabled(false);
                jButton3.setEnabled(true);
                jButton4.setEnabled(true);
                PrintAlignmentImage.this.statusField.setText(PrintAlignmentImage.this.pageIndex + 1 + " of " + n + " pages");
            }
        });
        if (this.pageIndex == n - 1) {
            jButton.setEnabled(false);
            jButton2.setEnabled(false);
        }
        jFrame.setJMenuBar(jMenuBar);
        jFrame.setVisible(true);
    }

    private void writeImageToFile(RenderedImage renderedImage, File file, String string) {
        try {
            ImageIO.write(renderedImage, string, file);
        }
        catch (IOException iOException) {
            System.out.println("Java 1.4+ is required");
            iOException.printStackTrace();
        }
    }
}

