/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.editor.Sequence;

public class SequenceJPanel
extends JPanel
implements ActionListener {
    private Color col;
    protected Sequence seq;
    private int fontSize = 12;
    private Font font = new Font("Monospaced", 0, this.fontSize);
    private int boundWidth;
    protected int boundWidth2;
    protected int resWidth;
    protected int seqHeight;
    private int pressedResidue;
    protected int interval;
    private int seqLength;
    private int ypad = 0;
    private Hashtable colorTable;
    private String padChar = new String("-");
    private String pattern;
    private boolean drawSequence = false;
    private boolean drawBlackBox = false;
    private boolean drawColorBox = false;
    protected boolean drawNumber = false;
    private boolean prettyPlot = false;
    private boolean highlightPattern = false;
    protected JComponent viewPane;
    private JPopupMenu popup;
    private Vector observers;

    public SequenceJPanel(Sequence sequence, JComponent jComponent, boolean bl, boolean bl2, boolean bl3, Hashtable hashtable, int n, int n2) {
        this.drawSequence = bl;
        this.drawBlackBox = bl2;
        this.drawColorBox = bl3;
        this.viewPane = jComponent;
        this.seq = sequence;
        this.ypad = n2;
        this.setOpaque(false);
        if (hashtable != null) {
            this.colorTable = hashtable;
        } else {
            this.setDefaultColorHashtable();
        }
        if (n != 0) {
            this.fontSize = n;
            this.font = new Font("Monospaced", 0, n);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.boundWidth = fontMetrics.stringWidth("A");
        this.boundWidth2 = this.boundWidth / 2;
        this.resWidth = fontMetrics.stringWidth("A") + this.boundWidth2;
        if (sequence != null) {
            this.seqLength = sequence.getLength();
        }
        this.seqHeight = fontMetrics.stringWidth("A") + this.boundWidth;
        this.init();
        this.addMouseListener(new PopupListener());
        this.popup = new JPopupMenu();
        JLabel jLabel = null;
        jLabel = sequence.getID() != null ? new JLabel(" " + sequence.getID()) : new JLabel(" " + sequence.getName());
        this.popup.add(jLabel);
        this.popup.add(new JSeparator());
        JMenuItem jMenuItem = new JMenuItem("Delete ");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.popup.add(new JSeparator());
        jMenuItem = new JMenuItem("Reverse Complement ");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Reverse ");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Complement ");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.setPreferredSize(this.getPreferredSize());
    }

    public SequenceJPanel(Sequence sequence, JComponent jComponent, boolean bl, boolean bl2, boolean bl3, Hashtable hashtable, int n) {
        this(sequence, jComponent, bl, bl2, bl3, hashtable, 0, n);
    }

    public SequenceJPanel(int n, int n2) {
        this.seq = null;
        this.drawNumber = true;
        this.interval = n;
        this.seqLength = n2 + 1;
        this.setOpaque(false);
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.boundWidth = fontMetrics.stringWidth("A");
        this.boundWidth2 = this.boundWidth / 2;
        this.resWidth = fontMetrics.stringWidth("A") + this.boundWidth2;
        this.seqHeight = fontMetrics.stringWidth("A") + this.boundWidth;
        this.setPreferredSize(this.getPreferredSize());
    }

    public void init() {
        if (!this.drawNumber) {
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    SequenceJPanel.this.pressedResidue = point.x / SequenceJPanel.this.resWidth;
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    int n = point.x / SequenceJPanel.this.resWidth;
                    SequenceJPanel.this.notifyGroup(n, SequenceJPanel.this.pressedResidue);
                    SequenceJPanel.this.update(n, SequenceJPanel.this.pressedResidue);
                }
            });
        }
    }

    protected void update(int n, int n2) {
        this.pressedResidue = n2;
        if (n == this.pressedResidue + 1 && n > 0) {
            this.seq.insertResidue(this.padChar, this.pressedResidue);
            ((GraphicSequenceCollection)this.viewPane).setMaxSequenceLength(this.seq.getLength());
            ++this.pressedResidue;
            this.repaint();
            this.viewPaneResize();
        } else if (n == this.pressedResidue - 1 && n > -1 && this.seq.getResidueAt(n).equals(this.padChar)) {
            this.seq.deleteResidue(n);
            --this.pressedResidue;
            this.repaint();
        }
    }

    protected void attach(SequenceJPanel sequenceJPanel) {
        if (this.observers == null) {
            this.observers = new Vector();
        }
        this.observers.add(sequenceJPanel);
    }

    protected void detach(SequenceJPanel sequenceJPanel) {
        if (this.observers != null && this.observers.contains(sequenceJPanel)) {
            this.observers.remove(sequenceJPanel);
        }
    }

    protected void detachAll() {
        this.observers = null;
    }

    protected void notifyGroup(int n, int n2) {
        if (this.observers != null) {
            Enumeration enumeration = this.observers.elements();
            while (enumeration.hasMoreElements()) {
                ((SequenceJPanel)enumeration.nextElement()).update(n, n2);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        Cloneable cloneable;
        super.paintComponent(graphics);
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.boundWidth = fontMetrics.stringWidth("A");
        this.boundWidth2 = this.boundWidth / 2;
        int n4 = this.boundWidth2 / 2;
        this.resWidth = fontMetrics.stringWidth("A") + this.boundWidth2;
        this.seqHeight = fontMetrics.stringWidth("A") + this.boundWidth;
        String string = null;
        if (this.drawSequence) {
            string = this.seq.getName();
        }
        String string2 = null;
        if (!this.drawNumber) {
            string2 = this.seq.getSequence();
            this.seqLength = string2.length();
        }
        int n5 = 0;
        int n6 = this.seqLength;
        try {
            cloneable = ((GraphicSequenceCollection)this.viewPane).getViewRect();
            n5 = cloneable.x / this.resWidth;
            n6 = n5 + cloneable.width / this.resWidth + 2;
            if (n6 > this.seqLength) {
                n6 = this.seqLength;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        cloneable = null;
        Font font = null;
        if (this.drawSequence && this.highlightPattern) {
            n3 = this.pattern.length();
            n2 = n5 - n3;
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = n6 + n3) > this.seqLength) {
                n = this.seqLength;
            }
            cloneable = this.getPatternPositions(n2, string2.substring(n2, n));
            font = new Font(this.font.getName(), 1, this.font.getSize() + 3);
        }
        n3 = 0;
        for (n2 = n5; n2 < n6; ++n2) {
            String string3;
            n = n2 * this.resWidth;
            if (this.drawColorBox) {
                graphics.setColor(this.getColor(string2.substring(n2, n2 + 1)));
                graphics.fillRect(n, 0, this.resWidth, this.seqHeight);
            }
            graphics.setColor(Color.black);
            if (this.drawSequence) {
                if (this.highlightPattern && ((Vector)cloneable).contains(new Integer(n2))) {
                    graphics.setFont(font);
                }
                string3 = string2.substring(n2, n2 + 1);
                if (this.prettyPlot) {
                    n3 = this.prettyDraw(n2, n, n6, string3, this.seqHeight, this.resWidth, n3 != 0, graphics);
                }
                graphics.drawString(string3, n + n4, this.seqHeight - this.boundWidth2);
                if (this.highlightPattern) {
                    graphics.setFont(this.font);
                }
            } else if (this.drawNumber && (n2 + 1) % this.interval == 0) {
                string3 = Integer.toString(n2 + 1);
                int n7 = fontMetrics.stringWidth(string3);
                graphics.drawString(string3, (int)(((double)n2 + 0.5) * (double)this.resWidth) - n7 / 2, this.seqHeight - this.boundWidth2);
            }
            if (!this.drawBlackBox) continue;
            graphics.setColor(Color.black);
            graphics.drawRect(n, 0, this.resWidth, this.seqHeight);
        }
    }

    private boolean prettyDraw(int n, int n2, int n3, String string, int n4, int n5, boolean bl, Graphics graphics) {
        GraphicSequenceCollection graphicSequenceCollection = (GraphicSequenceCollection)this.viewPane;
        String string2 = this.seq.getName();
        Color color = graphicSequenceCollection.getColor(string, n, string2);
        Color color2 = graphicSequenceCollection.getPrettyBackground(color);
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fillRect(n2, 0, n5, n4);
        }
        if (!color.equals(Color.black) && graphicSequenceCollection.isPrettyBox()) {
            graphics.setColor(Color.black);
            if (!bl) {
                graphics.drawLine(n2, 0, n2, n4);
            }
            bl = true;
            if (n + 2 > n3) {
                graphics.drawLine(n2 + n5, 0, n2 + n5, n4);
            } else {
                String string3 = this.seq.getSequence().substring(n + 1, n + 2);
                Color color3 = graphicSequenceCollection.getColor(string3, n + 1, string2);
                if (color3.equals(Color.black)) {
                    graphics.drawLine(n2 + n5, 0, n2 + n5, n4);
                }
            }
            int n6 = graphicSequenceCollection.testUpAndDown(n, this.seq);
            if (n6 == 1 || n6 == 3) {
                graphics.drawLine(n2, 0, n2 + n5, 0);
            }
            if (n6 == 2 || n6 == 3) {
                graphics.drawLine(n2, n4 - 1, n2 + n5, n4 - 1);
            }
        } else {
            bl = false;
        }
        graphics.setColor(color);
        return bl;
    }

    private Vector getPatternPositions(int n, int n2, String string) {
        int n3;
        Vector<Integer> vector = new Vector<Integer>();
        int n4 = this.pattern.length();
        int n5 = n - n4;
        int n6 = n2 + n4;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 > this.seqLength) {
            n6 = this.seqLength;
        }
        while ((n3 = string.substring(n5, n6).indexOf(this.pattern)) > -1) {
            for (int i = 0; i < n4; ++i) {
                vector.add(new Integer(n3 + n5 + i));
            }
            n5 = n3 + n5 + 1;
        }
        return vector;
    }

    private Vector getPatternPositions(int n, String string) {
        int n2;
        string = string.toLowerCase();
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = this.pattern.length();
        int n4 = 0;
        while ((n2 = string.substring(n4).indexOf(this.pattern)) > -1) {
            for (int i = 0; i < n3; ++i) {
                vector.add(new Integer(n2 + n4 + n + i));
            }
            n4 = n2 + n4 + 1;
        }
        return vector;
    }

    protected void showPattern(String string) {
        this.highlightPattern = true;
        this.pattern = string.toLowerCase();
    }

    public void setPrettyPlot(boolean bl) {
        this.prettyPlot = bl;
    }

    public boolean isPrettyPlot() {
        return this.prettyPlot;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = point.x / this.resWidth;
        if (n < 0) {
            return null;
        }
        if (n > this.seq.getSequence().length() - 1) {
            return null;
        }
        String string = this.seq.getSequence().substring(n, n + 1);
        String string2 = System.getProperty("line.separator");
        if (this.seq.getID() != null) {
            return this.seq.getID() + "\nResidue: " + string + string2 + "Position: " + Integer.toString(n + 1);
        }
        return this.seq.getName() + "\nResidue: " + string + string2 + "Position: " + Integer.toString(n + 1);
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = (point.x + this.resWidth) / this.resWidth * this.resWidth;
        int n2 = this.seqHeight - this.resWidth / 2;
        return new Point(n, n2);
    }

    private Color getColor(String string) {
        if (this.colorTable.containsKey(string = string.toUpperCase())) {
            return (Color)this.colorTable.get(string);
        }
        return this.getBackground();
    }

    public void setDefaultColorHashtable() {
        this.colorTable = new Hashtable();
        this.colorTable.put("A", Color.green);
        this.colorTable.put("T", Color.red);
        this.colorTable.put("C", Color.blue);
        this.colorTable.put("G", Color.white);
    }

    public void setDrawBoxes(boolean bl) {
        if (this.drawNumber) {
            return;
        }
        this.drawBlackBox = bl;
    }

    public void setDrawColor(boolean bl) {
        if (this.drawNumber) {
            return;
        }
        this.drawColorBox = bl;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        this.font = new Font("Monospaced", 0, this.fontSize);
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.boundWidth = fontMetrics.stringWidth("A");
        this.resWidth = fontMetrics.stringWidth("A") + this.boundWidth / 2;
        this.seqHeight = fontMetrics.stringWidth("A") + this.boundWidth;
        this.setPreferredSize(this.getPreferredSize());
        this.repaint();
    }

    public int getResidueWidth() {
        return this.resWidth;
    }

    public void setColorScheme(Hashtable hashtable) {
        this.colorTable = hashtable;
        this.setPrettyPlot(false);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSequenceWidth(), this.getSequenceHeight());
    }

    protected void viewPaneResize() {
        Dimension dimension = this.viewPane.getPreferredSize();
        GraphicSequenceCollection graphicSequenceCollection = (GraphicSequenceCollection)this.viewPane;
        int n = (int)dimension.getWidth();
        int n2 = graphicSequenceCollection.getPanelWidth();
        if (n2 > n) {
            this.viewPane.setPreferredSize(new Dimension(n2, graphicSequenceCollection.getPanelHeight()));
        }
        graphicSequenceCollection.setJScrollPaneViewportView();
    }

    public int getSequenceHeight() {
        return this.seqHeight + this.ypad;
    }

    public int getSequenceWidth() {
        return this.resWidth * this.seqLength;
    }

    public int getSequenceResidueWidth() {
        return this.resWidth;
    }

    public void setSequenceLength(int n) {
        this.seqLength = n;
    }

    public String getName() {
        return this.seq.getName();
    }

    public void getNamePrintGraphic(Graphics graphics) {
        if (this.seq == null) {
            return;
        }
        String string = this.seq.getName();
        if (this.seq.getID() != null) {
            string = this.seq.getID();
        }
        graphics.setFont(this.font);
        graphics.setColor(Color.black);
        graphics.drawString(string, 0, this.seqHeight - this.boundWidth2);
    }

    public void getSequencePrintGraphic(Graphics graphics, int n, int n2, int n3) {
        int n4;
        String string = null;
        String string2 = null;
        graphics.setFont(this.font);
        if (this.drawSequence) {
            string = this.seq.getName();
            if (this.seq.getID() != null) {
                string = this.seq.getID();
            }
            string2 = this.seq.getSequence();
            n4 = this.seq.getLength();
            if (n4 < n3) {
                n3 = n4;
            }
        }
        n4 = this.boundWidth2 / 2;
        boolean bl = false;
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        for (int i = n2; i < n3; ++i) {
            String string3;
            int n5 = (i - n2) * this.resWidth + n;
            if (this.drawColorBox) {
                graphics.setColor(this.getColor(string2.substring(i, i + 1)));
                graphics.fillRect(n5, 0, this.resWidth, this.seqHeight);
            }
            graphics.setColor(Color.black);
            if (this.drawBlackBox) {
                graphics.drawRect((i - n2) * this.resWidth + n, 0, this.resWidth, this.seqHeight);
            }
            if (this.drawSequence) {
                string3 = string2.substring(i, i + 1);
                if (this.prettyPlot) {
                    bl = this.prettyDraw(i, n5, n3, string3, this.seqHeight, this.resWidth, bl, graphics);
                }
                graphics.drawString(string3, (i - n2) * this.resWidth + n4 + n, this.seqHeight - this.boundWidth2);
                continue;
            }
            if (!this.drawNumber || (i + 1 - n2) % this.interval != 0) continue;
            string3 = Integer.toString(i + 1);
            int n6 = fontMetrics.stringWidth(string3);
            graphics.drawString(string3, (int)(((double)(i - n2) + 0.5) * (double)this.resWidth) - n6 / 2 + n, this.seqHeight - this.boundWidth2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem.getText().startsWith("Delete ")) {
            ((GraphicSequenceCollection)this.viewPane).deleteSequence(this.seq.getName());
        } else if (jMenuItem.getText().startsWith("Reverse Complement")) {
            this.seq.reverseComplementSequence();
            this.paintComponent(this.getGraphics());
        } else if (jMenuItem.getText().startsWith("Reverse ")) {
            this.seq.reverseSequence();
            this.paintComponent(this.getGraphics());
        } else if (jMenuItem.getText().startsWith("Complement ")) {
            this.seq.complementSequence();
            this.paintComponent(this.getGraphics());
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                SequenceJPanel.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

