/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.emboss.jemboss.gui.form.TextFieldSink;

public class TextFieldFloat
extends TextFieldSink {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat decimalFormatter = NumberFormat.getNumberInstance(Locale.UK);

    public double getValue() {
        double d = 0.0;
        try {
            d = this.decimalFormatter.parse(this.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
            System.err.println("TextFieldFloat getValue: " + d);
        }
        return d;
    }

    public void setValue(double d) {
        this.setText(this.decimalFormatter.format(d));
    }

    protected Document createDefaultModel() {
        return new DecimalNumberDocument();
    }

    protected class DecimalNumberDocument
    extends PlainDocument {
        protected DecimalNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                if (Character.isDigit(cArray[i]) || cArray[i] == '.' || cArray[i] == '-') {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                if (cArray[i] != ',') {
                    TextFieldFloat.this.toolkit.beep();
                }
                System.err.println("insertString: " + cArray[i]);
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

