/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.sequenceChooser;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class TextAreaSink
extends JTextArea
implements DropTargetListener {
    protected static Border dropBorder = new BevelBorder(1);

    public TextAreaSink() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TextAreaSink.this.pasteText();
                    mouseEvent.consume();
                }
            }
        });
        this.setDropTarget(new DropTarget(this, this));
    }

    public void pasteText() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable == null) {
            this.getToolkit().beep();
            return;
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.replaceSelection(string);
            } else {
                this.getToolkit().beep();
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.getToolkit().beep();
        }
        catch (IOException iOException) {
            this.getToolkit().beep();
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dropTargetDragEvent.acceptDrag(3);
            this.setBorder(dropBorder);
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.setBorder(null);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.setBorder(null);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dropTargetDropEvent.acceptDrop(3);
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.replaceSelection(string);
                dropTargetDropEvent.dropComplete(true);
            }
            catch (Exception exception) {}
        } else {
            dropTargetDropEvent.rejectDrop();
            return;
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }
}

