package nsdb;


/**
* nsdb/_NucSeqStub.java .
* Generated by the IDL-to-Java compiler (portable), version "3.1"
* from corba/nsdb.idl
* Monday, August 23, 2004 12:02:41 PM BST
*/


/**
       * Generic Nucleotide sequence interface.
       * The accession number is retrieved using the getBioSeqId method inherited from BioSeq.
       * @see EmblSeq
       * @see seqdb::BioSeq
       */
public class _NucSeqStub extends org.omg.CORBA.portable.ObjectImpl implements nsdb.NucSeq
{


  /**
  	 * retrieve string representation of nucleotide sequence. Each character
  	 * in the string is a 
  	 *   <href="http://www.ebi.ac.uk/ebi_docs/embl_db/ft/iupac_codes.html">
  	 *   IUPAC nucleotide base code</A>
  	 * <P>
  	 * This method can be used instead of the getAnySeq() 
  	 * method in seqdb::BioSeq
  	 * @see seqdb::BioSeq
  	 */
  public String getSeq ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getSeq", true);
                $in = _invoke ($out);
                String $result = $in.read_string ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getSeq (        );
            } finally {
                _releaseReply ($in);
            }
  } // getSeq


  /**
  	 * Checksum on sequence to allow validation.
  	 * 
  	 */
  public int getCheckSum ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getCheckSum", true);
                $in = _invoke ($out);
                int $result = $in.read_ulong ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getCheckSum (        );
            } finally {
                _releaseReply ($in);
            }
  } // getCheckSum


  /**
  	 * topology of the nucleotide sequence
  	 * @see meta::nsdb
  	 */
  public String getTopology ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getTopology", true);
                $in = _invoke ($out);
                String $result = $in.read_string ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getTopology (        );
            } finally {
                _releaseReply ($in);
            }
  } // getTopology


  /**
  	 * molecule type of the nucleotide sequence
  	 * @see meta::nsdb
  	 */
  public String getMoleculeType ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getMoleculeType", true);
                $in = _invoke ($out);
                String $result = $in.read_string ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getMoleculeType (        );
            } finally {
                _releaseReply ($in);
            }
  } // getMoleculeType


  /**
  	 * retrieve sequence of NucFeatureList associated with
  	 * the nucleotide sequence.
  	 * A sequence has <I>ownership</I> of all these 
  	 * features. It is possible on the other hand that
  	 * features, owned by another sequence, reference 
  	 * the current sequence. Currently there is no way to find out.
  	 * @raises type::NoResult if no features are owned by the sequence
  	 */
  public nsdb.NucFeature[] getNucFeatures () throws type.NoResult
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getNucFeatures", true);
                $in = _invoke ($out);
                nsdb.NucFeature $result[] = nsdb.NucFeatureListHelper.read ($in);
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/NoResult:1.0"))
                    throw type.NoResultHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getNucFeatures (        );
            } finally {
                _releaseReply ($in);
            }
  } // getNucFeatures


  /**
  	 * A location of a NucFeature can span multiple sequences.
  	 * If only the location of a feature relevant to the current
  	 * sequence is required, this method will calculate that.
  	 * @parm nuc_feature Feature from which location needs to be
  	 *   intersected with the current sequence.
  	 * @raises type::InvalidRelation if the nuc_feature 
  	 *   is not associated to the current sequence
  	 */
  public nsdb.Location getLocalLocation (nsdb.NucFeature nuc_feature) throws type.InvalidRelation
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getLocalLocation", true);
                nsdb.NucFeatureHelper.write ($out, nuc_feature);
                $in = _invoke ($out);
                nsdb.Location $result = nsdb.LocationHelper.read ($in);
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/InvalidRelation:1.0"))
                    throw type.InvalidRelationHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getLocalLocation (nuc_feature        );
            } finally {
                _releaseReply ($in);
            }
  } // getLocalLocation


  /**
  	 * organism(s) from which the NucSeq was obtained.
  	 * If the sequence is chimeric, multiple organisms will be returned.
  	 * For each organism, there should be a source feature associated
  	 * with the current sequence. This source feature has a location
  	 * defining which part of the sequence was derived from the specified
  	 * organism.
  	 * This method provides a shortcut to:
  	 * invoke getNucFeaturesByKey("source"), invoke getQualifiers() on each 
  	 * source feature and loop through qualifiers to find DbXref. 
  	 * @raises type::NoResult if no source features are associated with
  	 * the sequence (should never happen).
  	 */
  public type.DbXref[] getOrganisms () throws type.NoResult
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getOrganisms", true);
                $in = _invoke ($out);
                type.DbXref $result[] = type.DbXrefListHelper.read ($in);
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/NoResult:1.0"))
                    throw type.NoResultHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getOrganisms (        );
            } finally {
                _releaseReply ($in);
            }
  } // getOrganisms


  /**
  	 * retreive all features of a specific kind (FeatureKey)
  	 * @parm key Type of features to be retrieved
  	 * @raises type::NoResult if the sequence has no associated features
  	 *     of the requested type.
  	 * @raises type::InvalidArgumentValue if the key is not a 
  	 * <A href="http://www.ebi.ac.uk/ebi_docs/embl_db/ft/feature_table.html">
  	 * valid feature key</A>
  	 * @see NucFeature
  	 */
  public nsdb.NucFeature[] getNucFeaturesByKey (String key) throws type.NoResult, type.InvalidArgumentValue
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getNucFeaturesByKey", true);
                $out.write_string (key);
                $in = _invoke ($out);
                nsdb.NucFeature $result[] = nsdb.NucFeatureListHelper.read ($in);
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/NoResult:1.0"))
                    throw type.NoResultHelper.read ($in);
                else if (_id.equals ("IDL:type/InvalidArgumentValue:1.0"))
                    throw type.InvalidArgumentValueHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getNucFeaturesByKey (key        );
            } finally {
                _releaseReply ($in);
            }
  } // getNucFeaturesByKey


  /**
  	 * Create nucleotide sequence of the segment specified
  	 * The first base in the sequence is numbered 1
  	 *
  	 * @parm start first base of sub-sequence (inclusive)
  	 * @parm end last base of sub-sequence (inclusive)
  	 * @raises type::IndexOutOfRange if start &lt 1
  	 *   or end &gt length
  	 */
  public String getSubSeq (int start, int end) throws type.IndexOutOfRange
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getSubSeq", true);
                $out.write_ulong (start);
                $out.write_ulong (end);
                $in = _invoke ($out);
                String $result = $in.read_string ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/IndexOutOfRange:1.0"))
                    throw type.IndexOutOfRangeHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getSubSeq (start, end        );
            } finally {
                _releaseReply ($in);
            }
  } // getSubSeq


  /** 
  	  * Create nucleotide sequence of the location derived from the specified feature
  	  * and contained in the current NucSeq.
  	  * @raises type::InvalidRelation if the nuc_feature 
  	  *   is not associated to the current sequence
            * @raises InexactLocation if an exact sequence cannot be
  	  *   determined due to the feature's location being inexact
  	  */
  public String getSubSeqByFeature (nsdb.NucFeature feature) throws type.InvalidRelation, nsdb.InexactLocation
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getSubSeqByFeature", true);
                nsdb.NucFeatureHelper.write ($out, feature);
                $in = _invoke ($out);
                String $result = $in.read_string ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/InvalidRelation:1.0"))
                    throw type.InvalidRelationHelper.read ($in);
                else if (_id.equals ("IDL:nsdb/InexactLocation:1.0"))
                    throw nsdb.InexactLocationHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getSubSeqByFeature (feature        );
            } finally {
                _releaseReply ($in);
            }
  } // getSubSeqByFeature


  /**
             * @raises type::InvalidRelation if reference does not exist
             * @raises type::InvalidRelation if reference is not 
             *   associated to the current sequence
             * @raises type::NoResult if there is no location associated with this reference
             */
  public nsdb.Location getReferenceLocation (String reference_id) throws type.InvalidRelation, type.NoResult
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getReferenceLocation", true);
                $out.write_string (reference_id);
                $in = _invoke ($out);
                nsdb.Location $result = nsdb.LocationHelper.read ($in);
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                if (_id.equals ("IDL:type/InvalidRelation:1.0"))
                    throw type.InvalidRelationHelper.read ($in);
                else if (_id.equals ("IDL:type/NoResult:1.0"))
                    throw type.NoResultHelper.read ($in);
                else
                    throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getReferenceLocation (reference_id        );
            } finally {
                _releaseReply ($in);
            }
  } // getReferenceLocation


  /**
  	 * retrieve unique identifier
  	 */
  public String getBioSeqId ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getBioSeqId", true);
                $in = _invoke ($out);
                String $result = $in.read_string ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getBioSeqId (        );
            } finally {
                _releaseReply ($in);
            }
  } // getBioSeqId


  /**
  	 * length (nr of elements) of the biosequence
  	 */
  public int getLength ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getLength", true);
                $in = _invoke ($out);
                int $result = $in.read_ulong ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getLength (        );
            } finally {
                _releaseReply ($in);
            }
  } // getLength


  /**
  	 * sequence of objects describing the elements in the biosequence
  	 * This is a generic description. Most subclasses
  	 * will define more convenient methods for accessing the biosequence.
  	 * @returns any containing an set of objects. The any should have 
  	 *          a typecode tk_array.
  	 */
  public org.omg.CORBA.Any getAnySeq ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getAnySeq", true);
                $in = _invoke ($out);
                org.omg.CORBA.Any $result = $in.read_any ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getAnySeq (        );
            } finally {
                _releaseReply ($in);
            }
  } // getAnySeq


  /**
  	 * Return current version of the BioSeq. returns 0 if versioning is not
  	 * implemented on the bioseq.
  	 */
  public int getBioSeqVersion ()
  {
            org.omg.CORBA.portable.InputStream $in = null;
            try {
                org.omg.CORBA.portable.OutputStream $out = _request ("getBioSeqVersion", true);
                $in = _invoke ($out);
                int $result = $in.read_ulong ();
                return $result;
            } catch (org.omg.CORBA.portable.ApplicationException $ex) {
                $in = $ex.getInputStream ();
                String _id = $ex.getId ();
                throw new org.omg.CORBA.MARSHAL (_id);
            } catch (org.omg.CORBA.portable.RemarshalException $rm) {
                return getBioSeqVersion (        );
            } finally {
                _releaseReply ($in);
            }
  } // getBioSeqVersion

  // Type-specific CORBA::Object operations
  private static String[] __ids = {
    "IDL:nsdb/NucSeq:1.0", 
    "IDL:seqdb/BioSeq:1.0"};

  public String[] _ids ()
  {
    return (String[])__ids.clone ();
  }

  private void readObject (java.io.ObjectInputStream s) throws java.io.IOException
  {
     String str = s.readUTF ();
     String[] args = null;
     java.util.Properties props = null;
     org.omg.CORBA.Object obj = org.omg.CORBA.ORB.init (args, props).string_to_object (str);
     org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl) obj)._get_delegate ();
     _set_delegate (delegate);
  }

  private void writeObject (java.io.ObjectOutputStream s) throws java.io.IOException
  {
     String[] args = null;
     java.util.Properties props = null;
     String str = org.omg.CORBA.ORB.init (args, props).object_to_string (this);
     s.writeUTF (str);
  }
} // class _NucSeqStub
