/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

class CBannerLayout
extends Layout {
    CBannerLayout() {
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        CBanner banner = (CBanner)composite;
        Control left = banner.left;
        Control right = banner.right;
        Control bottom = banner.bottom;
        boolean showCurve = left != null && right != null;
        int height = hHint;
        int width = wHint;
        Point bottomSize = new Point(0, 0);
        if (bottom != null) {
            int trim = this.computeTrim(bottom);
            int w = wHint == -1 ? -1 : width - trim;
            bottomSize = bottom.computeSize(w, -1, flushCache);
            if (hHint != -1) {
                bottomSize.y = Math.min(bottomSize.y, height);
                height -= bottomSize.y + 3 + 1 + 2;
            }
        }
        if (showCurve && hHint != -1) {
            height -= 7;
        }
        Point rightSize = new Point(0, 0);
        if (right != null) {
            int trim = this.computeTrim(right);
            int w = banner.rightWidth == -1 ? -1 : banner.rightWidth - trim;
            int h = banner.rightWidth == -1 ? -1 : height;
            rightSize = right.computeSize(w, h, flushCache);
            if (wHint != -1) {
                rightSize.x = Math.min(rightSize.x, width);
                width -= rightSize.x + banner.curve_width - 2 * banner.curve_indent;
                width = Math.max(width, 10);
            }
        }
        Point leftSize = new Point(0, 0);
        if (left != null) {
            int trim = this.computeTrim(left);
            int w = wHint == -1 ? -1 : width - trim;
            leftSize = left.computeSize(w, -1, flushCache);
        }
        width = leftSize.x + rightSize.x;
        height = bottomSize.y;
        if (bottom != null && (left != null || right != null)) {
            height += 6;
        }
        height = left != null ? (height += right == null ? leftSize.y : Math.max(leftSize.y, banner.rightMinHeight)) : (height += rightSize.y);
        if (showCurve) {
            width += banner.curve_width - 2 * banner.curve_indent;
            height += 7;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    int computeTrim(Control c) {
        if (c instanceof Scrollable) {
            Rectangle rect = ((Scrollable)c).computeTrim(0, 0, 0, 0);
            return rect.width;
        }
        return c.getBorderWidth() * 2;
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean flushCache) {
        CBanner banner = (CBanner)composite;
        Control left = banner.left;
        Control right = banner.right;
        Control bottom = banner.bottom;
        Point size = banner.getSize();
        boolean showCurve = left != null && right != null;
        int width = size.x;
        int height = size.y;
        Point bottomSize = new Point(0, 0);
        if (bottom != null) {
            int trim = this.computeTrim(bottom);
            int w = width - trim;
            bottomSize = bottom.computeSize(w, -1, flushCache);
            bottomSize.y = Math.min(bottomSize.y, height);
            height -= bottomSize.y + 3 + 2 + 1;
        }
        if (showCurve) {
            height -= 7;
        }
        height = Math.max(0, height);
        Point rightSize = new Point(0, 0);
        if (right != null) {
            int trimX = 0;
            int trimY = 0;
            if (right instanceof Scrollable) {
                Rectangle rect = ((Scrollable)right).computeTrim(0, 0, 0, 0);
                trimX = rect.width;
                trimY = rect.height;
            } else {
                trimX = trimY = right.getBorderWidth() * 2;
            }
            int rightW = banner.rightWidth == -1 ? -1 : banner.rightWidth - trimX;
            int rightH = banner.rightWidth == -1 ? -1 : height - trimY;
            rightSize = right.computeSize(rightW, rightH, flushCache);
            rightSize.x = Math.min(rightSize.x, width);
            width -= rightSize.x + banner.curve_width - 2 * banner.curve_indent;
            width = Math.max(width, 10);
        }
        Point leftSize = new Point(0, 0);
        if (left != null) {
            int trim = this.computeTrim(left);
            leftSize = left.computeSize(width - trim, -1, flushCache);
        }
        int x = 0;
        int y = 0;
        int oldStart = banner.curveStart;
        Rectangle leftRect = null;
        Rectangle rightRect = null;
        Rectangle bottomRect = null;
        if (bottom != null) {
            bottomRect = new Rectangle(x, y + size.y - bottomSize.y, bottomSize.x, bottomSize.y);
        }
        if (showCurve) {
            y += 4;
        }
        if (left != null) {
            leftRect = new Rectangle(x, y, leftSize.x, leftSize.y);
            banner.curveStart = x + leftSize.x - banner.curve_indent;
            x += leftSize.x + banner.curve_width - 2 * banner.curve_indent;
        }
        if (right != null) {
            rightRect = new Rectangle(x, y, rightSize.x, rightSize.y);
        }
        if (banner.curveStart < oldStart) {
            banner.redraw(banner.curveStart - 200, 0, oldStart + banner.curve_width - banner.curveStart + 200 + 5, size.y, false);
        }
        if (banner.curveStart > oldStart) {
            banner.redraw(oldStart - 200, 0, banner.curveStart + banner.curve_width - oldStart + 200 + 5, size.y, false);
        }
        banner.curveRect = new Rectangle(banner.curveStart, 0, banner.curve_width, size.y);
        banner.update();
        if (bottomRect != null) {
            bottom.setBounds(bottomRect);
        }
        if (rightRect != null) {
            right.setBounds(rightRect);
        }
        if (leftRect != null) {
            left.setBounds(leftRect);
        }
    }
}

