/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMRGINFO;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.NMTVCUSTOMDRAW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.TVHITTESTINFO;
import org.eclipse.swt.internal.win32.TVINSERTSTRUCT;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    int hAnchor;
    TreeItem[] items;
    ImageList imageList;
    boolean dragStarted;
    boolean gestureCompleted;
    boolean ignoreSelect;
    boolean ignoreExpand;
    boolean ignoreDeselect;
    boolean lockSelection;
    boolean oldSelected;
    boolean newSelected;
    boolean customDraw;
    static final int TreeProc;
    static final TCHAR TreeClass;

    static {
        TreeClass = new TCHAR(0, "SysTreeView32", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, TreeClass, lpWndClass);
        TreeProc = lpWndClass.lpfnWndProc;
    }

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int callWindowProc(int hwnd, int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        switch (msg) {
            case 513: 
            case 516: 
            case 519: 
            case 523: {
                this.display.ignoreMsgFilter = true;
                int code = OS.CallWindowProc(TreeProc, hwnd, msg, wParam, lParam);
                this.display.ignoreMsgFilter = false;
                return code;
            }
        }
        return OS.CallWindowProc(TreeProc, hwnd, msg, wParam, lParam);
    }

    boolean checkScroll(int hItem) {
        if (this.drawCount == 0) {
            return false;
        }
        int hRoot = OS.SendMessage(this.handle, 4362, 0, 0);
        int hParent = OS.SendMessage(this.handle, 4362, 3, hItem);
        while (hParent != hRoot && hParent != 0) {
            hParent = OS.SendMessage(this.handle, 4362, 3, hParent);
        }
        return hParent == 0;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        RECT rect = new RECT();
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        while (hItem != 0) {
            rect.left = hItem;
            if (OS.SendMessage(this.handle, 4356, 1, rect) != 0) {
                width = Math.max(width, rect.right);
                height += rect.bottom - rect.top;
            }
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            height += OS.GetSystemMetrics(3);
        }
        return new Point(width, height);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        if (!OS.IsWinCE && OS.COMCTL32_MAJOR < 6) {
            OS.SendMessage(this.handle, 8199, 5, 0);
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
        int hFont = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, hFont, 0);
    }

    void createItem(TreeItem item, int hParent, int hInsertAfter) {
        int hItem;
        item.font = -1;
        item.background = -1;
        item.foreground = -1;
        int id = 0;
        while (id < this.items.length && this.items[id] != null) {
            ++id;
        }
        if (id == this.items.length) {
            TreeItem[] newItems = new TreeItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        TVINSERTSTRUCT tvInsert = new TVINSERTSTRUCT();
        tvInsert.hParent = hParent;
        tvInsert.hInsertAfter = hInsertAfter;
        tvInsert.lParam = id;
        tvInsert.iSelectedImage = tvInsert.iImage = -2;
        tvInsert.mask = 54;
        if ((this.style & 0x20) != 0) {
            tvInsert.mask |= 8;
            tvInsert.state = 4096;
            tvInsert.stateMask = 61440;
        }
        if ((hItem = OS.SendMessage(this.handle, OS.TVM_INSERTITEM, 0, tvInsert)) == 0) {
            this.error(14);
        }
        item.handle = hItem;
        this.items[id] = item;
        if (!OS.IsWindowVisible(this.handle) || this.drawCount > 0) {
            return;
        }
        int hChild = OS.SendMessage(this.handle, 4362, 4, hParent);
        if (hChild != 0 && OS.SendMessage(this.handle, 4362, 1, hChild) == 0) {
            RECT rect = new RECT();
            rect.left = hParent;
            if (OS.SendMessage(this.handle, 4356, 0, rect) != 0) {
                OS.InvalidateRect(this.handle, rect, true);
            }
        }
    }

    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    public void deselectAll() {
        this.checkWidget();
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 8;
        tvItem.stateMask = 2;
        if ((this.style & 4) != 0) {
            int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
            if (hItem != 0) {
                tvItem.hItem = hItem;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            }
        } else {
            int oldProc = OS.GetWindowLong(this.handle, -4);
            OS.SetWindowLong(this.handle, -4, TreeProc);
            int i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    tvItem.hItem = item.handle;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                }
                ++i;
            }
            OS.SetWindowLong(this.handle, -4, oldProc);
        }
    }

    void destroyItem(TreeItem item) {
        int count;
        int hItem = item.handle;
        int hParent = 0;
        boolean fixRedraw = false;
        if (this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
            RECT rect = new RECT();
            rect.left = hItem;
            boolean bl = fixRedraw = OS.SendMessage(this.handle, 4356, 0, rect) == 0;
        }
        if (fixRedraw) {
            hParent = OS.SendMessage(this.handle, 4362, 3, hItem);
            OS.UpdateWindow(this.handle);
            OS.SendMessage(this.handle, 11, 0, 0);
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        this.releaseItems(item.getItems(), tvItem);
        this.releaseItem(item, tvItem);
        this.lockSelection = true;
        this.ignoreSelect = true;
        this.ignoreDeselect = true;
        OS.SendMessage(this.handle, 4353, 0, hItem);
        this.lockSelection = false;
        this.ignoreSelect = false;
        this.ignoreDeselect = false;
        if (fixRedraw) {
            OS.SendMessage(this.handle, 11, 1, 0);
            OS.ValidateRect(this.handle, null);
            if (OS.SendMessage(this.handle, 4362, 4, hParent) == 0) {
                RECT rect = new RECT();
                rect.left = hParent;
                if (OS.SendMessage(this.handle, 4356, 0, rect) != 0) {
                    OS.InvalidateRect(this.handle, rect, true);
                }
            }
        }
        if ((count = OS.SendMessage(this.handle, 4357, 0, 0)) == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 4361, 0, 0);
                this.display.releaseImageList(this.imageList);
            }
            this.imageList = null;
            this.customDraw = false;
            this.items = new TreeItem[4];
        }
    }

    int getBackgroundPixel() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        int pixel = OS.SendMessage(this.handle, 4383, 0, 0);
        if (pixel == -1) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return pixel;
    }

    int getForegroundPixel() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        int pixel = OS.SendMessage(this.handle, 4384, 0, 0);
        if (pixel == -1) {
            return OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        return pixel;
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = point.x;
        lpht.y = point.y;
        OS.SendMessage(this.handle, 4369, 0, lpht);
        if (lpht.hItem != 0 && (lpht.flags & 0x46) != 0) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 20;
            tvItem.hItem = lpht.hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            return this.items[tvItem.lParam];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        if (hItem == 0) {
            return 0;
        }
        return this.getItemCount(hItem);
    }

    int getItemCount(int hItem) {
        int count = 0;
        while (hItem != 0) {
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
            ++count;
        }
        return count;
    }

    public int getItemHeight() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4380, 0, 0);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        if (hItem == 0) {
            return new TreeItem[0];
        }
        return this.getItems(hItem);
    }

    TreeItem[] getItems(int hTreeItem) {
        int count = 0;
        int hItem = hTreeItem;
        while (hItem != 0) {
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
            ++count;
        }
        int index = 0;
        TreeItem[] result = new TreeItem[count];
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        tvItem.hItem = hTreeItem;
        while (tvItem.hItem != 0) {
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            TreeItem item = this.items[tvItem.lParam];
            if (item != null) {
                result[index++] = item;
            }
            tvItem.hItem = OS.SendMessage(this.handle, 4362, 1, tvItem.hItem);
        }
        if (index != count) {
            TreeItem[] newResult = new TreeItem[index];
            System.arraycopy(result, 0, newResult, 0, index);
            result = newResult;
        }
        return result;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
            if (hItem == 0) {
                return new TreeItem[0];
            }
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 12;
            tvItem.hItem = hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if ((tvItem.state & 2) == 0) {
                return new TreeItem[0];
            }
            return new TreeItem[]{this.items[tvItem.lParam]};
        }
        int count = 0;
        TreeItem[] guess = new TreeItem[8];
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 12;
        int oldProc = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                tvItem.hItem = item.handle;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 2) != 0) {
                    if (count < guess.length) {
                        guess[count] = item;
                    }
                    ++count;
                }
            }
            ++i;
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
        if (count == 0) {
            return new TreeItem[0];
        }
        if (count == guess.length) {
            return guess;
        }
        TreeItem[] result = new TreeItem[count];
        if (count < guess.length) {
            System.arraycopy(guess, 0, result, 0, count);
            return result;
        }
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int index = 0;
        int i2 = 0;
        while (i2 < this.items.length) {
            TreeItem item = this.items[i2];
            if (item != null) {
                tvItem.hItem = item.handle;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 2) != 0) {
                    result[index++] = item;
                }
            }
            ++i2;
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
            if (hItem == 0) {
                return 0;
            }
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 8;
            tvItem.hItem = hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if ((tvItem.state & 2) == 0) {
                return 0;
            }
            return 1;
        }
        int count = 0;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 8;
        int oldProc = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                tvItem.hItem = item.handle;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 2) != 0) {
                    ++count;
                }
            }
            ++i;
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
        return count;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        int hItem = OS.SendMessage(this.handle, 4362, 5, 0);
        if (hItem == 0) {
            return null;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 4;
        tvItem.hItem = hItem;
        if (OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem) == 0) {
            return null;
        }
        return this.items[tvItem.lParam];
    }

    int imageIndex(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            int hOldList = OS.SendMessage(this.handle, 4360, 0, 0);
            if (hOldList != 0) {
                OS.ImageList_Destroy(hOldList);
            }
            Rectangle bounds = image.getBounds();
            this.imageList = this.display.getImageList(new Point(bounds.width, bounds.height));
            int index = this.imageList.indexOf(image);
            if (index == -1) {
                index = this.imageList.add(image);
            }
            int hImageList = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4361, 0, hImageList);
            return index;
        }
        int index = this.imageList.indexOf(image);
        if (index != -1) {
            return index;
        }
        return this.imageList.add(image);
    }

    boolean releaseItem(TreeItem item, TVITEM tvItem) {
        int hItem = item.handle;
        if (hItem == this.hAnchor) {
            this.hAnchor = 0;
        }
        if (item.isDisposed()) {
            return false;
        }
        tvItem.hItem = hItem;
        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
        this.items[tvItem.lParam] = null;
        return true;
    }

    void releaseItems(TreeItem[] nodes, TVITEM tvItem) {
        int i = 0;
        while (i < nodes.length) {
            TreeItem item = nodes[i];
            TreeItem[] sons = item.getItems();
            if (sons.length != 0) {
                this.releaseItems(sons, tvItem);
            }
            if (this.releaseItem(item, tvItem)) {
                item.releaseResources();
            }
            ++i;
        }
    }

    void releaseWidget() {
        int hOldList;
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.customDraw = false;
        this.items = null;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4361, 0, 0);
            this.display.releaseImageList(this.imageList);
        } else {
            hOldList = OS.SendMessage(this.handle, 4360, 0, 0);
            OS.SendMessage(this.handle, 4361, 0, 0);
            if (hOldList != 0) {
                OS.ImageList_Destroy(hOldList);
            }
        }
        this.imageList = null;
        hOldList = OS.SendMessage(this.handle, 4360, 2, 0);
        OS.SendMessage(this.handle, 4361, 2, 0);
        if (hOldList != 0) {
            OS.ImageList_Destroy(hOldList);
        }
        super.releaseWidget();
    }

    public void removeAll() {
        boolean redraw;
        this.checkWidget();
        this.ignoreSelect = true;
        this.ignoreDeselect = true;
        boolean bl = redraw = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
        if (redraw) {
            OS.DefWindowProc(this.handle, 11, 0, 0);
        }
        int result = OS.SendMessage(this.handle, 4353, 0, -65536);
        if (redraw) {
            OS.DefWindowProc(this.handle, 11, 1, 0);
            OS.InvalidateRect(this.handle, null, true);
        }
        this.ignoreSelect = false;
        this.ignoreDeselect = false;
        if (result == 0) {
            this.error(15);
        }
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4361, 0, 0);
            this.display.releaseImageList(this.imageList);
        }
        this.imageList = null;
        this.customDraw = false;
        this.items = new TreeItem[4];
        this.hAnchor = 0;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        int hItem = 0;
        if (item != null) {
            if (item.isDisposed()) {
                this.error(5);
            }
            hItem = item.handle;
        }
        OS.SendMessage(this.handle, 4378, before ? 0 : 1, hItem);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 8;
        tvItem.state = 2;
        tvItem.stateMask = 2;
        int oldProc = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                tvItem.hItem = item.handle;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            }
            ++i;
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
    }

    void setBackgroundPixel(int pixel) {
        if (this.background == pixel) {
            return;
        }
        this.background = pixel;
        int oldPixel = OS.SendMessage(this.handle, 4383, 0, 0);
        if (oldPixel != -1) {
            OS.SendMessage(this.handle, 4381, 0, -1);
        }
        OS.SendMessage(this.handle, 4381, 0, pixel);
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        int hItem;
        boolean fixSelection = false;
        if ((flags & 1) == 0 && (width != 0 || height != 0) && OS.SendMessage(this.handle, 4368, 0, 0) == 0) {
            fixSelection = true;
        }
        super.setBounds(x, y, width, height, flags);
        if (fixSelection && (hItem = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
            this.showItem(hItem);
        }
    }

    void setCursor() {
        Cursor cursor = this.findCursor();
        int hCursor = cursor == null ? OS.LoadCursor(0, 32512) : cursor.handle;
        OS.SetCursor(hCursor);
    }

    void setCheckboxImageList() {
        int height;
        if ((this.style & 0x20) == 0) {
            return;
        }
        int count = 5;
        int width = height = OS.SendMessage(this.handle, 4380, 0, 0);
        int hImageList = OS.ImageList_Create(width, height, 0, count, count);
        int hDC = OS.GetDC(this.handle);
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            OS.SetLayout(hDC, 0);
        }
        int memDC = OS.CreateCompatibleDC(hDC);
        int hBitmap = OS.CreateCompatibleBitmap(hDC, width * count, height);
        int hOldBitmap = OS.SelectObject(memDC, hBitmap);
        RECT rect = new RECT();
        OS.SetRect(rect, 0, 0, width * count, height);
        int hBrush = OS.CreateSolidBrush(this.getBackgroundPixel());
        OS.FillRect(memDC, rect, hBrush);
        OS.DeleteObject(hBrush);
        int oldFont = OS.SelectObject(hDC, this.defaultFont());
        TEXTMETRIC tm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(hDC, tm);
        OS.SelectObject(hDC, oldFont);
        int itemWidth = Math.min(tm.tmHeight, width);
        int itemHeight = Math.min(tm.tmHeight, height);
        int left = (width - itemWidth) / 2;
        int top = (height - itemHeight) / 2 + 1;
        OS.SetRect(rect, left + width, top, left + width + itemWidth, top + itemHeight);
        OS.DrawFrameControl(memDC, rect, 4, 16384);
        rect.left += width;
        rect.right += width;
        OS.DrawFrameControl(memDC, rect, 4, 17408);
        rect.left += width;
        rect.right += width;
        OS.DrawFrameControl(memDC, rect, 4, 16640);
        rect.left += width;
        rect.right += width;
        OS.DrawFrameControl(memDC, rect, 4, 17664);
        OS.SelectObject(memDC, hOldBitmap);
        OS.DeleteDC(memDC);
        OS.ReleaseDC(this.handle, hDC);
        OS.ImageList_AddMasked(hImageList, hBitmap, 0);
        OS.DeleteObject(hBitmap);
        int hOldList = OS.SendMessage(this.handle, 4360, 2, 0);
        OS.SendMessage(this.handle, 4361, 2, hImageList);
        if (hOldList != 0) {
            OS.ImageList_Destroy(hOldList);
        }
    }

    void setForegroundPixel(int pixel) {
        if (this.foreground == pixel) {
            return;
        }
        this.foreground = pixel;
        OS.SendMessage(this.handle, 4382, 0, pixel);
    }

    public void setRedraw(boolean redraw) {
        int count;
        this.checkWidget();
        int hItem = 0;
        if (redraw && this.drawCount == 1 && (count = OS.SendMessage(this.handle, 4357, 0, 0)) == 0) {
            TVINSERTSTRUCT tvInsert = new TVINSERTSTRUCT();
            tvInsert.hInsertAfter = -65535;
            hItem = OS.SendMessage(this.handle, OS.TVM_INSERTITEM, 0, tvInsert);
        }
        super.setRedraw(redraw);
        if (hItem != 0) {
            OS.SendMessage(this.handle, 4353, 0, hItem);
        }
    }

    public void setSelection(TreeItem[] items) {
        int length;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if ((length = items.length) == 0 || (this.style & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        TreeItem item = items[0];
        if (item != null) {
            if (item.isDisposed()) {
                this.error(5);
            }
            int hOldItem = OS.SendMessage(this.handle, 4362, 9, 0);
            this.hAnchor = item.handle;
            int hNewItem = this.hAnchor;
            boolean fixScroll = this.checkScroll(hNewItem);
            if (fixScroll) {
                OS.SendMessage(this.handle, 11, 1, 0);
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4363, 9, hNewItem);
            this.ignoreSelect = false;
            if (OS.SendMessage(this.handle, 4368, 0, 0) == 0) {
                OS.SendMessage(this.handle, 4363, 5, hNewItem);
            }
            if (fixScroll) {
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.SendMessage(this.handle, 11, 0, 0);
            }
            if (hOldItem == hNewItem) {
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 8;
                tvItem.state = 2;
                tvItem.stateMask = 2;
                tvItem.hItem = hNewItem;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                this.showItem(hNewItem);
            }
        }
        if ((this.style & 4) != 0) {
            return;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 8;
        tvItem.stateMask = 2;
        int oldProc = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int i = 0;
        while (i < this.items.length) {
            item = this.items[i];
            if (item != null) {
                int index = 0;
                while (index < length) {
                    if (items[index] == item) break;
                    ++index;
                }
                tvItem.hItem = item.handle;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 2) != 0) {
                    if (index == length) {
                        tvItem.state = 0;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                } else if (index != length) {
                    tvItem.state = 2;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                }
            }
            ++i;
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
    }

    public void setTopItem(TreeItem item) {
        int hItem;
        boolean fixScroll;
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        if (fixScroll = this.checkScroll(hItem = item.handle)) {
            OS.SendMessage(this.handle, 11, 1, 0);
            OS.DefWindowProc(this.handle, 11, 0, 0);
        }
        OS.SendMessage(this.handle, 4363, 5, hItem);
        if (fixScroll) {
            OS.DefWindowProc(this.handle, 11, 1, 0);
            OS.SendMessage(this.handle, 11, 0, 0);
        }
    }

    void showItem(int hItem) {
        if (OS.SendMessage(this.handle, 4368, 0, 0) == 0) {
            boolean fixScroll = this.checkScroll(hItem);
            if (fixScroll) {
                OS.SendMessage(this.handle, 11, 1, 0);
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
            OS.SendMessage(this.handle, 4363, 5, hItem);
            OS.SendMessage(this.handle, 276, 6, 0);
            if (fixScroll) {
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.SendMessage(this.handle, 11, 0, 0);
            }
        } else {
            boolean scroll = true;
            RECT itemRect = new RECT();
            itemRect.left = hItem;
            if (OS.SendMessage(this.handle, 4356, 1, itemRect) != 0) {
                this.forceResize();
                RECT rect = new RECT();
                OS.GetClientRect(this.handle, rect);
                POINT pt = new POINT();
                pt.x = itemRect.left;
                pt.y = itemRect.top;
                if (OS.PtInRect(rect, pt)) {
                    pt.y = itemRect.bottom;
                    if (OS.PtInRect(rect, pt)) {
                        scroll = false;
                    }
                }
            }
            if (scroll) {
                boolean fixScroll = this.checkScroll(hItem);
                if (fixScroll) {
                    OS.SendMessage(this.handle, 11, 1, 0);
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
                OS.SendMessage(this.handle, 4372, 0, hItem);
                if (fixScroll) {
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    OS.SendMessage(this.handle, 11, 0, 0);
                }
            }
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.showItem(item.handle);
    }

    public void showSelection() {
        this.checkWidget();
        int hItem = 0;
        if ((this.style & 4) != 0) {
            hItem = OS.SendMessage(this.handle, 4362, 9, 0);
            if (hItem == 0) {
                return;
            }
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 8;
            tvItem.hItem = hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if ((tvItem.state & 2) == 0) {
                return;
            }
        } else {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 8;
            int oldProc = OS.GetWindowLong(this.handle, -4);
            OS.SetWindowLong(this.handle, -4, TreeProc);
            int index = 0;
            while (index < this.items.length) {
                TreeItem item = this.items[index];
                if (item != null) {
                    tvItem.hItem = item.handle;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    if ((tvItem.state & 2) != 0) {
                        hItem = tvItem.hItem;
                        break;
                    }
                }
                ++index;
            }
            OS.SetWindowLong(this.handle, -4, oldProc);
        }
        if (hItem != 0) {
            this.showItem(hItem);
        }
    }

    String toolTipText(NMTTDISPINFO hdr) {
        int hwndToolTip = OS.SendMessage(this.handle, 4377, 0, 0);
        if (hwndToolTip == hdr.hwndFrom && this.toolTipText != null) {
            return "";
        }
        return super.toolTipText(hdr);
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x20;
        return bits |= 7;
    }

    TCHAR windowClass() {
        return TreeClass;
    }

    int windowProc() {
        return TreeProc;
    }

    LRESULT WM_CHAR(int wParam, int lParam) {
        LRESULT result = super.WM_CHAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch (wParam) {
            case 13: {
                Event event = new Event();
                int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
                if (hItem != 0) {
                    TVITEM tvItem = new TVITEM();
                    tvItem.hItem = hItem;
                    tvItem.mask = 4;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    event.item = this.items[tvItem.lParam];
                }
                this.postEvent(14, event);
            }
            case 27: 
            case 32: {
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    LRESULT WM_GETOBJECT(int wParam, int lParam) {
        if ((this.style & 0x20) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(wParam, lParam);
    }

    LRESULT WM_KEYDOWN(int wParam, int lParam) {
        LRESULT result = super.WM_KEYDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch (wParam) {
            case 32: {
                int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
                if (hItem == 0) break;
                this.hAnchor = hItem;
                OS.SendMessage(this.handle, 4372, 0, hItem);
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 12;
                tvItem.hItem = hItem;
                if ((this.style & 0x20) != 0) {
                    tvItem.stateMask = 61440;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    int state = tvItem.state >> 12;
                    state = (state & 1) != 0 ? ++state : --state;
                    tvItem.state = state << 12;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    if (!OS.IsWinCE) {
                        int id = hItem;
                        if (OS.COMCTL32_MAJOR >= 6) {
                            id = OS.SendMessage(this.handle, 4395, hItem, 0);
                        }
                        OS.NotifyWinEvent(32773, this.handle, -4, id);
                    }
                }
                tvItem.stateMask = 2;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                tvItem.state = (this.style & 2) != 0 && OS.GetKeyState(17) < 0 ? ((tvItem.state & 2) != 0 ? (tvItem.state &= 0xFFFFFFFD) : (tvItem.state |= 2)) : (tvItem.state |= 2);
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                Event event = new Event();
                event.item = this.items[tvItem.lParam];
                this.postEvent(13, event);
                if ((this.style & 0x20) != 0) {
                    event = new Event();
                    event.item = this.items[tvItem.lParam];
                    event.detail = 32;
                    this.postEvent(13, event);
                }
                return LRESULT.ZERO;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: {
                int hItem;
                if ((this.style & 4) != 0) break;
                if (OS.GetKeyState(16) < 0 && (hItem = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
                    if (this.hAnchor == 0) {
                        this.hAnchor = hItem;
                    }
                    this.ignoreDeselect = true;
                    this.ignoreSelect = true;
                    int code = this.callWindowProc(this.handle, 256, wParam, lParam);
                    this.ignoreDeselect = false;
                    this.ignoreSelect = false;
                    int hNewItem = OS.SendMessage(this.handle, 4362, 9, 0);
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 8;
                    tvItem.stateMask = 2;
                    int hDeselectItem = hItem;
                    RECT rect1 = new RECT();
                    rect1.left = this.hAnchor;
                    OS.SendMessage(this.handle, 4356, 1, rect1);
                    RECT rect2 = new RECT();
                    rect2.left = hDeselectItem;
                    OS.SendMessage(this.handle, 4356, 1, rect2);
                    int flags = rect1.top < rect2.top ? 7 : 6;
                    while (hDeselectItem != this.hAnchor) {
                        tvItem.hItem = hDeselectItem;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        hDeselectItem = OS.SendMessage(this.handle, 4362, flags, hDeselectItem);
                    }
                    int hSelectItem = this.hAnchor;
                    rect1.left = hNewItem;
                    OS.SendMessage(this.handle, 4356, 1, rect1);
                    rect2.left = hSelectItem;
                    OS.SendMessage(this.handle, 4356, 1, rect2);
                    tvItem.state = 2;
                    flags = rect1.top < rect2.top ? 7 : 6;
                    while (hSelectItem != hNewItem) {
                        tvItem.hItem = hSelectItem;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        hSelectItem = OS.SendMessage(this.handle, 4362, flags, hSelectItem);
                    }
                    tvItem.hItem = hNewItem;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    tvItem.mask = 4;
                    tvItem.hItem = hNewItem;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    Event event = new Event();
                    event.item = this.items[tvItem.lParam];
                    this.postEvent(13, event);
                    return new LRESULT(code);
                }
                if (OS.GetKeyState(17) < 0 && (hItem = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 8;
                    tvItem.stateMask = 2;
                    tvItem.hItem = hItem;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    boolean oldSelected = (tvItem.state & 2) != 0;
                    int hNewItem = 0;
                    block4 : switch (wParam) {
                        case 38: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 7, hItem);
                            break;
                        }
                        case 40: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 6, hItem);
                            break;
                        }
                        case 36: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 0, 0);
                            break;
                        }
                        case 33: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 5, 0);
                            if (hNewItem != hItem) break;
                            OS.SendMessage(this.handle, 277, 2, 0);
                            hNewItem = OS.SendMessage(this.handle, 4362, 5, 0);
                            break;
                        }
                        case 34: {
                            int hVisible;
                            RECT rect = new RECT();
                            RECT clientRect = new RECT();
                            OS.GetClientRect(this.handle, clientRect);
                            hNewItem = OS.SendMessage(this.handle, 4362, 5, 0);
                            while ((hVisible = OS.SendMessage(this.handle, 4362, 6, hNewItem)) != 0) {
                                rect.left = hVisible;
                                OS.SendMessage(this.handle, 4356, 1, rect);
                                if (rect.bottom > clientRect.bottom) break block4;
                                hNewItem = hVisible;
                                if (hNewItem == hItem) {
                                    OS.SendMessage(this.handle, 277, 3, 0);
                                }
                                if (hNewItem != 0) continue;
                                break block4;
                            }
                            break;
                        }
                        case 35: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 10, 0);
                        }
                    }
                    if (hNewItem != 0) {
                        boolean newSelected;
                        OS.SendMessage(this.handle, 4372, 0, hNewItem);
                        tvItem.hItem = hNewItem;
                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                        boolean bl = newSelected = (tvItem.state & 2) != 0;
                        if (!newSelected && this.drawCount == 0) {
                            OS.UpdateWindow(this.handle);
                            OS.DefWindowProc(this.handle, 11, 0, 0);
                        }
                        this.ignoreSelect = true;
                        OS.SendMessage(this.handle, 4363, 9, hNewItem);
                        this.ignoreSelect = false;
                        if (oldSelected) {
                            tvItem.state = 2;
                            tvItem.hItem = hItem;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        }
                        if (!newSelected) {
                            tvItem.state = 0;
                            tvItem.hItem = hNewItem;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        }
                        if (!newSelected && this.drawCount == 0) {
                            RECT rect1 = new RECT();
                            RECT rect2 = new RECT();
                            rect1.left = hItem;
                            rect2.left = hNewItem;
                            OS.SendMessage(this.handle, 4356, 1, rect1);
                            OS.SendMessage(this.handle, 4356, 1, rect2);
                            OS.DefWindowProc(this.handle, 11, 1, 0);
                            if (OS.IsWinCE) {
                                OS.InvalidateRect(this.handle, rect1, false);
                                OS.InvalidateRect(this.handle, rect2, false);
                                OS.UpdateWindow(this.handle);
                            } else {
                                int flags = 257;
                                OS.RedrawWindow(this.handle, rect1, 0, flags);
                                OS.RedrawWindow(this.handle, rect2, 0, flags);
                            }
                        }
                        return LRESULT.ZERO;
                    }
                }
                int code = this.callWindowProc(this.handle, 256, wParam, lParam);
                this.hAnchor = OS.SendMessage(this.handle, 4362, 9, 0);
                return new LRESULT(code);
            }
        }
        return result;
    }

    LRESULT WM_KILLFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_KILLFOCUS(wParam, lParam);
        if ((this.style & 4) != 0) {
            return result;
        }
        OS.InvalidateRect(this.handle, null, false);
        return result;
    }

    LRESULT WM_LBUTTONDOWN(int wParam, int lParam) {
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = (short)(lParam & 0xFFFF);
        lpht.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4369, 0, lpht);
        if (lpht.hItem == 0 || (lpht.flags & 0x46) == 0) {
            TVITEM tvItem;
            int hSelection;
            this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam);
            boolean fixSelection = false;
            boolean deselected = false;
            if ((this.style & 2) != 0 && lpht.hItem != 0 && (lpht.flags & 0x10) != 0 && (hSelection = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
                tvItem = new TVITEM();
                tvItem.mask = 12;
                tvItem.hItem = lpht.hItem;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 0x20) != 0) {
                    fixSelection = true;
                    tvItem.stateMask = 2;
                    int hParent = OS.SendMessage(this.handle, 4362, 3, lpht.hItem);
                    int hLast = OS.SendMessage(this.handle, 4362, 10, lpht.hItem);
                    int hNext = OS.SendMessage(this.handle, 4362, 6, lpht.hItem);
                    while (hNext != 0 && hNext != hLast) {
                        tvItem.hItem = hNext;
                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                        if ((tvItem.state & 2) != 0) {
                            deselected = true;
                        }
                        tvItem.state = 0;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        hNext = OS.SendMessage(this.handle, 4362, 6, hNext);
                        if (hNext == 0 || hParent == OS.SendMessage(this.handle, 4362, 3, hNext)) break;
                    }
                }
            }
            if (fixSelection) {
                this.lockSelection = true;
                this.ignoreSelect = true;
                this.ignoreDeselect = true;
            }
            int code = this.callWindowProc(this.handle, 513, wParam, lParam);
            if (fixSelection) {
                this.lockSelection = false;
                this.ignoreSelect = false;
                this.ignoreDeselect = false;
            }
            if (OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            if (deselected) {
                tvItem = new TVITEM();
                tvItem.mask = 4;
                tvItem.hItem = lpht.hItem;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                Event event = new Event();
                event.item = this.items[tvItem.lParam];
                this.postEvent(13, event);
            }
            return new LRESULT(code);
        }
        if ((this.style & 0x20) != 0 && (lpht.flags & 0x40) != 0) {
            TVITEM tvItem = new TVITEM();
            tvItem.hItem = lpht.hItem;
            tvItem.mask = 12;
            tvItem.stateMask = 61440;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            int state = tvItem.state >> 12;
            state = (state & 1) != 0 ? ++state : --state;
            tvItem.state = state << 12;
            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            if (!OS.IsWinCE) {
                int id = tvItem.hItem;
                if (OS.COMCTL32_MAJOR >= 6) {
                    id = OS.SendMessage(this.handle, 4395, tvItem.hItem, 0);
                }
                OS.NotifyWinEvent(32773, this.handle, -4, id);
            }
            Event event = new Event();
            event.item = this.items[tvItem.lParam];
            event.detail = 32;
            this.postEvent(13, event);
            this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam);
            if (OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 8;
        tvItem.stateMask = 2;
        boolean hittestSelected = false;
        if ((this.style & 2) != 0) {
            tvItem.hItem = lpht.hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            hittestSelected = (tvItem.state & 2) != 0;
        }
        int hOldItem = OS.SendMessage(this.handle, 4362, 9, 0);
        if ((this.style & 2) != 0) {
            tvItem.hItem = hOldItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if (hittestSelected || (wParam & 8) != 0) {
                if (this.drawCount == 0) {
                    OS.UpdateWindow(this.handle);
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
            } else {
                this.deselectAll();
            }
        }
        this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam);
        this.gestureCompleted = false;
        this.dragStarted = false;
        this.ignoreSelect = true;
        this.ignoreDeselect = true;
        int code = this.callWindowProc(this.handle, 513, wParam, lParam);
        this.ignoreSelect = false;
        this.ignoreDeselect = false;
        if (this.dragStarted && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        int hNewItem = OS.SendMessage(this.handle, 4362, 9, 0);
        if ((this.style & 4) != 0 && hOldItem == hNewItem) {
            tvItem.mask = 8;
            tvItem.state = 2;
            tvItem.stateMask = 2;
            tvItem.hItem = hNewItem;
            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
        }
        if ((this.style & 2) != 0) {
            if (hittestSelected || (wParam & 8) != 0) {
                if (hOldItem == hNewItem && hOldItem == lpht.hItem) {
                    if ((wParam & 8) != 0) {
                        tvItem.state ^= 2;
                        if (this.dragStarted) {
                            tvItem.state = 2;
                        }
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                } else {
                    if ((tvItem.state & 2) != 0) {
                        tvItem.state = 2;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                    if ((wParam & 8) != 0 && !this.dragStarted && hittestSelected) {
                        tvItem.state = 0;
                        tvItem.hItem = lpht.hItem;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                }
                if (this.drawCount == 0) {
                    RECT rect1 = new RECT();
                    RECT rect2 = new RECT();
                    rect1.left = hOldItem;
                    rect2.left = hNewItem;
                    OS.SendMessage(this.handle, 4356, 1, rect1);
                    OS.SendMessage(this.handle, 4356, 1, rect2);
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    if (OS.IsWinCE) {
                        OS.InvalidateRect(this.handle, rect1, false);
                        OS.InvalidateRect(this.handle, rect2, false);
                        OS.UpdateWindow(this.handle);
                    } else {
                        int flags = 257;
                        OS.RedrawWindow(this.handle, rect1, 0, flags);
                        OS.RedrawWindow(this.handle, rect2, 0, flags);
                    }
                }
            }
            if (!((wParam & 8) != 0 || hittestSelected && this.dragStarted)) {
                tvItem.state = 0;
                int oldProc = OS.GetWindowLong(this.handle, -4);
                OS.SetWindowLong(this.handle, -4, TreeProc);
                int i = 0;
                while (i < this.items.length) {
                    TreeItem item = this.items[i];
                    if (item != null && item.handle != hNewItem) {
                        tvItem.hItem = item.handle;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                    ++i;
                }
                tvItem.hItem = hNewItem;
                tvItem.state = 2;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                OS.SetWindowLong(this.handle, -4, oldProc);
                if ((wParam & 4) != 0) {
                    RECT rect1 = new RECT();
                    if (this.hAnchor == 0) {
                        this.hAnchor = hNewItem;
                    }
                    rect1.left = this.hAnchor;
                    if (OS.SendMessage(this.handle, 4356, 1, rect1) != 0) {
                        RECT rect2 = new RECT();
                        rect2.left = hNewItem;
                        OS.SendMessage(this.handle, 4356, 1, rect2);
                        int flags = rect1.top < rect2.top ? 6 : 7;
                        tvItem.state = 2;
                        int hItem = tvItem.hItem = this.hAnchor;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        while (hItem != hNewItem) {
                            tvItem.hItem = hItem;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                            hItem = OS.SendMessage(this.handle, 4362, flags, hItem);
                        }
                    }
                }
            }
        }
        if ((wParam & 4) == 0) {
            this.hAnchor = hNewItem;
        }
        if (!this.gestureCompleted) {
            tvItem.hItem = hNewItem;
            tvItem.mask = 4;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            Event event = new Event();
            event.item = this.items[tvItem.lParam];
            this.postEvent(13, event);
        }
        this.gestureCompleted = false;
        if (this.dragStarted) {
            Event event = new Event();
            event.x = (short)(lParam & 0xFFFF);
            event.y = (short)(lParam >> 16);
            this.postEvent(29, event);
        } else {
            this.sendMouseEvent(4, 1, this.handle, 514, wParam, lParam);
        }
        this.dragStarted = false;
        return new LRESULT(code);
    }

    LRESULT WM_RBUTTONDOWN(int wParam, int lParam) {
        this.sendMouseEvent(3, 3, this.handle, 516, wParam, lParam);
        this.setFocus();
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = (short)(lParam & 0xFFFF);
        lpht.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4369, 0, lpht);
        if (lpht.hItem != 0 && (lpht.flags & 6) != 0 && (wParam & 0xC) == 0) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 8;
            tvItem.stateMask = 2;
            tvItem.hItem = lpht.hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if ((tvItem.state & 2) == 0) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4363, 9, 0);
                this.ignoreSelect = false;
                OS.SendMessage(this.handle, 4363, 9, lpht.hItem);
            }
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        if ((this.style & 4) != 0) {
            return result;
        }
        OS.InvalidateRect(this.handle, null, false);
        return result;
    }

    LRESULT WM_SYSCOLORCHANGE(int wParam, int lParam) {
        LRESULT result = super.WM_SYSCOLORCHANGE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
        return result;
    }

    LRESULT wmNotifyChild(int wParam, int lParam) {
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, 12);
        int code = hdr.code;
        switch (code) {
            case -12: {
                if (!this.customDraw) break;
                NMTVCUSTOMDRAW nmcd = new NMTVCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMTVCUSTOMDRAW.sizeof);
                switch (nmcd.dwDrawStage) {
                    case 1: {
                        return new LRESULT(32);
                    }
                    case 65537: {
                        TreeItem item = this.items[nmcd.lItemlParam];
                        if (item == null) break;
                        TVITEM tvItem = new TVITEM();
                        tvItem.mask = 8;
                        tvItem.hItem = item.handle;
                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                        int hFont = item.font;
                        int clrText = item.foreground;
                        int clrTextBk = item.background;
                        if (hFont == -1 && clrText == -1 && clrTextBk == -1) break;
                        if (hFont != -1) {
                            OS.SelectObject(nmcd.hdc, hFont);
                        }
                        if ((tvItem.state & 0xA) == 0) {
                            nmcd.clrText = clrText == -1 ? this.getForegroundPixel() : clrText;
                            nmcd.clrTextBk = clrTextBk == -1 ? this.getBackgroundPixel() : clrTextBk;
                        }
                        OS.MoveMemory(lParam, nmcd, NMTVCUSTOMDRAW.sizeof);
                        return new LRESULT(2);
                    }
                }
                break;
            }
            case -3: {
                if (!this.ignoreSelect) {
                    int pos = OS.GetMessagePos();
                    POINT pt = new POINT();
                    pt.x = (short)(pos & 0xFFFF);
                    pt.y = (short)(pos >> 16);
                    OS.ScreenToClient(this.handle, pt);
                    TVHITTESTINFO lpht = new TVHITTESTINFO();
                    lpht.x = pt.x;
                    lpht.y = pt.y;
                    OS.SendMessage(this.handle, 4369, 0, lpht);
                    if ((lpht.flags & 0x46) == 0) break;
                    Event event = new Event();
                    int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
                    if (hItem != 0) {
                        TVITEM tvItem = new TVITEM();
                        tvItem.hItem = hItem;
                        tvItem.mask = 4;
                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                        event.item = this.items[tvItem.lParam];
                    }
                    this.postEvent(14, event);
                }
                if (!this.hooks(14)) break;
                return LRESULT.ONE;
            }
            case -451: 
            case -402: {
                int offset;
                TVITEM tvItem;
                if ((this.style & 2) != 0 && this.lockSelection) {
                    if (this.oldSelected) {
                        tvItem = new TVITEM();
                        offset = 16;
                        OS.MoveMemory(tvItem, lParam + offset, 40);
                        tvItem.mask = 8;
                        tvItem.stateMask = 2;
                        tvItem.state = 2;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                    if (!this.newSelected && this.ignoreSelect) {
                        tvItem = new TVITEM();
                        offset = 56;
                        OS.MoveMemory(tvItem, lParam + offset, 40);
                        tvItem.mask = 8;
                        tvItem.stateMask = 2;
                        tvItem.state = 0;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                }
                if (this.ignoreSelect) break;
                tvItem = new TVITEM();
                offset = 56;
                OS.MoveMemory(tvItem, lParam + offset, 40);
                this.hAnchor = tvItem.hItem;
                Event event = new Event();
                event.item = this.items[tvItem.lParam];
                this.postEvent(13, event);
                break;
            }
            case -450: 
            case -401: {
                if ((this.style & 2) != 0 && this.lockSelection) {
                    TVITEM tvItem = new TVITEM();
                    int offset1 = 16;
                    OS.MoveMemory(tvItem, lParam + offset1, 40);
                    this.oldSelected = (tvItem.state & 2) != 0;
                    int offset2 = 56;
                    OS.MoveMemory(tvItem, lParam + offset2, 40);
                    boolean bl = this.newSelected = (tvItem.state & 2) != 0;
                }
                if (this.ignoreSelect || this.ignoreDeselect) break;
                this.hAnchor = 0;
                if ((this.style & 2) == 0) break;
                this.deselectAll();
                break;
            }
            case -454: 
            case -405: {
                if (this.ignoreExpand) break;
                TVITEM tvItem = new TVITEM();
                int offset = 56;
                OS.MoveMemory(tvItem, lParam + offset, 40);
                TreeItem item = this.items[tvItem.lParam];
                if (item == null) break;
                Event event = new Event();
                event.item = item;
                int[] action = new int[1];
                OS.MoveMemory(action, lParam + 12, 4);
                switch (action[0]) {
                    case 2: {
                        if ((tvItem.state & 0x20) != 0) break;
                        this.sendEvent(17, event);
                        if (!this.isDisposed()) break;
                        return LRESULT.ZERO;
                    }
                    case 1: {
                        this.sendEvent(18, event);
                        if (!this.isDisposed()) break;
                        return LRESULT.ZERO;
                    }
                }
                break;
            }
            case -457: 
            case -456: 
            case -408: 
            case -407: {
                TVITEM tvItem = new TVITEM();
                int offset = 56;
                OS.MoveMemory(tvItem, lParam + offset, 40);
                if (tvItem.hItem != 0 && (tvItem.state & 2) == 0) {
                    this.ignoreDeselect = true;
                    this.ignoreSelect = true;
                    OS.SendMessage(this.handle, 4363, 9, tvItem.hItem);
                    this.ignoreDeselect = false;
                    this.ignoreSelect = false;
                }
                this.dragStarted = true;
                break;
            }
            case -16: {
                boolean hasMenu;
                if (!OS.IsPPC) break;
                boolean bl = hasMenu = this.menu != null && !this.menu.isDisposed();
                if (hasMenu || this.hooks(35)) break;
                return LRESULT.ONE;
            }
            case 1000: {
                boolean hasMenu;
                if (!OS.IsPPC) break;
                boolean bl = hasMenu = this.menu != null && !this.menu.isDisposed();
                if (!hasMenu && !this.hooks(35)) break;
                NMRGINFO nmrg = new NMRGINFO();
                OS.MoveMemory(nmrg, lParam, NMRGINFO.sizeof);
                this.showMenu(this.menu, nmrg.x, nmrg.y);
                this.gestureCompleted = true;
                return LRESULT.ONE;
            }
        }
        return super.wmNotifyChild(wParam, lParam);
    }
}

