/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.debug.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.debug.IAntDebugController;
import org.eclipse.ant.internal.ui.debug.model.AntDebugTarget;
import org.eclipse.ant.internal.ui.debug.model.AntThread;
import org.eclipse.ant.internal.ui.launchConfigurations.RemoteAntBuildListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IProcess;

public class RemoteAntDebugBuildListener
extends RemoteAntBuildListener
implements IAntDebugController {
    private Socket fRequestSocket;
    private PrintWriter fRequestWriter;
    private BufferedReader fResponseReader;
    private int fRequestPort = -1;
    private AntDebugTarget fTarget;

    public RemoteAntDebugBuildListener(ILaunch launch) {
        super(launch);
    }

    protected void receiveMessage(String message) {
        if (this.fDebug) {
            System.out.println(message);
        }
        if (message.startsWith("build_started")) {
            this.buildStarted();
        } else if (message.startsWith("suspended")) {
            this.handleSuspendMessage(message);
        } else if (message.startsWith("terminated")) {
            this.fTarget.terminated();
        } else if (message.startsWith("stack")) {
            AntThread thread = (AntThread)this.fTarget.getThreads()[0];
            thread.buildStack(message);
        } else if (message.startsWith("prop")) {
            AntThread thread = (AntThread)this.fTarget.getThreads()[0];
            thread.newProperties(message);
        } else {
            super.receiveMessage(message);
        }
    }

    private void handleSuspendMessage(String message) {
        if (message.endsWith("client")) {
            this.fTarget.suspended(32);
        } else if (message.endsWith("step")) {
            this.fTarget.suspended(8);
        } else if (message.indexOf("breakpoint") >= 0) {
            this.fTarget.breakpointHit(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildStarted() {
        IProcess process = this.getProcess();
        while (process == null) {
            try {
                RemoteAntDebugBuildListener remoteAntDebugBuildListener = this;
                synchronized (remoteAntDebugBuildListener) {
                    this.wait(400L);
                }
                process = this.getProcess();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fTarget = new AntDebugTarget(this.fLaunch, process, this);
        this.fLaunch.addDebugTarget((IDebugTarget)this.fTarget);
        this.connectRequest();
        this.fTarget.buildStarted();
    }

    private void connectRequest() {
        try {
            this.fRequestSocket = new Socket("localhost", this.fRequestPort);
            this.fRequestWriter = new PrintWriter(this.fRequestSocket.getOutputStream(), true);
            this.fResponseReader = new BufferedReader(new InputStreamReader(this.fRequestSocket.getInputStream()));
            ReaderThread readerThread = new ReaderThread();
            readerThread.start();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {}
    }

    public synchronized void startListening(int eventPort, int requestPort) {
        super.startListening(eventPort);
        this.fRequestPort = requestPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRequest(String request) {
        if (this.fRequestSocket == null) {
            return;
        }
        Socket socket = this.fRequestSocket;
        synchronized (socket) {
            this.fRequestWriter.println(request);
        }
    }

    protected synchronized void shutDown() {
        if (this.fDebug) {
            System.out.println("shutdown " + this.fRequestPort);
        }
        if (this.fTarget != null) {
            this.fTarget.terminated();
            this.fTarget = null;
        }
        this.fLaunch = null;
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        try {
            if (this.fResponseReader != null) {
                this.fResponseReader.close();
                this.fResponseReader = null;
            }
        }
        catch (IOException iOException) {}
        if (this.fRequestWriter != null) {
            this.fRequestWriter.close();
            this.fRequestWriter = null;
        }
        try {
            if (this.fRequestSocket != null) {
                this.fRequestSocket.close();
                this.fRequestSocket = null;
            }
        }
        catch (IOException iOException) {}
        super.shutDown();
    }

    public void resume() {
        this.sendRequest("resume");
    }

    public void suspend() {
        this.sendRequest("suspend");
    }

    public void stepInto() {
        this.sendRequest("step_into");
    }

    public void stepOver() {
        this.sendRequest("step_over");
    }

    public void handleBreakpoint(IBreakpoint breakpoint, boolean add) {
        if (!this.fTarget.supportsBreakpoint(breakpoint)) {
            return;
        }
        StringBuffer message = new StringBuffer();
        if (add) {
            try {
                if (!breakpoint.isEnabled()) {
                    return;
                }
            }
            catch (CoreException e) {
                AntUIPlugin.log(e);
                return;
            }
            message.append("add");
        } else {
            message.append("remove");
        }
        message.append(",");
        message.append(breakpoint.getMarker().getResource().getLocation().toOSString());
        message.append(",");
        try {
            message.append(((ILineBreakpoint)breakpoint).getLineNumber());
            this.sendRequest(message.toString());
        }
        catch (CoreException ce) {
            AntUIPlugin.log(ce);
            return;
        }
    }

    public void getProperties() {
        this.sendRequest("prop");
    }

    public void getStackFrames() {
        this.sendRequest("stack");
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread() {
            super("Ant Request Response Reader Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String message = null;
                while (RemoteAntDebugBuildListener.this.fResponseReader != null) {
                    RemoteAntDebugBuildListener remoteAntDebugBuildListener = RemoteAntDebugBuildListener.this;
                    synchronized (remoteAntDebugBuildListener) {
                        if (RemoteAntDebugBuildListener.this.fResponseReader != null && (message = RemoteAntDebugBuildListener.this.fResponseReader.readLine()) != null) {
                            RemoteAntDebugBuildListener.this.receiveMessage(message);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                RemoteAntDebugBuildListener.this.shutDown();
            }
            catch (Exception e) {
                AntUIPlugin.log("Internal error processing remote response", e);
                RemoteAntDebugBuildListener.this.shutDown();
            }
        }
    }
}

