/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModelProblem;
import org.eclipse.jface.resource.ImageDescriptor;

public class AntTaskNode
extends AntElementNode {
    private Task fTask = null;
    private String fBaseLabel = null;
    protected String fLabel;
    private String fId = null;
    protected boolean fConfigured = false;

    public AntTaskNode(Task task) {
        super(task.getTaskName());
        this.fTask = task;
    }

    public AntTaskNode(Task task, String label) {
        super(task.getTaskName());
        this.fTask = task;
        this.fBaseLabel = label;
    }

    public String getLabel() {
        if (this.fLabel == null) {
            StringBuffer label = new StringBuffer();
            if (this.fBaseLabel != null) {
                label.append(this.fBaseLabel);
            } else if (this.fId != null) {
                label.append(this.fId);
            } else {
                label.append(this.fTask.getTaskName());
            }
            if (this.isExternal()) {
                this.appendEntityName(label);
            }
            this.fLabel = label.toString();
        }
        return this.fLabel;
    }

    public void setBaseLabel(String label) {
        this.fBaseLabel = label;
    }

    public Task getTask() {
        return this.fTask;
    }

    public void setTask(Task task) {
        this.fTask = task;
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        if (this.fId != null) {
            return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.type");
        }
        return super.getBaseImageDescriptor();
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public boolean configure(boolean validateFully) {
        if (!validateFully || this.getParentNode() instanceof AntTaskNode) {
            return false;
        }
        if (this.fConfigured) {
            return false;
        }
        int severity = AntModelProblem.getSeverity("problem_tasks");
        if (severity != -1) {
            try {
                this.getTask().maybeConfigure();
                this.nodeSpecificConfigure();
                this.fConfigured = true;
                return true;
            }
            catch (BuildException be) {
                this.handleBuildException(be, "problem_tasks");
            }
        }
        return false;
    }

    protected void nodeSpecificConfigure() {
    }

    protected void handleBuildException(BuildException be, String preferenceKey) {
        int severity = AntModelProblem.getSeverity(preferenceKey);
        if (severity != -1) {
            this.getAntModel().handleBuildException(be, this, severity);
        }
    }
}

