/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.ConsoleDocumentAdapter;
import org.eclipse.ui.internal.console.ConsoleHyperlinkPosition;

public class TextConsoleViewer
extends TextViewer
implements LineStyleListener,
LineBackgroundListener,
MouseTrackListener,
MouseMoveListener,
MouseListener,
PaintListener {
    private ConsoleDocumentAdapter documentAdapter;
    private IHyperlink hyperlink;
    private Cursor handCursor;
    private Cursor textCursor;
    private int consoleWidth = -1;
    private TextConsole console;
    private IPropertyChangeListener propertyChangeListener;

    public TextConsoleViewer(Composite parent, TextConsole console) {
        super(parent, 768);
        this.console = console;
        this.setDocument(console.getDocument());
        StyledText styledText = this.getTextWidget();
        styledText.setDoubleClickEnabled(true);
        styledText.addLineStyleListener((LineStyleListener)this);
        styledText.addLineBackgroundListener((LineBackgroundListener)this);
        styledText.setEditable(true);
        this.setFont(console.getFont());
        styledText.addMouseTrackListener((MouseTrackListener)this);
        styledText.addPaintListener((PaintListener)this);
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        this.propertyChangeListener = new HyperlinkColorChangeListener();
        colorRegistry.addListener(this.propertyChangeListener);
    }

    public void setTabWidth(int tabWidth) {
        StyledText styledText = this.getTextWidget();
        styledText.setTabs(tabWidth);
        styledText.redraw();
    }

    public void setFont(Font font) {
        StyledText styledText = this.getTextWidget();
        styledText.setFont(font);
        styledText.redraw();
    }

    protected void revealEndOfDocument() {
        StyledText text = this.getTextWidget();
        if (text != null) {
            int charCount = text.getCharCount();
            text.setCaretOffset(charCount);
            text.showSelection();
        }
    }

    public void lineGetStyle(LineStyleEvent event) {
        IDocument document = this.getDocument();
        if (document != null && document.getLength() > 0) {
            ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
            int offset = event.lineOffset;
            int length = event.lineText.length();
            StyleRange[] partitionerStyles = ((IConsoleDocumentPartitioner)document.getDocumentPartitioner()).getStyleRanges(event.lineOffset, event.lineText.length());
            if (partitionerStyles != null) {
                int i = 0;
                while (i < partitionerStyles.length) {
                    ranges.add(partitionerStyles[i]);
                    ++i;
                }
            }
            try {
                Display display = ConsolePlugin.getStandardDisplay();
                Color hyperlinkText = JFaceColors.getHyperlinkText((Display)display);
                Position[] positions = this.getDocument().getPositions(ConsoleHyperlinkPosition.HYPER_LINK_CATEGORY);
                Position[] overlap = this.findPosition(offset, length, positions);
                if (overlap != null) {
                    int i = 0;
                    while (i < overlap.length) {
                        this.weave(ranges, new StyleRange(overlap[i].offset, overlap[i].length, hyperlinkText, null));
                        ++i;
                    }
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            if (ranges.size() > 0) {
                event.styles = ranges.toArray(new StyleRange[ranges.size()]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void weave(List ranges, StyleRange styleRange) {
        if (ranges.isEmpty()) {
            ranges.add(styleRange);
            return;
        }
        int start = styleRange.start;
        int end = start + styleRange.length;
        int i = 0;
        while (i < ranges.size()) {
            StyleRange r = (StyleRange)ranges.get(i);
            int rEnd = r.start + r.length;
            if (start < r.start) {
                if (end >= r.start) {
                    ranges.add(i, new StyleRange(start, r.start - start, styleRange.foreground, styleRange.background));
                    if (end <= rEnd) return;
                    start = rEnd + 1;
                }
            } else if (start < rEnd) {
                if (end <= rEnd) return;
                start = rEnd + 1;
            }
            ++i;
        }
        if (start >= end) return;
        ranges.add(new StyleRange(start, end - start, styleRange.foreground, styleRange.background));
    }

    private Position[] findPosition(int offset, int length, Position[] positions) {
        if (positions.length == 0) {
            return null;
        }
        int rangeEnd = offset + length;
        int left = 0;
        int right = positions.length - 1;
        int mid = 0;
        Position position = null;
        while (left < right) {
            mid = (left + right) / 2;
            position = positions[mid];
            if (rangeEnd < position.getOffset()) {
                if (left == mid) {
                    right = left;
                    continue;
                }
                right = mid - 1;
                continue;
            }
            if (offset > position.getOffset() + position.getLength() - 1) {
                if (right == mid) {
                    left = right;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            left = right = mid;
        }
        ArrayList<Position> list = new ArrayList<Position>();
        int index = left - 1;
        if (index >= 0) {
            position = positions[index];
            while (index >= 0 && position.getOffset() + position.getLength() > offset) {
                if (--index <= 0) continue;
                position = positions[index];
            }
        }
        position = positions[++index];
        while (index < positions.length && position.getOffset() < rangeEnd) {
            list.add(position);
            if (++index >= positions.length) continue;
            position = positions[index];
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new Position[list.size()]);
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        event.lineBackground = null;
    }

    public void paintControl(PaintEvent e) {
        if (this.hyperlink != null) {
            IDocument doc = this.getDocument();
            StyledText text = this.getTextWidget();
            if (doc == null || text == null) {
                return;
            }
            IConsoleDocumentPartitioner partitioner = (IConsoleDocumentPartitioner)doc.getDocumentPartitioner();
            if (partitioner == null) {
                return;
            }
            IRegion linkRegion = this.console.getRegion(this.hyperlink);
            if (linkRegion != null) {
                int start = linkRegion.getOffset();
                int end = start + linkRegion.getLength();
                Color fontColor = JFaceColors.getActiveHyperlinkText((Display)Display.getCurrent());
                Color color = e.gc.getForeground();
                e.gc.setForeground(fontColor);
                FontMetrics metrics = e.gc.getFontMetrics();
                int height = metrics.getHeight();
                int width = metrics.getAverageCharWidth();
                int startLine = text.getLineAtOffset(start);
                int endLine = text.getLineAtOffset(end);
                int baseLineBias = text.getBaseline() - (metrics.getAscent() + metrics.getLeading());
                int i = startLine;
                while (i <= endLine) {
                    int styleStart = i == startLine ? start : text.getOffsetAtLine(i);
                    int styleEnd = i == endLine ? end : text.getOffsetAtLine(i + 1);
                    Point p1 = text.getLocationAtOffset(styleStart);
                    Point p2 = text.getLocationAtOffset(styleEnd - 1);
                    e.gc.drawLine(p1.x, p1.y + height + baseLineBias, p2.x + width, p2.y + height + baseLineBias);
                    String hyperlinkText = text.getText(styleStart, styleEnd - 1);
                    e.gc.drawString(hyperlinkText, p1.x, p1.y + baseLineBias);
                    ++i;
                }
                e.gc.setForeground(color);
            }
        }
    }

    protected Cursor getHandCursor() {
        if (this.handCursor == null) {
            this.handCursor = new Cursor((Device)ConsolePlugin.getStandardDisplay(), 21);
        }
        return this.handCursor;
    }

    protected Cursor getTextCursor() {
        if (this.textCursor == null) {
            this.textCursor = new Cursor((Device)ConsolePlugin.getStandardDisplay(), 19);
        }
        return this.textCursor;
    }

    protected void linkEntered(IHyperlink link) {
        StyledText control = this.getTextWidget();
        control.setRedraw(false);
        if (this.hyperlink != null) {
            this.linkExited(this.hyperlink);
        }
        this.hyperlink = link;
        this.hyperlink.linkEntered();
        control.setCursor(this.getHandCursor());
        control.setRedraw(true);
        control.redraw();
        control.addMouseListener((MouseListener)this);
    }

    protected void linkExited(IHyperlink link) {
        link.linkExited();
        this.hyperlink = null;
        StyledText control = this.getTextWidget();
        control.setCursor(this.getTextCursor());
        control.redraw();
        control.removeMouseListener((MouseListener)this);
    }

    public void mouseEnter(MouseEvent e) {
        this.getTextWidget().addMouseMoveListener((MouseMoveListener)this);
    }

    public void mouseExit(MouseEvent e) {
        this.getTextWidget().removeMouseMoveListener((MouseMoveListener)this);
        if (this.hyperlink != null) {
            this.linkExited(this.hyperlink);
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
        int offset = -1;
        try {
            Point p = new Point(e.x, e.y);
            offset = this.getTextWidget().getOffsetAtLocation(p);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.updateLinks(offset);
    }

    protected void updateLinks(int offset) {
        IHyperlink link;
        if (offset >= 0 && (link = this.getHyperlink(offset)) != null) {
            if (link.equals(this.hyperlink)) {
                return;
            }
            this.linkEntered(link);
            return;
        }
        if (this.hyperlink != null) {
            this.linkExited(this.hyperlink);
        }
    }

    public IHyperlink getHyperlink() {
        return this.hyperlink;
    }

    public IHyperlink getHyperlink(int offset) {
        if (offset >= 0 && this.console != null) {
            return this.console.getHyperlink(offset);
        }
        return null;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        String selection;
        if (this.hyperlink != null && (selection = this.getTextWidget().getSelectionText()).length() <= 0 && e.button == 1) {
            this.hyperlink.linkActivated();
        }
    }

    protected IDocumentAdapter createDocumentAdapter() {
        if (this.documentAdapter == null) {
            this.consoleWidth = -1;
            this.documentAdapter = new ConsoleDocumentAdapter(-1);
        }
        return this.documentAdapter;
    }

    public void setConsoleWidth(int width) {
        this.consoleWidth = width;
        if (this.documentAdapter != null) {
            this.documentAdapter.setWidth(this.consoleWidth);
        }
    }

    protected void handleDispose() {
        super.handleDispose();
        StyledText styledText = this.getTextWidget();
        styledText.removeLineStyleListener((LineStyleListener)this);
        styledText.removeLineBackgroundListener((LineBackgroundListener)this);
        styledText.removeMouseTrackListener((MouseTrackListener)this);
        styledText.removePaintListener((PaintListener)this);
        this.handCursor = null;
        this.textCursor = null;
        this.hyperlink = null;
        this.console = null;
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        colorRegistry.removeListener(this.propertyChangeListener);
    }

    class HyperlinkColorChangeListener
    implements IPropertyChangeListener {
        HyperlinkColorChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("ACTIVE_HYPERLINK_COLOR") || event.getProperty().equals("HYPERLINK_COLOR")) {
                TextConsoleViewer.this.getTextWidget().redraw();
            }
        }
    }
}

