/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.ConsoleFactoryExtension;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsolePageParticipantExtension;
import org.eclipse.ui.internal.console.PatternMatchListener;
import org.eclipse.ui.internal.console.PatternMatchListenerExtension;

public class ConsoleManager
implements IConsoleManager {
    private ListenerList fListeners = null;
    private List fConsoles = new ArrayList(10);
    private static final int ADDED = 1;
    private static final int REMOVED = 2;
    private List fPatternMatchListeners;
    private List fPageParticipants;
    private List fConsoleFactoryExtensions;
    private IWindowListener fWindowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            ConsoleManager.this.removeConsoles(ConsoleManager.this.fConsoles.toArray(new IConsole[0]));
        }
    };
    private boolean fWarnQueued = false;

    public ConsoleManager() {
        ConsolePlugin.getDefault().getWorkbench().addWindowListener(this.fWindowListener);
    }

    public void addConsoleListener(IConsoleListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList(5);
        }
        this.fListeners.add((Object)listener);
    }

    public void removeConsoleListener(IConsoleListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    public synchronized void addConsoles(IConsole[] consoles) {
        ArrayList<IConsole> added = new ArrayList<IConsole>(consoles.length);
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            if (console instanceof TextConsole) {
                TextConsole ioconsole = (TextConsole)console;
                IPatternMatchListener[] matchListeners = this.getPatternMatchListeners(ioconsole);
                int j = 0;
                while (j < matchListeners.length) {
                    ioconsole.addPatternMatchListener(matchListeners[j]);
                    ++j;
                }
            }
            if (!this.fConsoles.contains(console)) {
                this.fConsoles.add(console);
                added.add(console);
            }
            ++i;
        }
        if (!added.isEmpty()) {
            this.fireUpdate(added.toArray(new IConsole[added.size()]), 1);
        }
    }

    public synchronized void removeConsoles(IConsole[] consoles) {
        ArrayList<IConsole> removed = new ArrayList<IConsole>(consoles.length);
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            if (this.fConsoles.remove(console)) {
                removed.add(console);
            }
            ++i;
        }
        if (!removed.isEmpty()) {
            this.fireUpdate(removed.toArray(new IConsole[removed.size()]), 2);
        }
    }

    public synchronized IConsole[] getConsoles() {
        return this.fConsoles.toArray(new IConsole[this.fConsoles.size()]);
    }

    private void fireUpdate(IConsole[] consoles, int type) {
        new ConsoleNotifier().notify(consoles, type);
    }

    public void showConsoleView(final IConsole console) {
        ConsolePlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page;
                boolean consoleFound = false;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    IViewReference[] viewReferences = page.getViewReferences();
                    int i = 0;
                    while (i < viewReferences.length) {
                        IViewReference viewRef = viewReferences[i];
                        if (viewRef != null && "org.eclipse.ui.console.ConsoleView".equals(viewRef.getId())) {
                            IWorkbenchPart part = viewRef.getPart(false);
                            IConsoleView consoleView = null;
                            if (part instanceof IConsoleView) {
                                consoleFound = true;
                                consoleView = (IConsoleView)part;
                                boolean bringToTop = ConsoleManager.this.shouldBringToTop(console, consoleView);
                                if (bringToTop) {
                                    page.bringToTop((IWorkbenchPart)consoleView);
                                }
                                consoleView.display(console);
                            }
                        }
                        ++i;
                    }
                    if (!consoleFound) {
                        try {
                            IConsoleView consoleView = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView", null, 3);
                            boolean bringToTop = ConsoleManager.this.shouldBringToTop(console, consoleView);
                            if (bringToTop) {
                                page.bringToTop((IWorkbenchPart)consoleView);
                            }
                            consoleView.display(console);
                        }
                        catch (PartInitException pie) {
                            ConsolePlugin.log(pie);
                        }
                    }
                }
            }
        });
    }

    private boolean shouldBringToTop(IConsole console, IViewPart consoleView) {
        IConsoleView cView;
        boolean bringToTop = true;
        if (consoleView instanceof IConsoleView && (cView = (IConsoleView)consoleView).isPinned()) {
            IConsole pinnedConsole = cView.getConsole();
            bringToTop = console.equals(pinnedConsole);
        }
        return bringToTop;
    }

    public void warnOfContentChange(final IConsole console) {
        if (!this.fWarnQueued) {
            this.fWarnQueued = true;
            ConsolePlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    IConsoleView consoleView;
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null && (consoleView = (IConsoleView)page.findView("org.eclipse.ui.console.ConsoleView")) != null) {
                        consoleView.warnOfContentChange(console);
                    }
                    ConsoleManager.this.fWarnQueued = false;
                }
            });
        }
    }

    public IPatternMatchListener[] getPatternMatchListeners(IConsole console) {
        if (this.fPatternMatchListeners == null) {
            this.fPatternMatchListeners = new ArrayList();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ConsolePlugin.getUniqueIdentifier(), "consolePatternMatchListeners");
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement config = elements[i];
                PatternMatchListenerExtension extension = new PatternMatchListenerExtension(config);
                this.fPatternMatchListeners.add(extension);
                ++i;
            }
        }
        ArrayList<PatternMatchListener> list = new ArrayList<PatternMatchListener>();
        Iterator i = this.fPatternMatchListeners.iterator();
        while (i.hasNext()) {
            PatternMatchListenerExtension extension = (PatternMatchListenerExtension)i.next();
            try {
                if (!extension.isEnabledFor(console)) continue;
                list.add(new PatternMatchListener(extension));
            }
            catch (CoreException e) {
                ConsolePlugin.log(e);
            }
        }
        return list.toArray(new PatternMatchListener[0]);
    }

    public IConsolePageParticipant[] getPageParticipants(IConsole console) {
        if (this.fPageParticipants == null) {
            this.fPageParticipants = new ArrayList();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ConsolePlugin.getUniqueIdentifier(), "consolePageParticipants");
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement config = elements[i];
                ConsolePageParticipantExtension extension = new ConsolePageParticipantExtension(config);
                this.fPageParticipants.add(extension);
                ++i;
            }
        }
        ArrayList<IConsolePageParticipant> list = new ArrayList<IConsolePageParticipant>();
        Iterator i = this.fPageParticipants.iterator();
        while (i.hasNext()) {
            ConsolePageParticipantExtension extension = (ConsolePageParticipantExtension)i.next();
            try {
                if (!extension.isEnabledFor(console)) continue;
                list.add(extension.createDelegate());
            }
            catch (CoreException e) {
                ConsolePlugin.log(e);
            }
        }
        return list.toArray(new IConsolePageParticipant[0]);
    }

    public ConsoleFactoryExtension[] getConsoleFactoryExtensions() {
        if (this.fConsoleFactoryExtensions == null) {
            this.fConsoleFactoryExtensions = new ArrayList();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ConsolePlugin.getUniqueIdentifier(), "consoleFactories");
            IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < configurationElements.length) {
                this.fConsoleFactoryExtensions.add(new ConsoleFactoryExtension(configurationElements[i]));
                ++i;
            }
        }
        return this.fConsoleFactoryExtensions.toArray(new ConsoleFactoryExtension[0]);
    }

    class ConsoleNotifier
    implements ISafeRunnable {
        private IConsoleListener fListener;
        private int fType;
        private IConsole[] fChanged;

        ConsoleNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, ConsolePlugin.getUniqueIdentifier(), 120, ConsoleMessages.getString("ConsoleManager.0"), exception);
            ConsolePlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 1: {
                    this.fListener.consolesAdded(this.fChanged);
                    break;
                }
                case 2: {
                    this.fListener.consolesRemoved(this.fChanged);
                }
            }
        }

        public void notify(IConsole[] consoles, int update) {
            if (ConsoleManager.this.fListeners == null) {
                return;
            }
            this.fChanged = consoles;
            this.fType = update;
            Object[] copiedListeners = ConsoleManager.this.fListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (IConsoleListener)copiedListeners[i];
                Platform.run((ISafeRunnable)this);
                ++i;
            }
            this.fChanged = null;
            this.fListener = null;
        }
    }
}

