/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.console.ConsoleDropDownAction;
import org.eclipse.ui.internal.console.ConsoleFactoryExtension;
import org.eclipse.ui.internal.console.ConsoleManager;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsoleWorkbenchPart;
import org.eclipse.ui.internal.console.IConsoleHelpContextIds;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.internal.console.OpenConsoleAction;
import org.eclipse.ui.internal.console.PinConsoleAction;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ConsoleView
extends PageBookView
implements IConsoleView,
IConsoleListener,
IPropertyChangeListener,
IPartListener2 {
    private boolean fPinned = false;
    private List fStack = new ArrayList();
    private IConsole fActiveConsole = null;
    private Map fConsoleToPart = new HashMap();
    private Map fConsoleToPageParticipants;
    private Map fPartToConsole = new HashMap();
    private boolean fActive = false;
    private PinConsoleAction fPinAction = null;
    private ConsoleDropDownAction fDisplayConsoleAction = null;
    private OpenConsoleAction fOpenConsoleAction = null;
    private boolean fScrollLock;
    static /* synthetic */ Class class$0;

    private boolean isAvailable() {
        return this.getPageBook() != null && !this.getPageBook().isDisposed();
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof IConsole && event.getProperty().equals("org.eclipse.jface.text") && source.equals(this.getConsole())) {
            this.updateTitle();
        }
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        this.fPinAction.update();
    }

    public IConsole getConsole() {
        return this.fActiveConsole;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        IPage page;
        if (this.fActiveConsole != null && pageRec.page != this.getDefaultPage() && this.fPinned && this.fConsoleToPart.size() > 1) {
            IConsole console = (IConsole)this.fPartToConsole.get(pageRec.part);
            if (!this.fStack.contains(console)) {
                this.fStack.add(console);
            }
            return;
        }
        super.showPageRec(pageRec);
        this.fActiveConsole = (IConsole)this.fPartToConsole.get(pageRec.part);
        IConsole tos = null;
        if (!this.fStack.isEmpty()) {
            tos = (IConsole)this.fStack.get(0);
        }
        if (tos != null && !tos.equals(this.fActiveConsole)) {
            this.deactivateParticipants(tos);
        }
        if (this.fActiveConsole != null && !this.fActiveConsole.equals(tos)) {
            this.fStack.remove(this.fActiveConsole);
            this.fStack.add(0, this.fActiveConsole);
            this.activateParticipants(this.fActiveConsole);
        }
        this.updateTitle();
        if (this.fPinAction != null) {
            this.fPinAction.update();
        }
        if ((page = this.getCurrentPage()) instanceof IOConsolePage) {
            ((IOConsolePage)page).setAutoScroll(!this.fScrollLock);
        }
    }

    private void activateParticipants(IConsole console) {
        IConsolePageParticipant[] participants;
        if (console != null && this.fActive && (participants = this.getParticipants(console)) != null) {
            int i = 0;
            while (i < participants.length) {
                participants[i].activated();
                ++i;
            }
        }
    }

    protected List getConsoleStack() {
        return this.fStack;
    }

    protected void updateTitle() {
        IConsole console = this.getConsole();
        if (console == null) {
            this.setContentDescription(ConsoleMessages.getString("ConsoleView.0"));
        } else {
            this.setContentDescription(console.getName());
        }
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IConsole console = (IConsole)this.fPartToConsole.get(part);
        IConsolePageParticipant[] participants = (IConsolePageParticipant[])this.fConsoleToPageParticipants.remove(console);
        int i = 0;
        while (i < participants.length) {
            IConsolePageParticipant participant = participants[i];
            participant.dispose();
            ++i;
        }
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        console.removePropertyChangeListener(this);
        this.fPartToConsole.remove(part);
        this.fConsoleToPart.remove(console);
        if (this.fPartToConsole.isEmpty()) {
            this.fActiveConsole = null;
        }
        this.fPinAction.update();
    }

    private IConsolePageParticipant[] getParticipants(IConsole console) {
        return (IConsolePageParticipant[])this.fConsoleToPageParticipants.get(console);
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart dummyPart) {
        ConsoleWorkbenchPart part = (ConsoleWorkbenchPart)dummyPart;
        IConsole console = part.getConsole();
        IPageBookViewPage page = console.createPage(this);
        this.initPage(page);
        page.createControl((Composite)this.getPageBook());
        console.addPropertyChangeListener(this);
        IConsolePageParticipant[] participants = ((ConsoleManager)this.getConsoleManager()).getPageParticipants(console);
        this.fConsoleToPageParticipants.put(console, participants);
        int i = 0;
        while (i < participants.length) {
            IConsolePageParticipant participant = participants[i];
            participant.init(page, console);
            ++i;
        }
        PageBookView.PageRec rec = new PageBookView.PageRec(dummyPart, (IPage)page);
        return rec;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof ConsoleWorkbenchPart;
    }

    public void dispose() {
        super.dispose();
        this.getViewSite().getPage().removePartListener((IPartListener2)this);
        this.getConsoleManager().removeConsoleListener(this);
    }

    private IConsoleManager getConsoleManager() {
        return ConsolePlugin.getDefault().getConsoleManager();
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    public void consolesAdded(final IConsole[] consoles) {
        if (this.isAvailable()) {
            Runnable r = new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < consoles.length) {
                        if (ConsoleView.this.isAvailable()) {
                            IConsole console = consoles[i];
                            IConsole[] allConsoles = ConsoleView.this.getConsoleManager().getConsoles();
                            int j = 0;
                            while (j < allConsoles.length) {
                                IConsole registered = allConsoles[j];
                                if (registered.equals(console)) {
                                    ConsoleWorkbenchPart part = new ConsoleWorkbenchPart(console, ConsoleView.this.getSite());
                                    ConsoleView.this.fConsoleToPart.put(console, part);
                                    ConsoleView.this.fPartToConsole.put(part, console);
                                    ConsoleView.this.partActivated(part);
                                    break;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            };
            this.asyncExec(r);
        }
    }

    public void consolesRemoved(final IConsole[] consoles) {
        if (this.isAvailable()) {
            Runnable r = new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < consoles.length) {
                        if (ConsoleView.this.isAvailable()) {
                            IConsole[] available;
                            IConsole console = consoles[i];
                            ConsoleView.this.fStack.remove(console);
                            ConsoleWorkbenchPart part = (ConsoleWorkbenchPart)ConsoleView.this.fConsoleToPart.get(console);
                            if (part != null) {
                                ConsoleView.this.partClosed(part);
                            }
                            if (ConsoleView.this.getConsole() == null && (available = ConsoleView.this.getConsoleManager().getConsoles()).length > 0) {
                                ConsoleView.this.display(available[available.length - 1]);
                            }
                        }
                        ++i;
                    }
                }
            };
            this.asyncExec(r);
        }
    }

    public ConsoleView() {
        this.fConsoleToPageParticipants = new HashMap();
    }

    protected void createActions() {
        this.fPinAction = new PinConsoleAction(this);
        this.fDisplayConsoleAction = new ConsoleDropDownAction(this);
        ConsoleFactoryExtension[] extensions = ((ConsoleManager)ConsolePlugin.getDefault().getConsoleManager()).getConsoleFactoryExtensions();
        if (extensions.length > 0) {
            this.fOpenConsoleAction = new OpenConsoleAction();
        }
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.add((IContributionItem)new Separator("launchGroup"));
        mgr.add((IContributionItem)new Separator("outputGroup"));
        mgr.add((IContributionItem)new Separator("fixedGroup"));
        mgr.add((IAction)this.fPinAction);
        mgr.add((IAction)this.fDisplayConsoleAction);
        if (this.fOpenConsoleAction != null) {
            mgr.add((IAction)this.fOpenConsoleAction);
        }
    }

    public void display(IConsole console) {
        if (this.fPinned && this.fActiveConsole != null) {
            return;
        }
        ConsoleWorkbenchPart part = (ConsoleWorkbenchPart)this.fConsoleToPart.get(console);
        if (part != null) {
            this.partActivated(part);
        }
    }

    public void pin(boolean pin) {
        this.fPinned = pin;
        if (this.fPinAction != null) {
            this.fPinAction.update();
        }
    }

    public boolean isPinned() {
        return this.fPinned;
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    public void asyncExec(Runnable r) {
        if (this.isAvailable()) {
            this.getPageBook().getDisplay().asyncExec(r);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createActions();
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        this.configureToolBar(tbm);
        this.updateForExistingConsoles();
        this.getViewSite().getActionBars().updateActionBars();
        WorkbenchHelp.setHelp((Control)parent, (String)IConsoleHelpContextIds.CONSOLE_VIEW);
        this.getViewSite().getPage().addPartListener((IPartListener2)this);
    }

    private void updateForExistingConsoles() {
        IConsoleManager manager = this.getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        this.consolesAdded(consoles);
        manager.addConsoleListener(this);
    }

    public void warnOfContentChange(IConsole console) {
        IWorkbenchPart part = (IWorkbenchPart)this.fConsoleToPart.get(console);
        if (part != null) {
            IWorkbenchSiteProgressService service;
            IWorkbenchPartSite iWorkbenchPartSite = part.getSite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((service = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
                service.warnOfContentChange();
            }
        }
    }

    public Object getAdapter(Class key) {
        IConsolePageParticipant[] participants;
        IConsole console;
        Object adpater = super.getAdapter(key);
        if (adpater == null && (console = this.getConsole()) != null && (participants = (IConsolePageParticipant[])this.fConsoleToPageParticipants.get(console)) != null) {
            int i = 0;
            while (i < participants.length) {
                IConsolePageParticipant participant = participants[i];
                adpater = participant.getAdapter(key);
                if (adpater != null) {
                    return adpater;
                }
                ++i;
            }
        }
        return adpater;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        if (this.isThisPart(partRef)) {
            this.fActive = true;
            this.activateParticipants(this.fActiveConsole);
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        if (this.isThisPart(partRef)) {
            this.fActive = false;
            this.deactivateParticipants(this.fActiveConsole);
        }
    }

    protected boolean isThisPart(IWorkbenchPartReference partRef) {
        IViewReference viewRef;
        if (partRef instanceof IViewReference && (viewRef = (IViewReference)partRef).getId().equals(this.getViewSite().getId())) {
            String secId = viewRef.getSecondaryId();
            String mySec = null;
            if (this.getSite() instanceof IViewSite) {
                mySec = ((IViewSite)this.getSite()).getSecondaryId();
            }
            if (mySec == null) {
                return secId == null;
            }
            return mySec.equals(secId);
        }
        return false;
    }

    private void deactivateParticipants(IConsole console) {
        IConsolePageParticipant[] participants;
        if (console != null && (participants = this.getParticipants(console)) != null) {
            int i = 0;
            while (i < participants.length) {
                participants[i].deactivated();
                ++i;
            }
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void setScrollLock(boolean scrollLock) {
        this.fScrollLock = scrollLock;
        IPage page = this.getCurrentPage();
        if (page instanceof IOConsolePage) {
            ((IOConsolePage)page).setAutoScroll(!scrollLock);
        }
    }

    public boolean getScrollLock() {
        return this.fScrollLock;
    }
}

