/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.biojava.utils.bytecode.BranchFixup;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.ConstantPool;
import org.biojava.utils.bytecode.ExceptionMemento;
import org.biojava.utils.bytecode.Label;
import org.biojava.utils.bytecode.LocalVariable;
import org.biojava.utils.bytecode.OutstandingReference;
import org.biojava.utils.bytecode.ParametricType;
import org.biojava.utils.bytecode.ParentContext;
import org.biojava.utils.bytecode.SimpleReference;

class ChildContext
implements CodeContext,
ParentContext {
    ParentContext ourParent;
    private List outstandingRefs = new ArrayList();
    private Map markedLabels = new HashMap();
    private Map localVariables = new HashMap();
    private int usedLocals;
    private Map resolvedParametrics = new HashMap();

    ChildContext(ParentContext p) {
        this.ourParent = p;
        this.usedLocals = this.ourParent.getUsedLocals();
    }

    public CodeClass getCodeClass() {
        return this.ourParent.getCodeClass();
    }

    public CodeMethod getCodeMethod() {
        return this.ourParent.getCodeMethod();
    }

    public ConstantPool getConstants() {
        return this.ourParent.getConstants();
    }

    public void writeByte(byte b) throws CodeException {
        this.ourParent.writeByte(b);
    }

    public void writeShort(int i) throws CodeException {
        this.ourParent.writeShort(i);
    }

    public void writeShortAt(int pos, int i) {
        this.ourParent.writeShortAt(pos, i);
    }

    public void markLabel(Label l) throws CodeException {
        if (this.markedLabels.containsKey(l)) {
            throw new CodeException("Attempt to duplicate marked label");
        }
        this.markedLabels.put(l, new Integer(this.getOffset()));
    }

    public void promoteOutstandingReference(OutstandingReference or) {
        this.outstandingRefs.add(or);
    }

    public void writeLabel(Label l) throws CodeException {
        this.outstandingRefs.add(new BranchFixup(l, this.getOffset(), this));
        this.writeShort(0);
    }

    public int getOffset() {
        return this.ourParent.getOffset();
    }

    public void open() {
    }

    public void close() throws CodeException {
        ListIterator li = this.outstandingRefs.listIterator();
        while (li.hasNext()) {
            OutstandingReference or = (OutstandingReference)li.next();
            Integer off = (Integer)this.markedLabels.get(or.getLabel());
            if (off != null) {
                or.resolve(off);
                continue;
            }
            this.ourParent.promoteOutstandingReference(or);
        }
    }

    public CodeContext subContext() {
        return new ChildContext(this);
    }

    public int resolveLocal(LocalVariable lv) {
        Integer slot = (Integer)this.localVariables.get(lv);
        if (slot != null) {
            return slot;
        }
        int locSlot = this.ourParent.resolveLocalNoCreate(lv);
        if (locSlot < 0) {
            locSlot = this.usedLocals;
            this.usedLocals += lv.needSlots();
            this.setMaxLocals(this.usedLocals);
        }
        this.localVariables.put(lv, new Integer(locSlot));
        return locSlot;
    }

    public int resolveLocalNoCreate(LocalVariable lv) {
        Integer slot = (Integer)this.localVariables.get(lv);
        if (slot != null) {
            return slot;
        }
        return this.ourParent.resolveLocalNoCreate(lv);
    }

    public void registerParametricType(ParametricType type, CodeClass concreteType) throws CodeException {
        if (this.resolvedParametrics.containsKey(type)) {
            throw new CodeException("Failed to regiter parametric type " + type + ". Attempted to register for " + concreteType + " but it is already registered for " + this.resolvedParametrics.get(type));
        }
        if (!type.canAccept(concreteType)) {
            throw new CodeException("Parametric type is not compattible with concrete type: " + type + " : " + concreteType);
        }
        this.resolvedParametrics.put(type, concreteType);
    }

    public CodeClass resolveParametricType(ParametricType type) throws CodeException {
        CodeClass cc = (CodeClass)this.resolvedParametrics.get(type);
        if (cc == null) {
            return this.ourParent.resolveParametricType(type);
        }
        return cc;
    }

    public int getUsedLocals() {
        return this.usedLocals;
    }

    public void setMaxLocals(int m) {
        this.ourParent.setMaxLocals(m);
    }

    public void addExceptionTableEntry(Label startHandled, Label endHandled, CodeClass eClass, Label handler) {
        SimpleReference rStartHandled = new SimpleReference(startHandled);
        SimpleReference rEndHandled = new SimpleReference(endHandled);
        SimpleReference rHandler = new SimpleReference(handler);
        this.outstandingRefs.add(rStartHandled);
        this.outstandingRefs.add(rEndHandled);
        this.outstandingRefs.add(rHandler);
        this.addExceptionTableEntry(new ExceptionMemento(rStartHandled, rEndHandled, eClass, rHandler));
    }

    public void addExceptionTableEntry(ExceptionMemento em) {
        this.ourParent.addExceptionTableEntry(em);
    }
}

