/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.IntrospectedCodeConstructor;
import org.biojava.utils.bytecode.IntrospectedCodeMethod;

public class IntrospectedCodeClass
implements CodeClass {
    private static Map introspectedClasses = new HashMap();
    private static Map primitiveDescriptors = new HashMap();
    private Class clazz;
    private Set _methods;
    private Map _methsByNameSig;
    private Map _methsByName;
    private Set _fields;

    public static CodeClass forClass(Class c) {
        CodeClass cc = (CodeClass)introspectedClasses.get(c);
        if (cc == null) {
            cc = new IntrospectedCodeClass(c);
            introspectedClasses.put(c, cc);
        }
        return cc;
    }

    public static CodeClass forClass(String name) throws ClassNotFoundException {
        Class<?> c = ClassLoader.getSystemClassLoader().loadClass(name);
        return IntrospectedCodeClass.forClass(c);
    }

    public static CodeMethod forMethod(Method method) {
        return new IntrospectedCodeMethod(method);
    }

    private IntrospectedCodeClass(Class c) {
        this.clazz = c;
    }

    public String getName() {
        return this.clazz.getName();
    }

    public String getJName() {
        String name = this.getName();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '.') {
                sb.append('/');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String getDescriptor() {
        if (this.clazz.isPrimitive()) {
            String desc = (String)primitiveDescriptors.get(this.clazz);
            if (desc == null) {
                throw new RuntimeException("Unknown primitive type " + this.clazz.getName() + ", eeek!");
            }
            return desc;
        }
        if (this.clazz.isArray()) {
            return "[" + IntrospectedCodeClass.forClass(this.clazz.getComponentType()).getDescriptor();
        }
        String name = this.getName();
        StringBuffer sb = new StringBuffer();
        sb.append('L');
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '.') {
                sb.append('/');
                continue;
            }
            sb.append(c);
        }
        sb.append(';');
        return sb.toString();
    }

    public int getModifiers() {
        return this.clazz.getModifiers();
    }

    public CodeClass getSuperClass() {
        return IntrospectedCodeClass.forClass(this.clazz.getSuperclass());
    }

    public List getInterfaces() {
        Class<?>[] interfaces = this.clazz.getInterfaces();
        return Arrays.asList(interfaces);
    }

    public Set getMethods() {
        this.initMethods();
        return this._methods;
    }

    private void initMethods() {
        if (this._methods == null) {
            HashMap meths = new HashMap();
            this.popMeths(this.clazz, meths);
            this.popIMeths(this.clazz, meths);
            this._methods = new HashSet(meths.values());
            this._methsByNameSig = new HashMap();
            this._methsByName = new HashMap();
            Iterator i = this._methods.iterator();
            while (i.hasNext()) {
                CodeMethod m = (CodeMethod)i.next();
                HashSet<CodeMethod> mbn = (HashSet<CodeMethod>)this._methsByName.get(m.getName());
                if (mbn == null) {
                    mbn = new HashSet<CodeMethod>();
                    this._methsByName.put(m.getName(), mbn);
                }
                mbn.add(m);
                this._methsByNameSig.put(this.makeNameSig(m), m);
            }
        }
    }

    private void popMeths(Class clazz, Map meths) {
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            ArrayList<Object> sigList = new ArrayList<Object>();
            sigList.add(m.getName());
            sigList.addAll(Arrays.asList(m.getParameterTypes()));
            if (meths.containsKey(sigList)) continue;
            meths.put(sigList, new IntrospectedCodeMethod(m));
        }
        Class sup = clazz.getSuperclass();
        if (sup != null) {
            this.popMeths(sup, meths);
        }
    }

    private void popIMeths(Class clazz, Map meths) {
        Class sup;
        if (clazz.isInterface()) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                ArrayList<Object> sigList = new ArrayList<Object>();
                sigList.add(m.getName());
                sigList.addAll(Arrays.asList(m.getParameterTypes()));
                if (meths.containsKey(sigList)) continue;
                meths.put(sigList, new IntrospectedCodeMethod(m));
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.popIMeths(interfaces[i], meths);
            }
        }
        if ((sup = clazz.getSuperclass()) != null) {
            this.popIMeths(sup, meths);
        }
    }

    private List makeNameSig(CodeMethod m) {
        ArrayList<Object> res = new ArrayList<Object>();
        res.add(m.getName());
        for (int i = 0; i < m.numParameters(); ++i) {
            res.add(m.getParameterType(i));
        }
        return res;
    }

    public CodeField getFieldByName(String name) throws NoSuchFieldException {
        try {
            Field f = this.clazz.getField(name);
            return new CodeField(this, name, IntrospectedCodeClass.forClass(f.getType()), f.getModifiers());
        }
        catch (NoSuchFieldException ex) {
            throw (NoSuchFieldException)new NoSuchFieldException("Can't find field " + name + " in class " + this.getName()).initCause(ex);
        }
    }

    public Set getFields() {
        if (this._fields == null) {
            this._fields = new HashSet();
            Field[] fields = this.clazz.getFields();
            for (int fi = 0; fi < fields.length; ++fi) {
                Field f = fields[fi];
                this._fields.add(new CodeField(this, f.getName(), IntrospectedCodeClass.forClass(f.getType()), f.getModifiers()));
            }
            this._fields = Collections.unmodifiableSet(this._fields);
        }
        return this._fields;
    }

    public Set getMethodsByName(String name) {
        this.initMethods();
        Set hits = (Set)this._methsByName.get(name);
        if (hits == null) {
            return Collections.EMPTY_SET;
        }
        return hits;
    }

    public CodeMethod getMethod(String name, CodeClass[] args) throws NoSuchMethodException {
        this.initMethods();
        ArrayList<Object> nameSig = new ArrayList<Object>();
        nameSig.add(name);
        for (int i = 0; i < args.length; ++i) {
            nameSig.add(args[i]);
        }
        CodeMethod cm = (CodeMethod)this._methsByNameSig.get(nameSig);
        if (cm == null) {
            throw new NoSuchMethodException("Could not find method " + this.getName() + "." + name + "(" + CodeUtils.classListToString(args) + ")");
        }
        return cm;
    }

    public CodeMethod getConstructor(CodeClass[] args) throws NoSuchMethodException {
        try {
            Class[] argsC = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argsC[i] = ((IntrospectedCodeClass)args[i]).clazz;
            }
            return new IntrospectedCodeConstructor(this.clazz.getConstructor(argsC));
        }
        catch (NoSuchMethodException nsme) {
            throw (NoSuchMethodException)new NoSuchMethodException("Could not find constructor new " + this.getName() + "(" + CodeUtils.classListToString(args) + ")").initCause(nsme);
        }
    }

    public boolean isPrimitive() {
        return this.clazz.isPrimitive();
    }

    public boolean isArray() {
        return this.clazz.isArray();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.clazz.getName();
    }

    static {
        primitiveDescriptors.put(Byte.TYPE, "B");
        primitiveDescriptors.put(Character.TYPE, "C");
        primitiveDescriptors.put(Double.TYPE, "D");
        primitiveDescriptors.put(Float.TYPE, "F");
        primitiveDescriptors.put(Integer.TYPE, "I");
        primitiveDescriptors.put(Long.TYPE, "J");
        primitiveDescriptors.put(Short.TYPE, "S");
        primitiveDescriptors.put(Boolean.TYPE, "Z");
        primitiveDescriptors.put(Void.TYPE, "V");
    }
}

