/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.ImplicitCollectionDef;
import com.thoughtworks.xstream.alias.ImplicitCollectionMapper;
import com.thoughtworks.xstream.core.ImplicitCollectionDefImpl;
import com.thoughtworks.xstream.core.NamedItemType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AddableImplicitCollectionMapper
implements ImplicitCollectionMapper {
    private Map classNameToMapper = Collections.synchronizedMap(new HashMap());

    private ImplicitCollectionMapperForClass getMapper(Class definedIn) {
        return (ImplicitCollectionMapperForClass)this.classNameToMapper.get(definedIn);
    }

    private ImplicitCollectionMapperForClass getOrCreateMapper(Class definedIn) {
        ImplicitCollectionMapperForClass mapper = this.getMapper(definedIn);
        if (mapper == null) {
            mapper = new ImplicitCollectionMapperForClass(definedIn);
            this.classNameToMapper.put(definedIn, mapper);
        }
        return mapper;
    }

    public String getFieldNameForItemTypeAndName(Class definedIn, Class itemType, String itemFieldName) {
        ImplicitCollectionMapperForClass mapper = this.getMapper(definedIn);
        if (mapper != null) {
            return mapper.getFieldNameForItemTypeAndName(itemType, itemFieldName);
        }
        return null;
    }

    public Class getItemTypeForItemFieldName(Class definedIn, String itemFieldName) {
        ImplicitCollectionMapperForClass mapper = this.getMapper(definedIn);
        if (mapper != null) {
            return mapper.getItemTypeForItemFieldName(itemFieldName);
        }
        return null;
    }

    public ImplicitCollectionDef getImplicitCollectionDefForFieldName(Class definedIn, String fieldName) {
        ImplicitCollectionMapperForClass mapper = this.getMapper(definedIn);
        if (mapper != null) {
            return mapper.getImplicitCollectionDefForFieldName(fieldName);
        }
        return null;
    }

    public void add(Class definedIn, String fieldName, Class itemType) {
        this.add(definedIn, fieldName, null, itemType);
    }

    public void add(Class definedIn, String fieldName, String itemFieldName, Class itemType) {
        ImplicitCollectionMapperForClass mapper = this.getOrCreateMapper(definedIn);
        mapper.add(new ImplicitCollectionDefImpl(fieldName, itemType, itemFieldName));
    }

    private static class ImplicitCollectionMapperForClass {
        private Map namedItemTypeToDef = new HashMap();
        private Map itemFieldNameToDef = new HashMap();
        private Map fieldNameToDef = new HashMap();

        public ImplicitCollectionMapperForClass(Class definedIn) {
        }

        public String getFieldNameForItemTypeAndName(Class itemType, String itemFieldName) {
            ImplicitCollectionDefImpl unnamed = null;
            Iterator iterator = this.namedItemTypeToDef.keySet().iterator();
            while (iterator.hasNext()) {
                NamedItemType itemTypeForFieldName = (NamedItemType)iterator.next();
                if (!itemTypeForFieldName.itemType.isAssignableFrom(itemType)) continue;
                ImplicitCollectionDefImpl def = (ImplicitCollectionDefImpl)this.namedItemTypeToDef.get(itemTypeForFieldName);
                if (def.getItemFieldName() != null) {
                    if (!def.getItemFieldName().equals(itemFieldName)) continue;
                    return def.getFieldName();
                }
                unnamed = def;
                if (itemFieldName != null) continue;
                break;
            }
            return unnamed != null ? unnamed.getFieldName() : null;
        }

        public Class getItemTypeForItemFieldName(String itemFieldName) {
            ImplicitCollectionDefImpl def = this.getImplicitCollectionDefByItemFieldName(itemFieldName);
            if (def != null) {
                return def.getItemType();
            }
            return null;
        }

        private ImplicitCollectionDefImpl getImplicitCollectionDefByItemFieldName(String itemFieldName) {
            if (itemFieldName == null) {
                return null;
            }
            return (ImplicitCollectionDefImpl)this.itemFieldNameToDef.get(itemFieldName);
        }

        public ImplicitCollectionDefImpl getImplicitCollectionDefByFieldName(String fieldName) {
            return (ImplicitCollectionDefImpl)this.fieldNameToDef.get(fieldName);
        }

        public ImplicitCollectionDef getImplicitCollectionDefForFieldName(String fieldName) {
            return (ImplicitCollectionDef)this.fieldNameToDef.get(fieldName);
        }

        public void add(ImplicitCollectionDefImpl def) {
            this.fieldNameToDef.put(def.getFieldName(), def);
            this.namedItemTypeToDef.put(def.createNamedItemType(), def);
            if (def.getItemFieldName() != null) {
                this.itemFieldNameToDef.put(def.getItemFieldName(), def);
            }
        }
    }
}

