/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.builder;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;

public class DevClassPathHelper {
    protected boolean inDevelopmentMode = false;
    protected String[] devDefaultClasspath;
    protected Properties devProperties = null;

    public DevClassPathHelper(String devInfo) {
        String osgiDev = devInfo;
        if (osgiDev != null) {
            try {
                this.inDevelopmentMode = true;
                URL location = new URL(osgiDev);
                this.devProperties = DevClassPathHelper.load(location);
                this.devDefaultClasspath = Utils.getArrayFromString(this.devProperties.getProperty("*"));
            }
            catch (MalformedURLException malformedURLException) {
                this.devDefaultClasspath = Utils.getArrayFromString(osgiDev);
            }
        }
    }

    public String[] getDevClassPath(String id) {
        String entry;
        String[] result = null;
        if (id != null && this.devProperties != null && (entry = this.devProperties.getProperty(id)) != null) {
            result = Utils.getArrayFromString(entry);
        }
        if (result == null) {
            result = this.devDefaultClasspath;
        }
        return result;
    }

    public boolean inDevelopmentMode() {
        return this.inDevelopmentMode;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties load(URL url) {
        Properties props = new Properties();
        try {
            InputStream is = null;
            try {
                is = url.openStream();
                props.load(is);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                is.close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                is.close();
                return props;
            }
        }
        catch (IOException iOException) {
            String message = Policy.bind("exception.missingFile", url.toExternalForm());
            BundleHelper.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.pde.build", 10, message, null));
        }
        return props;
    }
}

