/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das.dasstructure;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.program.das.dasstructure.DASStructureXMLResponseParser;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DASStructureCall {
    String serverurl;

    public DASStructureCall() {
        this.serverurl = "";
    }

    public DASStructureCall(String url) {
        this.serverurl = url;
    }

    public void setServerurl(String s) {
        this.serverurl = s;
    }

    public String getServerurl() {
        return this.serverurl;
    }

    public Structure getStructure(String pdb_code) throws IOException {
        String connstr = this.serverurl + pdb_code;
        System.out.println(connstr);
        URL dasUrl = null;
        try {
            dasUrl = new URL(connstr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        InputStream inStream = this.connectDASServer(dasUrl);
        StructureImpl structure = null;
        try {
            structure = this.parseDASResponse(inStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return structure;
    }

    private InputStream connectDASServer(URL url) throws IOException {
        InputStream inStream = null;
        HttpURLConnection huc = null;
        huc = (HttpURLConnection)url.openConnection();
        String contentEncoding = huc.getContentEncoding();
        inStream = huc.getInputStream();
        return inStream;
    }

    private StructureImpl parseDASResponse(InputStream inStream) throws IOException, SAXException {
        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        spfactory.setValidating(false);
        spfactory.setNamespaceAware(false);
        SAXParser saxParser = null;
        try {
            saxParser = spfactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        XMLReader xmlreader = saxParser.getXMLReader();
        xmlreader.setFeature("http://xml.org/sax/features/validation", false);
        xmlreader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DASStructureXMLResponseParser cont_handle = new DASStructureXMLResponseParser();
        xmlreader.setContentHandler(cont_handle);
        xmlreader.setErrorHandler(new DefaultHandler());
        InputSource insource = new InputSource();
        insource.setByteStream(inStream);
        xmlreader.parse(insource);
        return cont_handle.get_structure();
    }
}

