/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.bio.program.tagvalue.TagValueWrapper;
import org.biojava.utils.ParserException;

public class StateMachine
implements TagValueWrapper {
    protected static final String START_RECORD_TAG = "__START_RECORD_TAG__";
    protected static final String END_RECORD_TAG = "__END_RECORD__";
    protected static final String END_TAG = "__END_TAG__";
    protected static final String MAGICAL_STATE = "__MAGICAL__";
    protected TagValueListener delegate = null;
    private State statePointer;
    private Map states = new HashMap();
    private BasicState magicalState = this.createState("__MAGICAL__");

    public StateMachine() {
        this.statePointer = this.magicalState;
    }

    public BasicState getMagicalState() {
        return this.magicalState;
    }

    public BasicState createState(String label) {
        if (this.states.get(label) != null) {
            throw new IllegalArgumentException("label " + label + " is not unique");
        }
        BasicState newState = new BasicState(label);
        this.states.put(label, newState);
        return newState;
    }

    public State getState(String label) {
        return (State)this.states.get(label);
    }

    public TransitionTable createTransitionTable() {
        return new TransitionTable();
    }

    public void setDelegate(TagValueListener delegate) {
        this.delegate = delegate;
    }

    public TagValueListener getDelegate() {
        return this.delegate;
    }

    public void startTag(Object tag) throws ParserException {
        this.statePointer.transit(tag);
        TagValueListener listener = this.statePointer.getListener();
        if (listener != null) {
            listener.startTag(tag);
        }
    }

    public void endTag() throws ParserException {
        TagValueListener lstnr = ((BasicState)this.statePointer).getListener();
        if (lstnr != null) {
            lstnr.endTag();
        }
        this.statePointer.transit(END_TAG);
    }

    public void startRecord() throws ParserException {
        TagValueListener lstnr = ((BasicState)this.statePointer).getListener();
        if (lstnr != null) {
            lstnr.startRecord();
        }
        this.statePointer.transit(START_RECORD_TAG);
    }

    public void endRecord() throws ParserException {
        TagValueListener lstnr = ((BasicState)this.statePointer).getListener();
        if (lstnr != null) {
            lstnr.endRecord();
        }
        this.statePointer.transit(END_RECORD_TAG);
    }

    public void value(TagValueContext ctxt, Object value) throws ParserException {
        TagValueListener lstnr = ((BasicState)this.statePointer).getListener();
        if (lstnr != null) {
            lstnr.value(ctxt, value);
        }
    }

    public class SimpleStateListener
    implements TagValueListener {
        private boolean exceptionOnNullDelegate = true;

        public void setExceptionOnNullDelegate(boolean throwException) {
            this.exceptionOnNullDelegate = throwException;
        }

        public void startTag(Object tag) throws ParserException {
            if (StateMachine.this.delegate != null) {
                StateMachine.this.delegate.startTag(tag);
            } else if (this.exceptionOnNullDelegate) {
                throw new ParserException("event arrived without a delegate being specified");
            }
        }

        public void endTag() throws ParserException {
            if (StateMachine.this.delegate != null) {
                StateMachine.this.delegate.endTag();
            } else if (this.exceptionOnNullDelegate) {
                throw new ParserException("event arrived without a delegate being specified");
            }
        }

        public void startRecord() throws ParserException {
            if (StateMachine.this.delegate != null) {
                StateMachine.this.delegate.startRecord();
            } else if (this.exceptionOnNullDelegate) {
                throw new ParserException("event arrived without a delegate being specified");
            }
        }

        public void endRecord() throws ParserException {
            if (StateMachine.this.delegate != null) {
                StateMachine.this.delegate.endRecord();
            } else if (this.exceptionOnNullDelegate) {
                throw new ParserException("event arrived without a delegate being specified");
            }
        }

        public void value(TagValueContext ctxt, Object value) throws ParserException {
            if (StateMachine.this.delegate != null) {
                StateMachine.this.delegate.value(ctxt, value);
            } else if (this.exceptionOnNullDelegate) {
                throw new ParserException("event arrived without a delegate being specified");
            }
        }
    }

    public class BasicState
    implements State {
        private String label;
        private TransitionTable transitions;
        private TransitionTable defaultTransitions;
        private TagValueListener listener = null;

        public BasicState(String label) {
            this.label = label;
            this.transitions = new TransitionTable();
        }

        public BasicState(String label, TagValueListener listener) {
            this.label = label;
            this.listener = listener;
            this.transitions = new TransitionTable();
        }

        public String getLabel() {
            return this.label;
        }

        public TagValueListener getListener() {
            return this.listener;
        }

        public void setListener(TagValueListener listener) {
            this.listener = listener;
        }

        public void setTransition(Object tag, State destination, boolean notifyOnExit) throws ParserException {
            this.transitions.setTransition(tag, destination, notifyOnExit);
        }

        public void setTransition(Object tag, State destination) throws ParserException {
            this.setTransition(tag, destination, false);
        }

        public TransitionTable getTransitionTable() {
            return this.transitions;
        }

        public void setDefaultTransitions(TransitionTable defaultTransitions) {
            this.defaultTransitions = defaultTransitions;
        }

        public void transit(Object tag) throws ParserException {
            Transition transition = this.transitions.get(tag);
            if (transition == null) {
                if (this.defaultTransitions == null) {
                    throw new ParserException("no transition available from " + StateMachine.this.statePointer.getLabel() + " for tag '" + tag + "'");
                }
                transition = this.defaultTransitions.get(tag);
                if (transition == null) {
                    throw new ParserException("no transition available from " + StateMachine.this.statePointer.getLabel() + " for tag '" + tag + "'");
                }
            }
            State nextState = transition.destination;
            if (transition.notifyOnExit && nextState != this && this.listener instanceof ExitNotification) {
                ((ExitNotification)((Object)this.listener)).notifyExit();
            }
            StateMachine.this.statePointer = nextState;
        }
    }

    public class TransitionTable {
        private Map table = new HashMap();
        private TransitionTable fallback = null;

        protected TransitionTable() {
        }

        public void put(Object tag, Transition transition) throws ParserException {
            if (this.table.containsKey(tag)) {
                throw new ParserException("duplicate tag " + tag);
            }
            this.table.put(tag, transition);
        }

        public void setTransition(Object tag, State destination, boolean notifyOnExit) throws ParserException {
            this.put(tag, new Transition(destination, notifyOnExit));
        }

        public Transition get(Object tag) {
            Transition transition = (Transition)this.table.get(tag);
            if (transition == null && this.fallback != null) {
                transition = this.fallback.get(tag);
            }
            return transition;
        }

        public void setFallback(TransitionTable fallback) {
            this.fallback = fallback;
        }
    }

    public class Transition {
        public State destination = null;
        public boolean notifyOnExit = false;

        private Transition(State destination, boolean notifyOnExit) {
            this.destination = destination;
            this.notifyOnExit = notifyOnExit;
        }
    }

    public static interface State {
        public String getLabel();

        public TagValueListener getListener();

        public void transit(Object var1) throws ParserException;
    }

    public static interface ExitNotification {
        public void notifyExit() throws ParserException;
    }
}

