/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.biosql.BioSQLAllFeatures;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceAnnotation;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceI;
import org.biojava.bio.seq.db.biosql.BioSQLTiledFeatures;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.DummySymbolList;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class BioSQLSequence
implements Sequence,
RealizingFeatureHolder,
BioSQLSequenceI {
    private BioSQLSequenceDB seqDB;
    private String name;
    private int bioentry_id = -1;
    private Annotation annotation;
    private Alphabet alphabet;
    private RealizingFeatureHolder features;
    private SymbolList symbols;
    private int length;

    public BioSQLSequenceDB getSequenceDB() {
        return this.seqDB;
    }

    public int getBioEntryID() {
        return this.bioentry_id;
    }

    BioSQLSequence(BioSQLSequenceDB seqDB, String name, int bioentry_id, String alphaName, int length) throws BioException {
        this.seqDB = seqDB;
        this.name = name;
        this.bioentry_id = bioentry_id;
        this.length = length;
        try {
            this.alphabet = AlphabetManager.alphabetForName(alphaName.toUpperCase());
        }
        catch (NoSuchElementException ex) {
            throw new BioException("Can't load sequence with unknown alphabet " + alphaName, ex);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return this.name;
    }

    public Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new BioSQLSequenceAnnotation(this.seqDB, this.bioentry_id);
        }
        return this.annotation;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public int length() {
        if (this.length >= 0) {
            return this.length;
        }
        return this.getSymbols().length();
    }

    public Symbol symbolAt(int i) {
        return this.getSymbols().symbolAt(i);
    }

    public SymbolList subList(int start, int end) {
        return this.getSymbols().subList(start, end);
    }

    public List toList() {
        return this.getSymbols().toList();
    }

    public Iterator iterator() {
        return this.getSymbols().iterator();
    }

    public String seqString() {
        return this.getSymbols().seqString();
    }

    public String subStr(int start, int end) {
        return this.getSymbols().subStr(start, end);
    }

    public void edit(Edit e) throws ChangeVetoException {
        throw new ChangeVetoException("Can't edit sequence in BioSQL -- or at least not yet...");
    }

    protected synchronized SymbolList getSymbols() {
        block9: {
            if (this.symbols == null) {
                try {
                    Connection conn = this.seqDB.getDataSource().getConnection();
                    PreparedStatement get_symbols = conn.prepareStatement("select seq from   biosequence where  bioentry_id = ?");
                    get_symbols.setInt(1, this.bioentry_id);
                    ResultSet rs = get_symbols.executeQuery();
                    String seqString = null;
                    if (rs.next()) {
                        seqString = rs.getString(1);
                        if (rs.wasNull()) {
                            seqString = null;
                        }
                    }
                    rs.close();
                    get_symbols.close();
                    conn.close();
                    if (seqString != null) {
                        try {
                            Alphabet alpha = this.getAlphabet();
                            SymbolTokenization toke = alpha.getTokenization("token");
                            this.symbols = new SimpleSymbolList(toke, seqString);
                            break block9;
                        }
                        catch (Exception ex) {
                            throw new BioRuntimeException("Couldn't parse tokenized symbols", ex);
                        }
                    }
                    if (this.length < 0) {
                        throw new BioRuntimeException("Length not available from database");
                    }
                    this.symbols = new DummySymbolList((FiniteAlphabet)this.alphabet, this.length);
                }
                catch (SQLException ex) {
                    throw new BioRuntimeException("Unknown error getting symbols from BioSQL.  Oh dear.", ex);
                }
            }
        }
        return this.symbols;
    }

    private RealizingFeatureHolder getFeatures() {
        if (this.features == null) {
            this.features = this.length() < 5000000 ? new BioSQLAllFeatures(this, this.seqDB, this.bioentry_id) : new BioSQLTiledFeatures(this, this.seqDB, this.bioentry_id, 1000000);
        }
        return this.features;
    }

    public FeatureFilter getSchema() {
        return this.getFeatures().getSchema();
    }

    public Iterator features() {
        return this.getFeatures().features();
    }

    public int countFeatures() {
        return this.getFeatures().countFeatures();
    }

    public boolean containsFeature(Feature f) {
        return this.getFeatures().containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff) {
        return this.getFeatures().filter(ff);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getFeatures().filter(ff, recurse);
    }

    public Feature createFeature(Feature.Template ft) throws ChangeVetoException, BioException {
        return this.getFeatures().createFeature(ft);
    }

    public void removeFeature(Feature f) throws ChangeVetoException, BioException {
        this.getFeatures().removeFeature(f);
    }

    public Feature realizeFeature(FeatureHolder parent, Feature.Template templ) throws BioException {
        return this.getFeatures().realizeFeature(parent, templ);
    }

    public void persistFeature(Feature f, int parent_id) throws BioException {
        this.seqDB.getFeaturesSQL().persistFeature(f, parent_id, this.bioentry_id);
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.getSequenceDB().getEntryChangeHub().addListener(this.bioentry_id, cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.getSequenceDB().getEntryChangeHub().removeListener(this.bioentry_id, cl, ct);
    }

    public boolean isUnchanging(ChangeType ct) {
        return false;
    }
}

