/*
 * Decompiled with CFR 0.152.
 */
package MCview;

import MCview.PDBChain;
import MCview.myAtom;
import jalview.DrawableSequence;
import jalview.FileParse;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class PDBfile
extends FileParse {
    public Vector chains = new Vector();

    public PDBfile(String inFile, String inType) throws IOException {
        super(inFile, inType);
        this.readLines();
        this.parse();
    }

    public void parse() {
        System.out.println("Parsing");
        int i = 0;
        while (i < this.lineArray.size()) {
            String inStr;
            StringTokenizer str = new StringTokenizer(this.lineArray.elementAt(i).toString());
            if (str.hasMoreTokens() && (inStr = str.nextToken()).indexOf("ATOM") != -1) {
                try {
                    myAtom tmpatom = new myAtom(str);
                    if (this.findChain(tmpatom.chain) != null) {
                        this.findChain((String)tmpatom.chain).atoms.addElement(tmpatom);
                    } else {
                        PDBChain tmpchain = new PDBChain(tmpatom.chain);
                        this.chains.addElement(tmpchain);
                        tmpchain.atoms.addElement(tmpatom);
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("Caught" + e);
                    System.out.println("Atom not added");
                }
            }
            ++i;
        }
        this.makeResidueList();
        this.makeCaBondList();
    }

    public void makeResidueList() {
        int i = 0;
        while (i < this.chains.size()) {
            ((PDBChain)this.chains.elementAt(i)).makeResidueList();
            ++i;
        }
    }

    public void makeCaBondList() {
        int i = 0;
        while (i < this.chains.size()) {
            ((PDBChain)this.chains.elementAt(i)).makeCaBondList();
            ++i;
        }
    }

    public PDBChain findChain(String id) {
        int i = 0;
        while (i < this.chains.size()) {
            if (((PDBChain)this.chains.elementAt((int)i)).id.equals(id)) {
                return (PDBChain)this.chains.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public void setChargeColours() {
        int i = 0;
        while (i < this.chains.size()) {
            ((PDBChain)this.chains.elementAt(i)).setChargeColours();
            ++i;
        }
    }

    public void setHydrophobicityColours() {
        int i = 0;
        while (i < this.chains.size()) {
            ((PDBChain)this.chains.elementAt(i)).setHydrophobicityColours();
            ++i;
        }
    }

    public void colourBySequence(DrawableSequence seq2) {
        int max = seq2.maxchain;
        if (seq2.maxchain != -1) {
            ((PDBChain)this.chains.elementAt(max)).colourBySequence(seq2);
        }
    }

    public void setChainColours() {
        int i = 0;
        while (i < this.chains.size()) {
            ((PDBChain)this.chains.elementAt(i)).setChainColours();
            ++i;
        }
    }

    public static void main(String[] args) {
        try {
            new PDBfile("enkp1.pdb", "File");
        }
        catch (IOException e) {
            System.out.println(e);
            System.exit(0);
        }
    }
}

