/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabPlugin;
import bilab.IUserText;
import bilab.Notify;
import bilab.PictureViewer;
import bilab.ViewerBase;
import bilab.picture;
import bilab.tree;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import scigol.TypeSpec;

public class TreeViewer
extends ViewerBase {
    tree input;
    PictureViewer viewer;
    Label label;
    Composite top;
    Composite child;
    ScrolledComposite scrolled;

    public TreeViewer(Composite parent) {
        this.top = new Composite(parent, 0);
        this.top.setLayout((Layout)new FillLayout());
        this.child = ViewerBase.optionalControlsComposite(this.top);
        this.scrolled = new ScrolledComposite(this.child, 2816);
        this.scrolled.setAlwaysShowScrollBars(false);
        this.input = null;
        this.viewer = null;
        this.label = new Label((Composite)this.scrolled, 0);
        this.scrolled.setContent((Control)this.label);
    }

    private picture renderTree(tree t) {
        Object[] args = new Object[]{t};
        Object result = BilabPlugin.getAddOnManager().callExternalFunction("bilab.phylip", "drawtree", args);
        if (!((result = TypeSpec.unwrapAny(result)) instanceof picture)) {
            Notify.devError((Object)this, "expected picture");
        }
        return (picture)result;
    }

    public Point preferedSize() {
        if (this.viewer != null) {
            return this.viewer.preferedSize();
        }
        return this.top.computeSize(-1, -1);
    }

    public Point maximumSize() {
        if (this.viewer != null) {
            return this.viewer.maximumSize();
        }
        return this.top.computeSize(-1, -1);
    }

    public String get_title() {
        if (this.input != null) {
            return this.input.get_ShortText();
        }
        return "<no tree>";
    }

    public String get_description() {
        if (this.input != null) {
            return this.input.get_DetailText();
        }
        return "";
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.top;
    }

    public Object getInput() {
        return this.input;
    }

    public void refresh() {
        if (this.viewer == null) {
            if (this.input != null) {
                if (this.input instanceof IUserText) {
                    this.label.setText(this.input.get_DetailText());
                } else {
                    this.label.setText(this.input.toString());
                }
            } else {
                this.label.setText("<no tree>");
            }
        } else {
            picture treePicture = this.renderTree(this.input);
            this.viewer.setInput(treePicture);
            this.viewer.refresh();
        }
        this.top.layout(true);
        this.top.redraw();
    }

    public void setInput(Object input) {
        if ((input = TypeSpec.unwrapAnyOrNum(input)) == this.input) {
            return;
        }
        if (!(input instanceof tree)) {
            input = null;
        }
        this.input = input != null ? (tree)input : null;
        if (!this.child.isDisposed()) {
            this.child.dispose();
        }
        if (this.viewer != null) {
            this.viewer.dispose();
            this.viewer = null;
        }
        this.child = ViewerBase.optionalControlsComposite(this.top);
        this.scrolled = new ScrolledComposite(this.child, 2816);
        this.scrolled.setAlwaysShowScrollBars(false);
        if (input != null) {
            this.viewer = new PictureViewer((Composite)this.scrolled);
        }
        if (this.viewer == null) {
            this.label = new Label((Composite)this.scrolled, 0);
            this.scrolled.setContent((Control)this.label);
        } else {
            this.scrolled.setContent(this.viewer.getControl());
        }
        this.refresh();
    }

    public ISelection getSelection() {
        if (this.viewer != null) {
            return this.viewer.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection, reveal);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }
}

