/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook.parts;

import bilab.notebook.model.Connection;
import bilab.notebook.model.EllipticalGraphic;
import bilab.notebook.model.Graphic;
import bilab.notebook.model.ModelElement;
import bilab.notebook.model.RectangularGraphic;
import bilab.notebook.model.commands.ConnectionCreateCommand;
import bilab.notebook.model.commands.ConnectionReconnectCommand;
import bilab.notebook.parts.GraphicComponentEditPolicy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

class GraphicEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    GraphicEditPart() {
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new GraphicComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolciy", (EditPolicy)new GraphicalNodeEditPolicy(){

            protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
                ConnectionCreateCommand cmd = (ConnectionCreateCommand)request.getStartCommand();
                cmd.setTarget((Graphic)this.getHost().getModel());
                return cmd;
            }

            protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
                Graphic source = (Graphic)this.getHost().getModel();
                int style = (Integer)request.getNewObjectType();
                ConnectionCreateCommand cmd = new ConnectionCreateCommand(source, style);
                request.setStartCommand((Command)cmd);
                return cmd;
            }

            protected Command getReconnectSourceCommand(ReconnectRequest request) {
                Connection conn = (Connection)request.getConnectionEditPart().getModel();
                Graphic newSource = (Graphic)this.getHost().getModel();
                ConnectionReconnectCommand cmd = new ConnectionReconnectCommand(conn);
                cmd.setNewSource(newSource);
                return cmd;
            }

            protected Command getReconnectTargetCommand(ReconnectRequest request) {
                Connection conn = (Connection)request.getConnectionEditPart().getModel();
                Graphic newTarget = (Graphic)this.getHost().getModel();
                ConnectionReconnectCommand cmd = new ConnectionReconnectCommand(conn);
                cmd.setNewTarget(newTarget);
                return cmd;
            }
        });
    }

    protected IFigure createFigure() {
        IFigure f = this.createFigureForModel();
        f.setOpaque(true);
        f.setBackgroundColor(ColorConstants.lightBlue);
        return f;
    }

    private IFigure createFigureForModel() {
        if (this.getModel() instanceof EllipticalGraphic) {
            return new Ellipse();
        }
        if (this.getModel() instanceof RectangularGraphic) {
            return new RectangleFigure();
        }
        throw new IllegalArgumentException();
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    private Graphic getCastedModel() {
        return (Graphic)this.getModel();
    }

    protected List getModelSourceConnections() {
        return this.getCastedModel().getSourceConnections();
    }

    protected List getModelTargetConnections() {
        return this.getCastedModel().getTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("Shape.Size".equals(prop) || "Shape.Location".equals(prop)) {
            this.refreshVisuals();
        }
        if ("Shape.SourceConn".equals(prop)) {
            this.refreshSourceConnections();
        }
        if ("Shape.TargetConn".equals(prop)) {
            this.refreshTargetConnections();
        }
    }

    protected void refreshVisuals() {
        Rectangle bounds = new Rectangle(this.getCastedModel().getLocation(), this.getCastedModel().getSize());
        this.figure.setBounds(bounds);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.figure, (Object)bounds);
    }
}

