/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.Format;
import jalview.MSFfile;
import jalview.ResidueProperties;
import jalview.Sequence;
import jalview.ick;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class AlignSeq {
    int[][] score;
    int[][] E;
    int[][] F;
    int[][] traceback;
    int[] seq1;
    int[] seq2;
    Sequence s1;
    Sequence s2;
    String s1str;
    String s2str;
    int maxi;
    int maxj;
    int[] aseq1;
    int[] aseq2;
    String astr1 = "";
    String astr2 = "";
    int seq1start;
    int seq1end;
    int seq2start;
    int seq2end;
    int count;
    int maxscore;
    float pid;
    int prev = 0;
    public static Hashtable dnaHash = new Hashtable();
    static String[] dna;
    static String[] pep;
    int gapOpen = 120;
    int gapExtend = 20;
    int[][] lookup = ResidueProperties.BLOSUM62;
    String[] intToStr = pep;
    int defInt = 23;
    String output = "";
    String type;
    Runtime rt;

    static {
        dnaHash.put("C", new Integer(0));
        dnaHash.put("T", new Integer(1));
        dnaHash.put("A", new Integer(2));
        dnaHash.put("G", new Integer(3));
        dnaHash.put("-", new Integer(4));
        dna = new String[]{"C", "T", "A", "G", "-"};
        pep = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "B", "Z", "X", "-"};
    }

    public AlignSeq() {
    }

    public AlignSeq(Sequence s1, Sequence s2, String type) {
        this.rt = Runtime.getRuntime();
        this.SeqInit(s1, s2, type);
    }

    public void SeqInit(Sequence s1, Sequence s2, String type) {
        System.out.println(s1.getSequence());
        System.out.println(s2.getSequence());
        this.s1str = AlignSeq.extractGaps(".", s1.getSequence());
        this.s2str = AlignSeq.extractGaps(".", s2.getSequence());
        this.s1str = AlignSeq.extractGaps("-", this.s1str);
        this.s2str = AlignSeq.extractGaps("-", this.s2str);
        this.s1str = AlignSeq.extractGaps(" ", this.s1str);
        this.s2str = AlignSeq.extractGaps(" ", this.s2str);
        this.s1 = s1;
        this.s2 = s2;
        this.type = type;
        if (type.equals("pep")) {
            this.lookup = ResidueProperties.BLOSUM62;
            this.intToStr = pep;
            this.defInt = 23;
        } else if (type.equals("dna")) {
            this.lookup = ResidueProperties.DNA;
            this.intToStr = dna;
            this.defInt = 4;
        } else {
            this.output = String.valueOf(this.output) + "Wrong type = dna or pep only";
            System.exit(0);
        }
        this.seq1 = new int[this.s1str.length()];
        this.seq2 = new int[this.s2str.length()];
        this.score = new int[this.s1str.length()][this.s2str.length()];
        this.E = new int[this.s1str.length()][this.s2str.length()];
        this.F = new int[this.s1str.length()][this.s2str.length()];
        this.traceback = new int[this.s1str.length()][this.s2str.length()];
        this.seq1 = this.stringToInt(this.s1str, type);
        this.seq2 = this.stringToInt(this.s2str, type);
    }

    public void traceAlignment() {
        int max = -9999;
        int i = 0;
        while (i < this.seq1.length) {
            if (this.score[i][this.seq2.length - 1] > max) {
                max = this.score[i][this.seq2.length - 1];
                this.maxi = i;
                this.maxj = this.seq2.length - 1;
            }
            ++i;
        }
        int j = 0;
        while (j < this.seq2.length) {
            if (this.score[this.seq1.length - 1][j] > max) {
                max = this.score[this.seq1.length - 1][j];
                this.maxi = this.seq1.length - 1;
                this.maxj = j;
            }
            ++j;
        }
        i = this.maxi;
        int j2 = this.maxj;
        this.maxscore = this.score[i][j2] / 10;
        this.seq1end = this.maxi + 1;
        this.seq2end = this.maxj + 1;
        this.aseq1 = new int[this.seq1.length + this.seq2.length];
        this.aseq2 = new int[this.seq1.length + this.seq2.length];
        this.count = this.seq1.length + this.seq2.length - 1;
        while (i > 0 && j2 > 0) {
            int trace;
            if (this.aseq1[this.count] != this.defInt && i >= 0) {
                this.aseq1[this.count] = this.seq1[i];
                this.astr1 = String.valueOf(this.intToStr[this.seq1[i]]) + this.astr1;
            }
            if (this.aseq2[this.count] != this.defInt && j2 > 0) {
                this.aseq2[this.count] = this.seq2[j2];
                this.astr2 = String.valueOf(this.intToStr[this.seq2[j2]]) + this.astr2;
            }
            if ((trace = this.findTrace(i, j2)) == 0) {
                --i;
                --j2;
            } else if (trace == 1) {
                --j2;
                this.aseq1[this.count] = this.defInt;
                this.astr1 = "-" + this.astr1.substring(1);
            } else if (trace == -1) {
                --i;
                this.aseq2[this.count] = this.defInt;
                this.astr2 = "-" + this.astr2.substring(1);
            }
            --this.count;
        }
        this.seq1start = i + 1;
        this.seq2start = j2 + 1;
        if (this.aseq1[this.count] != this.defInt) {
            this.aseq1[this.count] = this.seq1[i];
            this.astr1 = String.valueOf(this.intToStr[this.seq1[i]]) + this.astr1;
        }
        if (this.aseq2[this.count] != this.defInt) {
            this.aseq2[this.count] = this.seq2[j2];
            this.astr2 = String.valueOf(this.intToStr[this.seq2[j2]]) + this.astr2;
        }
    }

    public void printAlignment() {
        int maxid = this.s1.getName().length();
        if (this.s2.getName().length() > maxid) {
            maxid = this.s2.getName().length();
        }
        int len = 72 - maxid - 1;
        int nochunks = (this.aseq1.length - this.count) / len + 1;
        this.pid = 0.0f;
        this.output = String.valueOf(this.output) + "Score = " + this.score[this.maxi][this.maxj] + "\n";
        this.output = String.valueOf(this.output) + "Length of alignment = " + (this.aseq1.length - this.count) + "\n";
        this.output = String.valueOf(this.output) + "Sequence ";
        this.output = String.valueOf(this.output) + new Format("%" + maxid + "s").form(this.s1.getName());
        this.output = String.valueOf(this.output) + " :  " + this.seq1start + " - " + this.seq1end + " (Sequence length = " + this.s1str.length() + ")\n";
        this.output = String.valueOf(this.output) + "Sequence ";
        this.output = String.valueOf(this.output) + new Format("%" + maxid + "s").form(this.s2.getName());
        this.output = String.valueOf(this.output) + " :  " + this.seq2start + " - " + this.seq2end + " (Sequence length = " + this.s2str.length() + ")\n\n";
        int j = 0;
        while (j < nochunks) {
            this.output = String.valueOf(this.output) + new Format("%" + maxid + "s").form(this.s1.getName()) + " ";
            int i = 0;
            while (i < len) {
                if (this.count + i + j * len < this.aseq1.length) {
                    this.output = String.valueOf(this.output) + new Format("%s").form(this.intToStr[this.aseq1[this.count + i + j * len]]);
                }
                ++i;
            }
            this.output = String.valueOf(this.output) + "\n";
            this.output = String.valueOf(this.output) + new Format("%" + maxid + "s").form(" ") + " ";
            i = 0;
            while (i < len) {
                if (this.count + i + j * len < this.aseq1.length) {
                    if (this.intToStr[this.aseq1[this.count + i + j * len]].equals(this.intToStr[this.aseq2[this.count + i + j * len]]) && !this.intToStr[this.aseq1[this.count + i + j * len]].equals("-")) {
                        this.pid += 1.0f;
                        this.output = String.valueOf(this.output) + "|";
                    } else {
                        this.output = this.type.equals("pep") ? (ResidueProperties.getPAM250(this.intToStr[this.aseq1[this.count + i + j * len]], this.intToStr[this.aseq2[this.count + i + j * len]]) > 0 ? String.valueOf(this.output) + "." : String.valueOf(this.output) + " ") : String.valueOf(this.output) + " ";
                    }
                }
                ++i;
            }
            this.output = String.valueOf(this.output) + "\n";
            this.output = String.valueOf(this.output) + new Format("%" + maxid + "s").form(this.s2.getName()) + " ";
            i = 0;
            while (i < len) {
                if (this.count + i + j * len < this.aseq1.length) {
                    this.output = String.valueOf(this.output) + new Format("%s").form(this.intToStr[this.aseq2[this.count + i + j * len]]);
                }
                ++i;
            }
            this.output = String.valueOf(this.output) + "\n\n";
            ++j;
        }
        this.pid = this.pid / (float)(this.aseq1.length - this.count) * 100.0f;
        this.output = String.valueOf(this.output) + new Format("Percentage ID = %2.2f\n\n").form(this.pid);
    }

    public void printScoreMatrix(int[][] mat) {
        int n = this.seq1.length;
        int m = this.seq2.length;
        int i = 0;
        while (i < n) {
            if (i == 0) {
                Format.print(System.out, "%8s", this.s2str.substring(0, 1));
                int jj = 1;
                while (jj < m) {
                    Format.print(System.out, "%5s", this.s2str.substring(jj, jj + 1));
                    ++jj;
                }
                System.out.println();
            }
            int j = 0;
            while (j < m) {
                if (j == 0) {
                    Format.print(System.out, "%3s", this.s1str.substring(i, i + 1));
                }
                Format.print(System.out, "%3d ", mat[i][j] / 10);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public int findTrace(int i, int j) {
        int t = 0;
        int max = this.score[i - 1][j - 1] + this.lookup[this.seq1[i]][this.seq2[j]] * 10;
        if (this.F[i][j] > max) {
            max = this.F[i][j];
            t = -1;
        } else if (this.F[i][j] == max && this.prev == -1) {
            max = this.F[i][j];
            t = -1;
        }
        if (this.E[i][j] >= max) {
            max = this.E[i][j];
            t = 1;
        } else if (this.E[i][j] == max && this.prev == 1) {
            max = this.E[i][j];
            t = 1;
        }
        this.prev = t;
        return t;
    }

    public void calcScoreMatrix() {
        int n = this.seq1.length;
        int m = this.seq2.length;
        this.score[0][0] = this.lookup[this.seq1[0]][this.seq2[0]] * 10;
        this.E[0][0] = -this.gapExtend;
        this.F[0][0] = 0;
        int j = 1;
        while (j < m) {
            this.E[0][j] = this.max(this.score[0][j - 1] - this.gapOpen, this.E[0][j - 1] - this.gapExtend);
            this.F[0][j] = -this.gapExtend;
            this.score[0][j] = this.max(this.lookup[this.seq1[0]][this.seq2[j]] * 10, -this.gapOpen, -this.gapExtend);
            this.traceback[0][j] = 1;
            ++j;
        }
        int i = 1;
        while (i < n) {
            this.E[i][0] = -this.gapOpen;
            this.F[i][0] = this.max(this.score[i - 1][0] - this.gapOpen, this.F[i - 1][0] - this.gapExtend);
            this.score[i][0] = this.max(this.lookup[this.seq1[i]][this.seq2[0]] * 10, this.E[i][0], this.F[i][0]);
            this.traceback[i][0] = -1;
            ++i;
        }
        i = 1;
        while (i < n) {
            int j2 = 1;
            while (j2 < m) {
                this.E[i][j2] = this.max(this.score[i][j2 - 1] - this.gapOpen, this.E[i][j2 - 1] - this.gapExtend);
                this.F[i][j2] = this.max(this.score[i - 1][j2] - this.gapOpen, this.F[i - 1][j2] - this.gapExtend);
                this.score[i][j2] = this.max(this.score[i - 1][j2 - 1] + this.lookup[this.seq1[i]][this.seq2[j2]] * 10, this.E[i][j2], this.F[i][j2]);
                this.traceback[i][j2] = this.findTrace(i, j2);
                ++j2;
            }
            ++i;
        }
    }

    public static String extractChars(String chars, String seq2) {
        String out = seq2;
        int i = 0;
        while (i < chars.length()) {
            String gap = chars.substring(i, i + 1);
            out = AlignSeq.extractGaps(gap, out);
            ++i;
        }
        return out;
    }

    public static String extractGaps(String gapChar, String seq2) {
        StringTokenizer str = new StringTokenizer(seq2, gapChar);
        String newString = "";
        while (str.hasMoreTokens()) {
            newString = String.valueOf(newString) + str.nextToken();
        }
        return newString;
    }

    public int max(int i1, int i2, int i3) {
        int max = i1;
        if (i2 > i1) {
            max = i2;
        }
        if (i3 > max) {
            max = i3;
        }
        return max;
    }

    public int max(int i1, int i2) {
        int max = i1;
        if (i2 > i1) {
            max = i2;
        }
        return max;
    }

    public int[] stringToInt(String s, String type) {
        int[] seq1 = new int[s.length()];
        int i = 0;
        while (i < s.length()) {
            String ss = s.substring(i, i + 1).toUpperCase();
            try {
                if (type.equals("pep")) {
                    seq1[i] = (Integer)ResidueProperties.aaHash.get(ss);
                } else if (type.equals("dna")) {
                    seq1[i] = (Integer)dnaHash.get(ss);
                }
                if (seq1[i] > 23) {
                    seq1[i] = 23;
                }
            }
            catch (Exception exception) {
                seq1[i] = type.equals("dna") ? 4 : 23;
            }
            ++i;
        }
        return seq1;
    }

    public static void displayMatrix(Graphics g, int[][] mat, int n, int m, int psize) {
        int j;
        int max = -1000;
        int min = 1000;
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < m) {
                if (mat[i][j] >= max) {
                    max = mat[i][j];
                }
                if (mat[i][j] <= min) {
                    min = mat[i][j];
                }
                ++j;
            }
            ++i;
        }
        System.out.println(String.valueOf(max) + " " + min);
        i = 0;
        while (i < n) {
            j = 0;
            while (j < m) {
                int x = psize * i;
                int y = psize * j;
                float score = (float)(mat[i][j] - min) / (float)(max - min);
                g.setColor(new Color(score, 0.0f, 0.0f));
                g.fillRect(x, y, psize, psize);
                ++j;
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        try {
            int j;
            if (args.length != 3) {
                System.out.println("args: <msffile> <File|URL> <pep|dna>");
                System.exit(0);
            }
            MSFfile msf = new MSFfile(args[0], args[1]);
            Sequence[] s = new Sequence[msf.seqs.size()];
            int[][] scores = new int[msf.seqs.size()][msf.seqs.size()];
            int totscore = 0;
            int i = 0;
            while (i < msf.seqs.size()) {
                s[i] = (Sequence)msf.seqs.elementAt(i);
                ++i;
            }
            i = 1;
            while (i < 2) {
                j = 0;
                while (j < i) {
                    AlignSeq as = new AlignSeq(s[i], s[j], args[2]);
                    as.calcScoreMatrix();
                    as.traceAlignment();
                    as.printAlignment();
                    scores[i][j] = as.maxscore;
                    totscore += as.maxscore;
                    System.out.println(as.output);
                    Frame f = new Frame("Score matrix");
                    Panel p = new Panel();
                    p.setLayout(new BorderLayout());
                    ick ic = new ick(as);
                    p.add("Center", ic);
                    f.setLayout(new BorderLayout());
                    f.add("Center", p);
                    f.resize(500, 500);
                    f.show();
                    ++j;
                }
                ++i;
            }
            System.out.println();
            System.out.print("      ");
            i = 1;
            while (i < msf.seqs.size()) {
                Format.print(System.out, "%6d ", i);
                ++i;
            }
            System.out.println();
            i = 1;
            while (i < msf.seqs.size()) {
                Format.print(System.out, "%6d", i + 1);
                j = 0;
                while (j < i) {
                    Format.print(System.out, "%7.3f", (float)scores[i][j] / (float)totscore);
                    ++j;
                }
                System.out.println();
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Exception : " + e);
        }
    }
}

