/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableSequence;
import jalview.MSFfile;
import jalview.PCA;
import jalview.PCAPanel;
import jalview.ResidueProperties;
import jalview.Sequence;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.io.IOException;

public class BinarySequence
extends Sequence {
    int[] binary;
    double[] dbinary;

    public BinarySequence(Sequence s) {
        super(s);
    }

    public BinarySequence(String name, String sequence, int start, int end) {
        super(name, sequence, start, end);
    }

    public void encode() {
        this.dbinary = new double[this.getSequence().length() * 21];
        int nores = 21;
        int i = 0;
        while (i < this.dbinary.length) {
            this.dbinary[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.getSequence().length()) {
            int aanum = 20;
            try {
                aanum = (Integer)ResidueProperties.aaHash.get(this.getSequence().substring(i, i + 1));
            }
            catch (NullPointerException nullPointerException) {
                aanum = 20;
            }
            if (aanum > 20) {
                aanum = 20;
            }
            this.dbinary[i * nores + aanum] = 1.0;
            ++i;
        }
    }

    public void blosumEncode() {
        this.dbinary = new double[this.getSequence().length() * 21];
        int nores = 21;
        int i = 0;
        while (i < this.getSequence().length()) {
            int aanum = 20;
            try {
                aanum = (Integer)ResidueProperties.aaHash.get(this.getSequence().substring(i, i + 1));
            }
            catch (NullPointerException nullPointerException) {
                aanum = 20;
            }
            if (aanum > 20) {
                aanum = 20;
            }
            int j = 0;
            while (j < 20) {
                this.dbinary[i * nores + j] = ResidueProperties.BLOSUM62[aanum][j];
                ++j;
            }
            ++i;
        }
    }

    public String toBinaryString() {
        String out = "";
        int i = 0;
        while (i < this.binary.length) {
            out = String.valueOf(out) + new Integer(this.binary[i]).toString();
            if (i < this.binary.length - 1) {
                out = String.valueOf(out) + " ";
            }
            ++i;
        }
        return out;
    }

    public static void printMemory(Runtime rt) {
        System.out.println("Free memory = " + rt.freeMemory());
    }

    public static void main(String[] args) {
        long tstart = System.currentTimeMillis();
        Runtime rt = Runtime.getRuntime();
        BinarySequence.printMemory(rt);
        try {
            long tend = System.currentTimeMillis();
            System.out.println("Reading file " + (tend - tstart) + "ms");
            tstart = System.currentTimeMillis();
            MSFfile msf = new MSFfile(args[0], "File");
            tend = System.currentTimeMillis();
            System.out.println("done " + (tend - tstart) + "ms");
            System.out.println("Creating sequences");
            tstart = System.currentTimeMillis();
            Sequence[] s = new DrawableSequence[msf.seqs.size()];
            int i = 0;
            while (i < msf.seqs.size()) {
                s[i] = new DrawableSequence((Sequence)msf.seqs.elementAt(i));
                ++i;
            }
            tend = System.currentTimeMillis();
            System.out.println("done " + (tend - tstart) + "ms");
            System.out.println("Diagonalizing matrix");
            tstart = System.currentTimeMillis();
            PCA pca = new PCA(s);
            pca.run();
            tend = System.currentTimeMillis();
            System.out.println("done " + (tend - tstart) + "ms");
            System.out.println("Finding component coords");
            tstart = System.currentTimeMillis();
            double[][] comps = new double[msf.seqs.size()][msf.seqs.size()];
            int i2 = 0;
            while (i2 < msf.seqs.size()) {
                if (pca.eigenvector.d[i2] > 1.0E-4) {
                    comps[i2] = pca.component(i2);
                }
                ++i2;
            }
            tend = System.currentTimeMillis();
            System.out.println("done " + (tend - tstart) + "ms");
            System.out.println("Creating frame");
            tstart = System.currentTimeMillis();
            Frame f = new Frame();
            f.setLayout(new BorderLayout());
            PCAPanel p = new PCAPanel(f, pca, s);
            f.add("Center", p);
            f.resize(400, 400);
            AlignFrame af = new AlignFrame(p, (DrawableSequence[])s);
            af.resize(700, 300);
            af.show();
            f.show();
        }
        catch (IOException e) {
            System.out.println("IOException : " + e);
        }
    }
}

