/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;

public class CGI
implements Runnable {
    String server;
    Hashtable variables;
    PrintStream statout;
    int port;
    String location;
    URLConnection connection;
    PrintStream out;
    DataInputStream in;

    public CGI() {
    }

    public CGI(String server, int port, String location, Hashtable variables, PrintStream statout) {
        this.server = server;
        this.port = port;
        this.location = location;
        this.variables = variables;
        this.statout = statout;
    }

    public CGI(String server, int port, String location, PrintStream statout) {
        this.server = server;
        this.port = port;
        this.location = location;
        this.statout = statout;
    }

    public static boolean test(String server, int port) {
        try {
            Socket socket = new Socket(server, port);
            socket.setSoTimeout(5000);
        }
        catch (UnknownHostException e) {
            System.out.println(e);
            return false;
        }
        catch (SocketException e) {
            System.out.println("Socket Exception " + e);
            return false;
        }
        catch (InterruptedIOException e) {
            System.out.println("Read to server timed out " + e);
            return false;
        }
        catch (IOException e) {
            System.out.println("IOException " + e);
            return false;
        }
        return true;
    }

    public void run() {
        try {
            if (CGI.test(this.server, this.port)) {
                URL cgiServer = new URL("http://" + this.server + ":" + this.port + "/" + this.location);
                this.connection = cgiServer.openConnection();
                this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                this.statout.println("Connection is " + this.connection);
                this.connection.setDoOutput(true);
                this.statout.println("OS = " + System.getProperty("os.name"));
                this.out = new PrintStream(this.connection.getOutputStream());
                this.out.println("FORM=" + URLEncoder.encode("SERVERSELECT"));
                System.out.println("Printstream = " + this.out);
                Enumeration en = this.variables.keys();
                while (en.hasMoreElements()) {
                    String name = (String)en.nextElement();
                    String value = (String)this.variables.get(name);
                    System.out.println(name);
                    System.out.println(value);
                    this.out.println("&" + name + "=" + URLEncoder.encode(value) + "\n");
                }
                this.out.close();
                this.statout.println("Transferred data to server");
                this.statout.println("Waiting for output data...");
                this.in = new DataInputStream(this.connection.getInputStream());
                this.readInput(this.in);
            }
        }
        catch (MalformedURLException ex) {
            System.out.println("Exception " + ex);
        }
        catch (IOException ioex) {
            System.out.println("Exception " + ioex);
        }
    }

    public void readInput(DataInputStream in) {
        String aln = "";
        try {
            while ((aln = in.readLine()) != null) {
                this.statout.println(aln);
            }
        }
        catch (IOException ioex) {
            System.out.println("Exception " + ioex);
        }
    }
}

