/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import MCview.PDBChain;
import MCview.PDBfile;
import MCview.rotFrame;
import jalview.AlignFrame;
import jalview.AlignSeq;
import jalview.FeatureColourScheme;
import jalview.FormatAdapter;
import jalview.ResidueProperties;
import jalview.Sequence;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;

public class DrawableSequence
extends Sequence {
    int charHeight;
    boolean fastDraw;
    boolean displayBoxes;
    boolean displayText;
    boolean colourText;
    Vector textColour = new Vector();
    public Vector boxColour;
    Color color;
    Font font;
    String fontName;
    int fontSize;
    int fontStyle;
    int padx = 0;
    int pady = 2;
    PDBfile pdb;
    public int maxchain = -1;
    public int pdbstart;
    public int pdbend;
    public int seqstart;
    public int seqend;

    public DrawableSequence(Sequence s) {
        super(s);
        this.boxColour = new Vector(s.sequence.length());
        this.color = Color.white;
        this.displayBoxes = true;
        this.displayText = true;
        this.colourText = false;
        this.setFont("Dialog", 0, 14);
    }

    public DrawableSequence(String name, String sequence, int start, int end) {
        super(name, sequence, start, end);
        this.boxColour = new Vector(sequence.length());
        this.color = Color.white;
        this.displayBoxes = true;
        this.displayText = true;
        this.colourText = false;
        this.setFont("Dialog", 0, 14);
    }

    public void setPDBfile(PDBfile pdb) {
        this.pdb = pdb;
        int max = -10;
        this.maxchain = -1;
        int i = 0;
        while (i < pdb.chains.size()) {
            System.out.println("PDB sequence = " + ((PDBChain)pdb.chains.elementAt((int)i)).sequence);
            AlignSeq.extractGaps(".", this.sequence);
            AlignSeq.extractGaps("-", this.sequence);
            AlignSeq.extractGaps(" ", this.sequence);
            AlignSeq.extractGaps("~", this.sequence);
            AlignSeq as = new AlignSeq(this, ((PDBChain)pdb.chains.elementAt((int)i)).sequence, "pep");
            as.calcScoreMatrix();
            as.traceAlignment();
            as.printAlignment();
            System.out.println("Score = " + as.maxscore);
            if (as.maxscore > max) {
                System.out.println("New max score");
                max = as.maxscore;
                this.maxchain = i;
                this.pdbstart = as.seq2start;
                this.pdbend = as.seq2end;
                this.seqstart = as.seq1start + this.start - 1;
                this.seqend = as.seq1end + this.end - 1;
            }
            System.out.println(as.output);
            System.out.println("PDB start/end " + this.pdbstart + " " + this.pdbend);
            System.out.println("SEQ start/end " + this.seqstart + " " + this.seqend);
            ++i;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setFont(String name, int style, int size) {
        this.font = new Font(name, style, size);
        this.fontName = name;
        this.fontStyle = style;
        this.fontSize = size;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setResidueTextColour(int i, Color c) {
        if (this.textColour.size() <= i) {
            int j = this.textColour.size();
            while (j <= i) {
                this.textColour.addElement(null);
                ++j;
            }
        }
        this.textColour.setElementAt(c, i);
    }

    public void setResidueBoxColour(int i, Color c) {
        if (this.boxColour.size() <= i) {
            int j = this.boxColour.size();
            while (j <= i) {
                this.boxColour.addElement(null);
                ++j;
            }
        }
        this.boxColour.setElementAt(c, i);
    }

    public void drawSequence(Graphics g, int start, int end, int x1, int y1, int width, int height, boolean showScores) {
        this.padx = !this.font.getName().equals("Courier") ? 1 : 1;
        if (showScores) {
            this.showScores(g, start, end, x1, y1 + height / 2 + 1, width, height / 2 - 1, 0);
            if (this.displayBoxes) {
                this.drawBoxes(g, start, end, x1, y1, width, height / 2);
            }
            if (this.displayText) {
                if (this.colourText) {
                    this.drawColourText(g, start, end, x1, y1, width, height / 2);
                } else {
                    this.drawText(g, start, end, x1, y1, width, height / 2);
                }
            }
        } else {
            if (this.displayBoxes) {
                this.drawBoxes(g, start, end, x1, y1, width, height);
            }
            if (this.displayText) {
                if (this.colourText) {
                    this.drawColourText(g, start, end, x1, y1, width, height);
                } else {
                    this.drawText(g, start, end, x1, y1, width, height);
                }
            }
        }
    }

    public void showScores(Graphics g, int start, int end, int x1, int y1, int width, int height) {
        this.showScores(g, start, end, x1, y1, width, height, 0);
    }

    public void showScores(Graphics g, int start, int end, int x1, int y1, int width, int height, int num) {
        int i = start;
        while (i < end && i < this.getSequence().length() && this.score[num] != null && i < this.score[num].size()) {
            if (this.score[num].size() > 0 && ((Double)this.score[num].elementAt(i)).intValue() < 10) {
                g.setColor((Color)ResidueProperties.scaleColours.elementAt(((Double)this.score[num].elementAt(i)).intValue()));
                g.fillRect(x1 + width * (i - start), y1, width, height / 2);
            }
            ++i;
        }
    }

    public void drawBoxes(Graphics g, int start, int end, int x1, int y1, int width, int height) {
        int i = start;
        while (i < end && i < this.getSequence().length() && i < this.boxColour.size()) {
            if (this.boxColour.elementAt(i) != Color.white) {
                g.setColor((Color)this.boxColour.elementAt(i));
                g.fillRect(x1 + width * (i - start), y1, width, height);
            }
            ++i;
        }
    }

    public void drawText(Graphics g, int start, int end, int x1, int y1, int width, int height) {
        String s = "";
        if (start < this.getSequence().length()) {
            s = this.getSequence().length() > end ? this.getSequence().substring(start, end) : this.getSequence().substring(start);
            g.setColor(Color.black);
            if (this.fastDraw) {
                g.drawString(s, x1, y1 + height - this.pady);
            } else {
                int i = 0;
                while (i < s.length()) {
                    g.drawString(s.substring(i, i + 1), x1 + this.padx + i * width, y1 + height - this.pady);
                    ++i;
                }
            }
        }
    }

    public void drawColourText(Graphics g, int start, int end, int x1, int y1, int width, int height) {
        if (start < this.getSequence().length()) {
            int i = start;
            while (i < this.getSequence().length() && i < end && i < this.boxColour.size()) {
                String s = this.getSequence().substring(i, i + 1);
                g.setColor(((Color)this.boxColour.elementAt(i)).darker());
                if (this.fastDraw) {
                    g.drawString(s, x1 + width * (i - start), y1 + height - this.pady);
                } else {
                    g.drawString(s, x1 + width * (i - start) + this.padx, y1 + height - this.pady);
                }
                ++i;
            }
        }
    }

    public synchronized void insertCharAt(int i, char c) {
        super.insertCharAt(i, c);
        int j = this.boxColour.size();
        while (j < i) {
            this.boxColour.addElement(Color.white);
            ++j;
        }
        this.boxColour.insertElementAt(Color.white, i);
    }

    public void deleteCharAt(int i) {
        super.deleteCharAt(i);
        if (this.boxColour.size() > i) {
            this.boxColour.removeElementAt(i);
        }
    }

    public static void main(String[] args) {
        try {
            DrawableSequence[] s = null;
            s = FormatAdapter.toDrawableSequence(FormatAdapter.read("http://srs.ebi.ac.uk/srs5bin/cgi-bin/wgetz?-e+-f+seq+-sf+fasta+[swissprot-id:" + args[0] + "]", "URL", "FASTA"));
            s[0].sequence = s[0].sequence.substring(0, s[0].sequence.indexOf("</PRE>"));
            DrawableSequence seq2 = s[0];
            seq2.getFeatures("srs.ebi.ac.uk/srs5bin/cgi-bin/", "swall");
            FeatureColourScheme ftcs = new FeatureColourScheme();
            ftcs.setColours(seq2);
            if (seq2.pdbcode.size() > 0) {
                PDBfile pdb = new PDBfile("http://srs.ebi.ac.uk/srs5bin/cgi-bin/wgetz?-e+[pdb-id:" + seq2.pdbcode.elementAt(0) + "]", "URL");
                seq2.setPDBfile(pdb);
                System.out.println("Max chain " + seq2.maxchain);
                ((PDBChain)pdb.chains.elementAt((int)seq2.maxchain)).isVisible = true;
                ((PDBChain)pdb.chains.elementAt((int)seq2.maxchain)).ds = seq2;
                ((PDBChain)pdb.chains.elementAt(seq2.maxchain)).colourBySequence();
                rotFrame f = new rotFrame(pdb);
                f.resize(500, 500);
                f.show();
                DrawableSequence[] s1 = new DrawableSequence[]{seq2, new DrawableSequence(((PDBChain)pdb.chains.elementAt((int)seq2.maxchain)).sequence)};
                AlignFrame af = new AlignFrame(null, s1);
                af.resize(700, 300);
                af.show();
            } else {
                System.out.println("No pdb code found");
            }
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(0);
        }
    }
}

