/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ColourAdapter;
import jalview.ColourProperties;
import jalview.DrawableAlignment;
import jalview.Popup;
import jalview.ResidueColourScheme;
import jalview.Sequence;
import jalview.SequenceGroup;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.io.PrintStream;
import java.util.Vector;

public class GroupPopup
extends Popup {
    PrintStream o = System.out;
    List groupList;
    Label groupLabel;
    List memberList;
    Label memberLabel;
    List ungroupedList;
    Label ungroupedLabel;
    Button add;
    Button del;
    Button addAll;
    Button delAll;
    Label groupProperties;
    Choice colourScheme;
    Label colourSchemeLabel;
    Checkbox boxes;
    Checkbox text;
    Checkbox colourText;
    Checkbox display;
    Button addGroup;
    Button delGroup;
    Button addSelected;
    DrawableAlignment da;

    public GroupPopup(Frame parent, String title, DrawableAlignment da) {
        super(parent, title);
        this.da = da;
        this.groupList = new List(9, false);
        this.groupLabel = new Label("Groups");
        this.memberList = new List(9, false);
        this.memberList.setMultipleSelections(true);
        this.memberLabel = new Label("Group members");
        this.ungroupedList = new List(9, false);
        this.ungroupedList.setMultipleSelections(true);
        this.ungroupedLabel = new Label("Ungrouped sequences");
        this.add = new Button("<- Add");
        this.del = new Button("Delete ->");
        this.addAll = new Button("<- Add all");
        this.delAll = new Button("Delete all ->");
        this.groupProperties = new Label("Group properties");
        this.colourScheme = new Choice();
        int i = 0;
        while (i < ColourProperties.colourSchemes.size()) {
            this.colourScheme.addItem((String)ColourProperties.colourSchemes.elementAt(i));
            ++i;
        }
        this.colourSchemeLabel = new Label("Colour scheme");
        this.boxes = new Checkbox("Display boxes");
        this.boxes.setState(true);
        this.text = new Checkbox("Display text");
        this.text.setState(true);
        this.colourText = new Checkbox("Colour text");
        this.colourText.setState(false);
        this.display = new Checkbox("Display group");
        this.display.setState(true);
        this.addGroup = new Button("Add new group");
        this.delGroup = new Button("Delete selected group");
        this.addSelected = new Button("Add selected IDs");
        Panel listp = new Panel();
        listp.setLayout(new GridLayout(1, 4, 10, 5));
        Panel adddel = new Panel();
        adddel.setLayout(new GridLayout(4, 1, 5, 5));
        Panel props = new Panel();
        props.setLayout(new GridLayout(6, 1, 5, 5));
        Panel gprops = new Panel();
        gprops.setLayout(new GridLayout(3, 1, 5, 5));
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(2, 2, 2, 2);
        listp.add(this.groupList);
        listp.add(this.memberList);
        adddel.add(this.add);
        adddel.add(this.del);
        adddel.add(this.addAll);
        adddel.add(this.delAll);
        listp.add(adddel);
        listp.add(this.ungroupedList);
        props.add(this.groupProperties);
        props.add(this.colourScheme);
        props.add(this.boxes);
        props.add(this.text);
        props.add(this.colourText);
        gprops.add(this.addGroup);
        gprops.add(this.delGroup);
        gprops.add(this.addSelected);
        this.add(listp, this.gb, this.gbc, 0, 0, 2, 3);
        this.add(props, this.gb, this.gbc, 0, 3, 1, 1);
        this.add(gprops, this.gb, this.gbc, 1, 3, 1, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 4, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 4, 1, 1);
        this.pack();
        this.show();
        this.listGroups();
        this.showUngrouped();
    }

    public void listGroups() {
        if (this.groupList.countItems() > 0) {
            this.groupList.clear();
        }
        Vector g = this.da.groups;
        int i = 0;
        while (i < g.size()) {
            SequenceGroup sg = (SequenceGroup)g.elementAt(i);
            this.groupList.addItem(String.valueOf(i) + " (" + sg.sequences.size() + " sequences)");
            ++i;
        }
    }

    public void showUngrouped() {
        if (this.ungroupedList.countItems() > 0) {
            this.ungroupedList.clear();
        }
        int i = 0;
        while (i < this.da.size) {
            Sequence s = this.da.sequences[i];
            if (this.da.findGroup(s) == null) {
                this.ungroupedList.addItem(s.name);
            }
            ++i;
        }
    }

    public void showGroup(SequenceGroup sg) {
        if (this.memberList.countItems() > 0) {
            this.memberList.clear();
        }
        int j = 0;
        while (j < sg.sequences.size()) {
            Sequence s = (Sequence)sg.sequences.elementAt(j);
            this.memberList.addItem(s.name);
            ++j;
        }
        this.displayProperties(sg);
    }

    public void setProperties(SequenceGroup sg) {
        int schemeno = this.colourScheme.getSelectedIndex();
        sg.colourScheme = ColourAdapter.get(schemeno);
        if (sg.colourScheme instanceof ResidueColourScheme) {
            System.out.println("setting consensus to " + this.da.cons);
            ((ResidueColourScheme)sg.colourScheme).cons = this.da.cons;
        }
        this.da.setColourScheme(sg);
        sg.displayBoxes = this.boxes.getState();
        sg.displayText = this.text.getState();
        sg.colourText = this.colourText.getState();
        this.da.displayBoxes(sg);
        this.da.displayText(sg);
        this.da.colourText(sg);
    }

    public void displayProperties(SequenceGroup sg) {
        int num = ColourAdapter.get(sg.colourScheme);
        String name = (String)ColourProperties.colourSchemes.elementAt(num);
        this.colourScheme.select(name);
        this.boxes.setState(sg.displayBoxes);
        this.text.setState(sg.displayText);
        this.colourText.setState(sg.colourText);
    }

    public boolean handleEvent(Event e) {
        if (e.target == this.groupList && e.id == 701) {
            System.out.println(e);
            Vector g = this.da.groups;
            if (this.groupList.getSelectedIndex() >= 0) {
                this.showGroup((SequenceGroup)g.elementAt(this.groupList.getSelectedIndex()));
            }
            return true;
        }
        if (e.target == this.addGroup && e.id == 1001) {
            SequenceGroup sg = this.da.addGroup();
            this.setProperties(sg);
            this.da.setColourScheme(sg);
            this.listGroups();
            this.groupList.select(this.da.groups.size() - 1);
            if (this.memberList.countItems() > 0) {
                this.memberList.clear();
            }
            return true;
        }
        if (e.target == this.delGroup && e.id == 1001) {
            this.delGroup.requestFocus();
            int i = this.groupList.getSelectedIndex();
            if (i >= 0) {
                this.da.deleteGroup((SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex()));
                this.listGroups();
                if (this.memberList.countItems() > 0) {
                    this.memberList.clear();
                }
                this.showUngrouped();
            }
            return true;
        }
        if (e.target == this.add && e.id == 1001) {
            this.add.requestFocus();
            int sel = this.groupList.getSelectedIndex();
            if (sel >= 0) {
                SequenceGroup sg = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                String[] selseqs = this.ungroupedList.getSelectedItems();
                int i = 0;
                while (i < selseqs.length) {
                    this.da.addToGroup(sg, this.da.findName(selseqs[i]));
                    ++i;
                }
                this.listGroups();
                this.groupList.select(sel);
                this.showGroup(sg);
                this.showUngrouped();
            }
            return true;
        }
        if (e.target == this.addAll && e.id == 1001) {
            this.addAll.requestFocus();
            int sel = this.groupList.getSelectedIndex();
            if (sel >= 0) {
                SequenceGroup sg = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                int i = 0;
                while (i < this.ungroupedList.countItems()) {
                    this.da.addToGroup(sg, this.da.findName(this.ungroupedList.getItem(i)));
                    ++i;
                }
                this.listGroups();
                this.groupList.select(sel);
                this.showGroup(sg);
                this.showUngrouped();
            }
            return true;
        }
        if (e.target == this.delAll && e.id == 1001) {
            this.delAll.requestFocus();
            int sel = this.groupList.getSelectedIndex();
            if (sel >= 0) {
                SequenceGroup sg = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                int i = 0;
                while (i < this.memberList.countItems()) {
                    this.da.removeFromGroup(sg, this.da.findName(this.memberList.getItem(i)));
                    ++i;
                }
                this.listGroups();
                this.groupList.select(sel);
                this.showGroup(sg);
                this.showUngrouped();
            }
            return true;
        }
        if (e.target == this.del && e.id == 1001) {
            this.del.requestFocus();
            int sel = this.groupList.getSelectedIndex();
            if (sel >= 0) {
                SequenceGroup sg = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                if (this.memberList.getSelectedItems() != null) {
                    String[] selseqs = this.memberList.getSelectedItems();
                    int i = 0;
                    while (i < selseqs.length) {
                        this.da.removeFromGroup(sg, this.da.findName(selseqs[i]));
                        ++i;
                    }
                }
                this.listGroups();
                this.groupList.select(sel);
                this.showGroup(sg);
                this.showUngrouped();
            }
            return true;
        }
        if (e.target == this.addSelected && e.id == 1001) {
            int sel;
            this.addSelected.requestFocus();
            if (this.parent instanceof AlignFrame && (sel = this.groupList.getSelectedIndex()) >= 0) {
                SequenceGroup sg = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                Vector selseqs = ((AlignFrame)this.parent).ap.sel;
                int i = 0;
                while (i < selseqs.size()) {
                    SequenceGroup found = this.da.findGroup((Sequence)selseqs.elementAt(i));
                    this.da.removeFromGroup(found, (Sequence)selseqs.elementAt(i));
                    if (found.sequences.size() == 0) {
                        this.da.groups.removeElement(found);
                    }
                    this.da.addToGroup(sg, (Sequence)selseqs.elementAt(i));
                    ++i;
                }
                this.listGroups();
                this.groupList.select(sel);
                this.showGroup(sg);
                this.showUngrouped();
            }
            return true;
        }
        if (e.target == this.boxes) {
            int sel = this.groupList.getSelectedIndex();
            if (sel >= 0) {
                SequenceGroup sg = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                sg.displayBoxes = this.boxes.getState();
                this.da.displayBoxes(sg);
            }
            return true;
        }
        if (e.target == this.text) {
            int sel = this.groupList.getSelectedIndex();
            if (sel >= 0) {
                SequenceGroup sg = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                sg.displayText = this.text.getState();
                this.da.displayText(sg);
            }
            return true;
        }
        if (e.target == this.colourText) {
            int sel = this.groupList.getSelectedIndex();
            if (sel >= 0) {
                SequenceGroup sg = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                sg.colourText = this.colourText.getState();
                this.da.colourText(sg);
            }
            return true;
        }
        if (e.target == this.colourScheme) {
            int sel = this.groupList.getSelectedIndex();
            if (sel >= 0) {
                SequenceGroup sg = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                int schemeno = this.colourScheme.getSelectedIndex();
                sg.colourScheme = ColourAdapter.get(schemeno);
                if (sg.colourScheme instanceof ResidueColourScheme) {
                    System.out.println("setting consensus to " + this.da.cons);
                    ((ResidueColourScheme)sg.colourScheme).cons = this.da.cons;
                }
                this.da.setColourScheme(sg);
            }
            return true;
        }
        if (e.target == this.apply && e.id == 1001) {
            this.applyCommand();
        } else {
            super.handleEvent(e);
        }
        return super.handleEvent(e);
    }

    public void applyCommand() {
        if (this.parent instanceof AlignFrame) {
            AlignFrame cfr_ignored_0 = (AlignFrame)this.parent;
            ((AlignFrame)this.parent).updateFont();
        }
    }
}

