/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.AlignmentPanel;
import jalview.DrawableSequence;
import jalview.IdCanvas;
import jalview.PCAPanel;
import jalview.QuickSort;
import jalview.SimpleBrowser;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Panel;
import java.net.URL;

public class IdPanel
extends Panel {
    protected AlignmentPanel alignPanel;
    public IdCanvas idCanvas;
    protected int offy;
    public int width;
    public int lastid;

    public IdPanel(AlignmentPanel alignPanel) {
        this.alignPanel = alignPanel;
        this.componentInit();
    }

    private void componentInit() {
        this.idCanvas = new IdCanvas(this);
        this.setLayout(new BorderLayout());
        this.add("Center", this.idCanvas);
    }

    public Dimension minimumSize() {
        return new Dimension(100, 500);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public boolean keyDown(Event evt, int key) {
        this.requestFocus();
        AlignFrame af = null;
        AlignmentPanel ap = this.alignPanel;
        if (ap.parent instanceof AlignFrame) {
            af = (AlignFrame)ap.parent;
        }
        if (ap.sel.size() > 0) {
            int i;
            int j;
            Object[] tmps = new DrawableSequence[ap.sel.size()];
            float[] ind = new float[tmps.length];
            if (key == 1004) {
                j = 0;
                while (j < tmps.length) {
                    tmps[j] = (DrawableSequence)ap.sel.elementAt(j);
                    i = 0;
                    while (i < ap.seqPanel.align.ds.length && ap.seqPanel.align.ds[i] != null) {
                        if (ap.seqPanel.align.ds[i] == (DrawableSequence)ap.sel.elementAt(j)) {
                            ind[j] = i;
                            break;
                        }
                        ++i;
                    }
                    ++j;
                }
            } else if (key == 1005) {
                j = 0;
                while (j < tmps.length) {
                    tmps[j] = (DrawableSequence)ap.sel.elementAt(j);
                    i = 0;
                    while (i < ap.seqPanel.align.ds.length && ap.seqPanel.align.ds[i] != null) {
                        if (ap.seqPanel.align.ds[i] == (DrawableSequence)ap.sel.elementAt(j)) {
                            ind[j] = tmps.length - i;
                            break;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
            QuickSort.sort(ind, tmps);
            int ii = 0;
            while (ii < tmps.length) {
                Object ds = tmps[ii];
                int i2 = 0;
                int fid = -1;
                boolean found = false;
                while (i2 < ap.seqPanel.align.ds.length && ap.seqPanel.align.ds[i2] != null) {
                    if (ap.seqPanel.align.ds[i2] == ds) {
                        found = true;
                        fid = i2;
                    }
                    ++i2;
                }
                if (found) {
                    DrawableSequence tmp;
                    if (key == 1004 && fid > 0) {
                        if (!ap.sel.contains(ap.seqPanel.align.ds[fid - 1])) {
                            tmp = ap.seqPanel.align.ds[fid - 1];
                            ap.seqPanel.align.ds[fid - 1] = ap.seqPanel.align.ds[fid];
                            ap.seqPanel.align.ds[fid] = tmp;
                            if (af != null) {
                                af.status.setText("Moved " + ap.seqPanel.align.ds[fid - 1].name);
                                af.status.validate();
                            }
                        }
                    } else if (key == 1005 && fid + 1 < ap.seqPanel.align.ds.length && ap.seqPanel.align.ds[fid + 1] != null && !ap.sel.contains(ap.seqPanel.align.ds[fid + 1])) {
                        tmp = ap.seqPanel.align.ds[fid + 1];
                        ap.seqPanel.align.ds[fid + 1] = ap.seqPanel.align.ds[fid];
                        ap.seqPanel.align.ds[fid] = tmp;
                        if (af != null) {
                            af.status.setText("Moved " + af.ap.seqPanel.align.ds[fid + 1].name);
                            af.status.validate();
                        }
                    }
                } else {
                    System.out.println("ID not found");
                }
                ++ii;
            }
        } else {
            af.status.setText("ERROR: no sequence(s) selected");
        }
        if (af != null) {
            af.updateFont();
        } else {
            ap.idPanel.idCanvas.paintFlag = true;
            ap.idPanel.idCanvas.repaint();
            ap.seqPanel.seqCanvas.paintFlag = true;
            ap.seqPanel.seqCanvas.repaint();
        }
        return true;
    }

    public boolean mouseDrag(Event e, int x, int y) {
        try {
            int seq2 = y / this.alignPanel.seqPanel.seqCanvas.charHeight + this.alignPanel.seqPanel.seqCanvas.starty;
            if (seq2 != this.lastid && this.alignPanel.parent instanceof AlignFrame) {
                AlignFrame af = (AlignFrame)this.alignPanel.parent;
                af.status.setText("Sequence ID : " + this.alignPanel.seqPanel.align.sequences[seq2].getName() + " (" + seq2 + ")");
                if (af.ap.sel.contains(this.alignPanel.seqPanel.align.sequences[seq2])) {
                    System.out.println("Selected " + seq2);
                    af.ap.sel.removeElement(this.alignPanel.seqPanel.align.sequences[seq2]);
                    if (af.pca != null) {
                        PCAPanel pca = af.pca.p;
                        pca.rc.redrawneeded = true;
                        pca.rc.repaint();
                    }
                    if (af.tt != null) {
                        af.tt.tf.p.mc.repaint();
                    }
                } else {
                    af.ap.sel.addElement(this.alignPanel.seqPanel.align.sequences[seq2]);
                    if (af.pca != null) {
                        PCAPanel pca = af.pca.p;
                        pca.rc.redrawneeded = true;
                        pca.rc.repaint();
                    }
                    if (af.tt != null) {
                        af.tt.tf.p.mc.repaint();
                    }
                }
                af.ap.idPanel.idCanvas.paintFlag = true;
                af.ap.idPanel.idCanvas.repaint();
            }
            this.lastid = seq2;
        }
        catch (Exception exception) {}
        return true;
    }

    public boolean mouseDown(Event e, int x, int y) {
        block22: {
            AlignFrame af = null;
            AlignmentPanel ap = this.alignPanel;
            if (ap.parent instanceof AlignFrame) {
                af = (AlignFrame)ap.parent;
            }
            int seq2 = this.alignPanel.seqPanel.seqCanvas.getIndex(y);
            System.out.println("Y = " + y + " " + seq2 + " " + ap.seqPanel.align.ds[seq2].name);
            try {
                if ((e.modifiers & 4) != 0) {
                    try {
                        String id = ap.seqPanel.align.ds[seq2].getName();
                        if (id.indexOf("/") != -1) {
                            id = id.substring(0, id.indexOf("/"));
                        }
                        URL u = new URL("http://" + af.srsServer + "wgetz?-e+[" + af.database + "-id:" + id + "]");
                        if (af != null && af.parent instanceof Applet) {
                            Applet app = (Applet)af.parent;
                            app.getAppletContext().showDocument(u, "entry");
                        } else if (af != null && af.browser != null) {
                            if (af.browser.bf != null) {
                                System.out.println("browser exists");
                                af.browser.bf.tf.setText(u.toString());
                                af.browser.pages.addElement(u.toString());
                                af.browser.position = af.browser.pages.size() - 1;
                                if (af.browser.pages.size() > 1) {
                                    af.browser.bf.back.enable();
                                }
                                af.browser.connect(af.browser.split(u.toString()));
                            } else {
                                System.out.println("browser null");
                                af.browser = new SimpleBrowser(u.toString());
                            }
                        } else if (af != null) {
                            af.browser = new SimpleBrowser(u.toString());
                        }
                        break block22;
                    }
                    catch (Exception ex) {
                        System.out.println("Exception : " + ex);
                    }
                    break block22;
                }
                this.lastid = seq2;
                if (af != null) {
                    af.status.setText("Sequence ID : " + this.alignPanel.seqPanel.align.ds[seq2].getName() + " (" + seq2 + ")");
                }
                if (ap.sel.contains(this.alignPanel.seqPanel.align.ds[seq2])) {
                    ap.sel.removeElement(this.alignPanel.seqPanel.align.ds[seq2]);
                    if (af != null && af.pca != null) {
                        PCAPanel pca = af.pca.p;
                        pca.rc.redrawneeded = true;
                        pca.rc.repaint();
                    }
                    if (af != null && af.tt != null) {
                        af.tt.tf.p.mc.repaint();
                    }
                } else {
                    ap.sel.addElement(this.alignPanel.seqPanel.align.ds[seq2]);
                    if (af != null && af.pca != null) {
                        PCAPanel pca = af.pca.p;
                        pca.rc.redrawneeded = true;
                        pca.rc.repaint();
                    }
                    if (af != null && af.tt != null) {
                        af.tt.tf.p.mc.repaint();
                    }
                }
                ap.idPanel.idCanvas.paintFlag = true;
                ap.idPanel.idCanvas.repaint();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public boolean mouseUp(Event e, int x, int y) {
        if (this.alignPanel.seqPanel.seqCanvas.colourSelected) {
            this.alignPanel.seqPanel.seqCanvas.paintFlag = true;
            this.alignPanel.seqPanel.seqCanvas.repaint();
        }
        return true;
    }
}

