/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.Popup;
import jalview.Sequence;
import jalview.ThresholdPanel;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;
import java.util.Vector;

public class RedundancyPopup
extends Popup {
    ThresholdPanel tp;

    public RedundancyPopup(Frame parent, String title, String label, int low, int high, int value) {
        super(parent, title);
        this.tp = new ThresholdPanel(parent, label, low, high, value);
        this.status.setText("Enter the redundancy threshold");
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.tp, this.gb, this.gbc, 0, 0, 2, 1);
        this.add(this.status, this.gb, this.gbc, 0, 1, 2, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 2, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 2, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event e) {
        if (e.target == this.apply && e.id == 1001) {
            int threshold = 0;
            try {
                threshold = Integer.valueOf(this.tp.tf.getText());
            }
            catch (Exception exception) {
                threshold = this.tp.sb.getValue();
                this.tp.tf.setText(new Integer(threshold).toString());
            }
            System.out.println("Threshold = " + threshold);
            System.out.println(this.parent);
            if (this.parent instanceof AlignFrame) {
                AlignFrame af = (AlignFrame)this.parent;
                af.status.setText("Removing redundancy...");
                af.status.validate();
                if (af.ap.sel != null && af.ap.sel.size() != 0) {
                    System.out.println("Sel = " + af.ap.sel);
                    if (af.ap.sel.size() == 1) {
                        af.status.setText("ERROR: Only one sequence selected");
                        af.status.validate();
                    } else {
                        this.status.setText("Removing redundancy for " + af.ap.sel.size() + " sequences");
                        Vector del = af.ap.seqPanel.align.removeRedundancy(threshold, af.ap.sel);
                        int i = 0;
                        while (i < del.size()) {
                            if (af.ap.sel.contains(del.elementAt(i))) {
                                af.ap.sel.removeElement(del.elementAt(i));
                            }
                            ++i;
                        }
                    }
                } else {
                    System.out.println("Creating vector");
                    Vector<Sequence> s = new Vector<Sequence>();
                    int i = 0;
                    while (i < af.ap.seqPanel.align.sequences.length && af.ap.seqPanel.align.sequences[i] != null) {
                        s.addElement(af.ap.seqPanel.align.sequences[i]);
                        ++i;
                    }
                    System.out.println("Removing redundancy for " + s.size() + " sequences");
                    Vector del = af.ap.seqPanel.align.removeRedundancy(threshold, s);
                    int j = 0;
                    while (j < del.size()) {
                        af.status.setText("Removing sequence " + ((Sequence)del.elementAt(j)).getName());
                        af.status.validate();
                        if (af.ap.sel.contains(del.elementAt(j))) {
                            af.ap.sel.removeElement(del.elementAt(j));
                        }
                        ++j;
                    }
                }
                af.status.setText("Done");
                af.updateFont();
            }
            return true;
        }
        if (e.target == this.close && e.id == 1001) {
            this.hide();
            this.dispose();
            return true;
        }
        return super.handleEvent(e);
    }
}

