/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.DrawableSequence;
import jalview.Sequence;
import java.awt.Color;
import java.awt.Graphics;

public class ScoreSequence
extends DrawableSequence {
    double max;
    double min;
    int scoreno = 0;
    int red = 255;
    int green = 255;
    int blue = 255;
    Color c;

    public ScoreSequence(Sequence s, int num, int red, int green, int blue) {
        super(s);
        this.scoreno = num;
        this.findMaxMin();
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.c = new Color(red, green, blue);
    }

    public ScoreSequence(Sequence s, int num) {
        this(s, num, 1, 1, 1);
    }

    public ScoreSequence(Sequence s) {
        this(s, 0, 1, 1, 1);
    }

    public ScoreSequence(String name, String sequence, int start, int end) {
        super(name, sequence, start, end);
        this.scoreno = 0;
        this.findMaxMin();
    }

    public void findMaxMin() {
        int i = 0;
        this.max = -10000.0;
        this.min = 10000.0;
        while (this.score[this.scoreno] != null && i < this.score[this.scoreno].size()) {
            double s = (Double)this.score[this.scoreno].elementAt(i);
            if (s > this.max) {
                this.max = s;
            }
            if (s < this.min) {
                this.min = s;
            }
            ++i;
        }
        System.out.println("Score max/min " + this.max + " " + this.min);
    }

    public void drawSequence(Graphics g, int start, int end, int x1, int y1, int width, int height, boolean showScores) {
        this.drawScores(g, start, end, x1, y1, width, height);
    }

    public void drawScores(Graphics g, int start, int end, int x1, int y1, int width, int height) {
        int i = start;
        while (i < end && i < this.score[this.scoreno].size()) {
            double s1 = (Double)this.score[this.scoreno].elementAt(i);
            double yd1 = (s1 - this.min) / (this.max - this.min);
            int yy1 = (int)(yd1 * (double)height);
            if (this.c != Color.white) {
                g.setColor(this.c);
                g.fillRect(x1 + (i - start) * width, y1 + height - yy1, width, yy1);
            }
            ++i;
        }
    }
}

