/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import MCview.Bond;
import MCview.PDBChain;
import jalview.AlignFrame;
import jalview.AlignmentPanel;
import jalview.BigPanel;
import jalview.Blosum62ColourScheme;
import jalview.ClustalxColourScheme;
import jalview.DrawableAlignment;
import jalview.DrawableSequence;
import jalview.FeatureFrame;
import jalview.MSFfile;
import jalview.PIDColourScheme;
import jalview.ResidueColourScheme;
import jalview.SeqCanvas;
import jalview.Sequence;
import jalview.SequenceFeature;
import jalview.SequenceGroup;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.io.IOException;

public class SeqPanel
extends Panel {
    protected AlignmentPanel alignPanel;
    public SeqCanvas seqCanvas;
    protected Scrollbar hscroll;
    protected Scrollbar vscroll;
    public DrawableAlignment align;
    protected int offx;
    protected int offy;
    protected int maxoffx = 0;
    protected int maxoffy = 0;
    protected int startres;
    protected int lastres;
    protected int endres;
    protected long lasttime;
    protected int startseq;
    protected int padseq;
    public boolean fastDraw;
    public boolean editFlag;

    public SeqPanel(AlignmentPanel alignPanel, DrawableSequence[] sequences) {
        this.alignPanel = alignPanel;
        this.align = new DrawableAlignment(sequences);
        System.out.println("Maximum sequence length = " + this.align.maxLength);
        System.out.println("No sequences  = " + this.align.size);
        this.setFastDraw(true);
        this.componentInit();
    }

    public void setFastDraw(boolean fd) {
        this.fastDraw = fd;
        int i = 0;
        while (i < this.align.ds.length && this.align.ds[i] != null) {
            this.align.ds[i].fastDraw = fd;
            ++i;
        }
    }

    private void componentInit() {
        this.seqCanvas = new SeqCanvas(this);
        this.hscroll = new Scrollbar(0);
        this.vscroll = new Scrollbar(1);
        this.setLayout(new BorderLayout());
        this.add("Center", this.seqCanvas);
        this.add("East", this.vscroll);
        this.add("South", this.hscroll);
        this.setScrollValues(0, 0);
        System.out.println("SeqPanel initialized");
    }

    public void setScrollValues(int offx, int offy) {
        int height;
        int width;
        System.getProperty("java.version");
        if (this.seqCanvas.size().width > 0) {
            width = this.seqCanvas.size().width;
            height = this.seqCanvas.size().height;
        } else {
            width = this.seqCanvas.preferredSize().width;
            height = this.seqCanvas.preferredSize().height;
        }
        if (this.maxoffx != this.align.maxLength + 1) {
            this.maxoffx = this.align.maxLength + 1;
        }
        if (this.maxoffy != this.align.size + 1) {
            this.maxoffy = this.align.size + 1;
        }
        this.hscroll.setValues(offx, width / this.seqCanvas.charWidth, 0, this.maxoffx);
        this.vscroll.setValues(offy, height / this.seqCanvas.charHeight, 0, this.maxoffy);
        this.hscroll.setLineIncrement(1);
        this.vscroll.setLineIncrement(1);
        if (this.seqCanvas.endx > 0) {
            this.hscroll.setPageIncrement((this.seqCanvas.endx - this.seqCanvas.startx) / 2);
            if (this.seqCanvas.endy - this.seqCanvas.starty > 2) {
                this.vscroll.setPageIncrement((this.seqCanvas.endy - this.seqCanvas.starty) / 2);
            }
        }
    }

    public boolean handleEvent(Event evt) {
        switch (evt.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                if (evt.target == this.hscroll) {
                    this.offx = this.hscroll.getValue();
                    this.alignPanel.scalePanel.scaleCanvas.paintFlag = true;
                    this.seqCanvas.repaint();
                    this.alignPanel.scalePanel.scaleCanvas.repaint();
                    return true;
                }
                if (evt.target != this.vscroll) break;
                this.offy = this.vscroll.getValue();
                this.alignPanel.idPanel.idCanvas.paintFlag = true;
                this.seqCanvas.repaint();
                this.alignPanel.idPanel.idCanvas.repaint();
                return true;
            }
        }
        return super.handleEvent(evt);
    }

    public boolean mouseUp(Event evt, int x, int y) {
        if (this.editFlag && this.align.autoConsensus) {
            System.out.println("Auto consensus");
            this.align.percentIdentity();
            BigPanel bp = ((AlignFrame)this.alignPanel.parent).bp;
            if (bp.scorePanel != null) {
                bp.scorePanel.seqPanel.align.ds[0] = this.align.qualityScore;
            }
            boolean redraw = false;
            int j = 0;
            while (j < this.align.groups.size()) {
                SequenceGroup sg = (SequenceGroup)this.align.groups.elementAt(j);
                if (sg.colourScheme instanceof ClustalxColourScheme) {
                    redraw = true;
                    ((ClustalxColourScheme)sg.colourScheme).cons2 = this.align.cons2;
                    sg.colourScheme.setColours(sg);
                } else if (sg.colourScheme instanceof PIDColourScheme) {
                    sg.colourScheme = new PIDColourScheme(this.align.cons);
                    sg.colourScheme.setColours(sg);
                    redraw = true;
                } else if (sg.colourScheme instanceof Blosum62ColourScheme) {
                    ((Blosum62ColourScheme)sg.colourScheme).cons = this.align.cons;
                    sg.colourScheme.setColours(sg);
                    redraw = true;
                } else if (sg.colourScheme instanceof ResidueColourScheme) {
                    ((ResidueColourScheme)sg.colourScheme).cons = this.align.cons;
                    redraw = true;
                    if (((ResidueColourScheme)sg.colourScheme).colourThreshold > 0) {
                        sg.colourScheme.setColours(sg);
                    }
                }
                ++j;
            }
            if (bp.scorePanel != null) {
                bp.scorePanel.seqPanel.seqCanvas.paintFlag = true;
                bp.scorePanel.seqPanel.seqCanvas.repaint();
            }
            if (redraw) {
                this.seqCanvas.paintFlag = true;
                this.seqCanvas.repaint();
            }
        }
        try {
            int res = x / this.seqCanvas.charWidth + this.seqCanvas.startx;
            int seq2 = this.seqCanvas.getIndex(y);
            System.out.println("Y = " + y + " " + seq2 + " " + this.align.ds[seq2].name);
            this.align.ds[seq2].charAt(res);
            this.endres = res;
            int pos = this.align.ds[seq2].findPosition(res);
            if (this.alignPanel.parent instanceof AlignFrame && !this.editFlag) {
                AlignFrame af = (AlignFrame)this.alignPanel.parent;
                if (this.align.ds[seq2].features != null && this.align.ds[seq2].features.size() > 0) {
                    SequenceFeature sf;
                    String tmp = "";
                    tmp = String.valueOf(tmp) + "No of features for " + this.align.ds[seq2].name + " = " + this.align.ds[seq2].features.size() + "\n\n";
                    tmp = String.valueOf(tmp) + "------------------------------------------------\n";
                    tmp = String.valueOf(tmp) + "Selected features for residue " + pos + " (" + res + " in alignment) : \n\n";
                    if (af.ff == null) {
                        af.ff = new FeatureFrame(af, "Sequence feature console", 15, 72, "");
                        af.ff.setTextFont(new Font("Courier", 0, 12));
                        af.ff.resize(500, 400);
                        af.ff.show();
                    }
                    int i = 0;
                    while (i < this.align.ds[seq2].features.size()) {
                        sf = (SequenceFeature)this.align.ds[seq2].features.elementAt(i);
                        if (pos >= sf.start && pos <= sf.end) {
                            tmp = String.valueOf(tmp) + sf.print() + "\n";
                        }
                        ++i;
                    }
                    tmp = String.valueOf(tmp) + "\n------------------------------------------------\n";
                    tmp = String.valueOf(tmp) + "All features : \n\n";
                    i = 0;
                    while (i < this.align.ds[seq2].features.size()) {
                        sf = (SequenceFeature)this.align.ds[seq2].features.elementAt(i);
                        tmp = String.valueOf(tmp) + sf.print() + "\n";
                        af.ff.setText(tmp);
                        ++i;
                    }
                }
            }
            this.editFlag = false;
            this.startseq = -1;
            this.startres = -1;
            this.lastres = -1;
        }
        catch (Exception exception) {}
        return true;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        int res = x / this.seqCanvas.charWidth + this.seqCanvas.startx;
        int seq2 = y / this.seqCanvas.charHeight + this.seqCanvas.starty;
        if (seq2 < this.align.size() && res < this.align.maxLength && res >= 0) {
            char resstr = this.align.ds[seq2].charAt(res);
            int pos = this.align.ds[seq2].findPosition(res);
            this.startseq = seq2;
            this.padseq = this.startseq == this.align.size() - 1 ? 1 : 1;
            this.startres = res;
            this.lastres = res;
            if (this.align.ds[seq2].pdb != null) {
                PDBChain tmp = (PDBChain)this.align.ds[seq2].pdb.chains.elementAt(this.align.ds[seq2].maxchain);
                int pdbpos = pos - this.align.ds[seq2].seqstart + this.align.ds[seq2].pdbstart + tmp.offset - 1;
                int i = 0;
                while (i < tmp.bonds.size()) {
                    if (((Bond)tmp.bonds.elementAt((int)i)).at1.resNumber == pdbpos) {
                        ((Bond)tmp.bonds.elementAt((int)i)).at1.isSelected = true;
                    }
                    if (((Bond)tmp.bonds.elementAt((int)i)).at2.resNumber == pdbpos) {
                        ((Bond)tmp.bonds.elementAt((int)i)).at2.isSelected = true;
                    }
                    ++i;
                }
            }
            if (this.alignPanel.parent instanceof AlignFrame) {
                ((AlignFrame)this.alignPanel.parent).status.setText("Sequence ID : " + this.align.ds[seq2].getName() + " (" + seq2 + ") Residue = " + resstr + " (" + pos + ") ");
            }
        } else {
            this.startseq = -1;
            this.startres = -1;
            this.lastres = -1;
        }
        return false;
    }

    public void drawChars(int seqstart, int seqend, int start, int end) {
        this.seqCanvas.drawPanel(this.seqCanvas.getGraphics(), start, end, seqstart, seqend);
        this.seqCanvas.drawPanel(this.seqCanvas.gg, start, end, seqstart, seqend);
        this.alignPanel.scalePanel.scaleCanvas.repaint();
    }

    public void insertChar(int j, int seq2) {
        this.align.sequences[seq2].insertCharAt(j, this.align.gapCharacter.charAt(0));
        this.align.maxLength();
        int cfr_ignored_0 = this.align.ds[seq2].sequence.length() - 1;
        this.setScrollValues(this.offx, this.offy);
    }

    public void deleteChar(int j, int res, int sno) {
        if (this.align.ds[sno].sequence.substring(j, j + 1).equals(".") || this.align.ds[sno].sequence.substring(j, j + 1).equals("-") || this.align.ds[sno].sequence.substring(j, j + 1).equals(" ")) {
            this.align.ds[sno].deleteCharAt(j);
        }
        this.align.maxLength();
        this.setScrollValues(this.offx, this.offy);
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        this.editFlag = true;
        int res = x / this.seqCanvas.charWidth + this.seqCanvas.startx;
        if (res < 0) {
            res = 0;
        }
        if (res != this.lastres && this.startseq != -1) {
            this.align.ds[this.startseq].charAt(res);
            if (this.alignPanel.groupEdit) {
                SequenceGroup sg = this.align.findGroup(this.startseq);
                if (res < this.align.maxLength && res < this.lastres) {
                    boolean flag = false;
                    int i = 0;
                    while (i < sg.sequences.size()) {
                        DrawableSequence s = (DrawableSequence)sg.sequences.elementAt(i);
                        int j = this.lastres - 1;
                        while (j >= res) {
                            if (!(flag || s.sequence.substring(j, j + 1).equals("-") || s.sequence.substring(j, j + 1).equals(".") || s.sequence.substring(j, j + 1).equals(" "))) {
                                res = j + 1;
                                System.out.print("\u0007");
                                System.out.flush();
                                flag = true;
                            }
                            --j;
                        }
                        ++i;
                    }
                }
                int i = 0;
                while (i < sg.sequences.size()) {
                    DrawableSequence s = (DrawableSequence)sg.sequences.elementAt(i);
                    boolean found = false;
                    int sno = -1;
                    int k = 0;
                    while (k < this.align.ds.length) {
                        if (this.align.ds[k] == s) {
                            found = true;
                            sno = k;
                            break;
                        }
                        ++k;
                    }
                    if (found && sno != -1) {
                        int index;
                        int j;
                        if (res < this.align.maxLength && res > this.lastres) {
                            j = this.lastres;
                            while (j < res) {
                                this.insertChar(j, sno);
                                ++j;
                            }
                            index = this.align.findIndex(s);
                            if (index != -1) {
                                this.drawChars(index, index + 1, this.lastres, this.align.maxLength);
                            }
                        } else if (res < this.align.maxLength && res < this.lastres) {
                            j = res;
                            while (j < this.lastres) {
                                this.deleteChar(j, res, sno);
                                this.startres = res;
                                ++j;
                            }
                            index = this.align.findIndex(s);
                            if (index != -1) {
                                this.drawChars(index, index + 1, res, this.align.maxLength);
                            }
                        }
                    }
                    ++i;
                }
                this.lastres = res;
            } else if (res < this.align.maxLength && res > this.lastres) {
                int j = this.lastres;
                while (j < res) {
                    this.insertChar(j, this.startseq);
                    ++j;
                }
                this.drawChars(this.startseq, this.startseq + 1, this.lastres, this.align.maxLength);
            } else if (res < this.align.maxLength && res < this.lastres) {
                int j = res;
                while (j < this.lastres) {
                    this.deleteChar(j, res, this.startseq);
                    this.startres = res;
                    ++j;
                }
                this.drawChars(this.startseq, this.startseq + 1, res, this.align.maxLength);
            }
        }
        this.lastres = res;
        return false;
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.setScrollValues(this.offx, this.offy);
    }

    public Dimension minimumSize() {
        return new Dimension(700, 500);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public static void main(String[] args) {
        Frame f = new Frame("SeqPanel");
        DrawableSequence[] s = null;
        try {
            MSFfile msf = new MSFfile("pog.msf", "File");
            int i = 0;
            while (i < msf.seqs.size()) {
                s[i] = new DrawableSequence((Sequence)msf.seqs.elementAt(i));
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println("Exception : " + e);
        }
        if (s != null) {
            SeqPanel sp = new SeqPanel(null, s);
            f.add(sp);
            f.resize(700, 500);
            f.show();
        }
    }
}

