/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.BinaryNode;
import jalview.DrawableSequence;
import jalview.FileParse;
import jalview.FileProperties;
import jalview.Format;
import jalview.MailProperties;
import jalview.OutputGenerator;
import jalview.PostscriptProperties;
import jalview.Sequence;
import jalview.SequenceNode;
import jalview.TreeCanvas;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;

public class TreeFile
extends FileParse
implements OutputGenerator {
    Font f;
    int fontSize = 8;
    SequenceNode top;
    int line = 0;
    int ch = 0;
    float ycount = 0.0f;
    float maxheight;
    SequenceNode maxdist = null;
    boolean showDistances = true;
    MailProperties mp;
    FileProperties fp;
    PostscriptProperties pp;
    int offx = 20;
    int offy = 20;
    Object found = null;
    Vector selected = null;
    Vector groups = new Vector();
    BufferedWriter bw;
    PrintStream ps;
    boolean makeString = false;
    StringBuffer out;

    public TreeFile(SequenceNode sn, Vector selected) {
        this(sn);
        this.selected = selected;
    }

    public TreeFile(SequenceNode sn) {
        this.top = sn;
        this.propertiesInit();
    }

    public TreeFile(String inStr) {
        this.readLines(inStr);
        this.parse();
        this.propertiesInit();
    }

    public TreeFile(String inFile, String type) throws IOException {
        super(inFile, type);
        System.out.print("Reading file....");
        long tstart = System.currentTimeMillis();
        this.readLines();
        long tend = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("Total time taken = " + (tend - tstart) + "ms");
        System.out.println("Parsing file....");
        this.parse();
        System.out.println("Parsing file....");
    }

    public void propertiesInit() {
        this.mp = new MailProperties();
        this.mp.server = "circinus.ebi.ac.uk";
        this.pp = new PostscriptProperties();
        this.fp = new FileProperties();
    }

    public void parse() {
        if (!((String)this.lineArray.elementAt(0)).equals("(")) {
            System.out.println("Invalid tree file: must start with (");
            this.top = null;
        } else {
            SequenceNode tmp = this.top = new SequenceNode();
            this.createTree(tmp, this.getChar());
            System.out.println("Done creating tree " + this.top);
        }
    }

    public void setFontSize(int size) {
        this.fontSize = size;
        this.f = this.f != null ? new Font(this.f.getName(), this.f.getStyle(), size) : new Font("Helvetica", 0, size);
    }

    public void setFont(Font f) {
        this.f = f;
    }

    public String getChar() {
        if (this.ch >= ((String)this.lineArray.elementAt(this.line)).length()) {
            ++this.line;
            this.ch = 0;
        }
        String str = ((String)this.lineArray.elementAt(this.line)).substring(this.ch, this.ch + 1);
        ++this.ch;
        return str;
    }

    /*
     * Unable to fully structure code
     */
    public String createTree(BinaryNode node, String str) {
        block10: {
            name = "";
            dist = "";
            if (!str.equals("(")) ** GOTO lbl36
            System.out.println("New left node on " + node);
            sn = new SequenceNode();
            sn.parent = node;
            node.left = sn;
            str = this.createTree(sn, this.getChar());
            if (!str.equals(",")) break block10;
            System.out.println("New right node on " + node);
            sn2 = new SequenceNode();
            sn2.parent = node;
            node.right = sn2;
            str = this.createTree(sn2, this.getChar());
            if (str.equals(",")) {
                System.out.println("Here " + node.parent);
                System.out.println(String.valueOf(((SequenceNode)node).dist) + " " + ((SequenceNode)node.right).dist);
                System.out.println(sn2.dist);
                this.top = sn3 = new SequenceNode();
                sn3.left = node;
                node.parent = sn3;
                ((SequenceNode)node).dist = 0.001f;
                sn4 = new SequenceNode();
                sn4.parent = sn3;
                sn3.right = sn4;
                this.createTree(sn4, this.getChar());
            }
            l = (SequenceNode)node.left;
            r = (SequenceNode)node.right;
            ((SequenceNode)node).count = l.count + r.count;
            ((SequenceNode)node).ycount = (l.ycount + r.ycount) / 2.0f;
            str = this.getChar();
            break block10;
lbl-1000:
            // 1 sources

            {
                name = String.valueOf(name) + str;
                str = this.getChar();
lbl36:
                // 2 sources

                ** while (!str.equals((Object)":") && !str.equals((Object)",") && !str.equals((Object)")"))
            }
lbl37:
            // 1 sources

            node.setElement(new Sequence(name, "", 0, 0));
            ((SequenceNode)node).count = 1;
            v0 = this.ycount;
            this.ycount = v0 + 1.0f;
            ((SequenceNode)node).ycount = v0;
        }
        if (!str.equals(";")) {
            while (!str.equals(":")) {
                str = this.getChar();
            }
            str = this.getChar();
            while (!(str.equals(":") || str.equals(",") || str.equals(")"))) {
                dist = String.valueOf(dist) + str;
                str = this.getChar();
            }
            if (node instanceof SequenceNode) {
                ((SequenceNode)node).dist = Float.valueOf(dist).floatValue();
                System.out.println("Distance = " + ((SequenceNode)node).dist);
                if (this.maxdist == null || Float.valueOf(dist).floatValue() > this.maxdist.dist) {
                    this.maxdist = (SequenceNode)node;
                }
            }
        }
        return str;
    }

    public float max(float l, float r) {
        if (l > r) {
            return l;
        }
        return r;
    }

    public void printNode(SequenceNode node) {
        if (node == null) {
            return;
        }
        if (node.left == null && node.right == null) {
            System.out.println("Leaf = " + ((Sequence)node.element()).name);
            System.out.println("Dist " + node.dist);
        } else {
            System.out.println("Dist " + node.dist);
            this.printNode((SequenceNode)node.left);
            this.printNode((SequenceNode)node.right);
        }
    }

    public void groupNodes(SequenceNode node, float threshold) {
        if (node == null) {
            return;
        }
        if (node.height / this.maxheight > threshold) {
            this.groups.addElement(node);
        } else {
            this.groupNodes((SequenceNode)node.left, threshold);
            this.groupNodes((SequenceNode)node.right, threshold);
        }
    }

    public Object findElement(Canvas c, int x, int y) {
        int count = (int)((float)(y - this.offy + 5) / (float)(c.size().height - 2 * this.offy) * (float)this.top.count);
        if ((double)x > (double)c.size().width * 0.8) {
            this.found = null;
            Object ob = this.findLeaf(this.top, count);
            return ob;
        }
        return null;
    }

    public Vector findLeaves(SequenceNode node, Vector leaves) {
        if (node == null) {
            return leaves;
        }
        if (node.left == null && node.right == null) {
            leaves.addElement(node);
            return leaves;
        }
        this.findLeaves((SequenceNode)node.left, leaves);
        this.findLeaves((SequenceNode)node.right, leaves);
        return leaves;
    }

    public Object findLeaf(SequenceNode node, int count) {
        if (node == null) {
            return this.found;
        }
        if (node.ycount == (float)count) {
            this.found = node.element;
            return this.found;
        }
        this.findLeaf((SequenceNode)node.left, count);
        this.findLeaf((SequenceNode)node.right, count);
        return this.found;
    }

    public void setColor(SequenceNode node, Color c) {
        if (node == null) {
            return;
        }
        if (node.left == null && node.right == null) {
            node.color = c;
            if (node instanceof SequenceNode) {
                ((DrawableSequence)node.element).setColor(c);
            }
        } else {
            node.color = c;
            this.setColor((SequenceNode)node.left, c);
            this.setColor((SequenceNode)node.right, c);
        }
    }

    public float findHeight(SequenceNode node) {
        if (node == null) {
            return this.maxheight;
        }
        if (node.left == null && node.right == null) {
            node.height = ((SequenceNode)node.parent).height + node.dist;
            if (node.height > this.maxheight) {
                return node.height;
            }
            return this.maxheight;
        }
        if (node.parent != null) {
            node.height = ((SequenceNode)node.parent).height + node.dist;
        } else {
            this.maxheight = 0.0f;
            node.height = 0.0f;
        }
        this.maxheight = this.findHeight((SequenceNode)node.left);
        this.maxheight = this.findHeight((SequenceNode)node.right);
        return this.maxheight;
    }

    public void draw(Graphics g, int width, int height) {
        if (this.f != null) {
            g.setFont(this.f);
        } else {
            g.setFont(new Font("Helvetica", 0, this.fontSize));
        }
        float wscale = (float)((double)width * 0.8 - (double)(this.offx * 2)) / this.maxheight;
        if (this.top.count == 0) {
            this.top.count = ((SequenceNode)this.top.left).count + ((SequenceNode)this.top.right).count;
        }
        float chunk = (float)(height - this.offy * 2) / (float)this.top.count;
        this.drawNode(g, this.top, chunk, wscale, width, this.offx, this.offy);
    }

    public void drawPostscript(PostscriptProperties pp) {
        try {
            int width = 0;
            int height = 0;
            this.printout("%!\n");
            this.printout("/" + pp.font + " findfont\n");
            this.printout(String.valueOf(pp.fsize) + " scalefont setfont\n");
            int offx = pp.xoffset;
            int offy = pp.yoffset;
            if (pp.orientation == PostscriptProperties.PORTRAIT) {
                width = PostscriptProperties.SHORTSIDE;
                height = PostscriptProperties.LONGSIDE;
            } else {
                height = PostscriptProperties.SHORTSIDE;
                width = PostscriptProperties.LONGSIDE;
                this.printout(String.valueOf(height) + " 0 translate\n90 rotate\n");
            }
            float wscale = (float)((double)width * 0.8 - (double)(offx * 2)) / this.maxheight;
            if (this.top.count == 0) {
                this.top.count = ((SequenceNode)this.top.left).count + ((SequenceNode)this.top.right).count;
            }
            float chunk = (float)(height - offy * 2) / (float)(this.top.count + 1);
            this.drawPostscriptNode(this.top, chunk, wscale, width, offx, offy);
            this.printout("showpage\n");
        }
        catch (IOException e) {
            System.out.println("Exception " + e);
        }
    }

    public void changeDirection(SequenceNode node, SequenceNode dir) {
        if (node == null) {
            return;
        }
        if (node.parent != this.top) {
            this.changeDirection((SequenceNode)node.parent, node);
            SequenceNode tmp = (SequenceNode)node.parent;
            if (dir == node.left) {
                node.parent = dir;
                node.left = tmp;
            } else if (dir == node.right) {
                node.parent = dir;
                node.right = tmp;
            }
        } else if (dir == node.left) {
            node.parent = node.left;
            node.right = this.top.left == node ? this.top.right : this.top.left;
        } else {
            node.parent = node.right;
            node.left = this.top.left == node ? this.top.right : this.top.left;
        }
    }

    public SequenceNode reRoot() {
        if (this.maxdist != null) {
            this.ycount = 0.0f;
            float tmpdist = this.maxdist.dist;
            SequenceNode sn = new SequenceNode();
            sn.parent = null;
            SequenceNode snr = (SequenceNode)this.maxdist.parent;
            this.changeDirection(snr, this.maxdist);
            System.out.println("Printing reversed tree");
            TreeFile.printN(snr);
            snr.dist = tmpdist / 2.0f;
            this.maxdist.dist = tmpdist / 2.0f;
            snr.parent = sn;
            this.maxdist.parent = sn;
            sn.right = snr;
            sn.left = this.maxdist;
            this.top = sn;
            this.ycount = 0.0f;
            this.reCount(this.top);
            this.findHeight(this.top);
        }
        return this.top;
    }

    public void drawPostscriptNode(SequenceNode node, float chunk, float scale, int width, int offx, int offy) throws IOException {
        if (node == null) {
            return;
        }
        if (node.left == null && node.right == null) {
            float height = node.height;
            float dist = node.dist;
            int xstart = (int)((height - dist) * scale) + offx;
            int xend = (int)(height * scale) + offx;
            int ypos = (int)(node.ycount * chunk) + offy;
            this.printout("\n" + new Format("%5.3f").form((double)node.color.getRed() / 255.0) + " " + new Format("%5.3f").form((double)node.color.getGreen() / 255.0) + " " + new Format("%5.3f").form((double)node.color.getBlue() / 255.0) + " setrgbcolor\n");
            this.printout(String.valueOf(xstart) + " " + ypos + " moveto " + xend + " " + ypos + " lineto stroke \n");
            if (this.showDistances && node.dist > 0.0f) {
                this.printout("(" + new Format("%5.2f").form(node.dist) + ") " + xstart + " " + (ypos + 5) + " moveto show\n");
            }
            this.printout("(" + ((Sequence)node.element()).name + ") " + (xend + 20) + " " + ypos + " moveto show\n");
        } else {
            this.drawPostscriptNode((SequenceNode)node.left, chunk, scale, width, offx, offy);
            this.drawPostscriptNode((SequenceNode)node.right, chunk, scale, width, offx, offy);
            float height = node.height;
            float dist = node.dist;
            int xstart = (int)((height - dist) * scale) + offx;
            int xend = (int)(height * scale) + offx;
            int ypos = (int)(node.ycount * chunk) + offy;
            this.printout("\n" + new Format("%5.3f").form((double)node.color.getRed() / 255.0) + " " + new Format("%5.3f").form((double)node.color.getGreen() / 255.0) + " " + new Format("%5.3f").form((double)node.color.getBlue() / 255.0) + " setrgbcolor\n");
            this.printout(String.valueOf(xstart) + " " + ypos + " moveto " + xend + " " + ypos + " lineto stroke\n");
            int ystart = (int)(((SequenceNode)node.left).ycount * chunk) + offy;
            int yend = (int)(((SequenceNode)node.right).ycount * chunk) + offy;
            this.printout(String.valueOf((int)(height * scale) + offx) + " " + ystart + " moveto " + ((int)(height * scale) + offx) + " " + yend + " lineto stroke\n");
            if (this.showDistances && node.dist > 0.0f) {
                this.printout("(" + new Format("%5.2f").form(node.dist) + ") " + xstart + " " + (ypos + 5) + " moveto show\n");
            }
        }
    }

    public void printout(String s) throws IOException {
        if (this.bw != null) {
            this.bw.write(s);
        }
        if (this.ps != null) {
            this.ps.print(s);
        }
        if (this.makeString) {
            this.out.append(s);
        }
    }

    public void drawNode(Graphics g, SequenceNode node, float chunk, float scale, int width, int offx, int offy) {
        if (node == null) {
            return;
        }
        if (node.left == null && node.right == null) {
            float height = node.height;
            float dist = node.dist;
            int xstart = (int)((height - dist) * scale) + offx;
            int xend = (int)(height * scale) + offx;
            int ypos = (int)(node.ycount * chunk) + offy;
            g.setColor(node.color);
            g.drawLine(xstart, ypos, xend, ypos);
            if (this.showDistances && node.dist > 0.0f) {
                g.drawString(new Format("%5.2f").form(node.dist), xstart, ypos - 5);
            }
            if (this.selected != null && this.selected.contains((Sequence)node.element())) {
                g.setColor(Color.gray);
                FontMetrics fm = g.getFontMetrics(this.f);
                int charWidth = fm.stringWidth(((Sequence)node.element()).name) + 3;
                int charHeight = fm.getHeight();
                g.fillRect(xend + 20, ypos - charHeight + 3, charWidth, charHeight);
                g.setColor(Color.white);
            }
            g.drawString(((Sequence)node.element()).name, xend + 20, ypos);
            g.setColor(Color.black);
        } else {
            this.drawNode(g, (SequenceNode)node.left, chunk, scale, width, offx, offy);
            this.drawNode(g, (SequenceNode)node.right, chunk, scale, width, offx, offy);
            float height = node.height;
            float dist = node.dist;
            int xstart = (int)((height - dist) * scale) + offx;
            int xend = (int)(height * scale) + offx;
            int ypos = (int)(node.ycount * chunk) + offy;
            g.setColor(node.color);
            g.drawLine(xstart, ypos, xend, ypos);
            int ystart = (int)(((SequenceNode)node.left).ycount * chunk) + offy;
            int yend = (int)(((SequenceNode)node.right).ycount * chunk) + offy;
            g.drawLine((int)(height * scale) + offx, ystart, (int)(height * scale) + offx, yend);
            if (this.showDistances && node.dist > 0.0f) {
                g.drawString(new Format("%5.2f").form(node.dist), xstart, ypos - 5);
            }
        }
    }

    public static void printN(SequenceNode node) {
        if (node == null) {
            return;
        }
        if (node.left != null && node.right != null) {
            TreeFile.printN((SequenceNode)node.left);
            TreeFile.printN((SequenceNode)node.right);
        } else {
            System.out.println(" name = " + ((Sequence)node.element()).name);
        }
        System.out.println(" dist = " + node.dist + " " + node.count + " " + node.height);
    }

    public void reCount(SequenceNode node) {
        if (node == null) {
            return;
        }
        if (node.left != null && node.right != null) {
            this.reCount((SequenceNode)node.left);
            this.reCount((SequenceNode)node.right);
            SequenceNode l = (SequenceNode)node.left;
            SequenceNode r = (SequenceNode)node.right;
            node.count = l.count + r.count;
            node.ycount = (l.ycount + r.ycount) / 2.0f;
        } else {
            node.count = 1;
            float f = this.ycount;
            this.ycount = f + 1.0f;
            node.ycount = f;
        }
    }

    public static void main(String[] args) {
        try {
            TreeFile tf = new TreeFile(args[0], "File");
            tf.top.height = 0.0f;
            tf.maxheight = -1.0f;
            tf.findHeight(tf.top);
            System.out.println("*************Done***********");
            Frame f = new Frame();
            f.setLayout(new BorderLayout());
            Panel p = new Panel();
            p.setLayout(new BorderLayout());
            TreeCanvas mc = new TreeCanvas(tf);
            p.add("Center", mc);
            f.resize(600, 600);
            f.add("Center", p);
            f.show();
        }
        catch (IOException e) {
            System.out.println("Exception " + e);
        }
    }

    public MailProperties getMailProperties() {
        return this.mp;
    }

    public PostscriptProperties getPostscriptProperties() {
        return this.pp;
    }

    public FileProperties getFileProperties() {
        return this.fp;
    }

    public void setMailProperties(MailProperties mp) {
        this.mp = mp;
    }

    public void setPostscriptProperties(PostscriptProperties pp) {
        this.pp = pp;
    }

    public void setFileProperties(FileProperties fp) {
        this.fp = fp;
    }

    public String getText(String format) {
        return null;
    }

    public void getPostscript(BufferedWriter bw) {
        this.bw = bw;
        this.drawPostscript(this.pp);
    }

    public void getPostscript(PrintStream bw) {
        this.ps = bw;
        this.drawPostscript(this.pp);
        bw.flush();
    }

    public StringBuffer getPostscript() {
        this.makeString = true;
        this.out = new StringBuffer();
        this.drawPostscript(this.pp);
        return this.out;
    }
}

