/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import java.util.EnumSet;
import scigol.Debug;
import scigol.Entry;
import scigol.FuncInfo;
import scigol.Scope;
import scigol.TypeManager;
import scigol.TypeSpec;

public class ClassScope
extends Scope {
    protected TypeSpec _classType;

    public ClassScope(TypeSpec classType) {
        Debug.Assert(classType.isClassOrBuiltinClass() || classType.isInterface(), "can't make a class scope from a non-class:" + classType);
        this._classType = classType;
        this._outer = classType.getClassInfo().getOuterScope();
    }

    public boolean isClassScope() {
        return true;
    }

    public TypeSpec getClassType() {
        return this._classType;
    }

    public Entry[] getEntries(String name, Object instance) {
        Entry[] entries = this._classType.getClassInfo().lookup(name, null, null);
        return entries;
    }

    public Entry addEntry(Entry e) {
        EnumSet<Entry.Flags> flags = e.flags;
        if (e.type.isFunc()) {
            flags.add(Entry.Flags.Method);
        } else {
            flags.add(Entry.Flags.Field);
        }
        this._classType.getClassInfo().addMember(e.name, flags, e.type, e.modifiers, e.getStaticValue(), e.initializer);
        return e;
    }

    public boolean contains(String name) {
        return super.contains(name);
    }

    public Entry[] lookup(String name, FuncInfo callSig, Object[] args, Object instance) {
        if (this.contains(name)) {
            Entry[] matches = this.getEntries(name, instance);
            if (matches.length == 1) {
                return matches;
            }
            if ((matches = TypeManager.resolveOverload(matches, callSig, args)).length > 0) {
                return matches;
            }
        }
        if (this._outer != null) {
            return this._outer.lookup(name, callSig, args, instance);
        }
        return new Entry[0];
    }
}

