/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import scigol.Any;
import scigol.Debug;
import scigol.Range;
import scigol.TypeSpec;
import scigol.Vector;
import scigol.accessor;

public class List
implements java.util.List {
    private ItemNode headitem = null;
    private ItemNode tailitem = null;
    private int length = 0;

    public List() {
    }

    public List(int len) {
        int i = 0;
        while (i < len) {
            this.add((Object)null);
            ++i;
        }
    }

    public List(Object head) {
        this.add(head);
    }

    public List(java.util.List list) {
        int i = 0;
        while (i < list.size()) {
            this.add(list.get(i));
            ++i;
        }
    }

    public List(Vector v) {
        int i = 0;
        while (i < v.get_size()) {
            this.add(v.get_Item((int)i).value);
            ++i;
        }
    }

    @accessor
    public Any get_head() {
        if (this.length == 0) {
            throw new IndexOutOfBoundsException("list () has no head");
        }
        return new Any(this.headitem.item);
    }

    @accessor
    public void set_head(Any value) {
        if (this.length == 0) {
            throw new IndexOutOfBoundsException("list () has no head");
        }
        this.headitem.item = value.value;
    }

    @accessor
    List get_tail() {
        if (this.length <= 1) {
            return new List();
        }
        return this.get_Item(new Range(1, this.length - 1));
    }

    @accessor
    void set_tail(List value) {
        this.assign(this.length > 0 ? List.op_Addition(new List(this.get_head()), value) : value);
    }

    @accessor
    public int get_size() {
        return this.length;
    }

    public int size() {
        return this.length;
    }

    public boolean add(Object value) {
        ItemNode item = new ItemNode(TypeSpec.unwrapAnyOrNum(value));
        if (this.tailitem == null) {
            this.tailitem = this.headitem = item;
        } else {
            this.tailitem.next = item;
            item.prev = this.tailitem;
            this.tailitem = item;
        }
        ++this.length;
        return true;
    }

    public void add(int index, Object element) {
        Debug.Unimplemented();
    }

    public void clear() {
        this.tailitem = null;
        this.headitem = null;
        this.length = 0;
    }

    public boolean contains(Object value) {
        Debug.Unimplemented();
        return false;
    }

    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Object value) {
        Debug.Unimplemented();
        return 0;
    }

    public boolean remove(Object value) {
        Debug.Unimplemented();
        return false;
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("list has no item with index " + index);
        }
        if (index == 0) {
            return this.removeHead();
        }
        if (index == this.length - 1) {
            return this.removeTailItem();
        }
        ItemNode item = this.findItem(index);
        item.prev.next = item.next;
        item.next.prev = item.prev;
        --this.length;
        return new Any(item.item);
    }

    public List append(List l2) {
        List newList = new List(this);
        for (Object e : l2) {
            newList.add(e);
        }
        return newList;
    }

    public boolean notEquals(List l2) {
        if (l2 == null) {
            return true;
        }
        int i = 0;
        while (i < this.length) {
            if (this.get_Item(i).equals(l2.get_Item(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object l2) {
        if ((l2 = TypeSpec.unwrapAnyOrNum(l2)) == null || !(l2 instanceof List)) {
            return false;
        }
        return this.equals((List)l2);
    }

    public boolean equals(List l2) {
        if (l2 == null) {
            return false;
        }
        int i = 0;
        while (i < this.length) {
            if (!this.get_Item(i).equals(l2.get_Item(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @accessor
    public List get_Item(Range r) {
        r = r.normalize(this.length);
        if (r.start < 0 || r.start >= this.length) {
            throw new IndexOutOfBoundsException("list range start " + r.start + " out of range 0.." + (this.length - 1));
        }
        if (r.end < 0 || r.end >= this.length) {
            throw new IndexOutOfBoundsException("list range end " + r.end + " out of range 0.." + (this.length - 1));
        }
        if (r.start > r.end) {
            return new List();
        }
        if (r.start == r.end) {
            return new List(new Any(this.getItem(r.start)));
        }
        List list = new List();
        int i = r.start;
        while (i <= r.end) {
            list.add(this.getItem(i));
            ++i;
        }
        return list;
    }

    @accessor
    public void set_Item(Range r, List value) {
        r = r.normalize(this.length);
        if (r.start < 0 || r.start >= this.length) {
            throw new IndexOutOfBoundsException("list range start " + r.start + " out of range 0.." + (this.length - 1));
        }
        if (r.end < 0 || r.end >= this.length) {
            throw new IndexOutOfBoundsException("list range end " + r.end + " out of range 0.." + (this.length - 1));
        }
        if (r.start > r.end) {
            if (value.length != 0) {
                throw new IllegalArgumentException("can't assign list with " + value.length + " elements to a range of 0 elements");
            }
            return;
        }
        if (r.start == r.end) {
            this.setItem(r.start, value.get_Item(0));
            if (value.length != 0) {
                throw new IllegalArgumentException("can't assign list with " + value.length + " elements to a range of 1 element");
            }
            return;
        }
        if (value.length != r.end - r.start + 1) {
            throw new IllegalArgumentException("can't assign list with " + value.length + " elements to a range of " + (r.end - r.start + 1) + " elements");
        }
        int i = r.start;
        while (i <= r.end) {
            this.setItem(i, value.get_Item(i - r.start));
            ++i;
        }
    }

    @accessor
    public Any get_Item(int i) {
        if (i < 0) {
            i += this.length;
        }
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("list index " + i + " out of range 0.." + (this.length - 1));
        }
        return new Any(this.getItem(i));
    }

    @accessor
    public void set_Item(int i, Any value) {
        if (i < 0) {
            i += this.length;
        }
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("list index " + i + " out of range 0.." + (this.length - 1));
        }
        this.setItem(i, value.value);
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        this.set_Item(index, new Any(element));
        return element;
    }

    public boolean isEmpty() {
        return this.get_size() == 0;
    }

    public boolean addAll(int index, Collection c) {
        Debug.Unimplemented();
        return false;
    }

    public boolean addAll(Collection c) {
        return this.addAll(0, c);
    }

    public boolean removeAll(Collection c) {
        if (this.isEmpty()) {
            return false;
        }
        for (Object o : c) {
            this.remove(o);
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        Debug.Unimplemented();
        return false;
    }

    public List subList(int fromIndex, int toIndex) {
        return this.get_Item(new Range(fromIndex, toIndex));
    }

    public int lastIndexOf(Object o) {
        Debug.Unimplemented();
        return -1;
    }

    public ListIterator listIterator() {
        Debug.Unimplemented();
        return null;
    }

    public ListIterator listIterator(int index) {
        Debug.Unimplemented();
        return null;
    }

    public Iterator iterator() {
        Debug.Unimplemented();
        return null;
    }

    public static List op_Addition(List l1, List l2) {
        return l1.append(l2);
    }

    public static boolean op_Equality(List l1, List l2) {
        return l1.equals(l2);
    }

    public static boolean op_InEquality(List l1, List l2) {
        return l1.notEquals(l2);
    }

    public static int op_Card(List l) {
        return l.length;
    }

    public String toString() {
        String s = "(";
        int i = 0;
        while (i < this.length) {
            s = String.valueOf(s) + this.getItem(i).toString();
            if (i != this.length - 1) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
        }
        s = String.valueOf(s) + ")";
        return s;
    }

    public Object[] toArray() {
        Object[] a = new Object[this.get_size()];
        int i = 0;
        while (i < this.get_size()) {
            a[i] = this.get_Item((int)i).value;
            ++i;
        }
        return a;
    }

    public Object[] toArray(Object[] a) {
        Debug.Unimplemented();
        return null;
    }

    protected void assign(List l) {
        this.clear();
        for (Object e : l) {
            this.add(e);
        }
    }

    protected int addToHead(Object value) {
        ItemNode item = new ItemNode(TypeSpec.unwrapAnyOrNum(value));
        if (this.headitem == null) {
            this.headitem = this.tailitem = item;
        } else {
            item.next = this.headitem;
            item.prev = null;
            this.headitem.prev = item;
            this.headitem = item;
        }
        ++this.length;
        return this.length - 1;
    }

    protected boolean addToTail(Object value) {
        return this.add(value);
    }

    protected Any removeHead() {
        ItemNode h = this.headitem;
        if (h == null) {
            return new Any(null);
        }
        --this.length;
        if (h == this.tailitem) {
            this.headitem = null;
            this.tailitem = null;
            return new Any(h);
        }
        this.headitem = h.next;
        this.headitem.prev = null;
        return new Any(h);
    }

    protected Any removeTailItem() {
        ItemNode t = this.tailitem;
        if (t == null) {
            return new Any(null);
        }
        --this.length;
        if (t == this.headitem) {
            this.headitem = null;
            this.tailitem = null;
            return new Any(t);
        }
        this.tailitem = this.tailitem.prev;
        return new Any(t);
    }

    private ItemNode findItem(int i) {
        ItemNode item = null;
        if (i < this.length / 2) {
            item = this.headitem;
            while (i > 0) {
                item = item.next;
                --i;
            }
        } else {
            item = this.tailitem;
            i = this.length - 1 - i;
            while (i > 0) {
                item = item.prev;
                --i;
            }
        }
        return item;
    }

    private Object getItem(int i) {
        return this.findItem((int)i).item;
    }

    private void setItem(int i, Object value) {
        this.findItem((int)i).item = TypeSpec.unwrapAnyOrNum(value);
    }

    protected class ItemNode {
        public Object item;
        public ItemNode next;
        public ItemNode prev;

        public ItemNode(Object item) {
            this.item = item;
            this.next = null;
            this.prev = null;
        }

        public ItemNode(Object item, ItemNode prev, ItemNode next) {
            this.item = item;
            this.prev = prev;
            this.next = next;
        }
    }
}

