/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import scigol.Debug;
import scigol.Entry;
import scigol.FuncInfo;
import scigol.ScigolException;
import scigol.ScigolTreeParser;
import scigol.Scope;
import scigol.TypeManager;
import scigol.TypeSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceScope
extends Scope {
    protected NamespaceType _namespaceType;
    protected String _namespaceName;
    protected Hashtable _namespaces;
    protected Hashtable _entries;
    protected Hashtable _usings;
    protected static HashMap<String, LinkedList<String>> loadedPackages = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        NamespaceScope.registerLibraryClass("scigol", "accessor");
        NamespaceScope.registerLibraryClass("scigol", "Any");
        NamespaceScope.registerLibraryClass("scigol", "Func");
        NamespaceScope.registerLibraryClass("scigol", "List");
        NamespaceScope.registerLibraryClass("scigol", "Map");
        NamespaceScope.registerLibraryClass("scigol", "Math");
        NamespaceScope.registerLibraryClass("scigol", "Matrix");
        NamespaceScope.registerLibraryClass("scigol", "Num");
        NamespaceScope.registerLibraryClass("scigol", "Range");
        NamespaceScope.registerLibraryClass("scigol", "redirect");
        NamespaceScope.registerLibraryClass("scigol", "TypeSpec");
        NamespaceScope.registerLibraryClass("scigol", "Value");
        NamespaceScope.registerLibraryClass("scigol", "Vector");
        NamespaceScope.registerLibraryClass("scigol", "TypeManager");
    }

    protected NamespaceScope() {
        this._namespaceName = "";
        this._namespaceType = NamespaceType.Local;
        this._namespaces = null;
        this._outer = null;
        this._entries = new Hashtable();
        this._usings = new Hashtable();
    }

    public NamespaceScope(String name, Scope outer) {
        Debug.Assert(outer.isNamespaceScope(), "namespaces can only be nested within namespaces");
        this._namespaceName = name;
        this._namespaceType = NamespaceType.Local;
        this._namespaces = null;
        this._outer = outer;
        this._entries = new Hashtable();
        this._usings = new Hashtable();
        NamespaceScope gs = this.getGlobalScope();
        String fullName = name;
        String outerFullName = ((NamespaceScope)this._outer).fullNamespaceName();
        if (outerFullName != "") {
            fullName = String.valueOf(outerFullName) + "." + fullName;
        }
        gs._namespaces.put(fullName, this);
    }

    @Override
    public boolean isNamespaceScope() {
        return true;
    }

    public static NamespaceScope newOrExistingNamespaceScope(String name, Scope outer) {
        NamespaceScope existingNamespace;
        Debug.Assert(outer.isNamespaceScope(), "namespaces can only be nested within namespaces");
        NamespaceScope outerNamespace = (NamespaceScope)outer;
        String fullName = name;
        String outerFullName = outerNamespace.fullNamespaceName();
        if (outerFullName != "") {
            fullName = String.valueOf(outerFullName) + "." + fullName;
        }
        if ((existingNamespace = outerNamespace.getNamespaceScope(fullName)) != null) {
            return existingNamespace;
        }
        return new NamespaceScope(name, outer);
    }

    public static NamespaceScope newGlobalNamespaceScope() {
        NamespaceScope ns = new NamespaceScope();
        ns.initGlobalScope();
        ns._namespaceType = NamespaceType.Local;
        return ns;
    }

    protected void initGlobalScope() {
        this._namespaceName = "";
        this._outer = null;
        this._namespaces = new Hashtable();
        this._usings = new Hashtable();
    }

    public String fullNamespaceName() {
        String fn = this._namespaceName;
        Scope s = this;
        while (s.getOuter() != null) {
            if (!((s = s.getOuter()) instanceof NamespaceScope) || ((NamespaceScope)s).getNamespaceName().length() <= 0) continue;
            fn = String.valueOf(((NamespaceScope)s).getNamespaceName()) + "." + fn;
        }
        return fn;
    }

    public String getNamespaceName() {
        return this._namespaceName;
    }

    public boolean isExternal() {
        return this._namespaceType == NamespaceType.External;
    }

    public NamespaceScope getNamespaceScope(String fullName) {
        NamespaceScope gs = this.getGlobalScope();
        if (gs._namespaces.containsKey(fullName)) {
            return (NamespaceScope)gs._namespaces.get(fullName);
        }
        if (NamespaceScope.loadedLibrariesContainNamespace(fullName)) {
            NamespaceScope ns = new NamespaceScope();
            ns._namespaceName = fullName;
            ns._outer = gs;
            ns._usings = new Hashtable();
            ns._namespaceType = NamespaceType.External;
            return ns;
        }
        return null;
    }

    public Entry[] getDeclaredEntries(String name, Object instance) {
        LinkedList<String> classes;
        Package p;
        Entry entry;
        ArrayList<Entry> nsentries = new ArrayList<Entry>();
        if (this._namespaceType == NamespaceType.Local) {
            if (name != null) {
                ArrayList entryList = null;
                if (this._entries.containsKey(name)) {
                    entryList = (ArrayList)this._entries.get(name);
                }
                if (entryList != null) {
                    for (Iterator<Object> o : entryList) {
                        Entry entry2 = (Entry)((Object)o);
                        nsentries.add(entry2);
                    }
                }
            } else {
                for (Object o : this._entries.keySet()) {
                    String key = (String)o;
                    ArrayList entryList = (ArrayList)this._entries.get(key);
                    for (Object eo : entryList) {
                        entry = (Entry)eo;
                        nsentries.add(entry);
                    }
                }
            }
        }
        if (name != null) {
            String fullName = String.valueOf(this._namespaceName) + "." + name;
            Type t = NamespaceScope.loadedLibrariesGetType(fullName);
            if (t != null) {
                Entry entry3 = new Entry(name, new TypeSpec(TypeSpec.typeType), new TypeSpec(t), null, EnumSet.of(TypeSpec.Modifier.Public), EnumSet.noneOf(Entry.Flags.class), -1, this);
                if (t instanceof Class) {
                    entry3.addAnnotations(((Class)t).getAnnotations());
                }
                nsentries.add(entry3);
            }
        } else if (this._namespaceName.length() > 0 && (p = Package.getPackage(this._namespaceName)) != null && (classes = loadedPackages.get(this._namespaceName)) != null) {
            for (String className : classes) {
                String fullName = String.valueOf(this._namespaceName) + "." + className;
                Type t = NamespaceScope.loadedLibrariesGetType(fullName);
                if (t == null) continue;
                entry = new Entry(className, new TypeSpec(TypeSpec.typeType), new TypeSpec(t), null, EnumSet.of(TypeSpec.Modifier.Public), EnumSet.noneOf(Entry.Flags.class), -1, this);
                if (t instanceof Class) {
                    entry.addAnnotations(((Class)t).getAnnotations());
                }
                nsentries.add(entry);
            }
        }
        return Entry.toArray(nsentries);
    }

    @Override
    public Entry[] getEntries(String name, Object instance) {
        Entry[] declaredEntries;
        ArrayList<Entry> nsentries = new ArrayList<Entry>();
        Entry[] entryArray = declaredEntries = this.getDeclaredEntries(name, instance);
        int n = 0;
        int n2 = entryArray.length;
        while (n < n2) {
            Entry e = entryArray[n];
            nsentries.add(e);
            ++n;
        }
        if (this._namespaceType == NamespaceType.Local && (name == null || this.containsUsing(name))) {
            Entry[] usingEntries;
            Entry[] entryArray2 = usingEntries = this.getUsingEntries(name);
            n2 = 0;
            int n3 = entryArray2.length;
            while (n2 < n3) {
                Entry o;
                Entry e = o = entryArray2[n2];
                nsentries.add(e);
                ++n2;
            }
        }
        return Entry.toArray(nsentries);
    }

    @Override
    public Entry addEntry(Entry e) {
        e.scope = this;
        String name = e.name;
        ArrayList<Entry> el = (ArrayList<Entry>)this._entries.get(name);
        if (el == null) {
            el = new ArrayList<Entry>();
            el.add(e);
            this._entries.put(name, el);
        } else {
            el.add(e);
        }
        return e;
    }

    @Override
    public Entry[] lookup(String name, FuncInfo callSig, Object[] args, Object instance) {
        if (this.contains(name)) {
            Entry[] matches = this.getEntries(name, instance);
            if (matches.length == 1) {
                return matches;
            }
            if ((matches = TypeManager.resolveOverload(matches, callSig, args)).length > 0) {
                return matches;
            }
        } else if (this.containsUsing(name)) {
            Entry[] matches = this.getUsingEntries(name);
            if (matches.length == 1) {
                return matches;
            }
            if ((matches = TypeManager.resolveOverload(matches, callSig, args)).length > 0) {
                return matches;
            }
        }
        if (this._outer != null) {
            return this._outer.lookup(name, callSig, args, instance);
        }
        return new Entry[0];
    }

    @Override
    public boolean contains(String name) {
        if (this._namespaceType == NamespaceType.Local) {
            return this._entries.containsKey(name) || this.containsUsing(name);
        }
        String fullName = String.valueOf(this._namespaceName) + "." + name;
        return NamespaceScope.loadedLibrariesGetType(fullName) != null;
    }

    public void usingAll() {
        Debug.Assert(this._namespaceName != null);
        for (Object o : this._namespaces.keySet()) {
            String nsName = (String)o;
            this.addUsingNamespace(nsName);
        }
    }

    public void addUsingNamespace(String namespaceName) {
        Debug.Assert(namespaceName != null);
        NamespaceScope namespaceScope = this.getNamespaceScope(namespaceName);
        if (namespaceScope == null) {
            ScigolTreeParser.semanticError(this._location, "no namespace named '" + namespaceName + "' can be found");
        }
        if (this._usings.containsKey(namespaceName)) {
            return;
        }
        this._usings.put(namespaceName, new UsingEntry(namespaceScope));
    }

    public void addUsingName(String aliased, String namespaceName) {
        this.addUsingAlias(null, aliased, namespaceName);
    }

    public void addUsingAlias(String alias, String aliased, String namespaceName) {
        NamespaceScope namespaceScope;
        NamespaceScope namespaceScope2 = namespaceScope = namespaceName.length() > 0 ? this.getNamespaceScope(namespaceName) : this;
        if (namespaceScope == null) {
            ScigolTreeParser.semanticError(this._location, "no name '" + namespaceName + "." + aliased + "' can be found");
        }
        if (alias != null) {
            if (this._usings.containsKey(alias)) {
                ScigolTreeParser.semanticError(this._location, "the name '" + alias + "' is already an alias for '" + ((UsingEntry)this._usings.get(alias)).fullAliasedName() + "'");
            }
        } else if (this._usings.containsKey(aliased)) {
            ScigolTreeParser.semanticError(this._location, "the name '" + aliased + "' is already used for '" + ((UsingEntry)this._usings.get(aliased)).fullAliasedName() + "'");
        }
        if (!namespaceScope.contains(aliased)) {
            ScigolTreeParser.semanticError(this._location, "the name '" + aliased + "' cannot be found in namespace '" + namespaceName + "'");
        }
        if (alias != null) {
            this._usings.put(alias, new UsingEntry(alias, aliased, namespaceScope));
        } else {
            this._usings.put(aliased, new UsingEntry(aliased, namespaceScope));
        }
    }

    public String toString() {
        Entry[] entries;
        String s = "namespace " + this.fullNamespaceName() + ":\n";
        Entry[] entryArray = entries = this.getEntries(null, null);
        int n = 0;
        int n2 = entryArray.length;
        while (n < n2) {
            Entry entry = entryArray[n];
            String id = entry.name;
            String typeString = entry.type.toString();
            if (entry.type.isAny() || entry.type.isNum()) {
                TypeSpec vtype = TypeSpec.typeOf(TypeSpec.unwrapAnyOrNum(entry.getStaticValue()));
                typeString = String.valueOf(typeString) + "(" + vtype + ")";
            }
            s = String.valueOf(s) + entry.modifiers + " " + id + " : " + typeString + " = " + entry.getStaticValue() + "\n";
            ++n;
        }
        return s;
    }

    boolean containsUsing(String name) {
        for (Object o : this._usings.keySet()) {
            String key = (String)o;
            UsingEntry e = (UsingEntry)this._usings.get(key);
            if (!e.isNamespace()) {
                if (e.name() != name) continue;
                return e.scope.contains(e.aliasedName);
            }
            if (!e.scope.contains(name)) continue;
            return true;
        }
        return false;
    }

    Entry[] getUsingEntries(String name) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (Object o : this._usings.keySet()) {
            Entry[] nsEntries;
            String key = (String)o;
            UsingEntry e = (UsingEntry)this._usings.get(key);
            if (!e.isNamespace()) {
                if (name != null && e.name() != name) continue;
                Entry[] entryArray = nsEntries = e.scope.getEntries(e.aliasedName, null);
                int n = 0;
                int n2 = entryArray.length;
                while (n < n2) {
                    Entry entry = entryArray[n];
                    if (!e.isAlias()) {
                        entries.add(entry);
                    } else {
                        Entry aliasEntry = entry.createAliasEntry(e.aliasName);
                        entries.add(aliasEntry);
                    }
                    ++n;
                }
                continue;
            }
            nsEntries = e.scope.getEntries(name, null);
            int i = 0;
            while (i < nsEntries.length) {
                entries.add(nsEntries[i]);
                ++i;
            }
        }
        return Entry.toArray(entries);
    }

    static boolean loadedLibrariesContainNamespace(String namespaceName) {
        if (namespaceName.equals("java") || namespaceName.equals("javax")) {
            return true;
        }
        return Package.getPackage(namespaceName) != null;
    }

    static boolean loadedLibrariesContainName(String fullName) {
        try {
            return Class.forName(fullName) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static Type loadedLibrariesGetType(String fullName) {
        try {
            return Class.forName(fullName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    public static void loadLibrary(String fullPathName) {
        boolean first = true;
        try {
            File file = new File(fullPathName);
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> fileEntries = jarFile.entries();
            while (fileEntries.hasMoreElements()) {
                boolean innerClass;
                JarEntry fileEntry = fileEntries.nextElement();
                if (fileEntry.isDirectory() || !fileEntry.getName().endsWith(".class")) continue;
                String name = fileEntry.getName();
                int lastDotIndex = name.lastIndexOf(46);
                int lastSlashIndex = name.lastIndexOf(47);
                String className = name.substring(lastSlashIndex + 1, lastDotIndex);
                String packageName = name.substring(0, lastSlashIndex).replace('/', '.');
                boolean bl = innerClass = className.indexOf(36) != -1;
                if (innerClass) continue;
                LinkedList<String> classes = loadedPackages.get(packageName);
                if (classes == null) {
                    classes = new LinkedList();
                }
                classes.add(className);
                loadedPackages.put(packageName, classes);
                if (!first) continue;
                first = false;
                try {
                    Class.forName(String.valueOf(packageName) + "." + className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ScigolException("ClassLoader unable to load library '" + fullPathName + "' (not in classpath?).");
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throw new ScigolException("Classloader unable to load library '" + fullPathName + "' (not in classpath?).");
                }
            }
        }
        catch (IOException e) {
            throw new ScigolException("unable to load library '" + fullPathName + "' - " + e);
        }
    }

    public static AbstractList<String> getNamespaceNames() {
        LinkedList<String> namespaceNames = new LinkedList<String>();
        for (String packageName : loadedPackages.keySet()) {
            namespaceNames.add(packageName);
        }
        return namespaceNames;
    }

    public static void registerLibraryClass(String packageName, String className) {
        String fullName = String.valueOf(packageName) + "." + className;
        try {
            Class.forName(fullName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.Warning("ClassLoader unable to class '" + fullName + "' (not in classpath?).");
            throw new ScigolException("ClassLoader unable to class '" + fullName + "' (not in classpath?).");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Debug.Warning("ClassLoader unable to class '" + fullName + "' (not in classpath?).");
            throw new ScigolException("Classloader unable to class '" + fullName + "' (not in classpath?).");
        }
        LinkedList<String> classes = loadedPackages.get(packageName);
        if (classes == null) {
            classes = new LinkedList();
        }
        classes.add(className);
        loadedPackages.put(packageName, classes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UsingType {
        Namespace,
        Name,
        Alias;

    }

    public class UsingEntry {
        public UsingType type;
        public NamespaceScope scope;
        public String aliasName;
        public String aliasedName;

        public UsingEntry(NamespaceScope namespaceScope2) {
            this.type = UsingType.Namespace;
            this.scope = namespaceScope2;
            this.aliasedName = null;
            this.aliasName = null;
        }

        public UsingEntry(String alias, String aliased, NamespaceScope scope) {
            this.type = UsingType.Alias;
            this.scope = scope;
            this.aliasName = alias;
            this.aliasedName = aliased;
        }

        public UsingEntry(String aliased, NamespaceScope scope) {
            this.type = UsingType.Name;
            this.aliasName = null;
            this.aliasedName = aliased;
            this.scope = scope;
        }

        public String fullAliasedName() {
            return String.valueOf(this.scope.fullNamespaceName()) + "." + this.aliasedName;
        }

        public String name() {
            if (this.type == UsingType.Namespace) {
                return this.scope.fullNamespaceName();
            }
            if (this.type == UsingType.Name) {
                return this.aliasedName;
            }
            if (this.type == UsingType.Alias) {
                return this.aliasName;
            }
            Debug.Assert(false);
            return null;
        }

        public boolean isNamespace() {
            return this.type == UsingType.Namespace;
        }

        public boolean isAlias() {
            return this.type == UsingType.Alias;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NamespaceType {
        Local,
        External;

    }
}

