/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import scigol.Debug;
import scigol.LValue;
import scigol.Location;
import scigol.ScigolTreeParser;
import scigol.TypeSpec;

public class Value {
    protected boolean _isLeftValue;
    protected boolean _isNamespaceComponent;
    protected Object _value;
    protected Location _loc = null;

    public Value() {
        this._isLeftValue = false;
        this._value = null;
        this._isNamespaceComponent = false;
    }

    public Value(LValue lvalue) {
        Debug.Assert(lvalue != null, "lvalue can't be null");
        this._isLeftValue = true;
        this._value = lvalue;
        this._isNamespaceComponent = false;
    }

    public Value(Object value) {
        if (value instanceof Value) {
            Value v = (Value)value;
            this._isLeftValue = v._isLeftValue;
            this._isNamespaceComponent = v._isNamespaceComponent;
            this._value = v._value;
        } else {
            this._isLeftValue = false;
            this._value = value;
            this._isNamespaceComponent = false;
        }
        Debug.Assert(!(this._value instanceof Value), "Values can't wrap Values");
    }

    public void setValueIsNamespaceComponent(Location l) {
        Debug.Assert(!this._isLeftValue);
        Debug.Assert(this._value instanceof String);
        this._isLeftValue = false;
        this._isNamespaceComponent = true;
        this._loc = l;
    }

    public boolean isLValue() {
        return this._isLeftValue;
    }

    public boolean isNamespaceComponent() {
        return this._isNamespaceComponent;
    }

    public String getNamespaceComponentString() {
        Debug.Assert(this.isNamespaceComponent());
        return this._value.toString();
    }

    public Value rvalue() {
        if (!this._isLeftValue) {
            return this;
        }
        LValue lvalue = (LValue)this._value;
        this._value = lvalue.getValue();
        this._isLeftValue = false;
        return this;
    }

    public void setValue(Object value) {
        Debug.Assert(!(value instanceof Value));
        Debug.Assert(this._isLeftValue, "can only set the value of a LValue");
        ((LValue)this._value).setValue(value);
    }

    public Object getValue() {
        if (this._isLeftValue) {
            return ((LValue)this._value).getValue();
        }
        if (!this._isNamespaceComponent) {
            return this._value;
        }
        ScigolTreeParser.semanticError(this._loc, "the symbol '" + this._value.toString() + "' could not be found in the current or global scope");
        return null;
    }

    public TypeSpec getType() {
        if (this._isLeftValue) {
            return ((LValue)this._value).getType();
        }
        if (!this._isNamespaceComponent) {
            return TypeSpec.typeOf(this._value);
        }
        ScigolTreeParser.semanticError(this._loc, "the symbol '" + this._value.toString() + "' could not be found in the current or global scope");
        return null;
    }

    public LValue getLValue() {
        Debug.Assert(this._isLeftValue, "isn't an lvalue");
        Debug.Assert(this._value instanceof LValue, "_value isn't an LValue");
        return (LValue)this._value;
    }

    public String toString() {
        Object v = this._value;
        if (v == null) {
            return "null";
        }
        return v.toString();
    }
}

