/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import uk.ac.sanger.artemis.io.Range;

public class AlignMatch {
    private Range subject_sequence_range = null;
    private Range query_sequence_range = null;
    private int score = -1;
    private int percent_id = -1;
    private boolean rev_match;

    public AlignMatch(Range subject_sequence_range, Range query_sequence_range, boolean rev_match, int score, int percent_id) {
        this.subject_sequence_range = subject_sequence_range;
        this.query_sequence_range = query_sequence_range;
        this.rev_match = rev_match;
        this.score = score;
        this.percent_id = percent_id;
    }

    public int getSubjectSequenceStart() {
        return this.subject_sequence_range.getStart();
    }

    public int getSubjectSequenceEnd() {
        return this.subject_sequence_range.getEnd();
    }

    public int getQuerySequenceStart() {
        if (this.isRevMatch()) {
            return this.query_sequence_range.getEnd();
        }
        return this.query_sequence_range.getStart();
    }

    public int getQuerySequenceEnd() {
        if (this.isRevMatch()) {
            return this.query_sequence_range.getStart();
        }
        return this.query_sequence_range.getEnd();
    }

    public Range getSubjectSequenceRange() {
        return this.subject_sequence_range;
    }

    public Range getQuerySequenceRange() {
        return this.query_sequence_range;
    }

    public boolean isRevMatch() {
        return this.rev_match;
    }

    public int getScore() {
        return this.score;
    }

    public int getPercentID() {
        return this.percent_id;
    }

    public boolean isSelfMatch() {
        return this.getQuerySequenceStart() == this.getSubjectSequenceStart() && this.getQuerySequenceEnd() == this.getSubjectSequenceEnd();
    }
}

