/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.util.NoSuchElementException;
import java.util.Vector;
import uk.ac.sanger.artemis.ActionController;
import uk.ac.sanger.artemis.ChangeEvent;
import uk.ac.sanger.artemis.ChangeListener;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.EntryVector;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.FeatureEnumeration;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.SimpleDocumentEntry;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class SimpleEntryGroup
extends EntryVector
implements EntryGroup {
    private final Vector entry_group_listener_list = new Vector();
    private final Vector entry_listener_list = new Vector();
    private final Vector feature_listener_list = new Vector();
    private final EntryVector active_entries = new EntryVector();
    private Entry default_entry = null;
    private Bases bases;
    private int reference_count = 0;
    private final ActionController action_controller = new ActionController();

    public SimpleEntryGroup(Bases bases) {
        this.bases = bases;
        this.addFeatureChangeListener(this.getActionController());
        this.addEntryChangeListener(this.getActionController());
        this.getBases().addSequenceChangeListener(this.getActionController(), -5);
        this.addEntryGroupChangeListener(this.getActionController());
    }

    public boolean hasUnsavedChanges() {
        int entry_index = 0;
        while (entry_index < this.size()) {
            if (this.elementAt(entry_index).hasUnsavedChanges()) {
                return true;
            }
            ++entry_index;
        }
        return false;
    }

    public Entry getDefaultEntry() {
        return this.default_entry;
    }

    public void setDefaultEntry(Entry entry) {
        if (entry != null && !this.isActive(entry)) {
            return;
        }
        if (this.default_entry == entry) {
            return;
        }
        this.default_entry = entry;
        EntryGroupChangeEvent event = new EntryGroupChangeEvent(this, this.getDefaultEntry(), 5);
        this.fireEvent(this.entry_group_listener_list, event);
    }

    public int indexOf(Feature feature) {
        int feature_count_of_previous_entries = 0;
        int entry_index = 0;
        while (entry_index < this.active_entries.size()) {
            Entry this_entry = this.active_entries.elementAt(entry_index);
            int feature_index = this_entry.indexOf(feature);
            if (feature_index != -1) {
                return feature_index + feature_count_of_previous_entries;
            }
            feature_count_of_previous_entries += this_entry.getFeatureCount();
            ++entry_index;
        }
        return -1;
    }

    public boolean contains(Feature feature) {
        int i = 0;
        while (i < this.active_entries.size()) {
            Entry current_entry = this.active_entries.elementAt(i);
            if (current_entry.contains(feature)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isActive(Entry entry) {
        return this.active_entries.contains(entry);
    }

    public void setIsActive(int index, boolean new_active) {
        Entry entry = this.elementAt(index);
        if (new_active) {
            if (this.isActive(entry)) {
                return;
            }
            EntryVector new_active_entries = new EntryVector();
            int i = 0;
            while (i < this.size()) {
                if (this.active_entries.contains(this.elementAt(i)) || index == i) {
                    new_active_entries.add(this.elementAt(i));
                }
                ++i;
            }
            this.active_entries.removeAllElements();
            i = 0;
            while (i < new_active_entries.size()) {
                this.active_entries.add(new_active_entries.elementAt(i));
                ++i;
            }
            if (this.active_entries.size() >= 1 && this.getDefaultEntry() == null) {
                if (this.active_entries.elementAt(0) == this.getSequenceEntry() && this.active_entries.size() == 1) {
                    this.setDefaultEntry(null);
                } else if (this.active_entries.size() == 1) {
                    this.setDefaultEntry(this.active_entries.elementAt(0));
                } else {
                    this.setDefaultEntry(this.active_entries.elementAt(1));
                }
            }
        } else {
            if (!this.isActive(entry)) {
                return;
            }
            this.active_entries.removeElement(entry);
            if (entry == this.getDefaultEntry()) {
                if (this.active_entries.size() > 0) {
                    if (this.active_entries.elementAt(0) == this.getSequenceEntry()) {
                        if (this.active_entries.size() > 1) {
                            this.setDefaultEntry(this.active_entries.elementAt(1));
                        } else {
                            this.setDefaultEntry(null);
                        }
                    } else {
                        this.setDefaultEntry(this.active_entries.elementAt(0));
                    }
                } else {
                    this.setDefaultEntry(null);
                }
            }
        }
        EntryGroupChangeEvent event = new_active ? new EntryGroupChangeEvent(this, entry, 3) : new EntryGroupChangeEvent(this, entry, 4);
        this.fireEvent(this.entry_group_listener_list, event);
    }

    public void setIsActive(Entry entry, boolean new_active) {
        this.setIsActive(this.indexOf(entry), new_active);
    }

    public Entry getSequenceEntry() {
        if (this.size() == 0) {
            return null;
        }
        return this.elementAt(0);
    }

    public int getSequenceLength() {
        return this.getBases().getLength();
    }

    public Bases getBases() {
        return this.bases;
    }

    public void reverseComplement() throws ReadOnlyException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.getBases().reverseComplement();
    }

    public boolean isReadOnly() {
        int i = 0;
        while (i < this.size()) {
            Entry this_entry = this.elementAt(i);
            if (this_entry.isReadOnly()) {
                return true;
            }
            FeatureEnumeration feature_enum = this_entry.features();
            while (feature_enum.hasMoreFeatures()) {
                if (!feature_enum.nextFeature().isReadOnly()) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void ref() {
        ++this.reference_count;
    }

    public void unref() {
        --this.reference_count;
        if (this.reference_count == 0) {
            while (this.size() > 0) {
                Entry this_entry = this.elementAt(0);
                this.remove(this_entry);
            }
            EntryGroupChangeEvent event = new EntryGroupChangeEvent(this, null, 6);
            this.fireEvent(this.entry_group_listener_list, event);
        }
    }

    public int refCount() {
        return this.reference_count;
    }

    public Feature featureAt(int index) {
        if (index < 0) {
            throw new Error("internal error - index out of range: " + index);
        }
        int entry_index = 0;
        while (entry_index < this.active_entries.size()) {
            Entry this_entry = this.active_entries.elementAt(entry_index);
            if (index < this_entry.getFeatureCount()) {
                return this_entry.getFeature(index);
            }
            index -= this_entry.getFeatureCount();
            ++entry_index;
        }
        throw new Error("internal error - index out of range: " + index);
    }

    public FeatureVector getFeaturesInIndexRange(int start_index, int end_index) {
        FeatureVector return_vector = new FeatureVector();
        int i = start_index;
        while (i <= end_index) {
            return_vector.add(this.featureAt(i));
            ++i;
        }
        return return_vector;
    }

    public FeatureVector getFeaturesInRange(Range range) throws OutOfRangeException {
        FeatureVector return_vector = new FeatureVector();
        int i = 0;
        while (i < this.size()) {
            Entry this_entry = this.elementAt(i);
            if (this.isActive(this_entry)) {
                FeatureVector visible_entry_features = this.elementAt(i).getFeaturesInRange(range);
                int feature_index = 0;
                while (feature_index < visible_entry_features.size()) {
                    Feature this_feature = visible_entry_features.elementAt(feature_index);
                    return_vector.add(this_feature);
                    ++feature_index;
                }
            }
            ++i;
        }
        return return_vector;
    }

    public FeatureVector getAllFeatures() {
        FeatureVector return_vector = new FeatureVector();
        int i = 0;
        while (i < this.size()) {
            Entry this_entry = this.elementAt(i);
            if (this.isActive(this_entry)) {
                FeatureVector entry_features = this.elementAt(i).getAllFeatures();
                int feature_index = 0;
                while (feature_index < entry_features.size()) {
                    Feature this_feature = entry_features.elementAt(feature_index);
                    return_vector.add(this_feature);
                    ++feature_index;
                }
            }
            ++i;
        }
        return return_vector;
    }

    public int getAllFeaturesCount() {
        int return_count = 0;
        int i = 0;
        while (i < this.size()) {
            Entry this_entry = this.elementAt(i);
            if (this.isActive(this_entry)) {
                return_count += this_entry.getFeatureCount();
            }
            ++i;
        }
        return return_count;
    }

    public void addElement(Entry entry) {
        Bases first_entry_bases;
        Entry first_entry;
        super.addElement(entry);
        if (this.default_entry == null) {
            this.default_entry = entry;
        }
        this.active_entries.add(entry);
        EntryGroupChangeEvent event = new EntryGroupChangeEvent(this, entry, 2);
        this.fireEvent(this.entry_group_listener_list, event);
        if (this.size() == 1) {
            this.setDefaultEntry(entry);
        } else if (this.size() == 2 && (first_entry = this.elementAt(0)).getFeatureCount() == 0 && (first_entry_bases = first_entry.getBases()) != null && first_entry_bases.getLength() > 0) {
            this.setDefaultEntry(entry);
        }
        entry.addEntryChangeListener(this);
        entry.addFeatureChangeListener(this);
    }

    public void add(Entry entry) {
        this.addElement(entry);
    }

    public boolean removeElement(Entry entry) {
        this.setIsActive(this.indexOf(entry), false);
        entry.dispose();
        boolean remove_return = super.removeElement(entry);
        entry.removeEntryChangeListener(this);
        entry.removeFeatureChangeListener(this);
        this.active_entries.removeElement(entry);
        EntryGroupChangeEvent event = new EntryGroupChangeEvent(this, entry, 1);
        this.fireEvent(this.entry_group_listener_list, event);
        return remove_return;
    }

    public boolean remove(Entry entry) {
        return this.removeElement(entry);
    }

    public Feature createFeature() throws ReadOnlyException {
        Feature new_feature = this.getDefaultEntry().createFeature();
        return new_feature;
    }

    public Entry createEntry() {
        Entry new_entry = Entry.newEntry(this.getBases());
        this.add(new_entry);
        return new_entry;
    }

    public Entry createEntry(String name) {
        Entry new_entry = this.createEntry();
        new_entry.setName(name);
        return new_entry;
    }

    public FeatureEnumeration features() {
        return new FeatureEnumerator();
    }

    public void featureChanged(FeatureChangeEvent event) {
        this.fireEvent(this.feature_listener_list, event);
    }

    public void entryChanged(EntryChangeEvent event) {
        this.fireEvent(this.entry_listener_list, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(Vector listeners, ChangeEvent event) {
        Vector targets;
        SimpleEntryGroup simpleEntryGroup = this;
        synchronized (simpleEntryGroup) {
            targets = (Vector)listeners.clone();
        }
        int i = 0;
        while (i < targets.size()) {
            ChangeListener target = (ChangeListener)targets.elementAt(i);
            if (event instanceof EntryGroupChangeEvent) {
                EntryGroupChangeListener entry_group_change_listener = (EntryGroupChangeListener)target;
                EntryGroupChangeEvent group_change_event = (EntryGroupChangeEvent)event;
                entry_group_change_listener.entryGroupChanged(group_change_event);
            } else if (event instanceof EntryChangeEvent) {
                EntryChangeListener entry_change_listener = (EntryChangeListener)target;
                entry_change_listener.entryChanged((EntryChangeEvent)event);
            } else {
                FeatureChangeListener feature_change_listener = (FeatureChangeListener)target;
                feature_change_listener.featureChanged((FeatureChangeEvent)event);
            }
            ++i;
        }
    }

    public void addEntryGroupChangeListener(EntryGroupChangeListener l) {
        this.entry_group_listener_list.addElement(l);
    }

    public void removeEntryGroupChangeListener(EntryGroupChangeListener l) {
        this.entry_group_listener_list.removeElement(l);
    }

    public void addEntryChangeListener(EntryChangeListener l) {
        this.entry_listener_list.addElement(l);
    }

    public void removeEntryChangeListener(EntryChangeListener l) {
        this.entry_listener_list.removeElement(l);
    }

    public void addFeatureChangeListener(FeatureChangeListener l) {
        this.feature_listener_list.addElement(l);
    }

    public void removeFeatureChangeListener(FeatureChangeListener l) {
        this.feature_listener_list.removeElement(l);
    }

    public EntryVector getActiveEntries() {
        return (EntryVector)this.active_entries.clone();
    }

    public EntryGroup truncate(Range constraint) {
        Bases new_bases = this.getBases().truncate(constraint);
        SimpleEntryGroup new_entry_group = new SimpleEntryGroup(new_bases);
        int i = 0;
        while (i < this.size()) {
            Entry this_entry = this.elementAt(i);
            Entry new_entry = this_entry.truncate(new_bases, constraint);
            new_entry_group.add(new_entry);
            ++i;
        }
        if (this.size() > 0) {
            StreamSequence sequence = (StreamSequence)new_bases.getSequence();
            SimpleDocumentEntry document_entry = (SimpleDocumentEntry)new_entry_group.elementAt(0).getEMBLEntry();
            document_entry.setSequence(sequence);
        }
        return new_entry_group;
    }

    public ActionController getActionController() {
        return this.action_controller;
    }

    public class FeatureEnumerator
    implements FeatureEnumeration {
        private EntryVector active_entries;
        private int entry_index = -1;
        private FeatureEnumeration feature_enumerator;

        public FeatureEnumerator() {
            this.active_entries = SimpleEntryGroup.this.getActiveEntries();
            this.entry_index = 0;
            this.feature_enumerator = this.active_entries.size() > 0 ? this.active_entries.elementAt(this.entry_index).features() : null;
        }

        public boolean hasMoreFeatures() {
            if (this.feature_enumerator == null) {
                return false;
            }
            if (this.feature_enumerator.hasMoreFeatures()) {
                return true;
            }
            ++this.entry_index;
            if (this.entry_index == this.active_entries.size()) {
                return false;
            }
            this.feature_enumerator = this.active_entries.elementAt(this.entry_index).features();
            return this.hasMoreFeatures();
        }

        public Feature nextFeature() throws NoSuchElementException {
            if (this.feature_enumerator == null) {
                throw new NoSuchElementException();
            }
            return this.feature_enumerator.nextFeature();
        }
    }
}

