/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.AlignMatchVector;
import uk.ac.sanger.artemis.AlignmentSelectionChangeEvent;
import uk.ac.sanger.artemis.AlignmentSelectionChangeListener;
import uk.ac.sanger.artemis.ComparisonData;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SelectionChangeEvent;
import uk.ac.sanger.artemis.SelectionChangeListener;
import uk.ac.sanger.artemis.components.AlignMatchViewer;
import uk.ac.sanger.artemis.components.AlignmentEvent;
import uk.ac.sanger.artemis.components.AlignmentListener;
import uk.ac.sanger.artemis.components.CanvasPanel;
import uk.ac.sanger.artemis.components.DisplayAdjustmentEvent;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.components.MessageFrame;
import uk.ac.sanger.artemis.components.ScoreChangeEvent;
import uk.ac.sanger.artemis.components.ScoreChangeListener;
import uk.ac.sanger.artemis.components.ScoreChanger;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;
import uk.ac.sanger.artemis.sequence.SequenceChangeListener;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.StringVector;

public class AlignmentViewer
extends CanvasPanel
implements SequenceChangeListener {
    private final ComparisonData comparison_data;
    private AlignMatch[] all_matches = null;
    private DisplayAdjustmentEvent last_subject_event;
    private DisplayAdjustmentEvent last_query_event;
    private FeatureDisplay subject_feature_display;
    private FeatureDisplay query_feature_display;
    private Strand orig_subject_forward_strand;
    private Strand orig_query_forward_strand;
    private Strand orig_subject_reverse_strand;
    private Strand orig_query_reverse_strand;
    private final EntryGroup subject_entry_group;
    private final EntryGroup query_entry_group;
    private AlignMatchVector selected_matches = null;
    private Vector selection_change_listeners = new Vector();
    private static int NUMBER_OF_SHADES = 13;
    private Color[] red_percent_id_colours;
    private Color[] blue_percent_id_colours;
    private JScrollBar scroll_bar = null;
    private int minimum_score = 0;
    private int maximum_score = 99999999;
    private int minimum_percent_id = 0;
    private int maximum_percent_id = 100;
    private boolean offer_to_flip_flag = false;
    private boolean ignore_self_match_flag = false;
    private Vector alignment_event_listeners = new Vector();
    private boolean displays_are_locked = true;
    private boolean disable_selection_from_ranges = false;

    public AlignmentViewer(FeatureDisplay subject_feature_display, FeatureDisplay query_feature_display, ComparisonData comparison_data) {
        this.subject_feature_display = subject_feature_display;
        this.query_feature_display = query_feature_display;
        this.comparison_data = comparison_data;
        this.all_matches = this.getComparisonData().getMatches();
        this.subject_entry_group = this.getSubjectDisplay().getEntryGroup();
        this.query_entry_group = this.getQueryDisplay().getEntryGroup();
        Bases subject_bases = this.getSubjectForwardStrand().getBases();
        Bases query_bases = this.getQueryForwardStrand().getBases();
        final Selection subject_selection = this.getSubjectDisplay().getSelection();
        final Selection query_selection = this.getQueryDisplay().getSelection();
        SelectionChangeListener subject_listener = new SelectionChangeListener(){

            public void selectionChanged(SelectionChangeEvent event) {
                RangeVector ranges = subject_selection.getSelectionRanges();
                AlignmentViewer.this.selectFromSubjectRanges(ranges);
            }
        };
        SelectionChangeListener query_listener = new SelectionChangeListener(){

            public void selectionChanged(SelectionChangeEvent event) {
                RangeVector ranges = query_selection.getSelectionRanges();
                AlignmentViewer.this.selectFromQueryRanges(ranges);
            }
        };
        this.makeColours();
        subject_selection.addSelectionChangeListener(subject_listener);
        query_selection.addSelectionChangeListener(query_listener);
        subject_bases.addSequenceChangeListener(this, 0);
        query_bases.addSequenceChangeListener(this, 0);
        this.orig_subject_forward_strand = this.getSubjectForwardStrand();
        this.orig_query_forward_strand = this.getQueryForwardStrand();
        this.getCanvas().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                if (AlignmentViewer.this.isMenuTrigger(event)) {
                    AlignmentViewer.this.popupMenu(event);
                } else {
                    AlignmentViewer.this.handleCanvasMousePress(event);
                }
            }
        });
        this.getCanvas().addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent event) {
                if (AlignmentViewer.this.isMenuTrigger(event)) {
                    return;
                }
                if (!AlignmentViewer.this.modifiersForLockToggle(event)) {
                    if (!event.isShiftDown()) {
                        AlignmentViewer.this.selected_matches = null;
                        AlignmentViewer.this.toggleSelection(event.getPoint());
                    }
                    AlignmentViewer.this.repaintCanvas();
                }
            }
        });
        this.scroll_bar = new JScrollBar(1);
        this.scroll_bar.setValues(1, 1, 1, 1000);
        this.scroll_bar.setBlockIncrement(10);
        this.scroll_bar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                AlignmentViewer.this.repaintCanvas();
            }
        });
        this.maximum_score = this.getComparisonData().getMaximumScore();
        this.add((Component)this.scroll_bar, "East");
    }

    private boolean modifiersForLockToggle(MouseEvent event) {
        return (event.getModifiers() & 8) != 0 || event.isAltDown();
    }

    public void selectFromSubjectRanges(RangeVector select_ranges) {
        if (this.disable_selection_from_ranges) {
            return;
        }
        this.selected_matches = null;
        int range_index = 0;
        while (range_index < select_ranges.size()) {
            Range select_range = select_ranges.elementAt(range_index);
            int match_index = 0;
            while (match_index < this.all_matches.length) {
                AlignMatch this_match = this.all_matches[match_index];
                if (this.isVisible(this_match)) {
                    Strand current_subject_forward_strand = this.getSubjectForwardStrand();
                    int subject_length = current_subject_forward_strand.getSequenceLength();
                    int subject_sequence_start = AlignmentViewer.getRealSubjectSequenceStart(this_match, subject_length, this.getOrigSubjectForwardStrand() != current_subject_forward_strand);
                    int subject_sequence_end = AlignmentViewer.getRealSubjectSequenceEnd(this_match, subject_length, this.getOrigSubjectForwardStrand() != current_subject_forward_strand);
                    if (subject_sequence_end < subject_sequence_start) {
                        int tmp = subject_sequence_start;
                        subject_sequence_start = subject_sequence_end;
                        subject_sequence_end = tmp;
                    }
                    if (!(select_range.getStart() < subject_sequence_start && select_range.getEnd() < subject_sequence_start || select_range.getStart() > subject_sequence_end && select_range.getEnd() > subject_sequence_end)) {
                        if (this.selected_matches == null) {
                            this.selected_matches = new AlignMatchVector();
                        }
                        if (!this.selected_matches.contains(this_match)) {
                            this.selected_matches.add(this_match);
                        }
                    }
                }
                ++match_index;
            }
            ++range_index;
        }
        this.selectionChanged();
    }

    public void selectFromQueryRanges(RangeVector select_ranges) {
        if (this.disable_selection_from_ranges) {
            return;
        }
        this.selected_matches = null;
        int range_index = 0;
        while (range_index < select_ranges.size()) {
            Range select_range = select_ranges.elementAt(range_index);
            int match_index = 0;
            while (match_index < this.all_matches.length) {
                AlignMatch this_match = this.all_matches[match_index];
                if (this.isVisible(this_match)) {
                    Strand current_query_forward_strand = this.getQueryForwardStrand();
                    int query_length = current_query_forward_strand.getSequenceLength();
                    int query_sequence_start = AlignmentViewer.getRealQuerySequenceStart(this_match, query_length, this.getOrigQueryForwardStrand() != current_query_forward_strand);
                    int query_sequence_end = AlignmentViewer.getRealQuerySequenceEnd(this_match, query_length, this.getOrigQueryForwardStrand() != current_query_forward_strand);
                    if (query_sequence_end < query_sequence_start) {
                        int tmp = query_sequence_start;
                        query_sequence_start = query_sequence_end;
                        query_sequence_end = tmp;
                    }
                    if (!(select_range.getStart() < query_sequence_start && select_range.getEnd() < query_sequence_start || select_range.getStart() > query_sequence_end && select_range.getEnd() > query_sequence_end)) {
                        if (this.selected_matches == null) {
                            this.selected_matches = new AlignMatchVector();
                        }
                        if (!this.selected_matches.contains(this_match)) {
                            this.selected_matches.add(this_match);
                        }
                    }
                }
                ++match_index;
            }
            ++range_index;
        }
        this.selectionChanged();
    }

    public void setSelection(AlignMatch match) {
        this.selected_matches = new AlignMatchVector();
        this.selected_matches.add(match);
        this.selectionChanged();
    }

    public void setSubjectSequencePosition(DisplayAdjustmentEvent event) {
        this.last_subject_event = event;
        this.repaintCanvas();
    }

    public void setQuerySequencePosition(DisplayAdjustmentEvent event) {
        this.last_query_event = event;
        this.repaintCanvas();
    }

    public void sequenceChanged(SequenceChangeEvent event) {
        this.repaintCanvas();
    }

    private boolean isMenuTrigger(MouseEvent event) {
        return event.isPopupTrigger() || (event.getModifiers() & 4) != 0;
    }

    private void popupMenu(MouseEvent event) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem alignmatch_list_item = new JMenuItem("View Selected Matches");
        popup.add(alignmatch_list_item);
        alignmatch_list_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _) {
                if (AlignmentViewer.this.selected_matches == null) {
                    new MessageFrame("No matches selected").setVisible(true);
                } else {
                    AlignMatchVector matches = (AlignMatchVector)AlignmentViewer.this.selected_matches.clone();
                    AlignMatchViewer viewer = new AlignMatchViewer(AlignmentViewer.this, matches);
                    viewer.setVisible(true);
                }
            }
        });
        JMenuItem flip_subject_item = new JMenuItem("Flip Subject Sequence");
        popup.add(flip_subject_item);
        flip_subject_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _) {
                if (AlignmentViewer.this.getSubjectDisplay().isRevCompDisplay()) {
                    AlignmentViewer.this.getSubjectDisplay().setRevCompDisplay(false);
                } else {
                    AlignmentViewer.this.getSubjectDisplay().setRevCompDisplay(true);
                }
            }
        });
        JMenuItem flip_query_item = new JMenuItem("Flip Query Sequence");
        popup.add(flip_query_item);
        flip_query_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _) {
                if (AlignmentViewer.this.getQueryDisplay().isRevCompDisplay()) {
                    AlignmentViewer.this.getQueryDisplay().setRevCompDisplay(false);
                } else {
                    AlignmentViewer.this.getQueryDisplay().setRevCompDisplay(true);
                }
            }
        });
        JMenuItem lock_item = new JMenuItem("Lock Sequences");
        popup.add(lock_item);
        lock_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _) {
                AlignmentViewer.this.lockDisplays();
            }
        });
        JMenuItem unlock_item = new JMenuItem("Unlock Sequences");
        popup.add(unlock_item);
        unlock_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _) {
                AlignmentViewer.this.unlockDisplays();
            }
        });
        JMenuItem cutoffs_item = new JMenuItem("Set Score Cutoffs ...");
        popup.add(cutoffs_item);
        cutoffs_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _) {
                ScoreChangeListener minimum_listener = new ScoreChangeListener(this){
                    final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void scoreChanged(ScoreChangeEvent event) {
                        AlignmentViewer.access$7(11.access$0(this.this$1), event.getValue());
                        11.access$0(this.this$1).repaintCanvas();
                    }
                };
                ScoreChangeListener maximum_listener = new ScoreChangeListener(this){
                    final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void scoreChanged(ScoreChangeEvent event) {
                        AlignmentViewer.access$8(11.access$0(this.this$1), event.getValue());
                        11.access$0(this.this$1).repaintCanvas();
                    }
                };
                ScoreChanger score_changer = new ScoreChanger("Score Cutoffs", minimum_listener, maximum_listener, AlignmentViewer.this.getComparisonData().getMinimumScore(), AlignmentViewer.this.getComparisonData().getMaximumScore());
                score_changer.setVisible(true);
            }

            static /* synthetic */ AlignmentViewer access$0(11 var0) {
                return var0.AlignmentViewer.this;
            }
        });
        JMenuItem percent_id_cutoffs_item = new JMenuItem("Set Percent ID Cutoffs ...");
        popup.add(percent_id_cutoffs_item);
        percent_id_cutoffs_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _) {
                ScoreChangeListener minimum_listener = new ScoreChangeListener(this){
                    final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void scoreChanged(ScoreChangeEvent event) {
                        AlignmentViewer.access$10(14.access$0(this.this$1), event.getValue());
                        14.access$0(this.this$1).repaintCanvas();
                    }
                };
                ScoreChangeListener maximum_listener = new ScoreChangeListener(this){
                    final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void scoreChanged(ScoreChangeEvent event) {
                        AlignmentViewer.access$11(14.access$0(this.this$1), event.getValue());
                        14.access$0(this.this$1).repaintCanvas();
                    }
                };
                ScoreChanger score_changer = new ScoreChanger("Percent Identity Cutoffs", minimum_listener, maximum_listener, 0, 100);
                score_changer.setVisible(true);
            }

            static /* synthetic */ AlignmentViewer access$0(14 var0) {
                return var0.AlignmentViewer.this;
            }
        });
        popup.addSeparator();
        JCheckBoxMenuItem offer_to_flip_item = new JCheckBoxMenuItem("Offer To RevComp", this.offer_to_flip_flag);
        offer_to_flip_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AlignmentViewer.this.offer_to_flip_flag = !AlignmentViewer.this.offer_to_flip_flag;
            }
        });
        popup.add(offer_to_flip_item);
        final JCheckBoxMenuItem ignore_self_match_item = new JCheckBoxMenuItem("Ignore Self Matches");
        ignore_self_match_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                AlignmentViewer.this.ignore_self_match_flag = ignore_self_match_item.getState();
                AlignmentViewer.this.repaintCanvas();
            }
        });
        ignore_self_match_item.setState(this.ignore_self_match_flag);
        popup.add(ignore_self_match_item);
        this.getCanvas().add(popup);
        popup.show(this.getCanvas(), event.getX(), event.getY());
    }

    private void handleCanvasMousePress(MouseEvent event) {
        if (event.getID() != 501) {
            return;
        }
        if (event.getClickCount() == 2) {
            this.handleCanvasDoubleClick(event);
        } else {
            this.handleCanvasSingleClick(event);
        }
        this.repaintCanvas();
    }

    private void handleCanvasDoubleClick(MouseEvent event) {
        if (this.selected_matches != null) {
            this.alignAt(this.selected_matches.elementAt(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alignAt(AlignMatch align_match) {
        Vector targets;
        AlignmentViewer alignmentViewer = this;
        synchronized (alignmentViewer) {
            targets = (Vector)this.alignment_event_listeners.clone();
        }
        int i = 0;
        while (i < targets.size()) {
            AlignmentListener listener = (AlignmentListener)targets.elementAt(i);
            listener.alignMatchChosen(new AlignmentEvent(align_match));
            ++i;
        }
    }

    private void handleCanvasSingleClick(MouseEvent event) {
        if (this.modifiersForLockToggle(event)) {
            this.toggleDisplayLock();
        } else {
            if (!event.isShiftDown()) {
                this.selected_matches = null;
            }
            this.toggleSelection(event.getPoint());
        }
    }

    private void toggleSelection(Point point) {
        AlignMatch clicked_align_match = this.getAlignMatchFromPosition(point);
        if (clicked_align_match != null) {
            if (this.selected_matches == null) {
                this.selected_matches = new AlignMatchVector();
                this.selected_matches.add(clicked_align_match);
            } else if (this.selected_matches.contains(clicked_align_match)) {
                this.selected_matches.remove(clicked_align_match);
                if (this.selected_matches.size() == 0) {
                    this.selected_matches = null;
                }
            } else {
                this.selected_matches.add(clicked_align_match);
            }
        }
        this.selectionChanged();
    }

    private AlignMatch getAlignMatchFromPosition(Point click_point) {
        int canvas_height = this.getCanvas().getSize().height;
        int canvas_width = this.getCanvas().getSize().width;
        int i = this.all_matches.length - 1;
        while (i >= 0) {
            AlignMatch this_match = this.all_matches[i];
            int[] match_x_positions = this.getMatchCoords(canvas_width, this_match);
            if (match_x_positions != null && this.isVisible(this_match)) {
                int subject_start_x = match_x_positions[0];
                int subject_end_x = match_x_positions[1];
                int query_start_x = match_x_positions[2];
                int query_end_x = match_x_positions[3];
                double match_left_x = (double)subject_start_x + 1.0 * (double)(query_start_x - subject_start_x) * (1.0 * (double)click_point.y / (double)canvas_height);
                double match_right_x = (double)subject_end_x + 1.0 * (double)(query_end_x - subject_end_x) * (1.0 * (double)click_point.y / (double)canvas_height);
                if ((double)click_point.x >= match_left_x - 1.0 && (double)click_point.x <= match_right_x + 1.0 || (double)click_point.x <= match_left_x + 1.0 && (double)click_point.x >= match_right_x - 1.0) {
                    return this_match;
                }
            }
            --i;
        }
        return null;
    }

    private void selectionChanged() {
        int i = 0;
        while (i < this.selection_change_listeners.size()) {
            AlignMatchVector matches = (AlignMatchVector)this.selected_matches.clone();
            AlignmentSelectionChangeEvent ev = new AlignmentSelectionChangeEvent(this, matches);
            AlignmentSelectionChangeListener listener = (AlignmentSelectionChangeListener)this.selection_change_listeners.elementAt(i);
            listener.alignmentSelectionChanged(ev);
            ++i;
        }
        if (this.selected_matches != null && this.selected_matches.size() > 0) {
            int seen_and_selected_count = 0;
            int i2 = 0;
            while (i2 < this.all_matches.length) {
                AlignMatch this_match = this.all_matches[i2];
                if (this.selected_matches.contains(this_match)) {
                    ++seen_and_selected_count;
                } else if (seen_and_selected_count > 0) {
                    this.all_matches[i2 - seen_and_selected_count] = this.all_matches[i2];
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.selected_matches.size()) {
                this.all_matches[this.all_matches.length - this.selected_matches.size() + i2] = this.selected_matches.elementAt(i2);
                ++i2;
            }
        }
        this.repaintCanvas();
    }

    public void addAlignmentSelectionChangeListener(AlignmentSelectionChangeListener l) {
        this.selection_change_listeners.addElement(l);
    }

    public void removeAlignmentSelectionChangeListener(AlignmentSelectionChangeListener l) {
        this.selection_change_listeners.removeElement(l);
    }

    public void addAlignmentListener(AlignmentListener l) {
        this.alignment_event_listeners.addElement(l);
    }

    public void removeAlignmentListener(AlignmentListener l) {
        this.alignment_event_listeners.removeElement(l);
    }

    public boolean offerToFlip() {
        return this.offer_to_flip_flag;
    }

    protected void paintCanvas(Graphics g) {
        this.fillBackground(g);
        if (this.last_subject_event != null && this.last_query_event != null) {
            this.drawAlignments(g);
            this.drawLabels(g);
        }
    }

    private void fillBackground(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getCanvas().getSize().width, this.getCanvas().getSize().height);
    }

    private void drawLabels(Graphics g) {
        String status_string;
        FontMetrics fm = g.getFontMetrics();
        int canvas_width = this.getCanvas().getSize().width;
        int canvas_height = this.getCanvas().getSize().height;
        String cutoff_label = Integer.toString(this.scroll_bar.getValue());
        int cutoff_label_width = fm.stringWidth(cutoff_label);
        int cutoff_label_position = (int)((double)(this.scroll_bar.getValue() - this.scroll_bar.getMinimum()) / (1.0 * (double)(this.scroll_bar.getMaximum() - this.scroll_bar.getMinimum())) * (double)canvas_height);
        if (cutoff_label_position < this.getFontAscent()) {
            cutoff_label_position = this.getFontAscent();
        }
        int[] cutoff_x_points = new int[]{canvas_width - cutoff_label_width, canvas_width - 2, canvas_width - 2, canvas_width - cutoff_label_width};
        int[] cutoff_y_points = new int[]{cutoff_label_position + 1, cutoff_label_position + 1, cutoff_label_position - this.getFontAscent(), cutoff_label_position - this.getFontAscent()};
        g.setColor(Color.white);
        g.fillPolygon(cutoff_x_points, cutoff_y_points, 4);
        g.setColor(Color.black);
        g.drawString(cutoff_label, canvas_width - cutoff_label_width, cutoff_label_position);
        int font_height = this.getFontAscent() + this.getFontDescent();
        if (this.selected_matches != null) {
            String match_string_1;
            if (this.selected_matches.size() > 1) {
                match_string_1 = String.valueOf(this.selected_matches.size()) + " matches selected";
            } else {
                AlignMatch selected_align_match = this.selected_matches.elementAt(0);
                match_string_1 = String.valueOf(selected_align_match.getQuerySequenceStart()) + ".." + selected_align_match.getQuerySequenceEnd() + " -> " + selected_align_match.getSubjectSequenceStart() + ".." + selected_align_match.getSubjectSequenceEnd();
            }
            int match_string_1_width = fm.stringWidth(match_string_1);
            int[] nArray = new int[4];
            nArray[2] = match_string_1_width;
            nArray[3] = match_string_1_width;
            int[] match_1_x_points = nArray;
            int[] nArray2 = new int[4];
            nArray2[1] = font_height;
            nArray2[2] = font_height;
            int[] match_1_y_points = nArray2;
            g.setColor(Color.white);
            g.fillPolygon(match_1_x_points, match_1_y_points, 4);
            g.setColor(Color.black);
            g.drawString(match_string_1, 0, this.getFontAscent());
            if (this.selected_matches.size() == 1) {
                AlignMatch selected_align_match = this.selected_matches.elementAt(0);
                String match_string_2 = "score: " + selected_align_match.getScore() + "  percent id: " + selected_align_match.getPercentID() + "%";
                int match_string_2_width = fm.stringWidth(match_string_2);
                int[] nArray3 = new int[4];
                nArray3[2] = match_string_2_width;
                nArray3[3] = match_string_2_width;
                int[] match_2_x_points = nArray3;
                int[] match_2_y_points = new int[]{font_height, font_height * 2, font_height * 2, font_height};
                g.setColor(Color.white);
                g.fillPolygon(match_2_x_points, match_2_y_points, 4);
                g.setColor(Color.black);
                g.drawString(match_string_2, 0, this.getFontAscent() + font_height);
            }
        }
        StringVector status_strings = new StringVector();
        if (this.displaysAreLocked()) {
            status_strings.add("LOCKED");
        }
        if (this.getSubjectDisplay().isRevCompDisplay()) {
            status_strings.add("Subject: Flipped");
        }
        if (this.getQueryDisplay().isRevCompDisplay()) {
            status_strings.add("Query: Flipped");
        }
        if (this.getOrigSubjectForwardStrand() != this.getSubjectForwardStrand()) {
            status_strings.add("Subject: Reverse Complemented");
        }
        if (this.getOrigQueryForwardStrand() != this.getQueryForwardStrand()) {
            status_strings.add("Query: Reverse Complemented");
        }
        g.setColor(Color.white);
        int i = 0;
        while (i < status_strings.size()) {
            status_string = status_strings.elementAt(i);
            int status_string_width = fm.stringWidth(status_string);
            int[] nArray = new int[4];
            nArray[2] = status_string_width;
            nArray[3] = status_string_width;
            int[] x_points = nArray;
            int string_offset = font_height * (status_strings.size() - i - 1);
            int[] y_points = new int[]{canvas_height - string_offset, canvas_height - font_height - string_offset, canvas_height - font_height - string_offset, canvas_height - string_offset};
            g.fillPolygon(x_points, y_points, 4);
            ++i;
        }
        g.setColor(Color.black);
        i = 0;
        while (i < status_strings.size()) {
            status_string = status_strings.elementAt(i);
            int string_offset = font_height * (status_strings.size() - i - 1);
            g.drawString(status_string, 0, canvas_height - string_offset - this.getFontDescent());
            ++i;
        }
    }

    private void drawAlignments(Graphics g) {
        int canvas_height = this.getCanvas().getSize().height;
        int canvas_width = this.getCanvas().getSize().width;
        int i = 0;
        while (i < this.all_matches.length) {
            AlignMatch this_match = this.all_matches[i];
            int[] match_x_positions = this.getMatchCoords(canvas_width, this_match);
            if (match_x_positions != null && this.isVisible(this_match)) {
                int subject_start_x = match_x_positions[0];
                int subject_end_x = match_x_positions[1];
                int query_start_x = match_x_positions[2];
                int query_end_x = match_x_positions[3];
                int[] x_coords = new int[4];
                int[] y_coords = new int[4];
                x_coords[0] = subject_start_x;
                y_coords[0] = 0;
                x_coords[1] = query_start_x;
                y_coords[1] = canvas_height;
                x_coords[2] = query_end_x;
                y_coords[2] = canvas_height;
                x_coords[3] = subject_end_x;
                y_coords[3] = 0;
                boolean highlight_this_match = this.selected_matches != null && this.selected_matches.contains(this_match);
                int percent_id = this_match.getPercentID();
                if (highlight_this_match) {
                    g.setColor(Color.yellow);
                } else if (percent_id == -1) {
                    if (this_match.isRevMatch()) {
                        g.setColor(Color.blue);
                    } else {
                        g.setColor(Color.red);
                    }
                } else {
                    int colour_index = this.red_percent_id_colours.length - 1;
                    if (this.maximum_percent_id > this.minimum_percent_id) {
                        colour_index = (int)((double)this.red_percent_id_colours.length * 0.999 * (double)(percent_id - this.minimum_percent_id) / (double)(this.maximum_percent_id - this.minimum_percent_id));
                    }
                    if (this_match.isRevMatch()) {
                        g.setColor(this.blue_percent_id_colours[colour_index]);
                    } else {
                        g.setColor(this.red_percent_id_colours[colour_index]);
                    }
                }
                g.fillPolygon(x_coords, y_coords, x_coords.length);
                if ((subject_end_x - subject_start_x >= 5 || subject_end_x - subject_start_x <= -5) && subject_start_x >= -3000 && subject_end_x <= 3000 && query_start_x >= -3000 && query_end_x <= 3000) {
                    g.setColor(Color.black);
                }
                g.drawLine(subject_start_x, 0, query_start_x, canvas_height);
                g.drawLine(subject_end_x, 0, query_end_x, canvas_height);
            }
            ++i;
        }
    }

    private boolean isVisible(AlignMatch match) {
        if (this.ignore_self_match_flag && match.isSelfMatch()) {
            return false;
        }
        int score = match.getScore();
        int percent_id = match.getPercentID();
        if (score > -1 && (score < this.minimum_score || score > this.maximum_score)) {
            return false;
        }
        if (percent_id > -1 && (percent_id < this.minimum_percent_id || percent_id > this.maximum_percent_id)) {
            return false;
        }
        int match_length = Math.abs(match.getSubjectSequenceStart() - match.getSubjectSequenceEnd());
        return match_length >= this.scroll_bar.getValue();
    }

    static int getRealSubjectSequenceStart(AlignMatch match, int sequence_length, boolean reverse_position) {
        if (reverse_position) {
            return sequence_length - match.getSubjectSequenceStart() + 1;
        }
        return match.getSubjectSequenceStart();
    }

    static int getRealSubjectSequenceEnd(AlignMatch match, int sequence_length, boolean reverse_position) {
        if (reverse_position) {
            return sequence_length - match.getSubjectSequenceEnd() + 1;
        }
        return match.getSubjectSequenceEnd();
    }

    static int getRealQuerySequenceStart(AlignMatch match, int sequence_length, boolean reverse_position) {
        if (reverse_position) {
            return sequence_length - match.getQuerySequenceStart() + 1;
        }
        return match.getQuerySequenceStart();
    }

    static int getRealQuerySequenceEnd(AlignMatch match, int sequence_length, boolean reverse_position) {
        if (reverse_position) {
            return sequence_length - match.getQuerySequenceEnd() + 1;
        }
        return match.getQuerySequenceEnd();
    }

    private int[] getMatchCoords(int canvas_width, AlignMatch this_match) {
        int subject_length = this.getSubjectForwardStrand().getSequenceLength();
        int query_length = this.getQueryForwardStrand().getSequenceLength();
        int subject_sequence_start = AlignmentViewer.getRealSubjectSequenceStart(this_match, subject_length, this.subjectIsRevComp());
        int subject_sequence_end = AlignmentViewer.getRealSubjectSequenceEnd(this_match, subject_length, this.subjectIsRevComp());
        int query_sequence_start = AlignmentViewer.getRealQuerySequenceStart(this_match, query_length, this.queryIsRevComp());
        int query_sequence_end = AlignmentViewer.getRealQuerySequenceEnd(this_match, query_length, this.queryIsRevComp());
        if (this.subjectIsRevComp()) {
            ++subject_sequence_start;
        } else {
            ++subject_sequence_end;
        }
        if (this_match.isRevMatch() && !this.queryIsRevComp() || !this_match.isRevMatch() && this.queryIsRevComp()) {
            ++query_sequence_start;
        } else {
            ++query_sequence_end;
        }
        int subject_start_x = this.getScreenPosition(canvas_width, this.last_subject_event, subject_sequence_start);
        int subject_end_x = this.getScreenPosition(canvas_width, this.last_subject_event, subject_sequence_end);
        int query_start_x = this.getScreenPosition(canvas_width, this.last_query_event, query_sequence_start);
        int query_end_x = this.getScreenPosition(canvas_width, this.last_query_event, query_sequence_end);
        boolean subject_off_left = false;
        boolean subject_off_right = false;
        boolean query_off_left = false;
        boolean query_off_right = false;
        if (subject_start_x < 0 && subject_end_x < 0) {
            subject_off_left = true;
        }
        if (subject_start_x >= canvas_width && subject_end_x >= canvas_width) {
            subject_off_right = true;
        }
        if (query_start_x < 0 && query_end_x < 0) {
            query_off_left = true;
        }
        if (query_start_x >= canvas_width && query_end_x >= canvas_width) {
            query_off_right = true;
        }
        if ((subject_off_left ? 1 : 0) + (query_off_left ? 1 : 0) + (subject_off_right ? 1 : 0) + (query_off_right ? 1 : 0) == 2) {
            return null;
        }
        int[] return_values = new int[]{subject_start_x, subject_end_x, query_start_x, query_end_x};
        return return_values;
    }

    private Strand getSubjectForwardStrand() {
        return this.getSubjectEntryGroup().getBases().getForwardStrand();
    }

    private Strand getQueryForwardStrand() {
        return this.getQueryEntryGroup().getBases().getForwardStrand();
    }

    private Strand getSubjectReverseStrand() {
        return this.getSubjectEntryGroup().getBases().getReverseStrand();
    }

    private Strand getQueryReverseStrand() {
        return this.getQueryEntryGroup().getBases().getReverseStrand();
    }

    private EntryGroup getSubjectEntryGroup() {
        return this.subject_entry_group;
    }

    private EntryGroup getQueryEntryGroup() {
        return this.query_entry_group;
    }

    public FeatureDisplay getSubjectDisplay() {
        return this.subject_feature_display;
    }

    public FeatureDisplay getQueryDisplay() {
        return this.query_feature_display;
    }

    boolean subjectIsRevComp() {
        Strand current_subject_forward_strand = this.getSubjectForwardStrand();
        return !(this.getOrigSubjectForwardStrand() == current_subject_forward_strand ^ this.getSubjectDisplay().isRevCompDisplay());
    }

    boolean queryIsRevComp() {
        Strand current_query_forward_strand = this.getQueryForwardStrand();
        return !(this.getOrigQueryForwardStrand() == current_query_forward_strand ^ this.getQueryDisplay().isRevCompDisplay());
    }

    public Strand getOrigSubjectForwardStrand() {
        return this.orig_subject_forward_strand;
    }

    public Strand getOrigQueryForwardStrand() {
        return this.orig_query_forward_strand;
    }

    public Strand getOrigSubjectReverseStrand() {
        return this.orig_subject_reverse_strand;
    }

    public Strand getOrigQueryReverseStrand() {
        return this.orig_query_reverse_strand;
    }

    public void lockDisplays() {
        this.displays_are_locked = true;
        this.repaintCanvas();
    }

    public void unlockDisplays() {
        this.displays_are_locked = false;
        this.repaintCanvas();
    }

    public boolean displaysAreLocked() {
        return this.displays_are_locked;
    }

    public void toggleDisplayLock() {
        this.displays_are_locked = !this.displays_are_locked;
        this.repaintCanvas();
    }

    public void disableSelection() {
        this.disable_selection_from_ranges = true;
    }

    public void enableSelection() {
        this.disable_selection_from_ranges = false;
    }

    private int getScreenPosition(int canvas_width, DisplayAdjustmentEvent event, int base_position) {
        int screen_start_base = event.getStart();
        double base_pos_float = event.getBaseWidth() * (float)(base_position - screen_start_base);
        if (base_pos_float > 30000.0) {
            return 30000;
        }
        if (base_pos_float < -30000.0) {
            return -30000;
        }
        return (int)base_pos_float;
    }

    private void makeColours() {
        this.red_percent_id_colours = new Color[NUMBER_OF_SHADES];
        this.blue_percent_id_colours = new Color[NUMBER_OF_SHADES];
        int i = 0;
        while (i < this.blue_percent_id_colours.length) {
            int shade_value = 255 - (int)(256.0 * (double)i / (double)NUMBER_OF_SHADES);
            this.red_percent_id_colours[i] = new Color(255, shade_value, shade_value);
            this.blue_percent_id_colours[i] = new Color(shade_value, shade_value, 255);
            ++i;
        }
    }

    private ComparisonData getComparisonData() {
        return this.comparison_data;
    }

    static /* synthetic */ void access$7(AlignmentViewer alignmentViewer, int n) {
        alignmentViewer.minimum_score = n;
    }

    static /* synthetic */ void access$8(AlignmentViewer alignmentViewer, int n) {
        alignmentViewer.maximum_score = n;
    }

    static /* synthetic */ void access$10(AlignmentViewer alignmentViewer, int n) {
        alignmentViewer.minimum_percent_id = n;
    }

    static /* synthetic */ void access$11(AlignmentViewer alignmentViewer, int n) {
        alignmentViewer.maximum_percent_id = n;
    }
}

