/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.components.FileViewer;
import uk.ac.sanger.artemis.io.ReadFormatException;

public class FeatureViewer
implements EntryChangeListener,
FeatureChangeListener {
    private Feature view_feature;
    private Entry entry;
    private FileViewer file_viewer;

    public FeatureViewer(Feature view_feature) {
        this.view_feature = view_feature;
        this.entry = view_feature.getEntry();
        this.file_viewer = new FileViewer("Artemis Feature View: " + view_feature.getIDString());
        this.readFeature(view_feature);
        view_feature.getEntry().addEntryChangeListener(this);
        view_feature.addFeatureChangeListener(this);
        this.file_viewer.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent event) {
                FeatureViewer.this.stopListening();
            }
        });
    }

    public void stopListening() {
        this.getEntry().removeEntryChangeListener(this);
        this.getFeature().removeFeatureChangeListener(this);
    }

    public void entryChanged(EntryChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                if (event.getFeature() != this.view_feature) break;
                this.stopListening();
                this.file_viewer.dispose();
                break;
            }
        }
    }

    public void featureChanged(FeatureChangeEvent event) {
        this.readFeature(this.view_feature);
    }

    public void readFeature(Feature feature) {
        try {
            this.file_viewer.clear();
            this.file_viewer.appendFile(this.view_feature.toReader());
        }
        catch (ReadFormatException e) {
            throw new Error("internal error - unexpected exception: " + e.getMessage() + (e.getLineNumber() > 1 ? " at line " + e.getLineNumber() : ""));
        }
        catch (IOException e) {
            throw new Error("internal error - unexpected exception: " + e.getMessage());
        }
    }

    public Feature getFeature() {
        return this.view_feature;
    }

    private Entry getEntry() {
        return this.entry;
    }
}

