/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.editor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import uk.ac.sanger.artemis.editor.Annotation;
import uk.ac.sanger.artemis.editor.BigPane;
import uk.ac.sanger.artemis.editor.BrowserControl;
import uk.ac.sanger.artemis.editor.CommonMenu;
import uk.ac.sanger.artemis.editor.ExternalApplication;
import uk.ac.sanger.artemis.editor.FastaListener;
import uk.ac.sanger.artemis.editor.FastaTextPane;
import uk.ac.sanger.artemis.editor.HitInfo;
import uk.ac.sanger.artemis.editor.ScrollPanel;

public class DataCollectionPane
extends JScrollPane
implements FastaListener {
    private FastaTextPane fastaTextPane;
    private Annotation ann;
    private JDesktopPane desktop;

    public DataCollectionPane(FastaTextPane fastaTextPane, Annotation ann, JDesktopPane desktop) {
        this.fastaTextPane = fastaTextPane;
        this.ann = ann;
        this.desktop = desktop;
        Box bdown = Box.createVerticalBox();
        ScrollPanel scrollPanel = new ScrollPanel();
        scrollPanel.add(bdown);
        Vector hitInfoCollection = fastaTextPane.getHitCollection();
        Hashtable goHash = this.getIDHash(hitInfoCollection);
        this.getGoHash("/nfs/disk222/yeastpub/analysis/pathogen/GO/go.flat", goHash);
        this.setResultLines(bdown, hitInfoCollection, goHash);
        this.setViewportView(scrollPanel);
        this.setPreferredSize(new Dimension(500, 300));
    }

    public void update() {
        Box bdown = Box.createVerticalBox();
        ScrollPanel scrollPanel = new ScrollPanel();
        scrollPanel.add(bdown);
        Vector hitInfoCollection = this.fastaTextPane.getHitCollection();
        Hashtable goHash = this.getIDHash(hitInfoCollection);
        this.getGoHash("/nfs/disk222/yeastpub/analysis/pathogen/GO/go.flat", goHash);
        this.setResultLines(bdown, hitInfoCollection, goHash);
        this.setViewportView(scrollPanel);
    }

    private void setResultLines(Box bdown, Vector hitInfoCollection, Hashtable goHash) {
        final Vector<JCheckBox> orthoCheckBox = new Vector<JCheckBox>();
        Enumeration hitEnum = hitInfoCollection.elements();
        while (hitEnum.hasMoreElements()) {
            Box bacross = Box.createHorizontalBox();
            final HitInfo hit = (HitInfo)hitEnum.nextElement();
            final JCheckBox orthoBox = new JCheckBox("ORTH");
            orthoBox.setFont(BigPane.font_sm);
            final JCheckBox paraBox = new JCheckBox("PARA");
            paraBox.setFont(BigPane.font_sm);
            orthoBox.setMargin(new Insets(1, 1, 1, 1));
            paraBox.setMargin(new Insets(1, 1, 1, 1));
            orthoBox.setActionCommand(hit.getID());
            orthoCheckBox.add(orthoBox);
            bacross.add(orthoBox);
            orthoBox.setFont(BigPane.font);
            orthoBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Enumeration checkEnum = orthoCheckBox.elements();
                    while (checkEnum.hasMoreElements()) {
                        JCheckBox cb = (JCheckBox)checkEnum.nextElement();
                        if (!cb.isSelected() || cb.getActionCommand().equals(orthoBox.getActionCommand())) continue;
                        cb.setSelected(false);
                        DataCollectionPane.this.ann.delete(cb.getActionCommand(), true);
                    }
                    if (orthoBox.isSelected()) {
                        if (paraBox.isSelected()) {
                            paraBox.setSelected(false);
                            DataCollectionPane.this.ann.delete(hit.getID(), false);
                        }
                        DataCollectionPane.this.setAnnotation(hit, DataCollectionPane.this.ann, DataCollectionPane.this.fastaTextPane.getFormat(), true);
                    } else {
                        DataCollectionPane.this.ann.delete(hit.getID(), true);
                    }
                }
            });
            bacross.add(paraBox);
            paraBox.setFont(BigPane.font);
            paraBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (paraBox.isSelected()) {
                        if (orthoBox.isSelected()) {
                            orthoBox.setSelected(false);
                            DataCollectionPane.this.ann.delete(hit.getID(), true);
                        }
                        DataCollectionPane.this.setAnnotation(hit, DataCollectionPane.this.ann, DataCollectionPane.this.fastaTextPane.getFormat(), false);
                    } else {
                        DataCollectionPane.this.ann.delete(hit.getID(), false);
                    }
                }
            });
            MouseOverButton butt = new MouseOverButton();
            butt.setPreferredSize(new Dimension(12, 12));
            butt.setBorderPainted(false);
            butt.setToolTipText("Go to alignment");
            butt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataCollectionPane.this.fastaTextPane.show(hit);
                }
            });
            bacross.add(butt);
            bacross.add(Box.createHorizontalStrut(2));
            MouseOverButton srsRetrieve = new MouseOverButton(hit);
            srsRetrieve.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataCollectionPane.this.getSRSEntry(hit, DataCollectionPane.this.desktop);
                }
            });
            srsRetrieve.setForeground(Color.blue);
            srsRetrieve.setToolTipText("");
            srsRetrieve.setFont(BigPane.font);
            srsRetrieve.setMargin(new Insets(1, 1, 1, 1));
            srsRetrieve.setBorderPainted(false);
            bacross.add(srsRetrieve);
            String head = hit.getHeader();
            if (head.startsWith(hit.getID())) {
                head = head.substring(hit.getID().length());
            }
            JLabel hiLabel = new JLabel(head);
            hiLabel.setFont(BigPane.font);
            hiLabel.setForeground(Color.red);
            JButton selectButt = new JButton("ALIGN");
            selectButt.setMargin(new Insets(1, 1, 1, 1));
            selectButt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataCollectionPane.this.fastaTextPane.show(hit);
                }
            });
            selectButt.setFont(BigPane.font);
            JButton srsButt = new JButton("->SRS");
            srsButt.setMargin(new Insets(1, 1, 1, 1));
            srsButt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataCollectionPane.this.getSRSEntry(hit, DataCollectionPane.this.desktop);
                }
            });
            srsButt.setFont(BigPane.font);
            bacross.add(hiLabel);
            bacross.add(selectButt);
            bacross.add(srsButt);
            bacross.add(Box.createHorizontalGlue());
            bdown.add(bacross);
            Vector gov = hit.getGO();
            if (gov == null) continue;
            Enumeration gov_enum = gov.elements();
            while (gov_enum.hasMoreElements()) {
                final String go_id = ((String)gov_enum.nextElement()).trim();
                bacross = Box.createHorizontalBox();
                JButton goButton = new JButton("GO:" + go_id);
                goButton.setFont(BigPane.font);
                goButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String go_cmd = "http://www.godatabase.org/cgi-bin/amigo/go.cgi?query=GO%3A" + go_id;
                        BrowserControl.displayURL(go_cmd);
                        if (BigPane.srsTabPane.isSelected()) {
                            try {
                                DataCollectionPane.this.setUpSRSFrame(new URL(go_cmd), go_id, DataCollectionPane.this.desktop);
                            }
                            catch (ConnectException connectException) {
                                JOptionPane.showMessageDialog(DataCollectionPane.this, "Cannot retrieve " + go_id + "\nConnection failed to:\n" + go_cmd, "Connection Error", 2);
                            }
                            catch (Exception exp) {
                                exp.printStackTrace();
                            }
                        }
                    }
                });
                bacross.add(Box.createHorizontalStrut(10));
                bacross.add(goButton);
                goButton.setMargin(new Insets(0, 1, 0, 1));
                JLabel goLabel = new JLabel((String)goHash.get(go_id));
                goLabel.setFont(BigPane.font);
                bacross.add(goLabel);
                bdown.add(bacross);
                bacross.add(Box.createHorizontalGlue());
            }
        }
    }

    private void getSRSEntry(HitInfo hit, JDesktopPane desktop) {
        String srscmd = "srs.sanger.ac.uk/srsbin/cgi-bin/wgetz?-e+";
        if (hit.getID() != null) {
            String search = hit.getID();
            srscmd = srscmd.concat("[{uniprot}-ID:" + search + "*]");
            if (hit.getAcc() != null) {
                srscmd = srscmd.concat("|[{uniprot}-AccNumber:" + hit.getAcc() + "*]");
            }
            if (BigPane.srsBrowser.isSelected()) {
                BrowserControl.displayURL(srscmd);
            }
            try {
                URL url = new URL("http://" + srscmd);
                if (BigPane.srsTabPane.isSelected()) {
                    this.setUpSRSFrame(url, search, desktop);
                }
                if (BigPane.srsWin.isSelected()) {
                    int hgt = 2 * desktop.getHeight() / 3;
                    Annotation edPane = new Annotation(url);
                    JScrollPane jsp = new JScrollPane(edPane);
                    JInternalFrame jif = new JInternalFrame("SRS " + search, true, true, true, true);
                    JMenuBar menuBar = new JMenuBar();
                    menuBar.add(new CommonMenu(jif));
                    jif.setJMenuBar(menuBar);
                    jif.getContentPane().add(jsp);
                    jif.setLocation(0, 0);
                    jif.setSize(800, hgt);
                    jif.setVisible(true);
                    desktop.add(jif);
                }
            }
            catch (ConnectException connectException) {
                JOptionPane.showMessageDialog(this, "Cannot retrieve " + search + "\nConnection failed to:\nhttp://" + srscmd, "Connection Error", 2);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(this, "No ID to retrieve SRS entry!", "Missing ID", 1);
        }
    }

    protected void setUpSRSFrame(URL url, String name, JDesktopPane desktop) throws IOException {
        if (BigPane.srsFrame == null) {
            BigPane.setUpSRSFrame(2 * desktop.getHeight() / 3, desktop);
            Border loweredbevel = BorderFactory.createLoweredBevelBorder();
            Border raisedbevel = BorderFactory.createRaisedBevelBorder();
            CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
            JTextField statusField = new JTextField();
            statusField.setBorder(compound);
            statusField.setEditable(false);
            BigPane.srsFrame.getContentPane().add((Component)statusField, "South");
        }
        Annotation edPane = new Annotation(url);
        JScrollPane jsp = new JScrollPane(edPane);
        JTabbedPane jtab = (JTabbedPane)BigPane.srsFrame.getContentPane().getComponent(0);
        jtab.insertTab(name, null, jsp, null, 0);
        BigPane.srsFrame.setVisible(true);
    }

    protected static void getzCall(Vector hits, int nretrieve) {
        String[] env = new String[]{"PATH=/usr/local/pubseq/bin/"};
        StringBuffer query = new StringBuffer();
        int n = 0;
        query.append("[uniprot-acc:");
        Enumeration ehits = hits.elements();
        while (ehits.hasMoreElements()) {
            if (n > nretrieve) break;
            HitInfo hit = (HitInfo)ehits.nextElement();
            if (n > 0) {
                query.append("|");
            }
            query.append(hit.getAcc());
            ++n;
        }
        query.append("]");
        String[] cmd = new String[]{"getz", "-f", "acc org description gen", query.toString()};
        ExternalApplication app = new ExternalApplication(cmd, env, null);
        String res = app.getProcessStdout();
        HitInfo hit = null;
        String line = null;
        String lineStrip = null;
        StringReader strread = new StringReader(res);
        BufferedReader strbuff = new BufferedReader(strread);
        try {
            while ((line = strbuff.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                lineStrip = line.substring(3).trim();
                if (line.startsWith("AC")) {
                    hit = DataCollectionPane.getHitInfo(lineStrip, hits);
                    if (hit == null) {
                        System.out.println("HIT NOT FOUND " + line);
                        continue;
                    }
                    hit.setOrganism("");
                    hit.setGeneName("");
                }
                if (hit == null) continue;
                if (line.startsWith("OS ")) {
                    hit.setOrganism(lineStrip);
                    continue;
                }
                if (line.startsWith("DE ")) {
                    hit.appendDescription(lineStrip);
                    continue;
                }
                if (!line.startsWith("GN ")) continue;
                StringTokenizer tokGN = new StringTokenizer(lineStrip, ";");
                while (tokGN.hasMoreTokens()) {
                    line = tokGN.nextToken();
                    if (line.startsWith("Name=")) {
                        hit.setGeneName(line.substring(5));
                        continue;
                    }
                    hit.appendDescription(line);
                }
            }
        }
        catch (IOException iOException) {}
        ehits = hits.elements();
        while (ehits.hasMoreElements()) {
            hit = (HitInfo)ehits.nextElement();
            String[] cmd2 = new String[]{"getz", "-f", "id", "[libs={uniprot}-id:" + hit.getID() + "]>EMBL"};
            app = new ExternalApplication(cmd2, env, null);
            res = app.getProcessStdout();
            int ind1 = res.indexOf("ID ");
            if (ind1 > -1) {
                StringTokenizer tok = new StringTokenizer(res);
                tok.nextToken();
                hit.setEMBL(tok.nextToken());
                continue;
            }
            hit.setEMBL("");
        }
    }

    private static HitInfo getHitInfo(String acc, Vector hits) {
        int ind = 0;
        ind = (acc = acc.trim()).indexOf(";");
        if (ind > -1) {
            acc = acc.substring(0, ind);
        }
        Enumeration ehits = hits.elements();
        HitInfo hit = null;
        while (ehits.hasMoreElements()) {
            hit = (HitInfo)ehits.nextElement();
            if (!hit.getAcc().equals(acc)) continue;
            return hit;
        }
        return null;
    }

    protected static void getzCall(HitInfo hit, boolean ortholog) {
        String[] cmd2;
        int ind1;
        String res;
        ExternalApplication app;
        String[] env = new String[]{"PATH=/usr/local/pubseq/bin/"};
        if (hit.getOrganism() == null || hit.getDescription() == null) {
            System.out.println("CALLING GETZ");
            String[] cmd = new String[]{"getz", "-f", "org description gen", "[uniprot:" + hit.getAcc() + "]|[uniprot:" + hit.getID() + "]"};
            app = new ExternalApplication(cmd, env, null);
            res = app.getProcessStdout();
            StringTokenizer tok = new StringTokenizer(res, "\n");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                String tokenline = token.substring(3).trim();
                if (tokenline.equals("")) continue;
                if (token.startsWith("OS ")) {
                    hit.setOrganism(tokenline);
                    continue;
                }
                if (token.startsWith("DE ")) {
                    hit.appendDescription(tokenline);
                    continue;
                }
                if (!token.startsWith("GN ")) continue;
                StringTokenizer tokGN = new StringTokenizer(tokenline, ";");
                while (tokGN.hasMoreTokens()) {
                    token = tokGN.nextToken();
                    if (token.startsWith("Name=")) {
                        hit.setGeneName(tokenline.substring(5));
                        continue;
                    }
                    hit.appendDescription(token);
                }
            }
        }
        if (hit.getEMBL() == null && (ind1 = (res = (app = new ExternalApplication(cmd2 = new String[]{"getz", "-f", "id", "[libs={uniprot}-id:" + hit.getID() + "]>EMBL"}, env, null)).getProcessStdout()).indexOf("ID ")) > -1) {
            StringTokenizer tok = new StringTokenizer(res);
            tok.nextToken();
            hit.setEMBL(tok.nextToken());
        }
    }

    private void setAnnotation(HitInfo hit, Annotation ann, String resultFormat, boolean ortholog) {
        DataCollectionPane.getzCall(hit, ortholog);
        String orthoText = "";
        if (ortholog) {
            hit.getGeneName();
            if (hit.getGeneName() != null) {
                orthoText = "<br>\n/gene=\"" + hit.getGeneName() + "\"";
            }
        }
        StringBuffer buff = new StringBuffer();
        if (hit.getDB() != null) {
            buff.append(String.valueOf(hit.getDB()) + ":" + hit.getID());
        } else {
            buff.append(" UNIPROT:" + hit.getID());
        }
        if (hit.getEMBL() != null && !hit.getEMBL().equals("")) {
            buff.append(" (EMBL:" + hit.getEMBL() + ")");
        }
        buff.append(";");
        if (hit.getOrganism() != null && !hit.getOrganism().equals("")) {
            buff.append(" " + hit.getOrganism() + ";");
        }
        if (hit.getGeneName() != null && !hit.getGeneName().equals("")) {
            buff.append(" " + hit.getGeneName() + ";");
        }
        if (hit.getDescription() != null) {
            buff.append(" " + hit.getDescription() + ";");
        }
        if (hit.getLength() != null) {
            buff.append(" length=" + hit.getLength() + ";");
        }
        if (hit.getUngapped() != null) {
            buff.append("ungapped id=" + hit.getUngapped() + ";");
        }
        if (hit.getEValue() != null) {
            buff.append(" E()=" + hit.getEValue() + ";");
        }
        if (hit.getOverlap() != null) {
            buff.append(" " + hit.getOverlap() + ";");
        }
        if (hit.getQueryRange() != null) {
            buff.append("query " + hit.getQueryRange() + ";");
        }
        if (hit.getSubjectRange() != null) {
            buff.append("subject " + hit.getSubjectRange());
        }
        buff.append("\"");
        ann.insert("\n/similarity=\"" + resultFormat + ";" + buff.toString() + orthoText, ortholog);
    }

    private Hashtable getIDHash(Vector hitInfoCollection) {
        Hashtable<String, String> goHash = new Hashtable<String, String>();
        Enumeration hitEnum = hitInfoCollection.elements();
        while (hitEnum.hasMoreElements()) {
            HitInfo hit = (HitInfo)hitEnum.nextElement();
            Vector gov = hit.getGO();
            if (gov == null) continue;
            Enumeration gov_enum = gov.elements();
            while (gov_enum.hasMoreElements()) {
                String id = ((String)gov_enum.nextElement()).trim();
                goHash.put(id, "");
            }
        }
        return goHash;
    }

    public void getGoHash(String filename, Hashtable goHash) {
        try {
            String line = null;
            BufferedReader buffRead = new BufferedReader(new FileReader(filename));
            while ((line = buffRead.readLine()) != null) {
                StringTokenizer tok = new StringTokenizer(line, "\t");
                String ID = tok.nextToken().substring(3);
                String desc = tok.nextToken();
                if (tok.hasMoreTokens()) {
                    desc = desc.concat("; " + tok.nextToken());
                }
                if (!goHash.containsKey(ID)) continue;
                goHash.put(ID, desc);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public class MouseOverButton
    extends JButton {
        private boolean over;
        private HitInfo hit;

        public MouseOverButton() {
            this.over = false;
        }

        public MouseOverButton(HitInfo hit) {
            super(hit.getID());
            this.over = false;
            this.hit = hit;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!this.getText().equals("")) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            if (this.over) {
                g2.setColor(new Color(100, 100, 200));
            } else {
                g2.setColor(Color.blue);
            }
            g2.setStroke(new BasicStroke(1.5f));
            g2.drawLine(1, 3, 11, 3);
            g2.drawLine(1, 7, 11, 7);
            this.setSize(12, 12);
        }

        public String getToolTipText() {
            if (this.hit == null) {
                return null;
            }
            return this.hit.getOrganism();
        }

        protected void processMouseEvent(MouseEvent evt) {
            switch (evt.getID()) {
                case 504: {
                    this.over = true;
                    this.setForeground(new Color(100, 100, 200));
                    this.repaint();
                    break;
                }
                case 505: {
                    this.over = false;
                    this.setForeground(Color.blue);
                    this.repaint();
                }
            }
            super.processMouseEvent(evt);
        }
    }
}

