/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.util.Comparator;
import nsdb.EmblSeq;
import nsdb.NucFeature;
import type.NoResult;
import uk.ac.sanger.artemis.io.CorbaFeature;
import uk.ac.sanger.artemis.io.CorbaSequence;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.FeatureComparator;
import uk.ac.sanger.artemis.io.FeatureEnumeration;
import uk.ac.sanger.artemis.io.FeatureTree;
import uk.ac.sanger.artemis.io.FeatureVector;
import uk.ac.sanger.artemis.io.InvalidKeyException;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.LocationParseException;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.ReadOnlyEntry;
import uk.ac.sanger.artemis.io.Sequence;

public class CorbaEntry
extends ReadOnlyEntry
implements Entry {
    private EmblSeq corba_handle;
    private CorbaSequence sequence = null;
    private FeatureTree features = new FeatureTree((Comparator)new FeatureComparator());
    private final EntryInformation entry_information;

    public CorbaEntry(EntryInformation entry_information, EmblSeq corba_handle) throws LocationParseException, InvalidKeyException, NoResult {
        this.corba_handle = corba_handle;
        this.sequence = new CorbaSequence(corba_handle);
        this.entry_information = entry_information;
        this.grabFeatures();
    }

    public String getHeaderText() {
        return null;
    }

    public String getName() {
        return this.corba_handle.getBioSeqId();
    }

    public int getFeatureCount() {
        return this.features.size();
    }

    public Feature getFeatureAtIndex(int arg_index) {
        FeatureEnumeration enumerator = this.features.features();
        int i = 0;
        while (enumerator.hasMoreFeatures()) {
            Feature this_feature = enumerator.nextFeature();
            if (i == arg_index) {
                return this_feature;
            }
            ++i;
        }
        return null;
    }

    public int indexOf(Feature feature) {
        FeatureEnumeration enumerator = this.features.features();
        int i = 0;
        while (enumerator.hasMoreFeatures()) {
            Feature this_feature = enumerator.nextFeature();
            if (this_feature == feature) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean contains(Feature feature) {
        return this.features.contains(feature);
    }

    public FeatureEnumeration features() {
        return this.features.features();
    }

    public FeatureVector getFeaturesInRange(Range range) {
        return this.features.getFeaturesInRange(range);
    }

    public FeatureVector getAllFeatures() {
        FeatureVector return_features = new FeatureVector();
        FeatureEnumeration enumerator = this.features.features();
        while (enumerator.hasMoreFeatures()) {
            Feature this_feature = enumerator.nextFeature();
            return_features.add(this_feature);
        }
        return return_features;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public EntryInformation getEntryInformation() {
        return this.entry_information;
    }

    private void grabFeatures() throws LocationParseException, InvalidKeyException, NoResult {
        NucFeature[] feature_handles = this.corba_handle.getNucFeatures();
        int i = 0;
        while (i < feature_handles.length) {
            try {
                CorbaFeature new_feature = new CorbaFeature(feature_handles[i]);
                this.features.add(new_feature);
            }
            catch (InvalidRelationException e) {
                System.out.println("exception while reading: " + e);
            }
            ++i;
        }
    }
}

